#include "World.h"
#include "mof/ConsoleIO.h"




et::World::World(std::vector<et::RegenerationEvent>& regenerationHistory)
{
	m_regenerationLevel = 0;
	m_term = 0;
	int regenePoint = 0;

	std::vector<et::RegenerationEvent> stock;
	
	m_pAreaMap = new et::AreaMap(10 , 10);
	for(int i = 0 ; i < regenerationHistory.size() ; i++){
		et::RegenerationEvent event = regenerationHistory.at(i);
		if(event.isSleepEvent()){
			m_term++;
			for(int j = 0 ; j < stock.size() ; j++){
				regenePoint += updateAreaPowerLevel(stock.at(j).position , stock.at(j));
			}
			stock.clear();
		}
		else stock.push_back(event);
	}
	
	for(int i = 0 ; i < stock.size() ; i++){
		//zuς݃GgƂď
		et::Area area = m_pAreaMap->get(stock.at(i).position.x , stock.at(i).position.y);
		if(stock.at(i).forest)area.forestGen = true;
	}
	m_regenerationLevel = regenePoint / 10;
}

et::World::~World(void)
{
	delete m_pAreaMap;
}


int et::World::updateAreaPowerLevel(mof::Vector2D& position , et::RegenerationEvent& event){
	int regenePoint = 0;
	static int tableX[] = { -1 , 0 , 1 , -1 , 0 , 1 , -1 , 0 , 1};
	static int tableY[] = { -1 , -1 , -1 , 0 , 0 , 0 , 1 , 1 , 1};
	static int tableEffect[] = { 1  , 3 , 1 , 3 , 5 , 3 , 1 , 3 , 1};
	for(int i = 0 ; i < 9 ; i++){
		mof::Vector2D target = position;
		target.x += tableX[i];
		target.y += tableY[i];
		if(0 <= target.x && target.x < m_pAreaMap->getWidth() && 0 <= target.y && target.y < m_pAreaMap->getHeight() ){
			et::Area area = m_pAreaMap->get(target.x , target.y);
			if(event.forest){
				int tmp = area.powerLevel.forest;
				area.powerLevel.forest += tableEffect[i]; 
				if(area.powerLevel.forest > 9)area.powerLevel.forest = 9;
				regenePoint += area.powerLevel.forest - tmp;
			}
			m_pAreaMap->set(target.x , target.y , area);
		}
		
	}
	return regenePoint;
	
}

et::Area& et::World::getArea(int x , int y){
	return m_pAreaMap->get(x , y);
}

void et::World::setArea(int x , int y , et::Area& area){
	m_pAreaMap->set(x , y , area);
}



et::AreaPowerLevelMap et::World::getAreaPowerLevelMap(){
	et::AreaPowerLevelMap powerLevelMap(m_pAreaMap->getWidth() , m_pAreaMap->getHeight());
	for(int x = 0 ; x < powerLevelMap.getWidth() ; x++){
		for(int y = 0 ; y < powerLevelMap.getHeight() ; y++)powerLevelMap.set(x , y , m_pAreaMap->get(x , y).powerLevel);
	}
	return powerLevelMap;
}
