#include "WorldMapBuilder.h"
#include "MapImageColor.h"
#include "mof/ConsoleIO.h"


et::WorldMapBuilder::WorldMapBuilder(et::AreaPowerLevelMap &map , mof::TextureManager* pTextureManager , float scale)
: et::MapBuilder( pTextureManager , scale , map.getWidth() , map.getHeight()) , m_map(map)
{
	m_pTexture = m_pTextureManager->getResource(_T("image/worldtip.png"));
}

et::WorldMapBuilder::~WorldMapBuilder(void)
{
}

void et::WorldMapBuilder::addParts(std::vector<et::VertexTypeDungeon>& vertices , int x , int y){
	
	const float SCALE = getScale();
	et::VertexTypeDungeon vertex;
	vertex.y = 0.0f;
	float t = 0.0001f;//eNX`E␳
	const float tmpTexel = 32.0f / (float)m_pTexture->getWidth();
	vertex.color = mof::createColor(255 , 255 , 255);
	float tableX[]={ 0.0f , SCALE , SCALE , SCALE , 0.0f , 0.0f};
	float tableZ[]={ 0.0f , 0.0f , -SCALE , -SCALE , -SCALE , 0.0f};
	float tableTU[]={ 0.0f+t , tmpTexel-t , tmpTexel-t , tmpTexel-t , 0.0f+t , 0.0f+t};
	float tableTV[]={ 0.0f+t, 0.0f+t , tmpTexel-t , tmpTexel-t , tmpTexel-t , 0.0f+t};


	float toForestLevelTable[] = {0 , 0 , 1 , 1 , 2 , 2 , 3 , 3 , 4 , 5 };
	for(int i = 0 ; i < 6 ; i++){
		vertex.x = tableX[i] + SCALE * x;
		vertex.z = tableZ[i] - SCALE * y;
		vertex.tu = tableTU[i] + toForestLevelTable[getMap().get(x , y).forest] * tmpTexel;
		vertex.tv = tableTV[i];
		vertices.push_back(vertex);
		
	}
	return;

	
}