#include "resource.hpp"
#include <stdexcept>

namespace
{
    mof::TextureManagerHandler m_systemTextureManager;
    bool m_initialized = false;

    void initialize( )
    {
        m_systemTextureManager = mof::TextureManagerHandler( new mof::TextureManager );
    }
}

mof::TextureManagerHandler 
getTextureResourceManager( ResourceGroup rg )
{
    if( !m_initialized )initialize();
    switch( rg )
    {
        case SYSTEM :
            return m_systemTextureManager;
        default :
            std::runtime_error("invalid resource group"); 
    }
}
