#include "script/MyEnvironment.hpp"
#include <boost/tuple/tuple.hpp>
#include <boost/format.hpp>
#include <boost/lexical_cast.hpp>
#include <boost/algorithm/string.hpp>
#include <mof/script/ObjectData.hpp>
#include <memory>
#include <mof/streams.hpp>
#include "widget/createMenuView.hpp"
#include "widget/createFrame.hpp"
#include <mof/Font.hpp>
#include <mof/widgets.hpp>
#include <mof/utilities.hpp>
#include <configure.hpp>
#include <mof/utilities.hpp>
#include <mof/widget/GridLayout.hpp>
#include "sqlite_wrapper.hpp"
#include "resource.hpp"


namespace script
{
//{{{ Impl
	struct MyEnvironment::Impl
	{
		::sqlite_wrapper sqlite_;

		Impl()
		{

		}
	};
//}}}
//{{{ constructor
	MyEnvironment::MyEnvironment(std::shared_ptr<mof::InputReceiver> input)
		: mof::script::Environment(input), impl_(new Impl())
	{
	}
//}}}
//{{{ destructor
	MyEnvironment::~MyEnvironment()
	{
	}
//}}}
//{{{ create_message_data
	std::unique_ptr<mof::script::MessageData> MyEnvironment::create_message_data
	(
		const mof::tstring& title, const mof::script::GameData::entry_t& style
	)
	{
		using namespace mof::widget;
		using namespace boost;

		auto compiler = std::make_shared<TextCompiler>
			(
				mof::Font(FONT_NAME_UME, FONT_SIZE_STANDARD),
				[] (const mof::tstring& path) { return ::getTextureResourceManager(::SYSTEM)->getResource(path);}
			);
 
		{
			// set behavior for page updated
			mof::KeyFrameAnimation<mof::Color4f>::KeyFrame keyFrames[] =
			{
				mof::makeKeyFrame(0,  mof::Color4f(0, 1, 1, 1)),
				mof::makeKeyFrame(15, mof::Color4f(0, 1, 1, 1)),
				mof::makeKeyFrame(45, mof::Color4f(1, 1, 1, 1)),
			};
			compiler->setBehaviorOnColor
			(
				TextCompiler::PAGE_OPEN,
				mof::makeKeyFrameAnimationHandler(keyFrames[0], mof::lastOf(keyFrames)),
				45
			);
		}

		{
			// set behavior for page updated
			compiler->setBehaviorOnColor
			(
				TextCompiler::PAGE_CLOSE,
				mof::makeKeyFrameAnimationHandler(0, mof::Color4f(1, 1, 1, 1), 15, mof::Color4f(0, 1, 1, 1)),
				15
			);
		}

		std::unique_ptr<mof::script::MessageData> result(new mof::script::MessageData);

		{
            result->message_ = std::make_shared<Message>(mof::Vector2D(550, 125), compiler);

            result->frame_ = 
				std::shared_ptr<Frame>
                (
					createFrame
                	(
					 	title,
                    	_T("image/frame0.png"),
                    	_T("image/frame3.png"),
						result->message_->getView()
                	).release()
				);
        }
		
	
		return result;
	
	}
//}}}
//{{{ create_menu_data
	std::unique_ptr<mof::script::MenuData> MyEnvironment::create_menu_data
	(
		const mof::tstring& title,
		const std::vector<mof::tstring>& items,
		const mof::script::GameData::entry_t& style
	)
	{
		using namespace mof::widget;
		using namespace mof::script;
		using namespace boost;

		GridLayout::Direction direction = GridLayout::VERTICAL;
		std::vector<int> disable_items;
		
		// X^C̉
		foreach (const auto& p, style) {
			if (p.first == "direction") {
				if (p.second == "vertical") direction = GridLayout::VERTICAL;
				else if (p.second == "horizontal") direction = GridLayout::HORIZONTAL;
				else throw std::invalid_argument("invalid direction value:" + p.second);
			}
			else if (p.first == "disable") {
				// 鍀ڂ̉
				std::vector<mof::tstring> splited_list;
				split(splited_list, p.second, is_any_of(","));
				foreach (auto& item, splited_list) { 
					disable_items.push_back(lexical_cast<int>(item));
				}
			}
			else throw std::invalid_argument("invalid key:" + p.first);
		}

		std::unique_ptr<MenuData> result(new MenuData);

		{
			std::vector<MenuItem> menu_items;
			for (int i = 0; i < items.size(); ++i) {
				bool disable = find(disable_items.begin(), disable_items.end(), i) != disable_items.end();// disable_items薳ȍڂf
				menu_items.push_back(MenuItem(createMenuView(items[i], disable)));
			}
            result->menu_ = std::make_shared<Menu>
				(
					menu_items.front(), menu_items.back(),
					mof::makeFactoryMethod<GridLayout>(direction, 0)
				);

            result->frame_ = 
				std::shared_ptr<Frame>
				(
                	createFrame
                	(
                    	title ,
                    	_T("image/frame0.png") ,
                    	_T("image/frame3.png") ,
                    	result->menu_->getView()
                	).release()
				);
        }

		return result;
	
	}
//}}}
//{{{ get_game_data
	mof::script::GameData::ptr MyEnvironment::get_game_data(const mof::tstring& resource_path)
	{
		using namespace mof::script;
		using namespace boost;

		DEBUG_PRINT("load_game_data(" << resource_path << ")");

		if (resource_path == "gamedata.item_profile") {
			return impl_->sqlite_.query_item_profile();
		}
		else if (resource_path == "gamedata.relic_profile") {
			return impl_->sqlite_.query_relic_profile();
		}
		else if (resource_path == "gamedata.ideal_profile") {
			return impl_->sqlite_.query_ideal_profile();
		}
		else if (resource_path == "system.client_region") {
			mof::Rectangle<int> rect = mof::GraphicsDevice::getClientRegion();
			mof::script::GameData::ptr p = std::make_shared<mof::script::GameData>();
			mof::script::GameData::entry_t entry;
			entry["width"] = boost::lexical_cast<mof::tstring>(rect.getWidth());
			entry["height"] = boost::lexical_cast<mof::tstring>(rect.getHeight());
			p->data_.push_back(entry);
			return p;
		}
		else {
			DEBUG_PRINT("unknown resource path:" << resource_path);
			return std::make_shared<GameData>(); 
		}
	}
//}}}	
}


