require('script/moflib')
require('script/common')
require('script/item')

--{{{ make_item_text
function make_item_text(item)
	local texts = {}
	table.insert(texts, get_icon_image_tag(item.icon_type))
	table.insert(texts, '<layout w="250" h="32" xalign="left" yalign="center">' .. item.name .. '</layout>')
	table.insert(texts, '<layout w="80" h="32" xalign="left" yalign="center"><col name="blue">cϐ</col></layout>')
	table.insert(texts, '<layout w="80" h="32" xalign="right" yalign="center">' .. item.durability .. 'term</layout>')
	if tonumber(item.equipped) == 1 then
		table.insert(texts, '<layout w="100" h="32" xalign="right" yalign="center"><col name="blue">()</col></layout>')
	end
	return table.concat(texts)
end
--}}}
--{{{ make_ideal_text
function make_ideal_text(ideal)
	-- TODO Grade
	local texts = {}
	table.insert(texts, get_icon_image_tag(ideal.icon_type))
	table.insert(texts, '<layout w="250" h="32" xalign="left" yalign="center">' .. ideal.name .. '</layout>')
	table.insert(texts, '<layout w="80" h="32" xalign="left" yalign="center"><col name="blue">cϐ</col></layout>')
	table.insert(texts, '<layout w="80" h="32" xalign="right" yalign="center">' .. ideal.durability .. 'term</layout>')
	if tonumber(ideal.attend) == 1 then
		table.insert(texts, '<layout w="100" h="32" xalign="right" yalign="center"><col name="blue">(Q)</col></layout>')
	end
	return table.concat(texts)
end
--}}}
--{{{ question_attached
function question_attached(item_tween, explanation_text)
	local items = load_game_data('gamedata.item_profile')
	local attached_items = {}
	local list = {}
	for i = 1, #items, 1 do
		if tonumber(items[i].attached) == 1 then 
			table.insert(list, make_item_text(items[i]))
			table.insert(attached_items, items[i])
		end
	end
	explanation_text:next(make_shop_item_explanation(attached_items[1]))
	return question('ACe(c0Xbg)', list, PRIORITY_MENU_SCENE_MENU, 'view=scroll', item_tween, false,
		function (index)	
			explanation_text:next(make_shop_item_explanation(attached_items[index + 1]))
		end
	)
end
--}}}
--{{{ question_stored
function question_stored(item_tween, explanation_text)
	local items = load_game_data('gamedata.item_profile')
	local stored_items = {}
	local list = {}
	for i = 1, #items, 1 do
		if tonumber(items[i].stored) == 1 then 
			table.insert(list, make_item_text(items[i]))
			table.insert(stored_items, items[i])
		end
	end
	explanation_text:next(make_shop_item_explanation(stored_items[1]))
	return question('qɃACe', list, PRIORITY_MENU_SCENE_MENU, 'view=scroll', item_tween, false, 
		function (index)	
			explanation_text:next(make_shop_item_explanation(stored_items[index + 1]))
		end
	)
end
--}}}
--{{{ question_relic
function question_relic(item_tween, explanation_text)
	local relics = load_game_data('gamedata.relic_profile')
	local list = {}
	for i = 1, #relics, 1 do
		if relics[i].num ~= 0 then
			local name = get_icon_image_tag(relics[i].icon_type) .. 
				'<layout w="360" h="32" xalign="left" yalign="center">' .. relics[i].name .. '</layout>' ..
				'<layout w="100" h="32" xalign="right" yalign="center">' .. relics[i].num .. '</layout>'
			table.insert(list, name)
		end
	end
	explanation_text:next(make_relic_explanation(relics[1]))

	return question('bN', list, PRIORITY_MENU_SCENE_MENU, 'view=scroll', item_tween, false,
		function (index)	
			explanation_text:next(make_relic_explanation(relics[index + 1]))
		end
	)
end
--}}}
--{{{ question_setup_weapon
function question_setup_weapon(item_tween, explanation_text)
	local items = load_game_data('gamedata.item_profile')
	local weapon_items = {}
	local list = {}
	local disables = {}
	local num_items = 0
	for i = 1, #items, 1 do
		local type = tonumber(items[i].type);
		local state = ''
		if items[i].equipped == '1' then
			state = '<col name="blue"><layout w="130" h="32" xalign="right" yalign="center">()</layout></col>'
		elseif items[i].attached == '1' then
			state = '<col name="blue"><layout w="130" h="32" xalign="right" yalign="center">()</layout></col>'
		elseif items[i].stored == '1' then
			state = '<col name="blue"><layout w="130" h="32" xalign="right" yalign="center">(q)</layout></col>'
		end
		if type == ITEM_TYPE_KNIGH or type == ITEM_TYPE_SWORD or type == ITEM_TYPE_BLADE then 
			-- disable
			local texts = {}
			if items[i].equipped == '1' then
				table.insert(texts, get_icon_image_tag(items[i].icon_type)) 
				table.insert(texts, '<layout w="250" h="32" xalign="left" yalign="center"><col name="gray">' .. items[i].name .. '</col></layout>')
				table.insert(disables, num_items)
			else
				table.insert(texts, get_icon_image_tag(items[i].icon_type)) 
				table.insert(texts, '<layout w="250" h="32" xalign="left" yalign="center">' .. items[i].name .. '</layout>')
			end
			table.insert(texts, '<layout w="80" h="32" xalign="left" yalign="center"><col name="blue">cϐ</col></layout>')
			table.insert(texts, '<layout w="80" h="32" xalign="right" yalign="center">' .. items[i].durability .. 'term</layout>')
			table.insert(texts, state)
			table.insert(list, table.concat(texts))
			table.insert(weapon_items, items[i])
			num_items = num_items + 1
		end
	end
	explanation_text:next(make_shop_item_explanation(weapon_items[1]))
	local style = 'view=scroll;disable=' .. join(disables, ',')
	return question('镐I', list, PRIORITY_MENU_SCENE_MENU, style, item_tween, false,
		function (index)
			explanation_text:next(make_shop_item_explanation(weapon_items[index + 1]))
		end)
end
--}}}
--{{{ question_setup_armer
function question_setup_armer(item_tween, explanation_text)
	local items = load_game_data('gamedata.item_profile')
	local armer_items = {}
	local list = {}
	local disables = {}
	local num_items = 0
	for i = 1, #items, 1 do
		local type = tonumber(items[i].type);
		local state = ''
		if items[i].equipped == '1' then
			state = '<col name="blue"><layout w="130" h="32" xalign="right" yalign="center">()</layout></col>'
		elseif items[i].attached == '1' then
			state = '<col name="blue"><layout w="130" h="32" xalign="right" yalign="center"><col name="blue">()</col></layout>'
		elseif items[i].stored == '1' then
			state = '<col name="blue"><layout w="130" h="32" xalign="right" yalign="center"><col name="blue">(q)</col></layout>'
		end
		if type == ITEM_TYPE_ROBE or type == ITEM_TYPE_ARMER then 
			-- disable
			local texts = {}
			if items[i].equipped == '1' then
				table.insert(texts, get_icon_image_tag(items[i].icon_type)) 
				table.insert(texts, '<layout w="250" h="32" xalign="left" yalign="center"><col name="gray">' .. items[i].name .. '</col></layout>')
				table.insert(disables, num_items)
			else
				table.insert(texts, get_icon_image_tag(items[i].icon_type)) 
				table.insert(texts, '<layout w="250" h="32" xalign="left" yalign="center">' .. items[i].name .. '</layout>')
			end
			table.insert(texts, '<layout w="80" h="32" xalign="left" yalign="center"><col name="blue">cϐ</col></layout>')
			table.insert(texts, '<layout w="80" h="32" xalign="right" yalign="center">' .. items[i].durability .. 'term</layout>')
			table.insert(texts, state)
			table.insert(list, table.concat(texts))
			table.insert(armer_items, items[i])
			num_items = num_items + 1
		end
	end
	explanation_text:next(make_shop_item_explanation(armer_items[1]))
	local style = 'view=scroll;disable=' .. join(disables, ',')
	return question('hI', list, PRIORITY_MENU_SCENE_MENU, style, item_tween, false, 
		function (index)
			explanation_text:next(make_shop_item_explanation(armer_items[index + 1]))
		end)
end
--}}}
--{{{ question_setup_item
function question_setup_item(item_tween, explanation_text)
	local items = load_game_data('gamedata.item_profile')
	local list = {}
	local disables = {}
	local num_items = 0
	for i = 1, #items, 1 do
		local state = ''
		if items[i].equipped == '1' then
			state = '<col name="blue"><layout w="130" h="32" xalign="right" yalign="center">()</layout></col>'
		elseif items[i].attached == '1' then
			state = '<col name="blue"><layout w="130" h="32" xalign="right" yalign="center"><col name="blue">()</col></layout>'
		elseif items[i].stored == '1' then
			state = '<col name="blue"><layout w="130" h="32" xalign="right" yalign="center"><col name="blue">(q)</col></layout>'
		end

		-- disable
		local texts = {}
		if items[i].equipped == '1' then
			table.insert(texts, get_icon_image_tag(items[i].icon_type))
			table.insert(texts, '<layout w="250" h="32" xalign="left" yalign="center"><col name="gray">' .. items[i].name .. '</col></layout>')
			table.insert(disables, num_items)
		else
			table.insert(texts, get_icon_image_tag(items[i].icon_type))
			table.insert(texts, '<layout w="250" h="32" xalign="left" yalign="center">' .. items[i].name .. '</layout>')
		end
		table.insert(texts, '<layout w="80" h="32" xalign="left" yalign="center"><col name="blue">cϐ</col></layout>')
		table.insert(texts, '<layout w="80" h="32" xalign="right" yalign="center">' .. items[i].durability .. 'term</layout>')
		table.insert(texts, state)
		table.insert(list, table.concat(texts))
		num_items = num_items + 1
	end
	local style = 'view=scroll;disable=' .. join(disables, ',')
	explanation_text:next(make_shop_item_explanation(items[1]))
	return question('ACeI(c0Xbg)', list, PRIORITY_MENU_SCENE_MENU, style, item_tween, false,
		function (index)
			explanation_text:next(make_shop_item_explanation(items[index + 1]))
		end)
end
--}}}
--{{{ question_setup_ideal
function question_setup_ideal(item_tween, explanation_text)
	local items = load_game_data('gamedata.ideal_profile')
	local list = {}
	for i = 1, #items, 1 do
		table.insert(list, make_ideal_text(items[i]))
	end
	explanation_text:next(items[1].explanation)
	return question('o_I(c0Xbg)', list, PRIORITY_MENU_SCENE_MENU, 'scroll', item_tween, false,
		function (index)
			explanation_text:next(items[index + 1].explanation)
		end
	)
end
--}}}
--{{{ item_menu
function item_menu(explanation_text)

	local items = 
		{
			'<layout w="170" h="24" xalign="center">ACe</layout>',
			'<layout w="170" h="24" xalign="center">qɃACe</layout>',
			'<layout w="170" h="24" xalign="center">bN</layout>',
		}
	local explanations = 
		{
			'_WɂĂACe̎gpEmF',
			'iȊÕACe̊mF',
			'ACe̊mF'
		}

	explanation_text:next(explanations[1])
	local tab_menu = Question:new(make_caption_text('Item Management Menu'), items, PRIORITY_MENU_SCENE_MENU, 'direction=horizontal')
	local tw_init = DownSlideTween:new(0.1, 0.1, 0.8, 0.15, 20)
	tw_init(tab_menu)

	local frame = tab_menu:show()
	wait_frame(frame)
	while true do
		local key = get_key()
		if key == KEY_UP then tab_menu:move_cursor_up()
		elseif key == KEY_DOWN then tab_menu:move_cursor_down()
		elseif key == KEY_LEFT then tab_menu:move_cursor_left()
		elseif key == KEY_RIGHT then tab_menu:move_cursor_right()
		elseif key == KEY_X then 
			sound("sound/cancel.wav")-- LZ
			frame = tab_menu:hide()
			wait_frame(frame)
			tab_menu:dispose()
			return 
		elseif key == KEY_Z then 
			local index = tab_menu:get_current()
			sound("sound/decide.wav")-- 艹
			-- tab_menüʒuvZ
			local prop = tab_menu:get_properties()

			-- item_menû߂tween쐬
			local item_tween = DefaultTween:new(0.1, 0.3, 0.8, 0.45)
			if index == 0 then
				question_attached(item_tween, explanation_text)
			elseif index == 1 then
				question_stored(item_tween, explanation_text)
			elseif index == 2 then
				question_relic(item_tween, explanation_text)
			end
		end	
		local index = tab_menu:get_current()
		explanation_text:next(explanations[index + 1])
	end
end
--}}}
--{{{ setup_menu
function setup_menu(explanation_text)
	local base_width = 500
	local base_height = 400

	local items = 
		{
			'<layout w="120" h="24" xalign="center"></layout>',
			'<layout w="120" h="24" xalign="center">h</layout>',
			'<layout w="120" h="24" xalign="center">_</layout>',
			'<layout w="120" h="24" xalign="center">ACe</layout>',
		}
	local explanations = 
		{
			'̃ZbgAbv',
			'h̃ZbgAbv',
			'퓬ɎQ_̃ZbgAbv',
			'_WɂĂACẽZbgAbv'
		}

	explanation_text:next(explanations[1])
	local tab_menu = Question:new(make_caption_text('Setup Menu'), items, PRIORITY_MENU_SCENE_MENU, 'direction=horizontal')
	local tw_init = DownSlideTween:new(0.1, 0.1, 0.8, 0.15, 20)
	tw_init(tab_menu)

	local frame = tab_menu:show()
	wait_frame(frame)
	while true do
		local key = get_key()
		if key == KEY_UP then tab_menu:move_cursor_up()
		elseif key == KEY_DOWN then tab_menu:move_cursor_down()
		elseif key == KEY_LEFT then tab_menu:move_cursor_left()
		elseif key == KEY_RIGHT then tab_menu:move_cursor_right()
		elseif key == KEY_X then 
			sound("sound/cancel.wav")-- LZ
			frame = tab_menu:hide()
			wait_frame(frame)
			tab_menu:dispose()
			return 
		elseif key == KEY_Z then 
			local index = tab_menu:get_current()
			sound("sound/decide.wav")-- 艹
			-- tab_menüʒuvZ
			local prop = tab_menu:get_properties()

			-- item_menû߂tween쐬
			local item_tween = DefaultTween:new(0.1, 0.3, 0.8, 0.45)
			if index == 0 then
				question_setup_weapon(item_tween, explanation_text)
			elseif index == 1 then
				question_setup_armer(item_tween, explanation_text)
			elseif index == 2 then
				question_setup_ideal(item_tween, explanation_text) 
			elseif index == 3 then
				question_setup_item(item_tween, explanation_text)
			end
		end	
		local index = tab_menu:get_current()
		explanation_text:next(explanations[index + 1])
	end
end
--}}}
--{{{ main_menu
function main_menu()
	
	local explanation_text = text('', ' ', PRIORITY_MENU_DESCRIPTION, nil, UpSlideTween:new(0.1, 0.8, 0.8, 0.12, 20))
	local character_pic = Picture:new('file.image/battler/hero0.png', PRIORITY_MENU_SCENE_CHARACTER)
	local x, y, w, h = to_client_coord(0.4, 0.4, 0.2, 0.2)
	character_pic:set_tween('position2', {[0] = {x, y}})
	character_pic:set_tween('size2', {[0] = {w, h}})
	character_pic:set_tween('texcoord', {['loop'] = {0, 60}, [0] = {0, 0, 1/4, 1/4}, [30] = {0, 1/4, 1/4, 2/4}})
	
	local status = {}
	table.insert(status, text('', '<col code="ffffff">go:300/300</col>', PRIORITY_MENU_SCENE_STATUS, 'view=no-content-bg', RightSlideTween:new(0.1, 0.3, 0.2, 0.12, 30)))
	table.insert(status, text('', '<col code="ffffff">QC:80%</col>', PRIORITY_MENU_SCENE_STATUS, 'view=no-content-bg', RightSlideTween:new(0.12, 0.35, 0.2, 0.12, 32)))
	table.insert(status, text('', '<col code="ffffff">U:200</col>', PRIORITY_MENU_SCENE_STATUS, 'view=no-content-bg', RightSlideTween:new(0.14, 0.4, 0.2, 0.12, 34)))
	table.insert(status, text('', '<col code="ffffff">ђʗ:20</col>', PRIORITY_MENU_SCENE_STATUS, 'view=no-content-bg', RightSlideTween:new(0.16, 0.45, 0.2, 0.12, 36)))
	table.insert(status, text('', '<col code="ffffff">h:100</col>', PRIORITY_MENU_SCENE_STATUS, 'view=no-content-bg', RightSlideTween:new(0.18, 0.5, 0.2, 0.12, 38)))
	table.insert(status, text('', '<col code="ffffff">ϐ:50</col>', PRIORITY_MENU_SCENE_STATUS, 'view=no-content-bg', RightSlideTween:new(0.2, 0.55, 0.5, 0.12, 40)))
	table.insert(status, text('', '<col code="ffffff">Cϐ:50</col>', PRIORITY_MENU_SCENE_STATUS, 'view=no-content-bg', RightSlideTween:new(0.22, 0.6, 0.2, 0.12, 42)))
	table.insert(status, text('', '<col code="ffffff">ϐ:50</col>', PRIORITY_MENU_SCENE_STATUS, 'view=no-content-bg', RightSlideTween:new(0.24, 0.65, 0.2, 0.12, 44)))
	table.insert(status, text('', '<col code="ffffff">d͑ϐ:50</col>', PRIORITY_MENU_SCENE_STATUS, 'view=no-content-bg', RightSlideTween:new(0.26, 0.7, 0.2, 0.12, 46)))

	-- np֐
	local finalizer = function ()
		explanation_text:hide()
		for idx, val in ipairs(status) do
			val:hide()
		end
		wait_frame(20)
		explanation_text:dispose()
		character_pic:dispose()
		for idx, val in ipairs(status) do
			val:dispose()
		end
	end
	
	local items = 
		{
			'<layout w="140" h="24" xalign="center">ACeǗ</layout>',
			'<layout w="140" h="24" xalign="center">ZbgAbv</layout>',
			'<layout w="140" h="24" xalign="center">VXe</layout>',
			'<layout w="140" h="24" xalign="center"><col name="gray">_WEo</col></layout>',
		}
	local explanations = 
		{
			'ACe̎gpEmF/bN̊mF',
			'ACeAiA_̃ZbgAbv',
			'Z[u/[h/ݒ',
			'_WEo',
		}
	explanation_text:next(explanations[1])

	local answer
	while true do
		answer = question(make_caption_text('Main Menu'), items, PRIORITY_MENU_SCENE_MENU, 'disable=3;direction=horizontal', DownSlideTween:new(0.1, 0.1, 0.8, 0.15, 20), false,
			function (index)
				explanation_text:next(explanations[index + 1])
			end)
		if answer == 0 then
			break
		elseif answer == 1 then
			item_menu(explanation_text)
		elseif answer == 2 then
			setup_menu(explanation_text)
		elseif answer == 3 then
			--answer = question('VXej[', {'Z[u', '[h', 'ݒ'})
		elseif answer == 4 then
		end 
		explanation_text:next(explanations[answer])
	end -- Cj[
	finalizer()
end
--}}}
