;;; monkey-script.el --- script file for monkey.el to run with ---

;;; License

;; This program is free software; you can redistribute it and/or
;; modify it under the terms of the GNU General Public License
;; as published by the Free Software Foundation; either version 2
;; of the License, or (at your option) any later version.

;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program; if not, write to the Free Software
;; Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

;;; Developer

;; tkoba
;; talltale@users.sourceforge.jp


;;; Dependencies

;;
;; This needs common lisp (cl.el)
;;
;; This is called by monkey.el
;;

;;; Code:

(require 'cl)


;; ------------------------------------------
;; mode specific regular expressions.
;; ------------------------------------------

(require 'monkey-config)




;; ---------------------------------------------------------
;; monkey-builder MAKE MTAG file start
;; ---------------------------------------------------------

(defconst tags-file-path nil
  "The file containing tree of monkey project.")
(defconst monkey-matches nil)
(defconst tags-insert-file-name-format        "\n%s\n")
(defconst tags-insert-functions-format        "%s,%s\n")

(defconst monkey-project-root nil)
(defconst monkey-project-type nil
"the programing type of a project.")


;; main ֐
(defun monkey-script (arg1 arg2)

  (setq monkey-project-root arg1)
  (setq monkey-project-type arg2)
  (setq tags-file-path (expand-file-name tags-name monkey-project-root))

  (monkey-regexps-set monkey-project-type) 

  (message (concat "monkey-project-root:" monkey-project-root))
  (message (concat "monkey-project-type:" monkey-project-type))
  (message (concat "monkey-regexps:" monkey-regexps))
  (message (concat "monkey-file-mask:" monkey-file-mask))

  (monkey-builder))

;; MTAG ̍쐬
(defun monkey-builder ()
  "vWFNgc[\At@Cɏo͂.
DIRŎw肵fBNgȉċAIɓǂݍ݁A
INPUTSŎw肵gq̃t@CƂ̒̊֐WA
TAGSŎw肵t@Cɏ."

  (save-excursion

    ;; don't make pesky backup files
    (setq make-backup-files nil)
    ;; codings
    (set-default-coding-systems 'utf-8-unix)

    ;; tags t@Cobt@WJ
    (message (concat "open file:" tags-file-path))
    (set-buffer (find-file-noselect tags-file-path))
    (setq buffer-read-only nil) ; unlock
    (erase-buffer)
    (insert (format "PROJECT[%s] TYPE[%s] BUILD[%s]\n" monkey-project-root monkey-project-type (current-time-string)))
    ;; vWFNgc[\
    (monkey-builder-find monkey-project-root monkey-project-type)
    (basic-save-buffer)
    (setq buffer-read-only t)   ; lock
    ))


(defun monkey-builder-find (dir inputs)
  "decide which regular expression to use"
  (let ((files nil))
    ;;(monkey-regexps-set inputs) ; DEL 2008/8/10 tkoba
    (message "Listing files...")
    (cond
     ((listp dir)
      (while dir
        (cond
         ((file-directory-p (car dir))
          (setq files (append
                       (reverse (monkey-builder-find-subdir (car dir) monkey-file-mask))
                       files)))
         (t
          (setq files (cons
                       (car dir)
                       files))))
        (setq dir (cdr dir))))
     (t
      (setq files (reverse (monkey-builder-find-subdir dir monkey-file-mask)))))
    (message "Listing files done!")
    (monkey-builder-search-files monkey-regexps files)))

(defun monkey-builder-find-subdir (dir mask)
  (let ((files (cdr (cdr (directory-files dir t)))) (list))
    (dolist (elt files)
      (message (format "Listing %s ..." (file-name-directory elt)))
      (cond
       ((and
         (not (string-match "^[.]+$" (file-name-nondirectory elt)))
         (file-directory-p elt))
        (setq list (append (monkey-builder-find-subdir elt mask) list)))
       ((string-match "^[.]+$" (file-name-nondirectory elt))
        ())
       ((string-match mask (file-name-nondirectory elt))
        (push elt list))
       (t ())))
    list))

(defun monkey-builder-search-files (regexps files)
  "Search REGEXP in FILES (list)."
  (save-excursion
    (let ((monkey-matches 0))
      (set-buffer (get-buffer-create " *tmp*")) ; tmp obt@̍쐬
      (while files
        (erase-buffer)
        (insert-file-contents (car files))
        (monkey-builder-search-buffer regexps (car files))
        (setq files (cdr files)))

      (message "Searching done!")
      (sit-for 1)
      (if (= monkey-matches 0)
          (progn (message "no matches") (sit-for 1))))))

(defun monkey-builder-search-buffer (regexp file-name)
  "Search a file FILE-NAME with regular expression REGEXP."
  (monkey-builder-insert-file-name file-name)
  (while (re-search-forward regexp nil t)
    (setq monkey-matches (1+ monkey-matches))
    (message "matches[%d]" monkey-matches)
    (monkey-builder-insert-functions (buffer-substring (match-beginning 1) (match-end 1))
                                     (match-beginning 1))))

(defun monkey-builder-insert-file-name (file-name)
  "Insert into tags buffer FILE-NAME."
  (save-excursion
    (set-buffer (get-buffer (file-name-nondirectory tags-file-path)))
    (insert (format tags-insert-file-name-format file-name))))

(defun monkey-builder-insert-functions (function-name found-point)
  "Insert into tags buffer FUNCTION-NAME FOUND-POINT."
  (save-excursion
    (set-buffer (get-buffer (file-name-nondirectory tags-file-path)))
    (insert (format tags-insert-functions-format function-name found-point))))
 
;; ---------------------------------------------------------
;; monkey-builder MAKE MTAG file end
;; ---------------------------------------------------------




;;; monkey-script.el
