
////////////////////////////////
/// neuron.js による処理 /////////

function addedTemplateValue(answer){
    closeFloatPanel();
    initForm();
}
function addTemplateValue(parentId, label, array){
	// テンプレート規定値を追加
    var title = window.prompt("この入力値セットのタイトルをつけてください", "");
    if (!title) return;
    
    var obj = new Object();
    for (num in array){
        var rec = array[num];
        var field = document.getElementById(rec.id + ".value");
        
        if (field && field.value.length)
            obj[rec.label] = field.value;
    }
    
    // ## 頻度更新にもこれを使う
    // ## そうしないと public を元にしている場合 ohashi に val="" を書きこんでしまう
	var val = encodeSTRING(encodeObject(obj));
    // 伝票では第２引数が cell.tag テンプレートでは第２引数が cell.label
	NRPutMenuTemplate(owner(), cellLabel(), label, title, "", val, addedTemplateValue);
}

function removedTemplateMenu(answer){
    closeFloatPanel();
    initForm();
}
function removeTemplateMenu(label, menu){
    // label テンプレートから menu を削除
    if (confirm("「" + menu + "」メニューを削除します"))
        // 伝票では第２引数が cell.tag テンプレートでは第２引数が cell.label
        NRRemoveMenuTemplate(owner(), cellLabel(), label, menu, removedTemplateMenu);
}

/// neuron.js による処理 /////////
////////////////////////////////

/////////////////////////////////////////////////////
///// テンプレート・メニュー ////////////////////////////

var _parentId;
var _templateLabel;
var _castX;
var _castY;
var _castW = 100;

var _templateArray;
function setTemplateArray(array){
    // array: "owner(ohashi)tag(検査)value(ut.size^[^normal^]^adnex^[^不明^]^)public(0)freq(140)menu(超音波所見)template()" 型式
    _templateArray = array;
    
    //alert("setTemplateArray->"+encodeObject(array)); //##
}
function templateArray(){
    // テンプレートの入った配列を返す
    return _templateArray;
}
function templateFor(item, tempName){
    // item, tempName に対するテンプレートを返す
    for (num in _templateArray){
        var rec = _templateArray[num];
        if ((rec.menu == item) && (rec.template == tempName)){
            return rec;
        }
    }
    return "";
}

function showCellContents(tr, cellId, label, val){
	// テンプレートの CELL 一個を表示
	tr.innerHTML = "";
	var td1 = newTD(tr, "formRecordLeft", label); // 名称
	var td = newTD(tr, "formRecordRight", ""); // 単位
	var unit = unitOfRecord(val);
	var size = (unit.length > 0) ? 10 : 20;
	
	// ポップアップメニューがあれば表示
	var menu = menuOfRecord(val);
	if ((menu != null) && (menu.length > 0)){
		showPopUp(cellId, menu, valueOfRecord(val));
		size = 10;
	} else {
        // テンキーを表示
        var tr = document.getElementById(cellId);
        var td = tr.childNodes[1]; // right side FORM
        var a = newA(td, "数値入力", "#", "");
        a.style.padding = "0 5px";
        a.setAttribute("onclick","showTenKey(this,'"+cellId+".value"+"')");
    }
	
	// 入力欄を表示
	var hd = newHIDDEN(td, cellId+".range", rangeOfRecord(val));
	var fd = newFIELD(td, cellId+".value", "", size, valueOfRecord(val));
	var action = "checkValue('"+cellId+"')";
	fd.setAttribute("onchange", action);
	
	// 単位表示
	var sp = newSPAN(td, cellId+".unit");
	sp.innerHTML = unit;
	//var tx = newTEXT(sp, " ");
	
	// 入力された値のチェックを行う
	checkValue(cellId);
}

function childrenForId(parentObj, targetId){
    // targetId に相当するオブジェクトの children を返す
    if (parentObj.id && (parentObj.id == targetId)){
        return parentObj.children;
    }
    
    for (key in parentObj){
        // parentObj の子供オブジェクトを検索
        var obj = parentObj[key];
        
        if (typeof obj == "object"){
            var array = childrenForId(obj, targetId);
            if (array) return array;
        }
    }
    return null;
}

function selectTemplate(button, parentId, label){
    // テンプレート・ポップアップが選択された
    var array = childrenForId(structure(), parentId);
    //alert("array->"+encodeObject(array)); //##
    
    if (array == null){
        alert("selectTemplate *** no children");
        return;
    }
    
    var title = button.innerHTML;
    if (title == "空欄") {
        // すべてのフィールドを空欄にする
        for (num in array){
            var rec = array[num];
            var field = document.getElementById(rec.id + ".value");
            
            if (field) field.value = "";
        }
    } else if (title == "...その他"){
        addTemplateValue(parentId, label, array);
    } else {
        // 選択されたテンプレートで各フィールドを上書きする
        var val = templateFor(label, title).value; // "心拍(+)尿蛋白(-).." 形式
        var templateObj = decodeObject(val);
        
        // すべてのフィールドを上書きする
        for (num in array){
            var rec = array[num];
            var field = document.getElementById(rec.id + ".value");
            if (!field) continue;
            
            var val = templateObj[rec.label];
            field.value = (val) ? val : "";
        }
    }
    closeFloatPanel();
}

function formTemplateHelp(){
    // FORM のテンプレート・ヘルプを開く
    var url = "formTemplateHelp.html";
    window.open(url,"Help","width=450,height=700,scrollbars=yes,resizable=yes");
}

function showCast(answer){
    // 鋳型テンプレートを開く
    var records = JSON.parse(answer);
    setTemplateArray(records);
    
    var label = _templateLabel;
    var templates = new Array();
    for (num in records){
        var rec = records[num];
        if (!rec.template) continue;
        
        if ((rec.menu == label) && rec.template.length){
            templates.push(rec.template);
        }
    }
    templates.splice(0, 0, "空欄");
    templates.push("...その他");

    var elm = openSeeThroughPanel("floatPanel", _castX, _castY, _castW, null, "formTemplateHelp()");
    var action = "selectTemplate(this,'"+_parentId+"','"+label+"')";
    for (num in templates){
        var menu = templates[num];
        var div = newDIV(elm, "/clearfix");
        // --- LEFT ---
        var dv = newDIV(div, "/left-side");
        dv.style.padding = "2px 0px";
        dv.style.width = "80%";
        var bt = newDIV(dv, "/blueButton");
        bt.innerHTML = menu;
        bt.setAttribute("onclick", action);
        // --- RIGHT ---
        var dv = newDIV(div, "/right-side");
        dv.style.padding = "2px 0px";
        if (num < templates.length - 1){
            var img = newIMAGE(dv, "icon", "./remove-field.png", "X");
            var act = "removeTemplateMenu('" + label + "','" + menu + "')";
            img.setAttribute("onclick", act);
            img.style.marginRight = "2px";
            img.style.position = "relative";
            img.style.top = "3px";
        }
    }
}
function getTemplateMenu(button, parentId, label){
    // テンプレート・メニューをサーバへリクエスト
    _parentId = parentId;
    _templateLabel = label;
    
    var pos = getPosition(button);
	_castX = pos.x - _castW + 10; // テンプレート・パネルを表示するx座標
	_castY = pos.y; // テンプレート・パネルを表示するy座標
    
    // cellLabel():検査（CELL ラベル） label:妊婦健診（伝票名）
    // 伝票では第２引数が cell.tag テンプレートでは第２引数が cell.label
    NRGetMenu(owner(), cellLabel(), showCast); //##
}

///// テンプレート・メニュー ////////////////////////////
/////////////////////////////////////////////////////
