

/////////////////////////
///// カルテからの継承値 ///

function patientId(){
    return parent().patientId();
}

function patientKanjiName(){
    return parent().patientKanjiName();
}

function currentDate(){
    return parent().currentDate();
}

function owner(){
    return parent().owner();
}

///// カルテからの継承値 ///
/////////////////////////

///////////////////////////////////
/// localStorage による処理 /////////

function getWindowSize(){
	// DocMaker のウインドー位置とサイズを localStorage から取り出す
    var windowStatus = window.localStorage["CorrectionHistoryWindowSize"];
    if (windowStatus){
        var array = windowStatus.split(",");
        var x = array[0];
        var y = array[1];
        var w = array[2];
        var h = array[3];
		// resize を先にしておかないと元が大きいサイズだった場合 moveTo しよう
		// としてもウインドー境界の制限で移動できない場合がある
		window.resizeTo(w, h);
		window.moveTo(x, y);
    }
}

/// localStorage による処理 /////////
///////////////////////////////////

function isTool(){
    return (window.name == "iframe") ? true : false;
}

var _records;
function setRecords(array){
    _records = array;
}
function records(){
    // 修正履歴としての ProgressSection レコードの配列
    return _records;
}
function recordForDate(dateTime){
    // 修正履歴としての ProgressSection レコードの配列
    for (num in _records){
        var rec = _records[num];
        if (rec['ProgressSection.updateTime'] == dateTime) return rec;
    }
    return null;
}

function showLogContents(elm){
    // dateTime の内容を表示
    var dateTime = elm.value;
    var rec = recordForDate(dateTime);
    if (!rec){
        alert(dateTime + " の日時に 修正前の記述はありませんでした");
        return;
    }
    _debug("showLogContents->"+encodeObject(rec));

    var elm = document.getElementById("logContentsArea");
    elm.innerHTML = "";
    
    // 修正履歴を表示するエリアを生成
    var tbl = newTABLE(elm, "");
    tbl.style.wodth = "100%";
    tbl.style.fontSize = "10pt";
    
    // 各 CELL 毎の修正履歴を表示
    var array = parent().layoutForMode(_progress_);
    for (num in array){
        var cell = array[num];
        var tag = cell.tag;

        var tr = newTR(tbl, "", "");
        if (tag == "ProgressSection.freq") tr.style.color = "#ccc";
        // LABEL
        var td = newTD(tr, "", cell.label);
        td.style.width = "55px";
        td.style.padding = "0 5px";
        td.style.verticalAlign = "top";
        td.style.backgroundColor = "#ec9";
        // VALUE
        var value = (rec[tag]) ? rec[tag] : "";
        value = transferCR(value); // 改行を <br> に変換
        var td = newTD(tr, "", "");
        td.innerHTML = value; // HTML を表示するため innerHTML へ与える
        td.style.padding = "0 5px";
        td.style.borderBottom = "thin solid #ccc";
    }
}

var _logTD;
function showLog(answer){
    // dateTime の修正履歴を表示
    //console.log("== showLog"); //##
    var array = JSON.parse(answer);
    var dateTime = array[0]['ProgressSection.entryDate'];
    setRecords(array);
    
    // 他の修正履歴が開いていれば消去
    if (_logTD) _logTD.innerHTML = "";
    
    // dateTime の修正履歴を表示する行を取得
    var elm = document.getElementById(dateTime + ".logRow");
    elm.innerHTML = "";
    _logTD = newDIV(elm, "logArea");

    // 修正日時のポップアップ・メニューを生成
    var correctionHistory = [""];
    var array = records();
    
    for (num in array){
        var rec = array[num];
        _debug("updateTime->"+rec['ProgressSection.entryDate']); //##
        var freq = rec['ProgressSection.freq'];
        if (!freq || (freq * 1 == 0)) continue;
        
        correctionHistory.push(rec['ProgressSection.updateTime']);
    }
    //_debug("correctionHistory->"+correctionHistory); //##
    
    var div = newDIV(_logTD, "");
    div.style.backgroundColor = "#ffe";
    div.style.border = "thin solid #aaa";
    div.style.fontSize = "10pt";
    var sp = newSPAN(div, "");
    sp.style.paddingLeft = "10px";
    if (correctionHistory.length > 1){
        sp.innerHTML = "修正日時";
        sp.style.paddingRight = "5px";
        var pu = newPopupMenu(div, "", correctionHistory, "");
        pu.setAttribute("onchange", "showLogContents(this)");
    } else {
        sp.innerHTML = "このページでは修正ありません";
    }

    // 修正ログを表示するエリア
    var dv = newDIV(div, "logContentsArea");
}
function getLog(dateTime){
    // dateTime の修正履歴をサーバへリクエスト
    if (isTool() == false){
        // Booking のウインドー位置とサイズをサーバへ記憶
        put_windowSize(0, -22, "CorrectionHistoryWindowSize");
    }

    // log ポップアップ表示領域をトグル式に表示・非表示
    var elm = document.getElementById(dateTime + ".logRow");
    if (elm.innerHTML.length > 0){
        elm.innerHTML = "";
        return;
    }

    var args = new Object();
    args["owner"] = owner();
    args["patientId"] = patientId();
    args["entryDate"] = dateTime;
    
    NRCall("GET_CORRECTION_HISTORY", args, showLog);
}


function gotPages(answer){
    //_debug("== openPages ->"+answer); //##
    
    var obj = JSON.parse(answer);
    //console.log("gotPages", encodeObject(obj)); //##
    
    // ### noa() 経由でなく neuron.js へ直接書込む
    setNameObj(obj.nameSection);
    setProgressObj(obj.progressSection);
    
    // 受信履歴を表示
    var elm = document.getElementById("contentsArea");
    elm.innerHTML = "";
    var tbl = newTABLE(elm, "/base-table");
    tbl.style.fontSize = "10pt";
    tbl.style.marginTop = "5px";

    var tr = newTR(tbl, "", "");
    tr.style.borderBottom = "thin solid #ccc";
    var td = newTD(tr, "", "受診年月日");
    td.style.textAlign = "center";
    td.style.width = "170px";
    var td = newTD(tr, "", "主訴");
    td.style.textAlign = "center";

    var array = history();
    //alert("gotPages->"+encodeObject(array)); //##
    
    for (num in array){
        var dateTime = array[num];
        var rec = obj.progressSection[dateTime];
        var tr = newTR(tbl, dateTime + ".row", "");
        // entryDate
        var td = newTD(tr, "/record", dateTime);
        td.setAttribute("onclick", "getLog('" + dateTime + "')");
        td.style.textAlign = "center";
        td.style.verticalAlign = "top";
        // subject
        var st = (rec.subject) ? rec.subject.val : "";
        var td = newTD(tr, "", st);
        // 修正ポップアップ表示エリア
        var tr = newTR(tbl, "", "");
        var td = newTD(tr, dateTime + ".logRow", "");
        td.setAttribute("colspan", "2");
        td.style.borderBottom = "thin solid #ccc";
    }
}

function help(){
	window.open("./help.html","Help"
				,"width=450,height=700,scrollbars=yes,resizable=yes");
}

function closeHistory(){
    // TOOL AREA を閉じる
    var tools = window.top.tools;
    
    tools.closeToolArea();
}

function init(){
    //_initDebug(true); //##
    
	var elm = document.getElementById("base");
	
	// === HEADER =======================
    var div = newDIV(elm, "/tool-header");
    var dv = newDIV(div, "/left-side");
    dv.style.fontSize = "12px";
    dv.style.width = "80%";
    // CLOSE ICON
    var im = newIMAGE(dv, "icon", "../NOA/close.png", "?");
    im.style.height = "12px";
    im.setAttribute("onclick", "closeHistory()");
    im.setAttribute("class", "expandIcon");
    // TITLE
    var sp = newSPAN(dv, "");
    sp.innerHTML = "修正履歴";
    sp.style.marginLeft = "10px";
    var dv = newDIV(div, "/right-side");
    // HELP ICON
	var img = newIMAGE(dv, "", "./help.png", "?");
	img.style.height = "18px";
    img.setAttribute("onclick", "help()");
    img.setAttribute("class", "expandIcon");
    
    // === CONTENTS ======================
    var contentsDiv = newDIV(elm, "contentsArea");

	// === FOOTER ===================
    var div = newDIV(elm, "/tool-footer");
    var dv = newDIV(div, "/left-side");
    var dv = newDIV(div, "/right-side");
    dv.innerHTML = version();

    if (!parent()){
        alert("NOA のツール・メニューから開いてください");
        if (isTool() == false) window.close();
    } else if (!patientId()){
        alert("修正履歴の対象となるカルテが開いていません");
        if (isTool() == false) window.close();
    } else {
        if (isTool() == false) getWindowSize();
        get_pages(owner(), patientId(), gotPages);
    }
}

function version(){
    return "Ver.140804";
}

