
/////////////////////////////////////////////
///// NOA からの継承値 /////////////////////////

// NOA 組込みの場合は patientId() などを直接取得できるが
// 外付けツールにも出来るようあえて以下の仕組みを使う

function owner(){
    return parent().owner();
}

function patientId(){
    return parent().patientId();
}

function patientKanjiName(){
    return parent().patientKanjiName();
}

function currentDate(){
    return parent().currentDate();
}

function timeLimit(){
    return parent().timeLimit();
}

function isReadOnly(){
    return parent().isReadOnly();
}

function layouts(){
    return parent().layoutForMode(_basic_);
}

function cellForTag(tag){
    return parent().cellForTag(tag);
}

function setValueForTag(tag, dateTime, value){
    return parent().setValueForTag(tag, dateTime, value);
}
function valueForTag(tag){
    return parent().valueForTag(tag);
}

function setGroupEditorOpen(status){
    parent().setGroupEditorOpen(status);
}

function groupEditorOpen(){
    // グループ・メニューのサブ・エディターが開いていれば true を返す
    return parent().groupEditorOpen();
}

function removeCheck(){
    // 編集可・不可のボタンを操作
    parent().removeCheck();
}

function openChart(){
    parent().openChart(patientId());
}

function nextTag(tag){
    // basicPage 内における tag の次の tag を返す：NOA 本文では dataCenter.js で定義
    var cell = cellForTag(tag);
    if (cell.script){
        // script が設定されている場合は script に従いジャンプ
        var condition = parent().jumpCondition(cell.script);
        var jumpTag = parent().jumpTag(cell.script);

        if (condition){
            // 条件に一致したら jumpTag を返す
            var status = eval('(' + condition + ')');
            
            if (status) return jumpTag;
        } else {
            // 無条件で jumpTag を返す
            return jumpTag;
        }
    }
    
    var found = false;
    var array = parent().layoutForMode(_basic_);
    for (num in array){
        var layoutObj = array[num];
        if (layoutObj.hitAndRun * 1) continue; // 非表示セルをスキップ
        
        if (found) return layoutObj.tag;

        if (layoutObj.tag == tag) found = true;
    }
    return null;
}

function setCurrentTag(tag){
    parent().setCurrentTag(tag);
}
function currentTag(){
    return parent().currentTag();
}

///// NOA からの継承値 /////////////////////////
//////////////////////////////////////////////

function scrollEditor(dateTIme, tag){
    // cellEditor を見える位置にスクロール
    var elm = valueElementForTag(dateTIme, tag);
    var pos = getPosition(elm);
    window.scroll(0, pos.y - 100);
}

function gotPage(answer){
    // BasicPage のデータを受取り dataCenter へ記憶
    var obj = JSON.parse(answer);
    // nameSection は GET_PAGES でも取得しているが currentDate() のレコードで上書き
    parent().setNameObj(obj.nameSection);
    parent().setAddressObj(obj.addressSection);
    parent().setBasicObj(obj.basicSection);
    parent().setMaritalObj(obj.maritalSection);
    parent().setUniversalObj(obj.universalSection);
    
    var elm = document.getElementById("contentArea");
    elm.innerHTML = "";
    
    // 受診年月日を強制的に表示
    var tbl = newTABLE(elm, "/base-table");
    var tr = newTR(tbl, "", "");
    var td = newTD(tr, "/cellLabel", "受診日"); // LABEL
    var td = newTD(tr, "/cellValue", currentDate()); // VALUE
    
    if (layouts()){
        for (num in layouts()){
            var cell = layouts()[num];
            
            if ((cell.hitAndRun * 1) == 0){ // 非表示セルではない
                openCell(elm, cell, currentDate(), true);
            }
        }
    }
    // FOOTER ==========================
    var div = newDIV(elm, "/tool-footer");
    var sp = newSPAN(div, "/versionLabel");
    sp.innerHTML = version();

    // iOS なら基本情報を折りたたむ 
    var status = isIOS();
    var style = frameStyle(); // localStorage.js
    if (style == "垂直")
        status = true;
    else if (style == "水平")
        status = false;

    if (status){
        toggleBasicInfo();
    }
    
    // === problemList を表示 ============
    showProblemList("problemListArea", "expand"); // problemList.js

    if (openInsViewerStatus() * 1 > 0){ // InsViewer 自動起動モードなら
        // 保険証画像のスキャンされた日付をリクエスト
        var args = new Object();
        args["patientId"] = trim(patientId());
        NRCall("GET_INS_IMAGE", args, got_ScanDate);
    }
}

function got_ScanDate(answer){
    // 保険証画像読込年月日がサーバから返された
    var obj = JSON.parse(answer);
    if (noInsImage(obj)){
        // 保険証画像が保存されていないなら保険証画像読込ツールを開く
        openInsViewer(patientId(), currentDate());
    }
    
    function noInsImage(obj){
        // 保険証画像がなければ true を返す
        if (!obj) return true;
        if (!obj.files) return true;
        for (num in obj.files){
            var filename = obj.files[num];
            if (filename.charAt(0) == "_") continue;
            return false;
        }
        return true;
    }
}

function makeInsranceArea(elm){
    // 保険情報エリアを生成
    elm.innerHTML = "";
    // === HEADER ============================
    var div = newDIV(elm, "/tool-header");
    // --- LEFT SIDE ---
    var dv = newDIV(div, "/left-side");
    var bt = newDIV(dv, "/greenButton");
    bt.innerHTML = "保険情報";
    bt.setAttribute("onclick", "getInsurance()");
    // --- RIGHT SIDE ---
    var dv = newDIV(div, "/right-side");
    dv.style.width = "20px";
    // HELP ICON
    var img = newIMAGE(dv, "", "./help.png", "?");
    img.style.height = "17px";
    img.setAttribute("onclick", "openHelp('insHelp.html')");
    img.setAttribute("class", "expandIcon");
    img.style.position = "relative";
    img.style.top = "2px";
    
    // コンテンツ・エリア ========================
    var div = newDIV(elm, "insContentsArea");
    div.style.border = "thin solid #ddd";
}

function toggleBasicInfo(){
    // 基本情報をトグル式に開閉
    var elm = elmFor("contentArea");
    if (elm.style.display == "none")
        elm.style.display = "block"; // 表示
    else 
        elm.style.display = "none"; // 非表示
}

function initBasicPage(){
    // 基本情報ページを初期化
    var tools = window.top.tools;
    var elm = tools.document.getElementById("base");
    elm.innerHTML = "";
    
    // === TOOL area ========================
    var div = newDIV(elm, "toolArea");
    
    // === PARTS area =======================
    // 伝票や処方など NOA 直轄ツール用エリア
    var div = newDIV(elm, "partsArea");
    
    // === problemList area =================
    var div = newDIV(elm, "problemListArea");

    // === 保険情報 area =====================
    var div = newDIV(elm, "insArea");
    makeInsranceArea(div);
    
    // === 基本情報 ==========================
    // HEADER ==========================
    var div = newDIV(elm, "/tool-header");
    div.style.padding = "5px 0";
    // --- LEFT SIDE ---
    var dv = newDIV(div, "/left-side");
    var dv = newDIV(div, "/greenButton");
    dv.innerHTML = "基本情報";
    dv.setAttribute("onclick", "toggleBasicInfo()");
    dv.style.marginLeft = "10px";
    // --- RIGHT SIDE ---
	var dv = newDIV(div, "/right-side");
    dv.style.width = "20px";
    // HELP ICON
	var img = newIMAGE(dv, "", "./help.png", "?");
	img.style.height = "18px";
    img.setAttribute("onclick", "openHelp('./basicPageHelp.html')");
    img.setAttribute("class", "expandIcon");
    
    // CONTENTS ==========================
    var div = newDIV(elm, "contentArea");
    div.style.border = "thin solid #ddd";

    // basicPage のデータをサーバへリクエスト
    get_page(owner(), patientId(), currentDate(), gotPage);
}

function version(){
    return "Ver.150225";
}
