<?php

    function decodeSTRING($val){
        // #, &, +  < > などが URI 送信で化けるため encode して送られたものを decode
        $array = explode("%x0;", $val);
        $val = implode("#", $array);
        $array = explode("%x1;", $val);
        $val = implode("&", $array);
        $array = explode("%x2;", $val);
        $val = implode("+", $array);
        $array = explode("%x3;", $val);
        $val = implode("<", $array);
        $array = explode("%x4;", $val);
        $val = implode(">", $array);
        $array = explode("%x5;", $val);
        $val = implode(" ", $array);
        $array = explode("%x6;", $val);
        $val = implode("\n", $array);
        $array = explode("%x7;", $val);
        $val = implode("\"", $array);
        $array = explode("%x8;", $val);
        $val = implode("$", $array);
        $array = explode("%x9;", $val);
        $val = implode("\'", $array);
        return $val;
    }
    
    function leftBrackets(){
        // $leftBrackets = "\^\[\^" では誤作動
        //	return "\^\[\^"; // encode 中で使う '(' -- クライアント側との約束 lib.js
        return "^[^"; // encode 中で使う '(' -- クライアント側との約束 lib.js
    }
    function rightBrackets(){
        return "^]^"; // encode 中で使う '(' -- クライアント側との約束 lib.js
        //	return "\^\]\^"; // encode 中で使う '(' -- クライアント側との約束 lib.js
    }
    function decodeObject($buff){
        // "key(value)" 形式の文字列を OBJECT に decode して返す
        $obj = array();
        //	echo "decodeObject ===\n$buff\n"; //##
        for ($p=$begin=$nest=0, $len=strlen($buff); $p < $len; $p++){
            $ch = substr($buff, $p, 1);
            if (strcmp($ch, "(") == 0){
                if ($nest == 0){
                    $key = trim(substr($buff, $begin, $p - $begin)); // key 終端
                    $begin = $p + 1; // value 開始位置
                }
                $nest++;
            } else if (strcmp($ch, ")") == 0){
                if (--$nest == 0){
                    if ($nest == 0){
                        // value 終端 ( trim しない )
                        $value = substr($buff,$begin,$p-$begin);
                        $begin = $p + 1; // key 開始位置
                    }
                    if (preg_match("/\)/", $value)){ // まだ入れ子になっているなら
                        $obj[$key] = decodeObject($value);
                    } else {
                        // 特定文字を "(", ")" へ戻す
                        $array = explode(leftBrackets(), $value);
                        $value = join("(", $array);
                        $array = explode(rightBrackets(), $value);
                        $value = join(")", $array);
                        
                        $obj[$key] = $value;
                    }
                    //echo "$key{".$obj[$key]."}\n"; //##
                }
            }
        }
        return $obj;
    }
    
    
    
    /* ########################################
     ### 以下でも $_POST['key'] と同じに機能する ###
     if (isset($_REQUEST['key'])) {
     $key = $_REQUEST['key'];
     }
     ########################################## */
    
    $command = $_POST['command'];
    $from = $_POST['from'];
    $from = decodeSTRING($from);
    $to = $_POST['to'];
    $to = decodeSTRING($to);
    $subject = $_POST['subject'];
    $subject = decodeSTRING($subject);
    $message = $_POST['message'];
    $message = decodeSTRING($message);
    
    if (strcmp($command,"POST_MAIL") == 0){
        $headers = "From: $from \r\nReply-to: $from \r\nX-Mailer PHP/".phpversion()." \r\n";
        
        echo "<SEPARATOR>";
        echo "To: $to\n"; //##
        echo "$headers\r\n"; //##
        echo "Subject: $subject\n"; //##
        echo "$message"; //##
        
        mail($to, $subject, $message, $headers);
    } else {
        echo "<p>( $command ) is wrong command *****</p>";
    }
    
    ?>