
function owner(){
	return document.getElementById("_owner").value;
}

function dateAndId(){
	return document.getElementById("_dateAndId").value;
}

function entryDate(){
	var array = dateAndId().split("^");
	return array[0];
}

var _record;
function setRecord(){
	// front.js から entryDate に相当するレコードを得る
	var front = window.opener; // window.parent
    console.log("setRecord", front); //##
    console.log("dateAndId", dateAndId()); //##

    _record = front.container(dateAndId());
}
function record(){
	return _record;
}
function patient_id(){
	return record().patientId;
}
function patientName(){
	return record().kanjiName;
}
function insFee(){
	return record().insFee * 1;
}
function ownFee(){
	return record().ownFee * 1;
}
function mishuuDate(){
	return record().unpaidDate;
}
function mishuu(){
	return record().mishuu * 1;
}
function receive(){
	return record().receive * 1;
}

function calcChange(){
    // 入金ボタンが押された
	var charge = document.getElementById("ed_charge").innerHTML;
	var receive = document.getElementById("ed_receive").value;
	var change = receive * 1 - charge * 1;
	if (change < 0)
		document.getElementById("ed_change").innerHTML = "";
	else
		document.getElementById("ed_change").innerHTML = change;
	var unpaid = (change >= 0) ? "" : change * (-1);
	document.getElementById("ed_mishuu").value = unpaid;
}

function registBill(){
	// 患者エディターの内容をDBへ登録
	//   受取額を FrontTable に記録
	//   未収金があれば PatientTable に記録 (frontServer.php で処理)
	var receive = document.getElementById("ed_receive").value * 1;
	var unpaid = document.getElementById("ed_mishuu").value * 1;
	if (unpaid > 0){
		if (! confirm("未収金 " + unpaid + " 円を記録して会計終了しますか"))
			return;
	}
	
	window.close();
	window.opener.putBill(patient_id(),entryDate(),receive,unpaid); // front.js
}

function setEditorValues(){
	// 会計パネルの各欄に値を入れる
	
	// ヘッダー
	var td = document.getElementById("headerArea");
	td.innerHTML = patient_id() + " " + patientName();
	
	// 合計額
	var total = insFee() + ownFee();
	document.getElementById("ed_total").innerHTML = total;
	
	// 未収額
	document.getElementById("ed_unpaid").innerHTML = mishuu();
	var lvd = mishuuDate().substr(0, 10);
	document.getElementById("ed_lvd").innerHTML = lvd;
	
	// 請求額
	document.getElementById("ed_charge").innerHTML = total + mishuu();

	// 受取額
	document.getElementById("ed_receive").value = receive();

	// 釣銭
	document.getElementById("ed_change").innerHTML = "";
	
	// 未収金
	document.getElementById("ed_mishuu").innerHTML = "";
}

function initBillEditor(){
	// front から該当レコード属性を取得
    console.log("initBillEditor"); //##
	setRecord();
	
	var base = document.getElementById("base");
	var tbl = newTABLE(base, "billEditor");
	
	// ヘッダー
	var tr = newTR(tbl,"ed_title","");
	var td = newTD(tr, "headerArea", "");
	td.setAttribute("COLSPAN", 4);
	
	var tr = newTR(tbl,"","");
	var td = newTD(tr, "ed_label", "合計額");
	var td = newTD(tr, "ed_total", "");
	
	var tr = newTR(tbl,"","");
	var td2 = newTD(tr, "", "");
	var tbl2 = newTABLE(td2, "billEditor");
	var tr2 = newTR(tbl2,"","");
	var td = newTD(tr2, "ed_lvd", "");
	var tr2 = newTR(tbl2,"","");
	var td = newTD(tr2, "ed_lvd_label", "前回未収");
	var td = newTD(tr, "ed_unpaid", "");
	
	var tr = newTR(tbl,"","");
	var td = newTD(tr, "ed_label", "請求額");
	var td = newTD(tr, "ed_charge", "");

	var tr = newTR(tbl,"","");
	var td = newTD(tr, "ed_label", "受取額");
	var ip = newFIELD(tr, "ed_receive", "", 8, "");
	ip.style.fontSize = 18;
	ip.setAttribute("onchange", "calcChange()");
	ip.focus();
	var tx = newTEXT(tr, "　");
	var bt = newBUTTON(tr, "", "入金");
	bt.setAttribute("onclick", "calcChange()");
	
	var tr = newTR(tbl,"","");
	var td = newTD(tr, "ed_label", "お釣り");
	var td = newTD(tr, "ed_change", "");

	var tr = newTR(tbl,"","");
	var td = newTD(tr, "ed_label", "未収金");
	var ip = newFIELD(tr, "ed_mishuu", "", 8, "");
	ip.style.fontSize = 18;
	ip.style.color = "#f06";
	
	// フッター
	var tr = newTR(tbl,"ed_control","");
	var td = newTD(tr,"","");
	td.setAttribute("COLSPAN", 4);
	var bt = newBUTTON(td, "", "とりやめ");
	bt.setAttribute("onclick", "window.close()");
	
	var bt = newBUTTON(td, "", "確定");
	bt.setAttribute("onclick", "registBill()");
	setEditorValues();
}
