
///////////////////////////
/// Ajax による処理 /////////

function gotPatientList(answer){
    //console.log("== gotPatientList", answer); //##
    
    if (answer.length > 1){
        var array = JSON.parse(answer);
        makeList(array);
    } else
        document.getElementById("message").innerHTML = value;
	
	function makeList(records){
        //console.log("makeList->", encodeObject(records)); //##
        
		var count = records.length;
		if (count == 0){
			document.getElementById("findResultArea").innerHTML = "";
			document.getElementById("message").innerHTML = "Nothing ...";
			return;
		}

		var dom = document.getElementById("findResultArea");
		dom.innerHTML = "";
        
		var tbl = newTABLE(dom, "subTable");
        tbl.style.backgroundColor = "#ffe";
		var tr = newTR(tbl, "resultBar", "");
		var td = newTD(tr, "", "NO");
        td.style.paddingLeft = "5px";
		var td = newTD(tr, "", "氏名");
		var td = newTD(tr, "", "最終受診日");
        
		for (r in records){
			var rec = records[r];
			var kanji = (rec.patientKanjiName) ? rec.patientKanjiName : "";

			if (count == 1){
				// 検索結果が１件のみなら直ちにそのカルテを開く
				document.getElementById("findResultArea").innerHTML = "";
				document.getElementById("message").innerHTML = "";
				openChart(rec.patientId, kanji);
				return;
			}

			var tr = newTR(tbl, "recordTR", "");
			var action = "openChart('" + rec.patientId + "','" + kanji + "')";
			tr.setAttribute("onclick", action);
			var td = newTD(tr, "", rec.patientId);
            td.style.paddingLeft = "5px";
			var td = newTD(tr, "", kanji);
			var td = newTD(tr, "", rec.lastVisitDate);
		}

		var tr = newTR(tbl, "resultBar", "");
		var count = records.length + " 件 見つかりました";
		var td = newTD(tr, "resultFooter", count);
		td.setAttribute("colspan", "3");
        td.style.paddingLeft = "5px";
		document.getElementById("message").innerHTML = "";
	}
}

function showPatientList(key){
	// 検索キーにマッチしたカルテのリストを表示
    var args = new Object();
    args["key"] = "roma";
    args["val"] = key;
    
    //console.log("showPatientList", key); //##
    
    NRCall("GET_PATIENTS", args, gotPatientList);
}

/// Ajax による処理 /////////
///////////////////////////

