/*
 * Decompiled with CFR 0.152.
 */
package onig4j;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import onig4j.OnigCaseFoldType;
import onig4j.OnigHandle;
import onig4j.OnigOptionType;
import onig4j.OnigRegion;
import onig4j.OnigSyntaxType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OnigRegex
extends OnigHandle {
    private static WarningListener warnListener;
    private static WarningListener verbListener;
    private final String pattern;
    private OnigSyntaxType syntax;
    public static final int ONIG_NORMAL = 0;
    public static final int ONIG_MISMATCH = -1;
    public static final int ONIG_NO_SUPPORT_CONFIG = -2;
    public static final int ONIGERR_MEMORY = -5;
    public static final int ONIGERR_TYPE_BUG = -6;
    public static final int ONIGERR_PARSER_BUG = -11;
    public static final int ONIGERR_STACK_BUG = -12;
    public static final int ONIGERR_UNDEFINED_BYTECODE = -13;
    public static final int ONIGERR_UNEXPECTED_BYTECODE = -14;
    public static final int ONIGERR_MATCH_STACK_LIMIT_OVER = -15;
    public static final int ONIGERR_DEFAULT_ENCODING_IS_NOT_SETTED = -21;
    public static final int ONIGERR_SPECIFIED_ENCODING_CANT_CONVERT_TO_WIDE_CHAR = -22;
    public static final int ONIGERR_INVALID_ARGUMENT = -30;
    public static final int ONIGERR_END_PATTERN_AT_LEFT_BRACE = -100;
    public static final int ONIGERR_END_PATTERN_AT_LEFT_BRACKET = -101;
    public static final int ONIGERR_EMPTY_CHAR_CLASS = -102;
    public static final int ONIGERR_PREMATURE_END_OF_CHAR_CLASS = -103;
    public static final int ONIGERR_END_PATTERN_AT_ESCAPE = -104;
    public static final int ONIGERR_END_PATTERN_AT_META = -105;
    public static final int ONIGERR_END_PATTERN_AT_CONTROL = -106;
    public static final int ONIGERR_META_CODE_SYNTAX = -108;
    public static final int ONIGERR_CONTROL_CODE_SYNTAX = -109;
    public static final int ONIGERR_CHAR_CLASS_VALUE_AT_END_OF_RANGE = -110;
    public static final int ONIGERR_CHAR_CLASS_VALUE_AT_START_OF_RANGE = -111;
    public static final int ONIGERR_UNMATCHED_RANGE_SPECIFIER_IN_CHAR_CLASS = -112;
    public static final int ONIGERR_TARGET_OF_REPEAT_OPERATOR_NOT_SPECIFIED = -113;
    public static final int ONIGERR_TARGET_OF_REPEAT_OPERATOR_INVALID = -114;
    public static final int ONIGERR_NESTED_REPEAT_OPERATOR = -115;
    public static final int ONIGERR_UNMATCHED_CLOSE_PARENTHESIS = -116;
    public static final int ONIGERR_END_PATTERN_WITH_UNMATCHED_PARENTHESIS = -117;
    public static final int ONIGERR_END_PATTERN_IN_GROUP = -118;
    public static final int ONIGERR_UNDEFINED_GROUP_OPTION = -119;
    public static final int ONIGERR_INVALID_POSIX_BRACKET_TYPE = -121;
    public static final int ONIGERR_INVALID_LOOK_BEHIND_PATTERN = -122;
    public static final int ONIGERR_INVALID_REPEAT_RANGE_PATTERN = -123;
    public static final int ONIGERR_TOO_BIG_NUMBER = -200;
    public static final int ONIGERR_TOO_BIG_NUMBER_FOR_REPEAT_RANGE = -201;
    public static final int ONIGERR_UPPER_SMALLER_THAN_LOWER_IN_REPEAT_RANGE = -202;
    public static final int ONIGERR_EMPTY_RANGE_IN_CHAR_CLASS = -203;
    public static final int ONIGERR_MISMATCH_CODE_LENGTH_IN_CLASS_RANGE = -204;
    public static final int ONIGERR_TOO_MANY_MULTI_BYTE_RANGES = -205;
    public static final int ONIGERR_TOO_SHORT_MULTI_BYTE_STRING = -206;
    public static final int ONIGERR_TOO_BIG_BACKREF_NUMBER = -207;
    public static final int ONIGERR_INVALID_BACKREF = -208;
    public static final int ONIGERR_NUMBERED_BACKREF_OR_CALL_NOT_ALLOWED = -209;
    public static final int ONIGERR_TOO_LONG_WIDE_CHAR_VALUE = -212;
    public static final int ONIGERR_EMPTY_GROUP_NAME = -214;
    public static final int ONIGERR_INVALID_GROUP_NAME = -215;
    public static final int ONIGERR_INVALID_CHAR_IN_GROUP_NAME = -216;
    public static final int ONIGERR_UNDEFINED_NAME_REFERENCE = -217;
    public static final int ONIGERR_UNDEFINED_GROUP_REFERENCE = -218;
    public static final int ONIGERR_MULTIPLEX_DEFINED_NAME = -219;
    public static final int ONIGERR_MULTIPLEX_DEFINITION_NAME_CALL = -220;
    public static final int ONIGERR_NEVER_ENDING_RECURSION = -221;
    public static final int ONIGERR_GROUP_NUMBER_OVER_FOR_CAPTURE_HISTORY = -222;
    public static final int ONIGERR_INVALID_CHAR_PROPERTY_NAME = -223;
    public static final int ONIGERR_INVALID_CODE_POINT_VALUE = -400;
    public static final int ONIGERR_INVALID_WIDE_CHAR_VALUE = -400;
    public static final int ONIGERR_TOO_BIG_WIDE_CHAR_VALUE = -401;
    public static final int ONIGERR_NOT_SUPPORTED_ENCODING_COMBINATION = -402;
    public static final int ONIGERR_INVALID_COMBINATION_OF_OPTIONS = -403;
    public static final int ONIGERR_OVER_THREAD_PASS_LIMIT_COUNT = -1001;

    public OnigRegex(String pattern) {
        this(pattern, OnigSyntaxType.ONIG_SYNTAX_DEFAULT, null, OnigOptionType.ONIG_OPTION_NONE.value);
    }

    public OnigRegex(String pattern, OnigOptionType ... options) {
        this(pattern, OnigSyntaxType.ONIG_SYNTAX_DEFAULT, null, OnigOptionType.values(options));
    }

    public OnigRegex(String pattern, Collection<OnigOptionType> options) {
        this(pattern, OnigSyntaxType.ONIG_SYNTAX_DEFAULT, null, OnigOptionType.values(options));
    }

    public OnigRegex(String pattern, OnigCaseFoldType flag, OnigOptionType ... options) {
        this(pattern, OnigSyntaxType.ONIG_SYNTAX_DEFAULT, flag, OnigOptionType.values(options));
    }

    public OnigRegex(String pattern, OnigCaseFoldType flag, Collection<OnigOptionType> options) {
        this(pattern, OnigSyntaxType.ONIG_SYNTAX_DEFAULT, flag, OnigOptionType.values(options));
    }

    public OnigRegex(String pattern, OnigSyntaxType syntax) {
        this(pattern, syntax, null, OnigOptionType.ONIG_OPTION_NONE.value);
    }

    public OnigRegex(String pattern, OnigSyntaxType syntax, OnigOptionType ... options) {
        this(pattern, syntax, null, OnigOptionType.values(options));
    }

    public OnigRegex(String pattern, OnigSyntaxType syntax, Collection<OnigOptionType> options) {
        this(pattern, syntax, null, OnigOptionType.values(options));
    }

    public OnigRegex(String pattern, OnigSyntaxType syntax, OnigCaseFoldType flag, OnigOptionType ... options) {
        this(pattern, syntax, flag, OnigOptionType.values(options));
    }

    public OnigRegex(String pattern, OnigSyntaxType syntax, OnigCaseFoldType flag, Collection<OnigOptionType> options) {
        this(pattern, syntax, flag, OnigOptionType.values(options));
    }

    protected OnigRegex(String pattern, OnigSyntaxType syntax, OnigCaseFoldType flag, int options) {
        int ret;
        if (pattern == null) {
            throw new NullPointerException("pattern is null");
        }
        if (syntax == null) {
            throw new NullPointerException("syntax is null");
        }
        String[] errmsg = new String[1];
        int n = ret = flag == null ? this.onig_new(pattern, options, syntax, errmsg) : this.onig_new_deluxe(pattern, options, syntax, flag.value, errmsg);
        if (ret < -1) {
            OnigRegex.throwOnigError(ret, errmsg[0], pattern);
        }
        this.pattern = pattern;
        this.syntax = syntax;
    }

    @Override
    protected final void free() {
        this.onig_free();
        this.syntax = null;
    }

    public int getBackRefNumber(String name, OnigRegion region) {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        if (region != null && region.count() == 0) {
            throw new IllegalStateException("region is empty");
        }
        int ret = this.onig_name_to_backref_number(name, region);
        if (ret < -1) {
            OnigRegex.throwOnigError(ret, OnigRegex.onig_error_code_to_str(ret, name), name);
        }
        return ret;
    }

    public int[] getGroupNumbers(String name) {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        return this.onig_name_to_group_numbers(name);
    }

    public static Charset getEncoding() {
        return Charset.forName(OnigRegex.useUnicodeLittleUnmarked() ? "UTF-16LE" : "UTF-16BE");
    }

    public EnumSet<OnigOptionType> getOptionType() {
        return OnigOptionType.valuesOf(this.onig_get_options());
    }

    public OnigCaseFoldType getCaseFoldType() {
        return OnigCaseFoldType.valueOf(this.onig_get_case_fold_flag());
    }

    public OnigSyntaxType getSyntaxType() {
        return this.syntax;
    }

    public String pattern() {
        return this.pattern;
    }

    public boolean isActiveNonameGroupCaputure() {
        return this.onig_noname_group_capture_is_active();
    }

    public int search(CharSequence input) {
        int end = input.length();
        return this.search(input, end, 0, end, null, OnigOptionType.ONIG_OPTION_NONE.value);
    }

    public int search(CharSequence input, OnigOptionType ... options) {
        int end = input.length();
        return this.search(input, end, 0, end, null, OnigOptionType.values(options));
    }

    public int search(CharSequence input, Collection<OnigOptionType> options) {
        int end = input.length();
        return this.search(input, end, 0, end, null, OnigOptionType.values(options));
    }

    public int search(CharSequence input, OnigRegion region) {
        int end = input.length();
        return this.search(input, end, 0, end, region, OnigOptionType.ONIG_OPTION_NONE.value);
    }

    public int search(CharSequence input, OnigRegion region, OnigOptionType ... options) {
        int end = input.length();
        return this.search(input, end, 0, end, region, OnigOptionType.values(options));
    }

    public int search(CharSequence input, OnigRegion region, Collection<OnigOptionType> options) {
        int end = input.length();
        return this.search(input, end, 0, end, region, OnigOptionType.values(options));
    }

    public int search(CharSequence input, int end, int start, int range) {
        return this.search(input, end, start, range, null, OnigOptionType.ONIG_OPTION_NONE.value);
    }

    public int search(CharSequence input, int end, int start, int range, OnigRegion region) {
        return this.search(input, end, start, range, region, OnigOptionType.ONIG_OPTION_NONE.value);
    }

    public int search(CharSequence input, int end, int start, int range, OnigOptionType ... options) {
        return this.search(input, end, start, range, null, OnigOptionType.values(options));
    }

    public int search(CharSequence input, int end, int start, int range, Collection<OnigOptionType> options) {
        return this.search(input, end, start, range, null, OnigOptionType.values(options));
    }

    public int search(CharSequence input, int end, int start, int range, OnigRegion region, OnigOptionType ... options) {
        return this.search(input, end, start, range, region, OnigOptionType.values(options));
    }

    public int search(CharSequence input, int end, int start, int range, OnigRegion region, Collection<OnigOptionType> options) {
        return this.search(input, end, start, range, region, OnigOptionType.values(options));
    }

    protected int search(CharSequence input, int end, int start, int range, OnigRegion region, int options) {
        if (input == null) {
            throw new NullPointerException("input is null");
        }
        int ret = this.onig_search(((Object)input).toString(), end, start, range, region, options);
        if (ret < -1) {
            OnigRegex.throwOnigError(ret, OnigRegex.onig_error_code_to_str(ret, ((Object)input).toString()), ((Object)input).toString());
        }
        return ret;
    }

    public int match(CharSequence input, int at) {
        return this.match(input, input.length(), at, null, OnigOptionType.ONIG_OPTION_NONE.value);
    }

    public int match(CharSequence input, int at, OnigRegion region) {
        return this.match(input, input.length(), at, region, OnigOptionType.ONIG_OPTION_NONE.value);
    }

    public int match(CharSequence input, int at, OnigOptionType ... options) {
        return this.match(input, input.length(), at, null, OnigOptionType.values(options));
    }

    public int match(CharSequence input, int at, Collection<OnigOptionType> options) {
        return this.match(input, input.length(), at, null, OnigOptionType.values(options));
    }

    public int match(CharSequence input, int at, OnigRegion region, OnigOptionType ... options) {
        return this.match(input, input.length(), at, region, OnigOptionType.values(options));
    }

    public int match(CharSequence input, int at, OnigRegion region, Collection<OnigOptionType> options) {
        return this.match(input, input.length(), at, region, OnigOptionType.values(options));
    }

    public int match(CharSequence input, int end, int at) {
        return this.match(input, end, at, null, OnigOptionType.ONIG_OPTION_NONE.value);
    }

    public int match(CharSequence input, int end, int at, OnigRegion region) {
        return this.match(input, end, at, region, OnigOptionType.ONIG_OPTION_NONE.value);
    }

    public int match(CharSequence input, int end, int at, OnigOptionType ... options) {
        return this.match(input, end, at, null, OnigOptionType.values(options));
    }

    public int match(CharSequence input, int end, int at, Collection<OnigOptionType> options) {
        return this.match(input, end, at, null, OnigOptionType.values(options));
    }

    public int match(CharSequence input, int end, int at, OnigRegion region, OnigOptionType ... options) {
        return this.match(input, end, at, region, OnigOptionType.values(options));
    }

    public int match(CharSequence input, int end, int at, OnigRegion region, Collection<OnigOptionType> options) {
        return this.match(input, end, at, region, OnigOptionType.values(options));
    }

    protected int match(CharSequence input, int end, int at, OnigRegion region, int options) {
        if (input == null) {
            throw new NullPointerException("input is null");
        }
        if (at < 0 || at > end) {
            throw new IndexOutOfBoundsException("the at parameter is out of range");
        }
        int ret = this.onig_match(((Object)input).toString(), end, at, region, options);
        if (ret < -1) {
            OnigRegex.throwOnigError(ret, OnigRegex.onig_error_code_to_str(ret, ((Object)input).toString()), ((Object)input).toString());
        }
        return ret;
    }

    public List<String> split(CharSequence input) {
        return this.split(input, 0, OnigOptionType.ONIG_OPTION_NONE.value);
    }

    public List<String> split(CharSequence input, int limit) {
        return this.split(input, limit, OnigOptionType.ONIG_OPTION_NONE.value);
    }

    public List<String> split(CharSequence input, Collection<OnigOptionType> options) {
        return this.split(input, 0, OnigOptionType.values(options));
    }

    public List<String> split(CharSequence input, OnigOptionType ... options) {
        return this.split(input, 0, OnigOptionType.values(options));
    }

    public List<String> split(CharSequence input, int limit, Collection<OnigOptionType> options) {
        return this.split(input, limit, OnigOptionType.values(options));
    }

    public List<String> split(CharSequence input, int limit, OnigOptionType ... options) {
        return this.split(input, limit, OnigOptionType.values(options));
    }

    protected List<String> split(CharSequence input, int limit, int options) {
        if (input == null) {
            throw new NullPointerException("input is null");
        }
        ArrayList<String> list = new ArrayList<String>();
        int ret = this.onig_split(((Object)input).toString(), limit, options, list);
        if (ret < -1) {
            OnigRegex.throwOnigError(ret, OnigRegex.onig_error_code_to_str(ret, ((Object)input).toString()), ((Object)input).toString());
        }
        if (limit == 0 && !list.isEmpty()) {
            int i = list.size() - 1;
            while (((String)list.get(i)).length() == 0) {
                --i;
            }
            if (i + 1 < list.size()) {
                return list.subList(0, i + 1);
            }
        }
        return list;
    }

    public int nameCount() {
        return this.onig_number_of_names();
    }

    public int captureCount() {
        return this.onig_number_of_captures();
    }

    public int captureHistoryCount() {
        return this.onig_number_of_capture_histories();
    }

    public int foreachName(Callback callback) {
        if (callback == null) {
            throw new NullPointerException("callback is null");
        }
        return this.onig_foreach_name(callback);
    }

    public static int getMatchStackLimitSize() {
        return OnigRegex.onig_get_match_stack_limit_size();
    }

    public static void setMatchStackLimitSize(int size) {
        int ret = OnigRegex.onig_set_match_stack_limit_size(size);
        if (ret != 0) {
            OnigRegex.throwOnigError(ret, String.valueOf(size));
        }
    }

    public static String getVersion() {
        return OnigRegex.onig_version();
    }

    public static String getErrorMessage(int ecode, String param) {
        return OnigRegex.onig_error_code_to_str(ecode, param);
    }

    public static boolean setWarningListener(WarningListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener is null");
        }
        warnListener = listener;
        return OnigRegex.onig_set_warn_func();
    }

    public static void clearWarningListener() {
        OnigRegex.onig_clear_warn_func();
        warnListener = null;
    }

    public static boolean setVerboseWarningListener(WarningListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener is null");
        }
        verbListener = listener;
        return OnigRegex.onig_set_verb_warn_func();
    }

    public static void clearVerboseWarningListener() {
        OnigRegex.onig_clear_verb_warn_func();
        verbListener = null;
    }

    private static String decodeString(String str) {
        OnigRegex regex = new OnigRegex("\\/(\\\\x\\h{2})+\\/");
        OnigRegion region = new OnigRegion();
        int s = regex.search((CharSequence)str, region);
        if (s >= 0) {
            int i;
            StringBuilder decoded = new StringBuilder(str);
            int e = region.end(0) - 1;
            String pattern = decoded.substring(s + 1, e);
            int end = pattern.length();
            regex.close();
            regex = new OnigRegex("\\h*\\\\x\\h*");
            int at = 0;
            ArrayList<Byte> split = new ArrayList<Byte>();
            while (at < end && regex.match((CharSequence)pattern, end, at, region) >= 0) {
                int cnt = region.count();
                for (i = 0; i < cnt; ++i) {
                    at = region.end(i);
                    split.add(Byte.parseByte(pattern.substring(region.begin(i) + 2, at), 16));
                }
            }
            region.close();
            regex.close();
            byte[] bytes = new byte[split.size()];
            for (i = 0; i < bytes.length; ++i) {
                bytes[i] = (Byte)split.get(i);
            }
            return decoded.replace(s + 1, e, new String(bytes, OnigRegex.getEncoding())).toString();
        }
        return str;
    }

    protected static void fireWarning(String msg) {
        if (warnListener != null) {
            warnListener.warning(OnigRegex.decodeString(msg));
        }
    }

    protected static void fireWarningVerbose(String msg) {
        if (verbListener != null) {
            verbListener.warning(OnigRegex.decodeString(msg));
        }
    }

    private static void throwOnigError(int ecode, String msg, String pattern) {
        if (OnigRegex.isSyntaxError(ecode)) {
            throw new PatternSyntaxException(msg, pattern, -1);
        }
        OnigRegex.throwOnigError(ecode, msg);
    }

    private static void throwOnigError(int ecode, String msg) {
        switch (ecode) {
            case -5: {
                throw new OutOfMemoryError(msg);
            }
            case -15: {
                throw new StackOverflowError(msg);
            }
            case -30: 
            case -2: {
                throw new IllegalArgumentException(msg);
            }
        }
        throw new InternalError(msg);
    }

    public static boolean isSyntaxError(int ecode) {
        return ecode <= -100 && ecode > -1000;
    }

    private static native boolean useUnicodeLittleUnmarked();

    private static native String onig_error_code_to_str(int var0, String var1);

    private native int onig_new(String var1, int var2, OnigSyntaxType var3, String[] var4);

    private native int onig_new_deluxe(String var1, int var2, OnigSyntaxType var3, int var4, String[] var5);

    private native void onig_free();

    private native boolean onig_noname_group_capture_is_active();

    private native int onig_search(String var1, int var2, int var3, int var4, OnigRegion var5, int var6);

    private native int onig_match(String var1, int var2, int var3, OnigRegion var4, int var5);

    private native int onig_split(String var1, int var2, int var3, Collection<String> var4);

    private native int onig_name_to_backref_number(String var1, OnigRegion var2);

    private native int[] onig_name_to_group_numbers(String var1);

    private native int onig_number_of_names();

    private native int onig_get_options();

    private native int onig_get_case_fold_flag();

    private native int onig_number_of_captures();

    private native int onig_number_of_capture_histories();

    static native long onig_region_new();

    static native int onig_get_default_case_fold_flag();

    static native int onig_set_default_case_fold_flag(int var0);

    private static native int onig_get_match_stack_limit_size();

    private static native int onig_set_match_stack_limit_size(int var0);

    private static native String onig_version();

    private static native boolean onig_set_warn_func();

    private static native void onig_clear_warn_func();

    private static native boolean onig_set_verb_warn_func();

    private static native void onig_clear_verb_warn_func();

    private native int onig_foreach_name(Callback var1);

    static native long ONIG_SYNTAX_ASIS();

    static native long ONIG_SYNTAX_POSIX_BASIC();

    static native long ONIG_SYNTAX_POSIX_EXTENDED();

    static native long ONIG_SYNTAX_EMACS();

    static native long ONIG_SYNTAX_GREP();

    static native long ONIG_SYNTAX_GNU_REGEX();

    static native long ONIG_SYNTAX_JAVA();

    static native long ONIG_SYNTAX_PERL();

    static native long ONIG_SYNTAX_PERL_NG();

    static native long ONIG_SYNTAX_RUBY();

    static native long ONIG_SYNTAX_DEFAULT();

    static {
        System.loadLibrary("onig4j");
    }

    public static interface WarningListener
    extends EventListener {
        public void warning(String var1);
    }

    public static interface Callback {
        public int call(String var1, int[] var2, OnigRegex var3);
    }
}

