/*
 * listcap -- example of the capture history.
 *
 * capture history (?@...) sample.
 */
import onig4j.OnigRegex;
import onig4j.OnigRegion;
import onig4j.OnigSyntaxType;

public class listcap {
    public static void main(String[] args) {
        final String str1     = "((())())";
        final String pattern1 = "\\g<p>(?@<p>\\(\\g<s>\\)){0}(?@<s>(?:\\g<p>)*|){0}";

        final String str2     = "x00x00x00";
        final String pattern2 = "(?@x(?@\\d+))+";

        final String str3     = "0123";
        final String pattern3 = "(?@.)(?@.)(?@.)(?@.)";
        
        /* enable capture hostory */
        final OnigSyntaxType syn = OnigSyntaxType.ONIG_SYNTAX_DEFAULT.clone();
        syn.setOperator2(
                    syn.getOperator2() | OnigSyntaxType.ONIG_SYN_OP2_ATMARK_CAPTURE_HISTORY
                );
        
        ex(str1, pattern1, syn);
        ex(str2, pattern2, syn);
        ex(str3, pattern3, syn);
        
        syn.close();
    }
    
    private static void ex(String str, String pattern, OnigSyntaxType syn) {
        final OnigRegex reg = new OnigRegex(pattern, syn);
        
        System.out.printf("number of captures: %d\n", reg.captureCount());
        System.out.printf("number of capture histories: %d\n", reg.captureHistoryCount());

        final OnigRegion region = new OnigRegion();
        int r = reg.search(str, region);
        if (r >= 0) {
            System.out.printf("match at %d\n", r);
            for (int i = 0; i < region.count(); ++i) {
                System.out.printf("%d: (%d-%d)\n", i, region.begin(i), region.end(i));
            }
            System.out.println();

            final OnigRegion.Callback callback
                = new OnigRegion.Callback() {
                        public int call(int group, int begin, int end, int level, int at) {
                            if (at != OnigRegion.ONIG_TRAVERSE_CALLBACK_AT_FIRST) {
                                return -1; /* error */
                            }

                            /* indent */
                            for (int i = 0; i < level * 2; ++i) {
                                System.out.print(' ');
                            }

                            System.out.printf("%d: (%d-%d)\n", group, begin, end);
                            return 0;
                        }
                    };
            region.traverseCaptureTree(callback, OnigRegion.ONIG_TRAVERSE_CALLBACK_AT_FIRST);

        } else if (r == OnigRegex.ONIG_MISMATCH) {
            System.out.println("search fail");
        }

        region.close();
        reg.close();
    }
    
    @org.junit.Test
    public void run() {
        listcap.main(null);
    }
}
