/*
 * names -- example of the named group callback.
 */
import onig4j.OnigRegex;
import onig4j.OnigRegion;

public class names {
    public static void main(String[] args) {
        final String pattern = "(?<foo>a*)(?<bar>b*)(?<foo>c*)";
        final String str = "aaabbbbcc";
        
        final OnigRegex reg = new OnigRegex(pattern);
        
        System.out.printf("number of names: %d\n", reg.nameCount());
        
        final OnigRegion region = new OnigRegion();
        final int r = reg.search(str, region);
        if (r >= 0) {
            System.out.printf("match at %d\n", r);
            
            final OnigRegex.Callback callback
                = new OnigRegex.Callback() {
                        public int call(String name, int[] groups, OnigRegex regex) {
                            for (int i = 0; i < groups.length; ++i) {
                                final int gn = groups[i];
                                final int ref = regex.getBackRefNumber(name, region);
                                String s = (ref == gn ? "*" : "");
                                System.out.printf("%s (%d): ", name, gn);
                                System.out.printf("(%d-%d) %s\n", region.begin(gn), region.end(gn), s);
                            }
                            return 0;  /* 0: continue */
                        }
                    };
            reg.foreachName(callback);
            
        } else if (r == OnigRegex.ONIG_MISMATCH) {
            System.out.println("search fail");
        }
        
        region.close();
        reg.close();
    }
    
    @org.junit.Test
    public void run() {
        names.main(null);
    }
}
