/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.doc;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.odftoolkit.odfdom.OdfAttribute;
import org.odftoolkit.odfdom.OdfElement;
import org.odftoolkit.odfdom.OdfFileDom;
import org.odftoolkit.odfdom.OdfName;
import org.odftoolkit.odfdom.dom.OdfAttributeNames;
import org.odftoolkit.odfdom.dom.OdfElementNames;
import org.odftoolkit.odfdom.pkg.element.OdfAlienAttribute;
import org.odftoolkit.odfdom.pkg.element.OdfAlienElement;
import org.w3c.dom.DOMException;

public class OdfElementFactory {
    private static Map<OdfName, Class> mElementTypes;
    private static Map<OdfName, Class> mAttributeTypes;

    private static synchronized void populateElementTypes() {
        if (mElementTypes != null) {
            return;
        }
        mElementTypes = new HashMap<OdfName, Class>();
        for (OdfElementNames element : OdfElementNames.values()) {
            mElementTypes.put(element.getOdfName(), element.getElementClass());
        }
    }

    private static synchronized void populateAttributeTypes() {
        if (mAttributeTypes != null) {
            return;
        }
        mAttributeTypes = new HashMap<OdfName, Class>();
        for (OdfAttributeNames attribute : OdfAttributeNames.values()) {
            mAttributeTypes.put(attribute.getOdfName(), attribute.getAttributeClass());
        }
    }

    public static void mapElementOdfNameToClass(OdfName odfName, Class className) {
        mElementTypes.put(odfName, className);
    }

    public static void mapAttributeOdfNameToClass(OdfName odfName, Class className) {
        mAttributeTypes.put(odfName, className);
    }

    public static OdfElement newOdfElement(OdfFileDom ownerDocument, OdfName name) throws DOMException {
        OdfElement e = null;
        Class elementClass = mElementTypes.get(name);
        if (elementClass != null) {
            try {
                Constructor ctor = elementClass.getConstructor(OdfFileDom.class);
                e = (OdfElement)((Object)ctor.newInstance(new Object[]{ownerDocument}));
                return e;
            }
            catch (Exception cause) {
                throw new Error("OdfDOM error in element factory", cause);
            }
        }
        return new OdfAlienElement(ownerDocument, name);
    }

    public static OdfAttribute newOdfAttribute(OdfFileDom ownerDocument, OdfName name) throws DOMException {
        OdfAttribute attr = null;
        Class attributeClass = mAttributeTypes.get(name);
        if (attributeClass != null) {
            try {
                Constructor ctor = attributeClass.getConstructor(OdfFileDom.class);
                attr = (OdfAttribute)((Object)ctor.newInstance(new Object[]{ownerDocument}));
                return attr;
            }
            catch (Exception cause) {
                throw new Error("OdfDOM error in attribute factory", cause);
            }
        }
        return new OdfAlienAttribute(ownerDocument, name);
    }

    static {
        OdfElementFactory.populateElementTypes();
        OdfElementFactory.populateAttributeTypes();
    }
}

