/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.report;

import org.opengion.fukurou.db.ApplicationInfo;
import org.opengion.fukurou.db.DBUtil;
import org.opengion.fukurou.system.HybsConst;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.report.CSVPrintPointService;
import org.opengion.hayabusa.report2.QueueManager_DB;
import org.opengion.hayabusa.resource.ResourceFactory;
import org.opengion.hayabusa.resource.ResourceManager;

public class CSVPrintRequest {
    private final StringBuilder errMsg = new StringBuilder(200);
    private ResourceManager resource;
    private final String SYSTEM_ID;
    private final String YKNO;
    private final String LISTID;
    private final String LANG;
    private final String FGRUN;
    private final String PRTID;
    private final String PRGDIR;
    private final String PRGFILE;
    private final String OUTDIR;
    private final String FILENAME;
    private final boolean DEBUG;
    private final String GRPID;
    private final String DMNGRP;
    private boolean fgLOCAL;
    private String prtName;
    private String hostName;
    private String portnm;
    private String fgkan = "8";
    private String option;
    private int bodyCount;
    private static final String GE54_SELECT = "SELECT BSQL,FGLOCAL,SYSTEM_ID,HSQL,FSQL ,OPTIONS,FGCUT FROM GE54 WHERE FGJ = '1' AND  SYSTEM_ID IN (?,'**') AND  LISTID = ?";
    private static final int GE54_FGLOCAL = 1;
    private static final int GE54_SYSTEM_ID = 2;
    private static final int GE54_OPTIONS = 5;
    private static final String GE55_SELECT = "SELECT PRTNM,HOST_ID,SYSTEM_ID,PORTNM FROM GE55 WHERE FGJ = '1' AND  SYSTEM_ID IN (?,'**') AND  PRTID = ?";
    private static final int GE55_PRTNM = 0;
    private static final int GE55_HOST_ID = 1;
    private static final int GE55_SYSTEM_ID = 2;
    private static final int GE55_PORTNM = 3;
    public static final boolean USE_DB_APPLICATION_INFO = HybsSystem.sysBool("USE_DB_APPLICATION_INFO");
    private final ApplicationInfo appInfo;
    private final String DBID = HybsSystem.sys("RESOURCE_DBID");

    public CSVPrintRequest(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, boolean bl) {
        this.SYSTEM_ID = string;
        this.YKNO = string2;
        this.LISTID = string3;
        this.LANG = string4;
        this.FGRUN = string5;
        this.PRTID = string6;
        this.PRGDIR = string7;
        this.PRGFILE = string8;
        this.OUTDIR = string9;
        this.FILENAME = string10;
        this.GRPID = string11;
        this.DMNGRP = string12;
        this.DEBUG = bl;
        if (USE_DB_APPLICATION_INFO) {
            this.appInfo = new ApplicationInfo();
            this.appInfo.setClientInfo(this.SYSTEM_ID, HybsSystem.HOST_ADRS, HybsSystem.HOST_NAME);
            this.appInfo.setModuleInfo("ReportConverter", this.YKNO, this.LISTID);
        } else {
            this.appInfo = null;
        }
    }

    public boolean initialDataSet() {
        String string;
        String[] stringArray = new String[]{this.SYSTEM_ID, this.LISTID};
        String[][] stringArray2 = DBUtil.dbExecute((String)GE54_SELECT, (String[])stringArray, (ApplicationInfo)this.appInfo, (String)this.DBID);
        if (stringArray2 == null || stringArray2.length == 0) {
            this.errMsg.append("Data does not exist in GE54 table.").append(HybsConst.CR).append("==============================").append(HybsConst.CR).append("SYSTEM_ID=[").append(this.SYSTEM_ID).append("] , LISTID=[").append(this.LISTID).append(']').append(HybsConst.CR);
            return false;
        }
        int n = 0;
        for (int i = 0; i < stringArray2.length; ++i) {
            if (!this.SYSTEM_ID.equalsIgnoreCase(stringArray2[i][2])) continue;
            n = i;
            break;
        }
        this.fgLOCAL = (string = stringArray2[n][1]) != null && "1".equals(string.trim());
        this.option = stringArray2[n][5];
        String[] stringArray3 = new String[]{this.SYSTEM_ID, this.PRTID};
        String[][] stringArray4 = DBUtil.dbExecute((String)GE55_SELECT, (String[])stringArray3, (ApplicationInfo)this.appInfo, (String)this.DBID);
        if (stringArray4 == null || stringArray4.length == 0) {
            this.errMsg.append("Data does not exist in GE55 table.").append(HybsConst.CR).append("==============================").append(HybsConst.CR).append("SYSTEM_ID=[").append(this.SYSTEM_ID).append("] , PRTID=[").append(this.PRTID).append(']').append(HybsConst.CR);
            return false;
        }
        int n2 = 0;
        for (int i = 0; i < stringArray2.length; ++i) {
            if (!this.SYSTEM_ID.equalsIgnoreCase(stringArray2[i][2])) continue;
            n2 = i;
            break;
        }
        this.prtName = stringArray4[n2][0];
        this.hostName = stringArray4[n2][1];
        this.portnm = stringArray4[n2][3];
        return true;
    }

    public boolean execute() {
        System.out.print("CSV RequestData Creating ... ");
        this.resource = this.fgLOCAL ? ResourceFactory.newInstance(this.SYSTEM_ID, this.LANG, false) : ResourceFactory.newInstance(this.LANG);
        QueueManager_DB.DBTableModelCreator dBTableModelCreator = new QueueManager_DB.DBTableModelCreator(this.SYSTEM_ID, this.LISTID, this.YKNO, "B", this.resource);
        DBTableModel dBTableModel = dBTableModelCreator.getTable();
        if (dBTableModel.getRowCount() <= 0) {
            this.errMsg.append("Database Body row count is Zero.").append(HybsConst.CR).append("==============================").append(HybsConst.CR).append("SYSTEM_ID=").append(this.SYSTEM_ID).append(",LISTID=").append(this.LISTID).append(",YKNO=").append(this.YKNO).append(HybsConst.CR);
            return false;
        }
        if (dBTableModel.isOverflow()) {
            this.errMsg.append("Database is Overflow. [").append(dBTableModel.getRowCount()).append(']').append(HybsConst.CR).append(HybsConst.CR).append("==============================").append(HybsConst.CR).append("Check SystemParameter Data in DB_MAX_ROW_COUNT Overflow").append(HybsConst.CR);
            return false;
        }
        this.bodyCount = dBTableModel.getRowCount();
        dBTableModelCreator = new QueueManager_DB.DBTableModelCreator(this.SYSTEM_ID, this.LISTID, this.YKNO, "H", this.resource);
        DBTableModel dBTableModel2 = dBTableModelCreator.getTable();
        dBTableModelCreator = new QueueManager_DB.DBTableModelCreator(this.SYSTEM_ID, this.LISTID, this.YKNO, "F", this.resource);
        DBTableModel dBTableModel3 = dBTableModelCreator.getTable();
        CSVPrintPointService cSVPrintPointService = null;
        try {
            cSVPrintPointService = (CSVPrintPointService)StringUtil.newInstance((String)HybsSystem.sys("REPORT_CSV_SERVICE_CLASS"));
            cSVPrintPointService.setYkno(this.YKNO);
            cSVPrintPointService.setSystemId(this.SYSTEM_ID);
            cSVPrintPointService.setFgrun(this.FGRUN);
            cSVPrintPointService.setHostName(this.hostName);
            cSVPrintPointService.setPrinterName(this.prtName);
            cSVPrintPointService.setTable(dBTableModel);
            cSVPrintPointService.setTableH(dBTableModel2);
            cSVPrintPointService.setTableF(dBTableModel3);
            cSVPrintPointService.setPrgDir(this.PRGDIR);
            cSVPrintPointService.setPrgFile(this.PRGFILE);
            cSVPrintPointService.setOutDir(this.OUTDIR);
            cSVPrintPointService.setPrtId(this.PRTID);
            cSVPrintPointService.setPortnm(this.portnm);
            cSVPrintPointService.setListId(this.LISTID);
            cSVPrintPointService.setModelname(this.FILENAME);
            cSVPrintPointService.setGrpId(this.GRPID);
            cSVPrintPointService.setDmnGrp(this.DMNGRP);
            cSVPrintPointService.setOption(this.option);
            boolean bl = cSVPrintPointService.execute();
            this.fgkan = cSVPrintPointService.getFgkan();
            if (this.DEBUG) {
                System.out.println(cSVPrintPointService);
            }
            if (!bl) {
                this.errMsg.append(cSVPrintPointService.getErrMsg());
                return false;
            }
        }
        catch (Throwable throwable) {
            this.fgkan = "8";
            this.errMsg.append("CSV Print Request Execution Error. ").append(HybsConst.CR).append("==============================").append(HybsConst.CR).append("SYSTEM_ID=[").append(this.SYSTEM_ID).append("] , YKNO=[").append(this.YKNO).append(']').append(HybsConst.CR).append(HybsSystem.sys("REPORT_CSV_SERVICE_CLASS")).append(HybsConst.CR).append(throwable.toString()).append(HybsConst.CR);
            if (cSVPrintPointService != null) {
                this.errMsg.append(cSVPrintPointService.getErrMsg());
            }
            return false;
        }
        System.out.println("End.");
        return true;
    }

    public String getErrMsg() {
        return this.errMsg.toString();
    }

    public String getFgkan() {
        return this.fgkan;
    }

    public int getBodyCount() {
        return this.bodyCount;
    }
}

