/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.opengion.fukurou.db.Transaction;
import org.opengion.fukurou.security.HybsCryptography;
import org.opengion.fukurou.system.DateSet;
import org.opengion.fukurou.system.OgBuilder;
import org.opengion.fukurou.util.ArraySet;
import org.opengion.fukurou.util.HybsDateUtil;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.ToString;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.DBColumn;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.db.Query;
import org.opengion.hayabusa.db.QueryFactory;
import org.opengion.hayabusa.taglib.CommonTagSupport;

public class ValueTag
extends CommonTagSupport {
    private static final String VERSION = "6.9.7.0 (2018/05/14)";
    private static final long serialVersionUID = 697020180514L;
    public static final String CMD_SET = "SET";
    public static final String CMD_GET = "GET";
    public static final String CMD_REMOVE = "REMOVE";
    public static final String CMD_CLEAR = "CLEAR";
    public static final String CMD_SQL = "SQL";
    public static final String CMD_SETTBL = "SETTBL";
    public static final String CMD_GETTBL = "GETTBL";
    public static final String CMD_KEYTBL = "KEYTBL";
    public static final String CMD_SETMEM = "SETMEM";
    public static final String CMD_SQLGET = "SQLGET";
    public static final String CMD_DEBUG = "DEBUG";
    private static final Set<String> COMMAND_SET = new ArraySet((Object[])new String[]{"SET", "GET", "REMOVE", "SQL", "SETTBL", "GETTBL", "KEYTBL", "CLEAR", "SETMEM", "SQLGET"});
    public static final String ACT_UPPER = "UPPER";
    public static final String ACT_LOWER = "LOWER";
    public static final String ACT_MESSAGE = "MESSAGE";
    public static final String ACT_APPEND = "APPEND";
    public static final String ACT_ALL_APPEND = "ALL_APPEND";
    public static final String ACT_MAP = "MAP";
    public static final String ACT_ALL_MAP = "ALL_MAP";
    public static final String ACT_MAPOBJ = "MAPOBJ";
    public static final String ACT_ALL_MAPOBJ = "ALL_MAPOBJ";
    public static final String ACT_LIST = "LIST";
    public static final String ACT_ALL_LIST = "ALL_LIST";
    public static final String ACT_DAY_WEEK = "DAY_WEEK";
    public static final String ACT_MERGE = "MERGE";
    public static final String ACT_FIRST = "FIRST";
    public static final String ACT_ROW_APPEND = "ROW_APPEND";
    public static final String ACT_REPLACE = "REPLACE";
    public static final String ACT_SUBSTR = "SUBSTR";
    public static final String ACT_SPLIT = "SPLIT";
    public static final String ACT_MAX_MIN = "MAX_MIN";
    public static final String ACT_ALL_MAX_MIN = "ALL_MAX_MIN";
    public static final String ACT_EXEC = "EXEC";
    public static final String ACT_CASE = "CASE";
    public static final String ACT_ESCAPE = "ESCAPE";
    public static final String ACT_ENCODE = "URL_ENCODE";
    public static final String ACT_ENCODE2 = "URL_ENCODE2";
    public static final String ACT_DECODE = "URL_DECODE";
    public static final String ACT_TRIM = "TRIM";
    public static final String ACT_MD5 = "MD5";
    public static final String ACT_TO_NUMBER = "TO_NUMBER";
    public static final String ACT_HMCSV = "HMCSV";
    private static final Set<String> ACTION_SET = new ArraySet((Object[])new String[]{"UPPER", "LOWER", "MESSAGE", "APPEND", "ALL_APPEND", "MAP", "ALL_MAP", "MAPOBJ", "ALL_MAPOBJ", "LIST", "ALL_LIST", "DAY_WEEK", "MERGE", "FIRST", "ROW_APPEND", "REPLACE", "SUBSTR", "SPLIT", "MAX_MIN", "ALL_MAX_MIN", "EXEC", "CASE", "ESCAPE", "URL_ENCODE", "URL_ENCODE2", "URL_DECODE", "TRIM", "MD5", "TO_NUMBER", "HMCSV"});
    public static final int MAX_CNT = 300;
    private transient DBTableModel table;
    private String tableId = "h_tblmdl";
    private String command = "SET";
    private String key;
    private String inValue;
    private String value;
    private String defaultVal;
    private String action;
    private String dbid;
    private String scope = "request";
    private String tblScope = "session";
    private String separator = ",";
    private boolean useMultiRows;
    private boolean xssCheck = HybsSystem.sysBool("USE_XSS_CHECK");
    private String fromVal;
    private String toVal;
    private String skipVal;
    private boolean tmpSelectedAll;

    @Override
    public int doStartTag() {
        if (this.useTag()) {
            this.useXssCheck(this.xssCheck);
            super.setScope(this.scope);
            if (CMD_SQL.equals(this.command) || CMD_SET.equals(this.command) || CMD_SQLGET.equals(this.command)) {
                return 2;
            }
        }
        return 0;
    }

    @Override
    public int doAfterBody() {
        if (this.value == null || this.value.length() <= 0) {
            this.value = this.getBodyString();
            this.inValue = this.getBodyRawString();
            if (CMD_SQL.equals(this.command) || CMD_SQLGET.equals(this.command)) {
                try (Transaction transaction = this.getTransaction();){
                    Query query = QueryFactory.newInstance();
                    this.value = this.value.trim();
                    query.setConnection(transaction.getConnection(this.dbid));
                    query.setResourceManager(this.getResource());
                    query.setStatement(this.value);
                    query.execute(new String[0]);
                    this.table = query.getDBTableModel();
                    transaction.commit();
                }
            }
        }
        return 0;
    }

    @Override
    public int doEndTag() {
        this.debugPrint();
        if (this.useTag()) {
            if (this.check(this.command, COMMAND_SET) && (CMD_SETTBL.equals(this.command) || CMD_GETTBL.equals(this.command) || CMD_KEYTBL.equals(this.command))) {
                if ("session".equals(this.tblScope)) {
                    this.table = (DBTableModel)this.getSessionAttribute(this.tableId);
                } else if ("request".equals(this.tblScope)) {
                    this.table = (DBTableModel)this.getRequestAttribute(this.tableId);
                } else {
                    String string = "\u3053\u306e\u30b9\u30b3\u30fc\u30d7\u306f\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002[" + this.tblScope + "]";
                    throw new IllegalArgumentException(string);
                }
            }
            this.commandExec(this.command);
            if ((CMD_GET.equals(this.command) || CMD_GETTBL.equals(this.command) || CMD_SQLGET.equals(this.command)) && this.value != null) {
                this.jspPrint(this.value);
            }
        }
        return 6;
    }

    @Override
    protected void release2() {
        super.release2();
        this.tableId = "h_tblmdl";
        this.command = CMD_SET;
        this.key = null;
        this.value = null;
        this.defaultVal = null;
        this.action = null;
        this.table = null;
        this.dbid = null;
        this.scope = "request";
        this.tblScope = "session";
        this.separator = ",";
        this.useMultiRows = false;
        this.tmpSelectedAll = false;
        this.inValue = null;
        this.xssCheck = HybsSystem.sysBool("USE_XSS_CHECK");
        this.fromVal = null;
        this.toVal = null;
        this.skipVal = null;
    }

    private void commandExec(String string) {
        if (CMD_SQL.equals(string)) {
            this.setSQLAttribute(this.table);
        } else if (CMD_SQLGET.equals(string)) {
            this.value = this.getSQLAttribute(this.table);
        } else if (CMD_SET.equals(string)) {
            this.value = StringUtil.nval((String)this.value, (String)this.defaultVal);
            this.setAttribute(this.key, this.value, this.action);
        } else if (CMD_GET.equals(string)) {
            this.value = this.getAttribute(this.key, this.action);
        } else if (CMD_REMOVE.equals(string)) {
            this.removeAttribute(this.key);
        } else if (CMD_CLEAR.equals(string)) {
            this.clearAttribute(this.key);
        } else if (CMD_SETTBL.equals(string)) {
            this.setTableAttribute(this.table, this.key, this.action);
        } else if (CMD_GETTBL.equals(string)) {
            this.value = this.getTableAttribute(this.table, this.key, this.action);
        } else if (CMD_KEYTBL.equals(string)) {
            this.setKeyTableAttribute(this.table, this.key, this.value, this.action);
        } else if (CMD_SETMEM.equals(string)) {
            this.value = StringUtil.nval((String)this.value, (String)this.defaultVal);
            this.setAttribute(this.key, this.value, this.action);
            this.setRequestCacheData(this.key, (String)this.getObject(this.key));
        } else if (CMD_DEBUG.equals(string)) {
            this.value = this.scopeAttributePrint();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String actionExec(String string, String string2) {
        String string3 = string2;
        if (string == null) return string3;
        if (string2 == null) {
            return string3;
        }
        if (ACT_UPPER.equals(string)) {
            return string2.toUpperCase(Locale.JAPAN);
        }
        if (ACT_LOWER.equals(string)) {
            return string2.toLowerCase(Locale.JAPAN);
        }
        if (ACT_MESSAGE.equals(string)) {
            return this.getResource().getLabel(string2);
        }
        if (ACT_DAY_WEEK.equals(string)) {
            Calendar calendar = HybsDateUtil.getCalendar((String)string2);
            int n = calendar.get(7) - 2;
            if (n == 0) return DateSet.getDate((long)calendar.getTimeInMillis(), (String)"yyyyMMdd");
            calendar.add(5, -n);
            return DateSet.getDate((long)calendar.getTimeInMillis(), (String)"yyyyMMdd");
        }
        if (ACT_MERGE.equals(string)) {
            String[] stringArray = StringUtil.csv2Array((String)string2);
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n] != null && stringArray[n].length() > 0) {
                    linkedHashSet.add(stringArray[n]);
                }
                ++n;
            }
            return StringUtil.iterator2line(linkedHashSet.iterator(), (String)this.separator);
        }
        if (ACT_REPLACE.equals(string)) {
            String[] stringArray;
            if (this.fromVal == null) return string3;
            if (this.toVal == null) return string3;
            if (this.fromVal.indexOf(44) < 0) {
                return string2.replaceAll(this.fromVal, this.toVal);
            }
            CharSequence[] charSequenceArray = this.fromVal.split(",");
            if (charSequenceArray.length == (stringArray = this.toVal.split(",")).length) {
                int n = 0;
                while (n < charSequenceArray.length) {
                    string3 = string3.replaceAll(charSequenceArray[n], stringArray[n]);
                    ++n;
                }
                return string3;
            }
            String string4 = "REPLACE\u6642\u306e fromVal\u306e\u30ab\u30f3\u30de\u306e\u6570\u304c\u3001toVal\u306e\u6570\u3068\u4e00\u81f4\u3057\u307e\u305b\u3093\u3002" + CR + " fromVal=[" + String.join((CharSequence)",", charSequenceArray) + "] , toVal=[" + this.toVal + "] , value=[" + string2 + "]";
            throw new HybsSystemException(string4);
        }
        if (ACT_SUBSTR.equals(string)) {
            int n = this.fromVal == null || this.fromVal.isEmpty() ? 0 : Integer.parseInt(this.fromVal);
            int n2 = this.toVal == null || this.toVal.isEmpty() ? string2.length() : Integer.parseInt(this.toVal);
            return string2.substring(n, n2);
        }
        if (ACT_CASE.equals(string)) {
            if (this.fromVal == null) return string3;
            if (this.fromVal.length() <= 0) return string3;
            String[] stringArray = StringUtil.csv2Array((String)this.fromVal, (char)' ');
            int n = 0;
            while (n < stringArray.length) {
                String string5;
                int n3 = stringArray[n].indexOf(58);
                if (n3 >= 0 && string2.equalsIgnoreCase(string5 = stringArray[n].substring(0, n3))) {
                    return stringArray[n].substring(n3 + 1);
                }
                ++n;
            }
            return string3;
        }
        if (ACT_EXEC.equals(string)) {
            ScriptEngine scriptEngine = new ScriptEngineManager().getEngineByName("JavaScript");
            try {
                Object object = scriptEngine.eval(string2);
                return String.valueOf(object);
            }
            catch (ScriptException scriptException) {
                String string6 = "JavaScript\u5f0f\u306e\u30d1\u30fc\u30b9\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002[" + string2 + "]";
                throw new HybsSystemException(string6, scriptException);
            }
        }
        if (ACT_ESCAPE.equals(string)) {
            return StringUtil.htmlFilter((String)string2);
        }
        if (ACT_ENCODE.equals(string)) {
            return StringUtil.urlEncode((String)string2);
        }
        if (ACT_ENCODE2.equals(string)) {
            return StringUtil.urlEncode2((String)string2);
        }
        if (ACT_DECODE.equals(string)) {
            return StringUtil.urlDecode((String)string2);
        }
        if (ACT_TRIM.equals(string)) {
            return string2.trim();
        }
        if (ACT_MD5.equals(string)) {
            return HybsCryptography.getMD5((String)string2);
        }
        if (ACT_TO_NUMBER.equals(string)) {
            StringBuilder stringBuilder = new StringBuilder(200);
            int n = 0;
            while (n < string2.length()) {
                char c = string2.charAt(n);
                if ('-' == c || '0' <= c && c <= '9') {
                    stringBuilder.append(c);
                }
                ++n;
            }
            return stringBuilder.toString();
        }
        if (ACT_HMCSV.equals(string) && this.fromVal != null && this.fromVal.length() > 0) {
            int n = Integer.parseInt(StringUtil.deleteChar((String)this.fromVal, (char)':'));
            int n4 = Integer.parseInt(StringUtil.deleteChar((String)this.toVal, (char)':'));
            String string7 = HybsDateUtil.getDateFormat((String)"YMDHMS", (String)string2, (String)"HM", (int)n);
            String string8 = HybsDateUtil.getDateFormat((String)"YMDHMS", (String)string2, (String)"HM", (int)n4);
            StringBuilder stringBuilder = new StringBuilder(200);
            stringBuilder.append(string7);
            StringBuilder stringBuilder2 = new StringBuilder(200);
            stringBuilder2.append(HybsDateUtil.getDateFormat((String)"HMF", (String)string7));
            int n5 = StringUtil.nval((String)this.skipVal, (int)60);
            int n6 = 1;
            String string9 = string7;
            String string10 = string9.substring(0, 8);
            while (string9.compareTo(string8) < 0 && n6 < 300) {
                string9 = HybsDateUtil.getDateFormat((String)"YMDHMS", (String)string7, (String)"MI", (int)(n5 * n6));
                ++n6;
                stringBuilder.append(this.separator).append(string9);
                if (string10.equals(string9.substring(0, 8))) {
                    stringBuilder2.append(this.separator).append(HybsDateUtil.getDateFormat((String)"HMF", (String)string9));
                } else {
                    stringBuilder2.append(this.separator).append(HybsDateUtil.getDateFormat((String)"M/d HH:mm", (String)string9));
                }
                string10 = string9.substring(0, 8);
            }
            string3 = stringBuilder.toString();
            if (n6 >= 300) {
                String string11 = "value\u30bf\u30b0\u3067\u3001action=\"HMCSV\" \u3067\u3001\u6700\u5927\u4ef6\u6570\u3092\u30aa\u30fc\u30d0\u30fc\u3057\u307e\u3057\u305f\u3002 MAX_CNT=[300]" + CR + " fromVal=[" + this.fromVal + "] , toVal=[" + this.toVal + "] , skipVal=[" + this.skipVal + "] , value=[" + string2 + "]" + CR + " rtn=[" + string3 + "]";
                System.err.println(string11);
            }
            this.setObject("MIN." + this.key, string7);
            this.setObject("MAX." + this.key, string8);
            this.setObject("HMF." + this.key, stringBuilder2.toString());
            return string3;
        } else {
            if (!ACT_HMCSV.equals(string)) return string3;
            if (!string2.contains(",")) return string3;
            String[] stringArray = StringUtil.csv2Array((String)string2);
            StringBuilder stringBuilder = new StringBuilder(200);
            String string12 = stringArray[0].substring(0, 8);
            for (String string13 : stringArray) {
                if (string12.equals(string13.substring(0, 8))) {
                    stringBuilder.append(this.separator).append(HybsDateUtil.getDateFormat((String)"HMF", (String)string13));
                } else {
                    stringBuilder.append(this.separator).append(HybsDateUtil.getDateFormat((String)"M/d HH:mm", (String)string13));
                }
                string12 = string13.substring(0, 8);
            }
            string3 = string2;
            this.setObject("MIN." + this.key, stringArray[0]);
            this.setObject("MAX." + this.key, stringArray[stringArray.length - 1]);
            this.setObject("HMF." + this.key, stringBuilder.toString());
        }
        return string3;
    }

    private void setAttribute(String string, String string2, String string3) {
        if (string == null || string.isEmpty()) {
            String string4 = "key \u304c\u30bb\u30c3\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002 command=" + this.command + " , action=" + string3 + " , value=" + string2;
            throw new HybsSystemException(string4);
        }
        if (string2 == null) {
            this.setObject(string, null);
        } else if (ACT_APPEND.equals(string3)) {
            String[] stringArray = this.getRequestParameterValues(this.inValue);
            this.setObject(string, StringUtil.array2line((String[])stringArray, (String)this.separator));
        } else if (ACT_SPLIT.equals(string3)) {
            String[] stringArray = string2.split(this.separator);
            this.setObject(string, stringArray[0]);
            for (int i = 0; i < stringArray.length; ++i) {
                this.setObject(string + i, stringArray[i]);
            }
        } else if (ACT_MAX_MIN.equals(string3)) {
            String[] stringArray = string2.split(this.separator);
            double d = Double.MAX_VALUE;
            double d2 = Double.MIN_VALUE;
            double d3 = 0.0;
            int n = 0;
            for (int i = 0; i < stringArray.length; ++i) {
                String string5 = stringArray[i].trim().replaceAll(",", "");
                if (string5.isEmpty()) continue;
                double d4 = Double.parseDouble(string5);
                if (d > d4) {
                    d = d4;
                }
                if (d2 < d4) {
                    d2 = d4;
                }
                d3 += d4;
                ++n;
            }
            if (n > 0) {
                NumberFormat numberFormat = NumberFormat.getInstance();
                numberFormat.setGroupingUsed(false);
                numberFormat.setMaximumFractionDigits(2);
                numberFormat.setMinimumFractionDigits(0);
                this.setObject("MIN." + string, numberFormat.format(d));
                this.setObject("MAX." + string, numberFormat.format(d2));
                this.setObject("SUM." + string, numberFormat.format(d3));
                this.setObject("AVG." + string, numberFormat.format(d3 / (double)n));
            } else {
                this.setObject("MIN." + string, StringUtil.nval((String)this.defaultVal, (String)""));
                this.setObject("MAX." + string, StringUtil.nval((String)this.defaultVal, (String)""));
                this.setObject("SUM." + string, StringUtil.nval((String)this.defaultVal, (String)""));
                this.setObject("AVG." + string, StringUtil.nval((String)this.defaultVal, (String)""));
            }
        } else {
            this.setObject(string, this.actionExec(string3, string2));
        }
    }

    private String getAttribute(String string, String string2) {
        if (string == null || string.isEmpty()) {
            String string3 = "key \u304c\u30bb\u30c3\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002 command=" + this.command + " , action=" + string2;
            throw new HybsSystemException(string3);
        }
        String string4 = this.defaultVal;
        Object object = this.pageContext.findAttribute(string);
        if (object != null) {
            string4 = object.toString();
        }
        return this.actionExec(string2, string4);
    }

    private void removeAttribute(String string) {
        if (string == null || string.isEmpty()) {
            String string2 = "key \u304c\u30bb\u30c3\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002 command=" + this.command;
            throw new HybsSystemException(string2);
        }
        this.removeObject(string);
    }

    private void clearAttribute(String string) {
        String string2;
        String string3 = null;
        if (string != null) {
            string3 = string.toLowerCase(Locale.JAPAN);
        }
        Enumeration enumeration = this.pageContext.getAttributeNamesInScope(4);
        while (enumeration.hasMoreElements()) {
            string2 = ((String)enumeration.nextElement()).toLowerCase(Locale.JAPAN);
            if (string2.startsWith("h_") || string2.startsWith("x_") || string3 != null && !string2.startsWith(string)) continue;
            this.pageContext.removeAttribute(string2, 4);
        }
        enumeration = this.pageContext.getAttributeNamesInScope(3);
        while (enumeration.hasMoreElements()) {
            string2 = String.valueOf(enumeration.nextElement()).toLowerCase(Locale.JAPAN);
            if (string2.startsWith("h_") || string2.startsWith("x_") || string3 != null && !string2.startsWith(string)) continue;
            this.pageContext.removeAttribute(string2, 3);
        }
    }

    private void setSQLAttribute(DBTableModel dBTableModel) {
        if (dBTableModel == null) {
            return;
        }
        int n = dBTableModel.getColumnCount();
        int n3 = dBTableModel.getRowCount();
        String string = "";
        if (ACT_ROW_APPEND.equals(this.action)) {
            OgBuilder ogBuilder = new OgBuilder();
            int n4 = 0;
            while (n4 < n) {
                int n5 = n4++;
                ogBuilder.clear();
                ogBuilder.appendRoop(0, n3, this.separator, n2 -> (String)dBTableModel.getValue(n2, n5));
                String string2 = dBTableModel.getColumnName(n5);
                this.setObject(string2, ogBuilder.toString());
            }
        } else if (ACT_LIST.equals(this.action)) {
            for (int i = 0; i < n; ++i) {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (int j = 0; j < n3; ++j) {
                    String string3 = (String)dBTableModel.getValue(j, i);
                    arrayList.add(string3);
                }
                String string4 = dBTableModel.getColumnName(i);
                this.setObject(string4, arrayList);
            }
        } else if (ACT_MAP.equals(this.action)) {
            if (n < 2) {
                String string5 = "action=MAP \u6642\u306b\u306f\u3001\u30ab\u30e9\u30e0\u306f\u3001\uff12\u3064\u4ee5\u4e0a\u5fc5\u8981\u3067\u3059\u3002\u30ab\u30e9\u30e0\u6570=[" + n + "]";
                throw new IllegalArgumentException(string5);
            }
            for (int i = 0; i < n3; ++i) {
                String string6 = (String)dBTableModel.getValue(i, 0);
                String string7 = (String)dBTableModel.getValue(i, 1);
                this.setObject(string6, string7);
                for (int j = 2; j < n; ++j) {
                    String string8 = string6 + "_" + (j - 1);
                    string7 = (String)dBTableModel.getValue(i, j);
                    this.setObject(string8, string7);
                }
            }
        } else if (ACT_MAPOBJ.equals(this.action)) {
            if (n < 2) {
                String string9 = "action=MAPOBJ \u6642\u306b\u306f\u3001\u30ab\u30e9\u30e0\u306f\u3001\uff12\u3064\u4ee5\u4e0a\u5fc5\u8981\u3067\u3059\u3002\u30ab\u30e9\u30e0\u6570=[" + n + "]";
                throw new IllegalArgumentException(string9);
            }
            if (this.key == null || this.key.isEmpty()) {
                this.key = dBTableModel.getColumnName(0);
            }
            LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
            for (int i = 0; i < n3; ++i) {
                String string10 = (String)dBTableModel.getValue(i, 0);
                String string11 = (String)dBTableModel.getValue(i, 1);
                linkedHashMap.put(string10, string11);
            }
            this.setObject(this.key, linkedHashMap);
        } else if (n3 == 0) {
            if (this.useMultiRows) {
                string = "0";
            }
            for (int i = 0; i < n; ++i) {
                String string12 = dBTableModel.getColumnName(i);
                String string13 = "";
                this.setObject(string12 + string, string13);
            }
        } else {
            for (int i = 0; i < n3; ++i) {
                if (this.useMultiRows) {
                    string = String.valueOf(i);
                }
                for (int j = 0; j < n; ++j) {
                    String string14 = dBTableModel.getColumnName(j);
                    String string15 = (String)dBTableModel.getValue(i, j);
                    this.setObject(string14 + string, string15);
                }
                if (this.useMultiRows) {
                    continue;
                }
                break;
            }
        }
    }

    private String getSQLAttribute(DBTableModel dBTableModel) {
        if (dBTableModel == null) {
            return "";
        }
        int n2 = dBTableModel.getRowCount();
        String string = ACT_ROW_APPEND.equals(this.action) ? new OgBuilder().appendRoop(0, n2, this.separator, n -> (String)dBTableModel.getValue(n, 0)).toString() : (n2 == 0 ? "" : (String)dBTableModel.getValue(0, 0));
        return string;
    }

    private void setTableAttribute(DBTableModel dBTableModel, String string, String string2) {
        if (dBTableModel == null || dBTableModel.getRowCount() == 0 || dBTableModel.getColumnCount() == 0) {
            return;
        }
        int[] nArray = this.getParameterRows();
        if (nArray.length == 0) {
            return;
        }
        String[] stringArray = string == null || string.isEmpty() ? dBTableModel.getNames() : new String[]{string};
        if (ACT_APPEND.equals(string2)) {
            OgBuilder ogBuilder = new OgBuilder();
            for (int i = 0; i < stringArray.length; ++i) {
                int n = dBTableModel.getColumnNo(stringArray[i]);
                ogBuilder.clear();
                ogBuilder.appendRoop(0, nArray.length, this.separator, n2 -> (String)dBTableModel.getValue(nArray[n2], n));
                this.setObject(stringArray[i], ogBuilder.toString());
            }
        } else if (ACT_MAP.equals(string2)) {
            int n = dBTableModel.getColumnNo(string, false);
            int n3 = dBTableModel.getColumnNo(this.value, false);
            if (n < 0) {
                n = 0;
            }
            if (n3 < 0) {
                n3 = 1;
            }
            for (int i = 0; i < nArray.length; ++i) {
                String string3 = (String)dBTableModel.getValue(nArray[i], n);
                String string4 = (String)dBTableModel.getValue(nArray[i], n3);
                this.setObject(string3, string4);
            }
        } else if (ACT_MAPOBJ.equals(string2)) {
            int n = dBTableModel.getColumnNo(string, false);
            int n4 = dBTableModel.getColumnNo(this.value, false);
            if (n < 0) {
                n = 0;
            }
            if (n4 < 0) {
                n4 = 1;
            }
            LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
            for (int i = 0; i < nArray.length; ++i) {
                String string5 = (String)dBTableModel.getValue(nArray[i], n);
                String string6 = (String)dBTableModel.getValue(nArray[i], n4);
                linkedHashMap.put(string5, string6);
            }
            this.setObject(string, linkedHashMap);
        } else if (ACT_LIST.equals(string2)) {
            for (int i = 0; i < stringArray.length; ++i) {
                int n = dBTableModel.getColumnNo(stringArray[i]);
                ArrayList<Object> arrayList = new ArrayList<Object>();
                for (int j = 0; j < nArray.length; ++j) {
                    arrayList.add(dBTableModel.getValue(nArray[j], n));
                }
                this.setObject(stringArray[i], arrayList);
            }
        } else if (ACT_MAX_MIN.equals(string2)) {
            NumberFormat numberFormat = null;
            for (int i = 0; i < stringArray.length; ++i) {
                int n = dBTableModel.getColumnNo(stringArray[i]);
                DBColumn dBColumn = dBTableModel.getDBColumn(n);
                boolean bl = dBColumn.isNumberType();
                String string7 = null;
                String string8 = null;
                double d = Double.MAX_VALUE;
                double d2 = Double.MIN_VALUE;
                double d3 = 0.0;
                int n5 = 0;
                for (int j = 0; j < nArray.length; ++j) {
                    String string9 = (String)dBTableModel.getValue(nArray[j], n);
                    if (string9 == null || string9.length() <= 0) continue;
                    if (bl) {
                        double d4 = Double.parseDouble(string9);
                        if (d > d4) {
                            d = d4;
                            string7 = string9;
                        }
                        if (d2 < d4) {
                            d2 = d4;
                            string8 = string9;
                        }
                        d3 += d4;
                        ++n5;
                        continue;
                    }
                    if (string7 == null || string7.compareTo(string9) > 0) {
                        string7 = string9;
                    }
                    if (string8 != null && string8.compareTo(string9) >= 0) continue;
                    string8 = string9;
                }
                if (string7 == null) {
                    string7 = StringUtil.nval((String)this.defaultVal, (String)"");
                }
                if (string8 == null) {
                    string8 = StringUtil.nval((String)this.defaultVal, (String)"");
                }
                this.setObject("MIN." + stringArray[i], string7);
                this.setObject("MAX." + stringArray[i], string8);
                if (n5 > 0) {
                    if (numberFormat == null) {
                        numberFormat = NumberFormat.getInstance();
                        numberFormat.setGroupingUsed(false);
                        numberFormat.setMaximumFractionDigits(2);
                        numberFormat.setMinimumFractionDigits(0);
                    }
                    this.setObject("SUM." + stringArray[i], numberFormat.format(d3));
                    this.setObject("AVG." + stringArray[i], numberFormat.format(d3 / (double)n5));
                    continue;
                }
                this.setObject("SUM." + stringArray[i], StringUtil.nval((String)this.defaultVal, (String)""));
                this.setObject("AVG." + stringArray[i], StringUtil.nval((String)this.defaultVal, (String)""));
            }
        } else {
            for (int i = 0; i < stringArray.length; ++i) {
                int n = dBTableModel.getColumnNo(stringArray[i]);
                this.setAttribute(stringArray[i], (String)dBTableModel.getValue(nArray[0], n), string2);
            }
        }
    }

    private String getTableAttribute(DBTableModel dBTableModel, String string, String string2) {
        if (dBTableModel == null) {
            String string3 = "table \u304c\u30bb\u30c3\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002 command=" + this.command + " , action=" + string2 + " , key=" + string;
            throw new HybsSystemException(string3);
        }
        if (string == null || string.isEmpty()) {
            String string4 = "key \u304c\u30bb\u30c3\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002 command=" + this.command + " , action=" + string2;
            throw new HybsSystemException(string4);
        }
        int[] nArray = this.getParameterRows();
        if (nArray.length == 0) {
            return "";
        }
        int n = dBTableModel.getColumnNo(string);
        if (ACT_APPEND.equals(string2)) {
            return new OgBuilder().appendRoop(0, nArray.length, this.separator, n2 -> (String)dBTableModel.getValue(nArray[n2], n)).toString();
        }
        return this.actionExec(string2, (String)dBTableModel.getValue(nArray[0], n));
    }

    private void setKeyTableAttribute(DBTableModel dBTableModel, String string, String string2, String string3) {
        int n;
        int[] nArray;
        OgBuilder ogBuilder;
        if (dBTableModel == null) {
            return;
        }
        if (string == null || string.isEmpty()) {
            String string4 = "key \u304c\u30bb\u30c3\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002 command=" + this.command + " , action=" + string3 + " , value=" + string2;
            throw new HybsSystemException(string4);
        }
        int[] nArray2 = this.getParameterRows();
        if (nArray2.length == 0) {
            return;
        }
        if (string2 == null || string2.isEmpty()) {
            ogBuilder = dBTableModel.getNames();
            nArray = new int[((String[])ogBuilder).length];
            for (n = 0; n < ((String[])ogBuilder).length; ++n) {
                nArray[n] = dBTableModel.getColumnNo((String)ogBuilder[n]);
            }
        } else {
            nArray = new int[]{dBTableModel.getColumnNo(string2)};
        }
        ogBuilder = new OgBuilder();
        for (n = 0; n < nArray2.length; ++n) {
            String string5 = string + n;
            int n3 = nArray2[n];
            if (ACT_APPEND.equals(string3)) {
                ogBuilder.clear();
                ogBuilder.appendRoop(0, nArray.length, this.separator, n2 -> (String)dBTableModel.getValue(n3, nArray[n2]));
                this.setObject(string5, ogBuilder.toString());
                continue;
            }
            this.setAttribute(string5, (String)dBTableModel.getValue(n3, nArray[0]), string3);
        }
    }

    private String scopeAttributePrint() {
        String string;
        Enumeration enumeration;
        StringBuilder stringBuilder = new StringBuilder(200).append("====================================").append(CR);
        if ("application".equals(this.scope)) {
            stringBuilder.append("APPLICATION_SCOPE:").append(CR);
            enumeration = this.pageContext.getAttributeNamesInScope(4);
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                stringBuilder.append("  key=[").append(string).append("] value=[").append(this.pageContext.getAttribute(string, 4)).append(']').append(CR);
            }
        }
        if ("session".equals(this.scope)) {
            stringBuilder.append("SESSION_SCOPE:").append(CR);
            enumeration = this.pageContext.getAttributeNamesInScope(3);
            while (enumeration.hasMoreElements()) {
                string = String.valueOf(enumeration.nextElement());
                stringBuilder.append("  key=[").append(string).append("] value=[").append(this.pageContext.getAttribute(string, 3)).append(']').append(CR);
            }
        }
        if ("request".equals(this.scope)) {
            stringBuilder.append("REQUEST_SCOPE:").append(CR);
            enumeration = this.pageContext.getAttributeNamesInScope(2);
            while (enumeration.hasMoreElements()) {
                string = String.valueOf(enumeration.nextElement());
                stringBuilder.append("  key=[").append(string).append("] value=[").append(this.pageContext.getAttribute(string, 2)).append(']').append(CR);
            }
        }
        if ("page".equals(this.scope)) {
            stringBuilder.append("PAGE_SCOPE:").append(CR);
            enumeration = this.pageContext.getAttributeNamesInScope(1);
            while (enumeration.hasMoreElements()) {
                string = String.valueOf(enumeration.nextElement());
                stringBuilder.append("  key=[").append(string).append("] value=[").append(this.pageContext.getAttribute(string, 1)).append(']').append(CR);
            }
        }
        stringBuilder.append("====================================").append(CR);
        return stringBuilder.toString();
    }

    @Override
    protected int[] getParameterRows() {
        int[] nArray;
        if (ACT_FIRST.equals(this.action)) {
            nArray = new int[]{0};
        } else if (this.tmpSelectedAll) {
            int n = this.table.getRowCount();
            nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = i;
            }
        } else {
            nArray = super.getParameterRows();
        }
        return nArray;
    }

    public void setTableId(String string) {
        this.tableId = StringUtil.nval((String)this.getRequestParameter(string), (String)this.tableId);
    }

    public void setCommand(String string) {
        this.command = StringUtil.nval((String)this.getRequestParameter(string), (String)this.command).toUpperCase(Locale.JAPAN);
        if (!this.check(this.command, COMMAND_SET)) {
            String string2 = "\u6307\u5b9a\u306e\u30b3\u30de\u30f3\u30c9\u306f\u5b9f\u884c\u3067\u304d\u307e\u305b\u3093\u3002\u30b3\u30de\u30f3\u30c9\u30a8\u30e9\u30fc" + CR + "command=[" + this.command + "] " + CR + "commandList=[" + String.join((CharSequence)", ", COMMAND_SET) + "]";
            throw new HybsSystemException(string2);
        }
    }

    public void setAction(String string) {
        this.action = StringUtil.nval((String)this.getRequestParameter(string), (String)this.action);
        if (this.action != null && !this.check(this.action, ACTION_SET)) {
            String string2 = "\u6307\u5b9a\u306e\u30a2\u30af\u30b7\u30e7\u30f3\u306f\u5b9f\u884c\u3067\u304d\u307e\u305b\u3093\u3002\u30a2\u30af\u30b7\u30e7\u30f3\u30a8\u30e9\u30fc" + CR + "action=[" + this.action + "] " + CR + "actionList=[" + String.join((CharSequence)", ", ACTION_SET) + "]";
            throw new HybsSystemException(string2);
        }
        if (this.action != null && this.action.startsWith("ALL_")) {
            this.action = this.action.substring(4);
            this.tmpSelectedAll = true;
        }
    }

    public void setKey(String string) {
        this.key = StringUtil.nval((String)this.getRequestParameter(string), (String)this.key);
    }

    public void setValue(String string) {
        this.inValue = string;
        this.value = this.getRequestParameter(this.inValue);
    }

    public void setDefaultVal(String string) {
        this.defaultVal = this.getRequestParameter(string);
    }

    public void setDbid(String string) {
        this.dbid = StringUtil.nval((String)this.getRequestParameter(string), (String)this.dbid);
    }

    @Override
    public void setScope(String string) {
        this.scope = StringUtil.nval((String)this.getRequestParameter(string), (String)this.scope);
    }

    public void setTblScope(String string) {
        this.tblScope = StringUtil.nval((String)this.getRequestParameter(string), (String)this.tblScope);
    }

    public void setUseMultiRows(String string) {
        this.useMultiRows = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useMultiRows);
    }

    public void setSeparator(String string) {
        this.separator = StringUtil.nval((String)this.getRequestParameter(string), (String)this.separator);
    }

    public void setXssCheck(String string) {
        this.xssCheck = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.xssCheck);
    }

    public void setFromVal(String string) {
        this.fromVal = StringUtil.nval((String)this.getRequestParameter(string), (String)this.fromVal);
    }

    public void setToVal(String string) {
        this.toVal = StringUtil.nval((String)this.getRequestParameter(string), (String)this.toVal);
    }

    public void setSkipVal(String string) {
        char c;
        this.skipVal = StringUtil.nval((String)this.getRequestParameter(string), (String)this.skipVal);
        if (!(StringUtil.isNull((CharSequence[])new CharSequence[]{this.skipVal}) || (c = this.skipVal.charAt(0)) != '-' && c != '0')) {
            String string2 = "skipVal\u5c5e\u6027\u306b\u306f\u3001\u30de\u30a4\u30ca\u30b9\u3084\u30bc\u30ed\u306f\u3001\u6307\u5b9a\u3067\u304d\u307e\u305b\u3093\u3002 skipVal=[" + this.skipVal + "]" + CR;
            throw new HybsSystemException(string2);
        }
    }

    @Override
    public String toString() {
        return ToString.title((String)((Object)((Object)this)).getClass().getName()).println("VERSION", (Object)VERSION).println("tableId", (Object)this.tableId).println("command", (Object)this.command).println("action", (Object)this.action).println("key", (Object)this.key).println("inValue", (Object)this.inValue).println("value", (Object)this.value).println("defaultVal", (Object)this.defaultVal).println("dbid", (Object)this.dbid).println("scope", (Object)this.scope).println("tblScope", (Object)this.tblScope).println("separator", (Object)this.separator).println("useMultiRows", (Object)this.useMultiRows).println("xssCheck", (Object)this.xssCheck).println("fromVal", (Object)this.fromVal).println("toVal", (Object)this.toVal).println("skipVal", (Object)this.skipVal).println("tmpSelectedAll", (Object)this.tmpSelectedAll).println("Other...", (Object)this.getAttributes().getAttribute()).fixForm().toString();
    }
}

