<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<!-- 2018/06/21 MODIFY useRichText属性を追加 -->
<og:head headType="result" useRealTimeCheck="false" useRichText="true" />

<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "23_FAQRGST"
	title	= "標準(FAQ登録)"
	date	= "2015/10/09"
	author	= "K.Hasegawa"
	text	= ""
	version	= "001"
>
	2018/06/29	T.OTA	05200-180319-01 ﾃｷｽﾄｴﾘｱをﾘｯﾁﾃｷｽﾄに変更。
</og:comment>

<!-- forward.jsp から command = "COPY/MODIFY/DELETE" がセットされて遷移してきます。-->
<!-- データが選ばれていなければエラー -->
<og:columnCheck command="{@command}" >
	<jsp:directive.include file="/jsp/common/history_back.jsp" />
</og:columnCheck>

<!-- ﾌｧｲﾙﾊﾟｽ取得-->
<og:equals val1="INSERT|COPY" val2="{@command}" contains="true">
	<og:value command="SQL">
		SELECT	'faq/'||'{@SYS.SYSTEM_ID}'||'/'||'{@USER.ID}'||TO_CHAR(SYSDATE,'YYYYMMDDHH24MISS')	REAL_PATH
		FROM	DUAL
	</og:value>
</og:equals>

<!-- forward.jsp から command がセットされて遷移してきます。-->
<!-- カラムに対して値をセットしない場合、ColumnSetTagは不要です。 -->
<og:entry command="{@command}" repeatCount="{@repeatCount}" >
	<og:columnSet command="{@command}" columnId="KBFAQ"		action="SET" value="{@KBFAQ}" caseNN="{@KBFAQ}" />
	<og:columnSet command="{@command}" columnId="SYSTEM_ID"	action="SET" value="{@SYS.SYSTEM_ID}"/>		<!-- ｼｽﾃﾑID	-->
	<og:columnSet command="COPY"	columnId="FILEPATH"		action="SET" value="{@REAL_PATH}"/>			<!-- ﾌｧｲﾙﾊﾟｽ-->
	<og:columnSet command="COPY"	columnId="FILE1"		action="CLEAR"/>							<!-- 添付ﾌｧｲﾙ1-->
	<og:columnSet command="COPY"	columnId="FILE2"		action="CLEAR"/>							<!-- 添付ﾌｧｲﾙ2-->
	<og:columnSet command="COPY"	columnId="FILE3"		action="CLEAR"/>							<!-- 添付ﾌｧｲﾙ3-->
</og:entry>

<og:message command="{@command}" /><br />  <!-- 動的にコメントを表示します。 -->

<!--  2018/06/29 MODIFY TEXTAREAをRICHTEXTに変更。 rendererはRICHLABEL。
<og:columnEditor columns="NAIYO" editor="RICHTEXT" renderer="RICHLABEL" size="200,500" />

<form name="frm" onSubmit="return oneClick();" method="POST" action="entry0.jsp" enctype="multipart/form-data" target="RESULT">
	<!-- 登録、取消、リセットボタンを作成します。 -->
	<!-- HTMLTextField(１点入力)使用時には、EXCEL(CSV)取り込みは使えません。 -->
	<!-- value属性+.jspの画面に制御が移ります。ただし、value="reset"のみ特殊で、result.jspに遷移します。 -->
	<!-- commandには value属性の値の大文字が設定されます。 command属性で設定しなおすことも出来ます。-->
	<og:writeCheck>
		<og:submit  action="ENTRY" />
		<og:submit  action="RESET" />
		<og:input type="reset"  name="command"  lbl="MSG0011"  td="false" />
		<br />
	</og:writeCheck>

	<!-- DB検索結果を表示させます。 -->
	<!-- checked="true" で、チェック済みの状態で表示できます。 -->
	<!-- selectedType="checkbox(デフォルト)/radio/hidden" から、選べます。-->
	<!-- viewFormType="HTMLTextField" を使用する場合は、skip="true"が必要です。 -->
	<og:view
		viewFormType = "HTMLFormatTextField"
		command      = "{@command}" 
		noDisplay    = "UNIQ"
		noWritable   = "{@noWritable}"
		skip         = "true"
	>
	<table>
		<tr>[CDBNRUI]				</tr>	<!-- 分類名 -->
		<tr>[TITLE]					</tr>	<!-- ﾀｲﾄﾙ-->
		<tr><td class="label">[#NAIYO]</td><td colspan="3">[$NAIYO]</td></tr>		<!-- 内容-->
		<tr>[KNRNGUI]	[KBFAQ]		</tr>	<!-- FAQ区分-->
		<tr>[SYSTEM_ID]	[SYSCODE]	</tr>	<!-- ｼｽﾃﾑｺｰﾄﾞ -->
		<tr>[FGJ]		[QANO]		</tr>	<!-- 質問番号 -->
	</table>
<!--
		<og:fieldset lbl="FILE">
			<table>
				<tr>
					[FILE1]					 添付1
					[FILE2]					 添付2
					[FILE3]					 添付3
				</tr>
			<og:equals val1="{@command}" val2="MODIFY">
				<tr>
					<td colspan="2">[!FILE1]</td>		 (変更前)ﾌｧｲﾙ1
					<td colspan="2">[!FILE2]</td>		 (変更前)ﾌｧｲﾙ2
					<td colspan="2">[!FILE3]</td>		 (変更前)ﾌｧｲﾙ3
				</tr>
			</og:equals>
			</table>
		</og:fieldset>
-->
		<!-- ﾌｧｲﾙﾊﾟｽ取得(追加･複写) -->
		<og:equals val1="COPY" val2="{@command}" contains="true">
			<og:userInfo key="USER.FILEPATH" command="SET" value="{@REAL_PATH}"/>
		</og:equals>
		<!-- ﾌｧｲﾙﾊﾟｽ取得(変更)-->
		<og:equals val1="{@command}" val2="MODIFY">
			<og:value command="SETTBL" key="FILEPATH"/>
			<og:userInfo key="USER.FILEPATH" command="SET" value="{@FILEPATH}"/>
		</og:equals>
	<og:hidden name="sqlType" defaultVal="{@command}" value="{@sqlType}" />
	</og:view>

</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
