/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.plugin.cloud;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpSession;
import org.opengion.fukurou.util.Closer;
import org.opengion.fukurou.util.FileUtil;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.io.StorageAPI;
import org.openstack4j.api.OSClient;
import org.openstack4j.api.client.IOSClientBuilder;
import org.openstack4j.api.storage.ObjectStorageService;
import org.openstack4j.model.common.DLPayload;
import org.openstack4j.model.common.Identifier;
import org.openstack4j.model.common.Payload;
import org.openstack4j.model.storage.object.SwiftObject;
import org.openstack4j.model.storage.object.options.ObjectListOptions;
import org.openstack4j.model.storage.object.options.ObjectLocation;
import org.openstack4j.openstack.OSFactory;
import org.openstack4j.openstack.internal.OSClientSession;

public class StorageAPI_bluemix
implements StorageAPI {
    String container = null;
    String username = null;
    String password = null;
    String domainId = null;
    String projectId = null;
    String auth_url = null;

    public StorageAPI_bluemix(String string, HttpSession httpSession) {
        Object object;
        JsonNode jsonNode;
        this.container = string;
        String string2 = System.getenv("VCAP_SERVICES");
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            jsonNode = objectMapper.readTree(string2);
            object = jsonNode.get("Object-Storage").elements();
            JsonNode jsonNode2 = ((JsonNode)object.next()).get("credentials");
            this.username = jsonNode2.get("username").textValue();
            this.password = jsonNode2.get("password").textValue();
            this.domainId = jsonNode2.get("domainId").textValue();
            this.projectId = jsonNode2.get("projectId").textValue();
            this.auth_url = jsonNode2.get("auth_url").textValue() + "/v3";
        }
        catch (Exception exception) {
            String string3 = "VCAP_SERVICES\u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002\u30b9\u30c8\u30ec\u30fc\u30b8\u3068\u63a5\u7d9a\u3055\u308c\u3066\u3044\u308b\u304b\u78ba\u8a8d\u3057\u3066\u4e0b\u3055\u3044\u3002" + exception;
            throw new HybsSystemException(string3);
        }
        try {
            jsonNode = this.auth(httpSession);
            jsonNode.containers().create(string);
        }
        catch (Exception exception) {
            object = new StringBuilder();
            ((StringBuilder)object).append("\u30b3\u30f3\u30c6\u30ca\u306e\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002container:");
            ((StringBuilder)object).append(string);
            ((StringBuilder)object).append(" errInfo:");
            ((StringBuilder)object).append(exception);
            throw new HybsSystemException(((StringBuilder)object).toString());
        }
    }

    private ObjectStorageService auth(HttpSession httpSession) {
        OSClientSession oSClientSession = OSClientSession.getCurrent();
        if (oSClientSession != null) {
            return oSClientSession.objectStorage();
        }
        String string = (String)httpSession.getAttribute("SESSION_CLOUD_TOKEN");
        if (string != null && !"".equals(string)) {
            OSClient.OSClientV3 oSClientV3 = (OSClient.OSClientV3)((IOSClientBuilder.V3)OSFactory.builderV3().endpoint(this.auth_url)).token(string).scopeToProject(Identifier.byId((String)this.projectId)).authenticate();
            return oSClientV3.objectStorage();
        }
        string = Identifier.byId((String)this.domainId);
        OSClient.OSClientV3 oSClientV3 = (OSClient.OSClientV3)((IOSClientBuilder.V3)OSFactory.builderV3().endpoint(this.auth_url)).credentials(this.username, this.password, (Identifier)string).scopeToProject(Identifier.byId((String)this.projectId)).authenticate();
        httpSession.setAttribute("SESSION_CLOUD_TOKEN", (Object)oSClientV3.getToken().getId());
        ObjectStorageService objectStorageService = oSClientV3.objectStorage();
        return objectStorageService;
    }

    public void add(InputStream inputStream, String string, String string2, HttpSession httpSession) {
        ObjectStorageService objectStorageService = this.auth(httpSession);
        InputPayload inputPayload = new InputPayload(this, inputStream);
        try {
            objectStorageService.objects().put(this.container, string + string2, (Payload)inputPayload);
        }
        catch (Exception exception) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\u30b9\u30c8\u30ec\u30fc\u30b8\u3078\u306e\u30d5\u30a1\u30a4\u30eb\u30a2\u30c3\u30d7\u30ed\u30fc\u30c9\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002updFolder:");
            stringBuilder.append(string);
            stringBuilder.append(" updFileName:");
            stringBuilder.append(string2);
            stringBuilder.append(" errInfo:");
            stringBuilder.append(exception);
            throw new HybsSystemException(stringBuilder.toString());
        }
        finally {
            Closer.ioClose((Closeable)inputStream);
            Closer.ioClose((Closeable)((Object)inputPayload));
        }
    }

    public InputStream get(String string, HttpSession httpSession) {
        ObjectStorageService objectStorageService = this.auth(httpSession);
        DLPayload dLPayload = null;
        try {
            SwiftObject swiftObject = objectStorageService.objects().get(ObjectLocation.create((String)this.container, (String)string));
            dLPayload = swiftObject.download();
        }
        catch (Exception exception) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\u30b9\u30c8\u30ec\u30fc\u30b8\u304b\u3089\u306e\u30d5\u30a1\u30a4\u30eb\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002filePath:");
            stringBuilder.append(string);
            stringBuilder.append(" errInfo:");
            stringBuilder.append(exception);
            throw new HybsSystemException(stringBuilder.toString());
        }
        return dLPayload.getInputStream();
    }

    public void copy(String string, String string2, HttpSession httpSession) {
        InputPayload inputPayload = null;
        InputStream inputStream = null;
        try {
            inputStream = this.get(string, httpSession);
            inputPayload = new InputPayload(this, inputStream);
            ObjectStorageService objectStorageService = this.auth(httpSession);
            objectStorageService.objects().put(this.container, string2, (Payload)inputPayload);
        }
        catch (Exception exception) {
            try {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("\u30b9\u30c8\u30ec\u30fc\u30b8\u306e\u30d5\u30a1\u30a4\u30eb\u30b3\u30d4\u30fc\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002oldFilePath:");
                stringBuilder.append(string);
                stringBuilder.append(" newFilePath:");
                stringBuilder.append(string2);
                stringBuilder.append(" errInfo:");
                stringBuilder.append(exception);
                throw new HybsSystemException(stringBuilder.toString());
            }
            catch (Throwable throwable) {
                Closer.ioClose(inputPayload);
                Closer.ioClose((Closeable)inputStream);
                throw throwable;
            }
        }
        Closer.ioClose((Closeable)((Object)inputPayload));
        Closer.ioClose((Closeable)inputStream);
    }

    public void delete(String string, HttpSession httpSession) {
        ObjectStorageService objectStorageService = this.auth(httpSession);
        try {
            objectStorageService.objects().delete(ObjectLocation.create((String)this.container, (String)string));
        }
        catch (Exception exception) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\u30b9\u30c8\u30ec\u30fc\u30b8\u306e\u30d5\u30a1\u30a4\u30eb\u524a\u9664\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002filePath:");
            stringBuilder.append(string);
            stringBuilder.append(" errInfo:");
            stringBuilder.append(exception);
            throw new HybsSystemException(stringBuilder.toString());
        }
    }

    public void rename(String string, String string2, String string3, boolean bl, HttpSession httpSession) {
        String string4 = string + string3;
        String string5 = string + string2;
        if (this.exists(string4, httpSession) && bl) {
            String string6 = string + "_backup/" + string3 + "_" + System.currentTimeMillis() + '.' + FileUtil.getExtension((String)string3);
            this.copy(string4, string6, httpSession);
        }
        this.copy(string5, string4, httpSession);
        this.delete(string5, httpSession);
    }

    public boolean exists(String string, HttpSession httpSession) {
        boolean bl = true;
        ObjectStorageService objectStorageService = this.auth(httpSession);
        try {
            SwiftObject swiftObject = objectStorageService.objects().get(ObjectLocation.create((String)this.container, (String)string));
            if (swiftObject == null) {
                bl = false;
            }
        }
        catch (Exception exception) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\u30b9\u30c8\u30ec\u30fc\u30b8\u306e\u30d5\u30a1\u30a4\u30eb\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002filePath:");
            stringBuilder.append(string);
            stringBuilder.append(" errInfo:");
            stringBuilder.append(exception);
            throw new HybsSystemException(stringBuilder.toString());
        }
        return bl;
    }

    public String[] list(String string, HttpSession httpSession) {
        ObjectStorageService objectStorageService = this.auth(httpSession);
        List list = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            ObjectListOptions objectListOptions = ObjectListOptions.create().startsWith(string);
            list = objectStorageService.objects().list(this.container, objectListOptions);
            for (SwiftObject swiftObject : list) {
                arrayList.add(swiftObject.getName());
            }
        }
        catch (Exception exception) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\u30d5\u30a1\u30a4\u30eb\u4e00\u89a7\u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002startsWith:");
            stringBuilder.append(string);
            stringBuilder.append(" errInfo:");
            stringBuilder.append("e");
            throw new HybsSystemException(stringBuilder.toString());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public Map<String, String> getInfo(String string, HttpSession httpSession) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ObjectStorageService objectStorageService = this.auth(httpSession);
        SwiftObject swiftObject = null;
        try {
            swiftObject = objectStorageService.objects().get(ObjectLocation.create((String)this.container, (String)string));
        }
        catch (Exception exception) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\u30d5\u30a1\u30a4\u30eb\u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002path:");
            stringBuilder.append(string);
            stringBuilder.append(" errInfo:");
            stringBuilder.append(exception);
            throw new HybsSystemException(stringBuilder.toString());
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddhhmmss");
        hashMap.put("SIZE", String.valueOf(swiftObject.getSizeInBytes()));
        hashMap.put("LASTMODIFIED", simpleDateFormat.format(swiftObject.getLastModified()));
        return hashMap;
    }

    public static class InputPayload<T extends InputStream>
    implements Payload<T> {
        private T stream = null;
        final /* synthetic */ StorageAPI_bluemix this$0;

        public InputPayload(T t) {
            this.this$0 = var1_1;
            this.stream = t;
        }

        public void close() throws IOException {
            ((InputStream)this.stream).close();
        }

        public T open() {
            return this.stream;
        }

        public void closeQuietly() {
            Closer.ioClose(this.stream);
        }

        public T getRaw() {
            return this.stream;
        }
    }
}

