/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.core.transport.internal;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;

public class OSBadBooleanDeserializer
extends JsonDeserializer<Boolean> {
    public Boolean deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.VALUE_TRUE) {
            return Boolean.TRUE;
        }
        if (t == JsonToken.VALUE_FALSE) {
            return Boolean.FALSE;
        }
        if (t == JsonToken.VALUE_NUMBER_INT) {
            if (jp.getNumberType() == JsonParser.NumberType.INT) {
                return jp.getIntValue() == 0 ? Boolean.FALSE : Boolean.TRUE;
            }
            return this._parseBooleanFromNumber(jp, ctxt);
        }
        if (t == JsonToken.VALUE_NULL) {
            return (Boolean)this.getNullValue();
        }
        if (t == JsonToken.VALUE_STRING) {
            String text = jp.getText().trim();
            if ("true".equalsIgnoreCase(text)) {
                return Boolean.TRUE;
            }
            if ("false".equalsIgnoreCase(text)) {
                return Boolean.FALSE;
            }
            if (text.length() == 0) {
                return (Boolean)this.getEmptyValue();
            }
            throw ctxt.weirdStringException(text, Boolean.class, "only \"true\" or \"false\" recognized");
        }
        throw ctxt.mappingException(Boolean.class, t);
    }

    protected final boolean _parseBooleanFromNumber(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        if (jp.getNumberType() == JsonParser.NumberType.LONG) {
            return jp.getLongValue() == 0L ? Boolean.FALSE : Boolean.TRUE;
        }
        String str = jp.getText();
        if ("0.0".equals(str) || "0".equals(str)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }
}

