/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.gbp.internal;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import org.openstack4j.api.gbp.PolicyRuleService;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.gbp.PolicyRule;
import org.openstack4j.openstack.gbp.domain.GbpPolicyRule;
import org.openstack4j.openstack.internal.BaseOpenStackService;
import org.openstack4j.openstack.networking.internal.BaseNetworkingServices;

public class PolicyRuleServiceImpl
extends BaseNetworkingServices
implements PolicyRuleService {
    @Override
    public List<? extends PolicyRule> list() {
        return this.get(GbpPolicyRule.PolicyRules.class, this.uri("/grouppolicy/policy_rules", new Object[0])).execute().getList();
    }

    @Override
    public List<? extends PolicyRule> list(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<GbpPolicyRule.PolicyRules> policyruleInvocation = this.buildInvocation(filteringParams);
        return policyruleInvocation.execute().getList();
    }

    private BaseOpenStackService.Invocation<GbpPolicyRule.PolicyRules> buildInvocation(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<GbpPolicyRule.PolicyRules> policyruleInvocation = this.get(GbpPolicyRule.PolicyRules.class, "/grouppolicy/policy_rules");
        if (filteringParams == null) {
            return policyruleInvocation;
        }
        if (filteringParams != null) {
            for (Map.Entry<String, String> entry : filteringParams.entrySet()) {
                policyruleInvocation = policyruleInvocation.param(entry.getKey(), entry.getValue());
            }
        }
        return policyruleInvocation;
    }

    @Override
    public PolicyRule get(String id) {
        Preconditions.checkNotNull((Object)id);
        return this.get(GbpPolicyRule.class, this.uri("/grouppolicy/policy_rules/%s", id)).execute();
    }

    @Override
    public ActionResponse delete(String id) {
        Preconditions.checkNotNull((Object)id);
        return this.deleteWithResponse(this.uri("/grouppolicy/policy_rules/%s", id)).execute();
    }

    @Override
    public PolicyRule create(PolicyRule policyRule) {
        return this.post(GbpPolicyRule.class, this.uri("/grouppolicy/policy_rules", new Object[0])).entity(policyRule).execute();
    }

    @Override
    public PolicyRule update(String policyRuleId, PolicyRule policyRule) {
        Preconditions.checkNotNull((Object)policyRuleId);
        Preconditions.checkNotNull((Object)policyRule);
        return this.put(GbpPolicyRule.class, this.uri("/grouppolicy/policy_rules/%s", policyRuleId)).entity(policyRule).execute();
    }
}

