/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.identity.v3.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import java.util.List;
import java.util.Map;
import org.openstack4j.model.identity.v3.Group;
import org.openstack4j.model.identity.v3.builder.GroupBuilder;
import org.openstack4j.openstack.common.ListResult;

@JsonRootName(value="group")
@JsonIgnoreProperties(ignoreUnknown=true)
public class KeystoneGroup
implements Group {
    private static final long serialVersionUID = 1L;
    private String id;
    @JsonProperty(value="domain_id")
    private String domainId;
    private String name;
    private String description;
    private Map<String, String> links;

    public static GroupBuilder builder() {
        return new GroupConcreteBuilder();
    }

    @Override
    public GroupBuilder toBuilder() {
        return new GroupConcreteBuilder(this);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getDomainId() {
        return this.domainId;
    }

    @Override
    public Map<String, String> getLinks() {
        return this.links;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("id", (Object)this.id).add("name", (Object)this.name).add("description", (Object)this.description).add("links", this.links).add("domainId", (Object)this.domainId).toString();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.name, this.description, this.links, this.domainId});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        KeystoneGroup that = (KeystoneGroup)KeystoneGroup.class.cast(obj);
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.domainId, (Object)that.domainId) && Objects.equal((Object)this.description, (Object)that.description) && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal(this.links, that.links);
    }

    public static class Groups
    extends ListResult<KeystoneGroup> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="groups")
        protected List<KeystoneGroup> list;

        @Override
        public List<KeystoneGroup> value() {
            return this.list;
        }
    }

    public static class GroupConcreteBuilder
    implements GroupBuilder {
        KeystoneGroup model;

        GroupConcreteBuilder() {
            this(new KeystoneGroup());
        }

        GroupConcreteBuilder(KeystoneGroup model) {
            this.model = model;
        }

        @Override
        public Group build() {
            return this.model;
        }

        @Override
        public GroupBuilder from(Group in) {
            if (in != null) {
                this.model = (KeystoneGroup)in;
            }
            return this;
        }

        @Override
        public GroupBuilder id(String id) {
            this.model.id = id;
            return this;
        }

        @Override
        public GroupBuilder name(String name) {
            this.model.name = name;
            return this;
        }

        @Override
        public GroupBuilder description(String description) {
            this.model.description = description;
            return this;
        }

        @Override
        public GroupBuilder domainId(String domainId) {
            this.model.domainId = domainId;
            return this;
        }

        @Override
        public GroupBuilder links(Map<String, String> links) {
            this.model.links = links;
            return this;
        }
    }
}

