/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Flow;
import java.util.concurrent.Phaser;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import oracle.jdbc.internal.CompletionStageUtil;
import oracle.jdbc.internal.Monitor;

abstract class PhasedPublisher<T>
implements Flow.Publisher<T> {
    private final Phaser publishingPhaser;
    private final AtomicInteger nextPhaseDeregistrations = new AtomicInteger(0);
    private final TerminalAction terminalAction;
    private final CompletableFuture<Void> terminalFuture = new CompletableFuture();
    private final Executor executor;
    private final ConcurrentHashMap<Flow.Subscriber<?>, PhasedSubscription> subscriptions = new ConcurrentHashMap();

    protected PhasedPublisher(Executor executor, TerminalAction terminalAction) {
        this.executor = executor;
        this.terminalAction = terminalAction == null ? () -> {} : terminalAction;
        this.publishingPhaser = new PublishingPhaser();
    }

    private final void deregisterAfterArrivedPhase(int n2) {
        int n3 = this.publishingPhaser.register();
        if (n3 > n2) {
            this.publishingPhaser.awaitAdvance(n2);
            this.publishingPhaser.arriveAndDeregister();
        } else {
            this.nextPhaseDeregistrations.incrementAndGet();
        }
        this.publishingPhaser.arriveAndDeregister();
    }

    private final void executeNextPhaseDeregistrations(int n2) {
        int n3 = this.nextPhaseDeregistrations.getAndSet(0);
        if (n3 != 0) {
            this.executor.execute(() -> {
                this.publishingPhaser.awaitAdvance(n2);
                for (int i2 = 0; i2 < n3; ++i2) {
                    this.publishingPhaser.arriveAndDeregister();
                }
            });
        }
    }

    protected void handleOnNext(T t2, Consumer<? super T> consumer) {
        consumer.accept(t2);
    }

    protected abstract CompletionStage<T> advancePhaseAsync();

    private final void handlePhaseAdvancement(T t2, Throwable throwable) {
        if (throwable != null) {
            this.endPublishing(CompletionStageUtil.unwrapCompletionException(throwable));
        } else if (t2 != null) {
            for (PhasedSubscription phasedSubscription : this.subscriptions.values()) {
                this.executor.execute(() -> phasedSubscription.emitNextItem(t2));
            }
        } else {
            this.endPublishing(null);
        }
    }

    private final void endPublishing(Throwable throwable) {
        this.publishingPhaser.forceTermination();
        try {
            this.terminalAction.run();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            }
            throwable.addSuppressed(throwable2);
        }
        if (throwable == null) {
            this.terminalFuture.complete(null);
        } else {
            this.terminalFuture.completeExceptionally(throwable);
        }
    }

    @Override
    public final void subscribe(Flow.Subscriber<? super T> subscriber) {
        Objects.requireNonNull(subscriber);
        PhasedSubscription phasedSubscription = new PhasedSubscription(subscriber);
        PhasedSubscription phasedSubscription2 = this.subscriptions.putIfAbsent(subscriber, phasedSubscription);
        if (phasedSubscription2 != null) {
            phasedSubscription2.emitError(new IllegalStateException("Subscriber argument to subscribe(Subscriber) is already subscribed"));
        } else {
            this.publishingPhaser.register();
            try (Monitor.CloseableLock closeableLock = phasedSubscription.monitor.acquireCloseableLock();){
                subscriber.onSubscribe(phasedSubscription);
                this.terminalFuture.whenCompleteAsync((void_, throwable) -> {
                    if (throwable == null) {
                        phasedSubscription.emitComplete();
                    } else {
                        phasedSubscription.emitError((Throwable)throwable);
                    }
                }, this.executor);
            }
            catch (Throwable throwable2) {
                phasedSubscription.cancel();
            }
        }
    }

    @FunctionalInterface
    static interface TerminalAction {
        public void run() throws Exception;
    }

    private class PhasedSubscription
    implements Flow.Subscription {
        private final Monitor monitor = Monitor.newInstance();
        private final Flow.Subscriber<? super T> proxiedSubscriber;
        private boolean isCancelled = false;
        private int lastArrivedPhase = -1;
        private long demand = 0L;

        private PhasedSubscription(Flow.Subscriber<? super T> subscriber) {
            this.proxiedSubscriber = subscriber;
        }

        private final void emitNextItem(T t2) {
            try (Monitor.CloseableLock closeableLock = this.monitor.acquireCloseableLock();){
                if (this.isCancelled) {
                    return;
                }
                PhasedPublisher.this.handleOnNext(t2, object -> {
                    try {
                        this.proxiedSubscriber.onNext(object);
                    }
                    catch (Throwable throwable) {
                        this.cancel();
                    }
                });
                this.decrementDemand();
                if (this.demand > 0L) {
                    this.arriveForNextPhase();
                }
            }
        }

        private final void emitError(Throwable throwable) {
            try (Monitor.CloseableLock closeableLock = this.monitor.acquireCloseableLock();){
                if (this.isCancelled) {
                    return;
                }
                this.cancel();
                try {
                    this.proxiedSubscriber.onError(throwable);
                }
                catch (Throwable throwable2) {
                }
            }
        }

        private final void emitComplete() {
            try (Monitor.CloseableLock closeableLock = this.monitor.acquireCloseableLock();){
                if (this.isCancelled) {
                    return;
                }
                this.cancel();
                try {
                    this.proxiedSubscriber.onComplete();
                }
                catch (Throwable throwable) {
                }
            }
        }

        @Override
        public final void cancel() {
            try (Monitor.CloseableLock closeableLock = this.monitor.acquireCloseableLock();){
                if (this.isCancelled) {
                    return;
                }
                this.isCancelled = true;
                this.demand = Long.MIN_VALUE;
                PhasedPublisher.this.subscriptions.remove(this.proxiedSubscriber);
                PhasedPublisher.this.deregisterAfterArrivedPhase(this.lastArrivedPhase);
            }
        }

        @Override
        public final void request(long l2) {
            try (Monitor.CloseableLock closeableLock = this.monitor.acquireCloseableLock();){
                if (this.isCancelled) {
                    return;
                }
                if (l2 < 1L) {
                    this.emitError(new IllegalArgumentException("Received a negative subscription request. Argument to request(long) was: " + l2));
                    return;
                }
                boolean bl = this.demand == 0L;
                this.increaseDemand(l2);
                if (bl) {
                    this.arriveForNextPhase();
                }
            }
        }

        private final void increaseDemand(long l2) {
            try (Monitor.CloseableLock closeableLock = this.monitor.acquireCloseableLock();){
                if (this.demand != Long.MAX_VALUE && this.demand != Long.MIN_VALUE) {
                    long l3 = this.demand + l2;
                    this.demand = l3 < 0L ? Long.MAX_VALUE : l3;
                }
            }
        }

        private final void decrementDemand() {
            try (Monitor.CloseableLock closeableLock = this.monitor.acquireCloseableLock();){
                if (this.demand != Long.MAX_VALUE && this.demand != Long.MIN_VALUE) {
                    --this.demand;
                }
            }
        }

        private void arriveForNextPhase() {
            try (Monitor.CloseableLock closeableLock = this.monitor.acquireCloseableLock();){
                if (this.isCancelled) {
                    return;
                }
                PhasedPublisher.this.publishingPhaser.awaitAdvance(this.lastArrivedPhase);
                this.lastArrivedPhase = PhasedPublisher.this.publishingPhaser.arrive();
            }
        }
    }

    private final class PublishingPhaser
    extends Phaser {
        private PublishingPhaser() {
        }

        @Override
        protected final boolean onAdvance(int n2, int n3) {
            if (n3 == 0) {
                PhasedPublisher.this.endPublishing(null);
            } else {
                PhasedPublisher.this.executor.execute(() -> PhasedPublisher.this.advancePhaseAsync().whenComplete((object, throwable) -> PhasedPublisher.this.handlePhaseAdvancement(object, (Throwable)throwable)));
            }
            PhasedPublisher.this.executeNextPhaseDeregistrations(n2);
            return false;
        }
    }
}

