/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.metadata;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import org.firebirdsql.gds.ng.fields.RowDescriptor;
import org.firebirdsql.gds.ng.fields.RowDescriptorBuilder;
import org.firebirdsql.gds.ng.fields.RowValue;
import org.firebirdsql.gds.ng.fields.RowValueBuilder;
import org.firebirdsql.jdbc.FBResultSet;
import org.firebirdsql.jdbc.metadata.Clause;
import org.firebirdsql.jdbc.metadata.DbMetadataMediator;
import org.firebirdsql.util.FirebirdSupportInfo;

public abstract class GetFunctions {
    private static final RowDescriptor FUNCTIONS_ROW_DESCRIPTOR = new RowDescriptorBuilder(11, DbMetadataMediator.datatypeCoder).at(0).simple(449, 63, "FUNCTION_CAT", "FUNCTIONS").addField().at(1).simple(449, 63, "FUNCTION_SCHEM", "FUNCTIONS").addField().at(2).simple(448, 63, "FUNCTION_NAME", "FUNCTIONS").addField().at(3).simple(449, Integer.MAX_VALUE, "REMARKS", "FUNCTIONS").addField().at(4).simple(500, 0, "FUNCTION_TYPE", "FUNCTIONS").addField().at(5).simple(448, 63, "SPECIFIC_NAME", "FUNCTIONS").addField().at(6).simple(449, Integer.MAX_VALUE, "JB_FUNCTION_SOURCE", "FUNCTIONS").addField().at(7).simple(448, 4, "JB_FUNCTION_KIND", "FUNCTIONS").addField().at(8).simple(449, 255, "JB_MODULE_NAME", "FUNCTIONS").addField().at(9).simple(449, 255, "JB_ENTRYPOINT", "FUNCTIONS").addField().at(10).simple(449, 255, "JB_ENGINE_NAME", "FUNCTIONS").addField().toRowDescriptor();
    private final DbMetadataMediator mediator;

    private GetFunctions(DbMetadataMediator mediator) {
        this.mediator = mediator;
    }

    public final ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        if ("".equals(functionNamePattern)) {
            return new FBResultSet(FUNCTIONS_ROW_DESCRIPTOR, Collections.emptyList());
        }
        DbMetadataMediator.MetadataQuery metadataQuery = this.createGetFunctionsQuery(functionNamePattern);
        try (ResultSet rs = this.mediator.performMetaDataQuery(metadataQuery);){
            if (!rs.next()) {
                FBResultSet fBResultSet = new FBResultSet(FUNCTIONS_ROW_DESCRIPTOR, Collections.emptyList());
                return fBResultSet;
            }
            ArrayList<RowValue> rows = new ArrayList<RowValue>();
            RowValueBuilder valueBuilder = new RowValueBuilder(FUNCTIONS_ROW_DESCRIPTOR);
            byte[] functionNoTableBytes = this.mediator.createShort(1);
            do {
                byte[] functionNameBytes = this.mediator.createString(rs.getString("FUNCTION_NAME"));
                valueBuilder.at(0).set(null).at(1).set(null).at(2).set(functionNameBytes).at(3).set(this.mediator.createString(rs.getString("REMARKS"))).at(4).set(functionNoTableBytes).at(5).set(functionNameBytes).at(6).set(this.mediator.createString(rs.getString("JB_FUNCTION_SOURCE"))).at(7).set(this.mediator.createString(rs.getString("JB_FUNCTION_KIND"))).at(8).set(this.mediator.createString(rs.getString("JB_MODULE_NAME"))).at(9).set(this.mediator.createString(rs.getString("JB_ENTRYPOINT"))).at(10).set(this.mediator.createString(rs.getString("JB_ENGINE_NAME")));
                rows.add(valueBuilder.toRowValue(false));
            } while (rs.next());
            FBResultSet fBResultSet = new FBResultSet(FUNCTIONS_ROW_DESCRIPTOR, rows);
            return fBResultSet;
        }
    }

    abstract DbMetadataMediator.MetadataQuery createGetFunctionsQuery(String var1);

    public static GetFunctions create(DbMetadataMediator mediator) {
        FirebirdSupportInfo firebirdSupportInfo = mediator.getFirebirdSupportInfo();
        if (firebirdSupportInfo.isVersionEqualOrAbove(3, 0)) {
            return new GetFunctionsFirebird3(mediator);
        }
        return new GetFunctionsFirebird2_5(mediator);
    }

    private static class GetFunctionsFirebird3
    extends GetFunctions {
        private static final String GET_FUNCTIONS_FRAGMENT_3_0 = "select\n  trim(trailing from RDB$FUNCTION_NAME) as FUNCTION_NAME,\n  RDB$DESCRIPTION as REMARKS,\n  RDB$FUNCTION_SOURCE as JB_FUNCTION_SOURCE,\n  case\n    when RDB$LEGACY_FLAG = 1 then 'UDF'\n    when RDB$ENGINE_NAME is not null then 'UDR'\n    else 'PSQL'\n  end as JB_FUNCTION_KIND,\n  trim(trailing from RDB$MODULE_NAME) as JB_MODULE_NAME,\n  trim(trailing from RDB$ENTRYPOINT) as JB_ENTRYPOINT,\n  trim(trailing from RDB$ENGINE_NAME) as JB_ENGINE_NAME\nfrom RDB$FUNCTIONS\nwhere RDB$PACKAGE_NAME is null\n";
        private static final String GET_FUNCTIONS_ORDER_BY_3_0 = "order by RDB$PACKAGE_NAME, RDB$FUNCTION_NAME";

        private GetFunctionsFirebird3(DbMetadataMediator mediator) {
            super(mediator);
        }

        @Override
        DbMetadataMediator.MetadataQuery createGetFunctionsQuery(String functionNamePattern) {
            Clause functionNameClause = new Clause("RDB$FUNCTION_NAME", functionNamePattern);
            String queryText = GET_FUNCTIONS_FRAGMENT_3_0 + functionNameClause.getCondition("and ", "\n") + GET_FUNCTIONS_ORDER_BY_3_0;
            return new DbMetadataMediator.MetadataQuery(queryText, Clause.parameters(functionNameClause));
        }
    }

    private static class GetFunctionsFirebird2_5
    extends GetFunctions {
        private static final String GET_FUNCTIONS_FRAGMENT_2_5 = "select\n  trim(trailing from RDB$FUNCTION_NAME) as FUNCTION_NAME,\n  RDB$DESCRIPTION as REMARKS,\n  cast(null as blob sub_type text) as JB_FUNCTION_SOURCE,\n  'UDF' as JB_FUNCTION_KIND,\n  trim(trailing from RDB$MODULE_NAME) as JB_MODULE_NAME,\n  trim(trailing from RDB$ENTRYPOINT) as JB_ENTRYPOINT,\n  cast(null as varchar(255)) as JB_ENGINE_NAME\nfrom RDB$FUNCTIONS\n";
        private static final String GET_FUNCTIONS_ORDER_BY_2_5 = "order by RDB$FUNCTION_NAME";

        private GetFunctionsFirebird2_5(DbMetadataMediator mediator) {
            super(mediator);
        }

        @Override
        DbMetadataMediator.MetadataQuery createGetFunctionsQuery(String functionNamePattern) {
            Clause functionNameClause = new Clause("RDB$FUNCTION_NAME", functionNamePattern);
            String queryText = GET_FUNCTIONS_FRAGMENT_2_5 + functionNameClause.getCondition("where ", "\n") + GET_FUNCTIONS_ORDER_BY_2_5;
            return new DbMetadataMediator.MetadataQuery(queryText, Clause.parameters(functionNameClause));
        }
    }
}

