/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.opengion.fukurou.system.Closer;
import org.opengion.fukurou.util.ArraySet;
import org.opengion.fukurou.util.ErrorMessage;
import org.opengion.fukurou.util.FileUtil;
import org.opengion.fukurou.util.HttpConnect;
import org.opengion.fukurou.util.JSONScan;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.ToString;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.DBColumn;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.db.DBTableModelUtil;
import org.opengion.hayabusa.taglib.CommonTagSupport;
import org.opengion.hayabusa.taglib.TaglibUtil;

public class IorQueryTag
extends CommonTagSupport {
    private static final String VERSION = "8.0.2.0 (2021/11/30)";
    private static final long serialVersionUID = 802020211130L;
    public static final String CMD_NEW = "NEW";
    public static final String CMD_RENEW = "RENEW";
    private static final Set<String> COMMAND_SET = new ArraySet((Object[])new String[]{"NEW", "RENEW"});
    protected static final String ERR_MSG_ID = "h_errMsg";
    private static final String IOR_HTTP_STTS = "status";
    private static final String IOR_HTTP_MSG = "message";
    protected static final String IOR_DISP_LBL = "display_label";
    protected static final String IOR_DISP_KEY = "display";
    private static final String IOR_SQL_CNT = "count";
    private static final String AUTH_JSON_FMT = "{\"userInfo\":{\"companyId\":\"%s\",\"userId\":\"%s\",\"password\":\"%s\"}}";
    protected final Map<String, String> mapParam = new LinkedHashMap<String, String>();
    protected transient DBTableModel table;
    private String urlStr;
    private String proxyHost = HybsSystem.sys("HTTP_PROXY_HOST");
    private int proxyPort = HybsSystem.sysInt("HTTP_PROXY_PORT");
    private int timeout = HybsSystem.sysInt("URL_CONNECT_TIMEOUT");
    private String authURL;
    private String authUserPass;
    private String companyId = HybsSystem.sys("IOR_COMPANYID");
    private String appliName;
    private String callMethod;
    private boolean display;
    private String saveFile;
    protected String loadFile;
    private String command = "NEW";
    private String displayMsg = HybsSystem.sys("VIEW_DISPLAY_MSG");
    private String notfoundMsg = "MSG0077";
    private boolean stopZero;
    protected String tableId = "h_tblmdl";
    protected boolean stopError = true;
    private boolean dispError = true;
    protected boolean quotCheck = HybsSystem.sysBool("USE_SQL_INJECTION_CHECK");
    private boolean xssCheck = HybsSystem.sysBool("USE_XSS_CHECK");
    private boolean useBeforeHtmlTag = true;
    protected boolean useTimeView = HybsSystem.sysBool("VIEW_USE_TIMEBAR");
    private String user;
    private String pass;
    protected String postData;
    protected String rtnData;
    protected int executeCount;
    protected long dyStart;
    private boolean isMainTrans = true;
    private String fileURL = HybsSystem.sys("FILE_URL");

    @Override
    public int doStartTag() {
        if (!this.useTag()) {
            return 0;
        }
        this.useXssCheck(this.xssCheck);
        this.dyStart = System.currentTimeMillis();
        if (!this.check(this.command, COMMAND_SET)) {
            this.table = (DBTableModel)this.getObject(this.tableId);
            this.executeCount = this.table == null ? 0 : this.table.getRowCount();
            return 0;
        }
        this.useMainTrans(this.isMainTrans);
        this.startQueryTransaction(this.tableId);
        if ("session".equals(this.getScope())) {
            this.removeSessionAttribute(this.tableId);
            this.removeSessionAttribute("h_vform");
        }
        this.checkUsrPw();
        if (this.loadFile == null) {
            this.setComJson();
        }
        return 2;
    }

    @Override
    public int doAfterBody() {
        this.useQuotCheck(this.quotCheck);
        this.postData = this.getBodyString();
        return 0;
    }

    @Override
    public int doEndTag() {
        int n;
        this.debugPrint();
        if (!this.useTag()) {
            return 6;
        }
        int n2 = 0;
        if (this.check(this.command, COMMAND_SET)) {
            this.rtnData = this.outJson();
            SplitReqJson splitReqJson = new SplitReqJson(this.rtnData);
            String string = splitReqJson.getSttsJson();
            n2 = this.getStatus(string);
            if (n2 == 0) {
                String string2 = splitReqJson.getCntJson();
                this.executeCount = this.getCount(string2);
                if (this.executeCount > 0) {
                    this.table = this.makeDBTable(splitReqJson);
                    n2 = this.makeMessage();
                }
            }
        }
        if (n2 >= 2) {
            n = this.stopError ? 5 : 6;
        } else {
            int n3 = n = this.executeCount == 0 && this.stopZero ? 5 : 6;
        }
        if (this.useTimeView && this.useBeforeHtmlTag) {
            long l = System.currentTimeMillis() - this.dyStart;
            this.jspPrint("<div id=\"queryTime\" value=\"" + l + "\"></div>");
        }
        return n;
    }

    @Override
    protected void release2() {
        super.release2();
        this.mapParam.clear();
        this.table = null;
        this.urlStr = null;
        this.proxyHost = HybsSystem.sys("HTTP_PROXY_HOST");
        this.proxyPort = HybsSystem.sysInt("HTTP_PROXY_PORT");
        this.timeout = HybsSystem.sysInt("URL_CONNECT_TIMEOUT");
        this.authURL = null;
        this.authUserPass = null;
        this.companyId = HybsSystem.sys("IOR_COMPANYID");
        this.appliName = null;
        this.callMethod = null;
        this.display = false;
        this.saveFile = null;
        this.loadFile = null;
        this.command = CMD_NEW;
        this.displayMsg = HybsSystem.sys("VIEW_DISPLAY_MSG");
        this.notfoundMsg = "MSG0077";
        this.stopZero = false;
        this.tableId = "h_tblmdl";
        this.stopError = true;
        this.dispError = true;
        this.quotCheck = HybsSystem.sysBool("USE_SQL_INJECTION_CHECK");
        this.xssCheck = HybsSystem.sysBool("USE_XSS_CHECK");
        this.useBeforeHtmlTag = true;
        this.useTimeView = HybsSystem.sysBool("VIEW_USE_TIMEBAR");
        this.user = null;
        this.pass = null;
        this.postData = null;
        this.rtnData = null;
        this.executeCount = 0;
        this.dyStart = 0L;
        this.isMainTrans = true;
        this.fileURL = HybsSystem.sys("FILE_URL");
    }

    protected void addParam(String string, String string2) {
        if (this.mapParam.containsKey(string)) {
            String string3 = string + "\u306e\uff77\uff70\u304c\u91cd\u8907\u3057\u3066\u3044\u307e\u3059\u3002";
            throw new HybsSystemException(string3);
        }
        this.mapParam.put(string, string2);
    }

    protected void checkUsrPw() {
        if (!this.authUserPass.contains(":")) {
            throw new HybsSystemException("\uff95\uff70\uff7b\uff9e\uff70:\uff8a\uff9f\uff7d\uff9c\uff70\uff84\uff9e \u306e\u5f62\u5f0f\u3067\u8a18\u8ff0\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        }
        String[] stringArray = StringUtil.csv2Array((String)this.authUserPass, (char)':', (int)2);
        this.user = stringArray[0];
        this.pass = stringArray[1];
    }

    protected void setComJson() {
        if (this.companyId != null) {
            this.mapParam.put("company_id", this.companyId);
        }
        if (!this.user.isEmpty()) {
            this.mapParam.put("user_id", this.user);
        }
        this.mapParam.put("session_id", "$session_id$");
        if (this.appliName != null) {
            this.mapParam.put("report_name", this.appliName);
        }
        if (this.callMethod != null) {
            this.mapParam.put("method", this.callMethod);
        }
    }

    protected String outJson() {
        String string;
        if (this.loadFile == null) {
            if (this.postData == null || this.postData.isEmpty()) {
                this.postData = JSONScan.map2Json(this.mapParam);
            }
            string = this.retResponse();
        } else {
            StringBuilder stringBuilder = new StringBuilder(200);
            try {
                for (String string2 : Files.readAllLines(Paths.get(this.loadFile, new String[0]), StandardCharsets.UTF_8)) {
                    stringBuilder.append(string2).append(CR);
                }
                string = stringBuilder.toString();
            }
            catch (IOException iOException) {
                String string3 = "loadFile \u51e6\u7406\u4e2d\u3067\uff74\uff97\uff70\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + CR + "\t " + iOException.getMessage() + CR;
                throw new HybsSystemException(string3, iOException);
            }
        }
        return string;
    }

    protected String retResponse() {
        HttpConnect httpConnect = null;
        PrintWriter printWriter = null;
        String string = null;
        try {
            httpConnect = this.connect();
            string = httpConnect.readData();
            if (httpConnect.getCode() != 200) {
                throw new Throwable();
            }
            if (this.display) {
                printWriter = FileUtil.getNonFlushPrintWriter((Writer)this.pageContext.getOut());
            } else if (this.saveFile != null) {
                printWriter = FileUtil.getPrintWriter((File)new File(this.saveFile), (String)"UTF-8");
            }
            string = StringUtil.convertToOiginal((String)string);
            if (printWriter != null) {
                ((Writer)printWriter).write(string);
            }
        }
        catch (Throwable throwable) {
            try {
                String string2 = "\uff83\uff9e\uff70\uff80\u51e6\u7406\u4e2d\u306b\uff74\uff97\uff70\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + CR + " url=[" + this.urlStr + "]" + CR + " message=[" + (httpConnect == null ? "NO_CONNECTION" : httpConnect.getMessage()) + "]" + CR + " Exception=[" + throwable.getMessage() + "]";
                throw new HybsSystemException(string2, throwable);
            }
            catch (Throwable throwable2) {
                Closer.ioClose(printWriter);
                throw throwable2;
            }
        }
        Closer.ioClose((Closeable)printWriter);
        return string;
    }

    protected HttpConnect connect() throws IOException {
        HttpConnect httpConnect = new HttpConnect(this.urlStr, this.authUserPass);
        httpConnect.setDebug(this.isDebug());
        httpConnect.usePost(true);
        if (this.proxyHost != null) {
            httpConnect.setProxy(this.proxyHost, this.proxyPort);
        }
        if (this.authUserPass != null && this.authURL != null) {
            String string = String.format(AUTH_JSON_FMT, this.companyId, this.user, this.pass);
            httpConnect.setAuthJson(string, this.authURL);
        }
        if (this.timeout >= 0) {
            httpConnect.setTimeout(this.timeout);
        }
        if (this.postData != null) {
            httpConnect.setReqJson(this.postData);
        }
        return httpConnect;
    }

    protected int getStatus(String string) {
        String string2;
        int n = 0;
        StringBuilder stringBuilder = new StringBuilder(200);
        Map map = JSONScan.json2Map((String)string);
        String string3 = (String)map.get(IOR_HTTP_STTS);
        if (string3.equals(String.valueOf(200))) {
            n = 0;
        } else {
            n = 2;
            string2 = (String)map.get(IOR_HTTP_MSG);
            ErrorMessage errorMessage = new ErrorMessage("iorQueryTag Error!");
            errorMessage.addMessage(0, n, string3, new String[]{string2});
            String string4 = TaglibUtil.makeHTMLErrorTable(errorMessage, this.getResource());
            if (string4 != null && string4.length() > 0) {
                stringBuilder.append(string4);
                this.setSessionAttribute(ERR_MSG_ID, errorMessage);
            } else if (CMD_NEW.equals(this.command)) {
                this.removeSessionAttribute(ERR_MSG_ID);
            }
        }
        string2 = stringBuilder.toString();
        if (this.dispError) {
            this.jspPrint(string2);
        }
        this.setRequestAttribute("DB.ERR_CODE", String.valueOf(n));
        this.setRequestAttribute("DB.ERR_MSG", string2);
        return n;
    }

    protected int getCount(String string) {
        StringBuilder stringBuilder = new StringBuilder(200);
        Map map = JSONScan.json2Map((String)string);
        int n = StringUtil.nval((String)((String)map.get(IOR_SQL_CNT)), (int)-1);
        if (CMD_NEW.equals(this.command)) {
            if (n > 0 && this.displayMsg != null && this.displayMsg.length() > 0) {
                stringBuilder.append(n).append(this.getResource().getLabel(this.displayMsg, new String[0])).append(BR);
            } else if (n == 0 && this.notfoundMsg != null && this.notfoundMsg.length() > 0) {
                stringBuilder.append(this.getResource().getLabel(this.notfoundMsg, new String[0])).append(BR);
            }
        }
        String string2 = stringBuilder.toString();
        if (this.dispError) {
            this.jspPrint(string2);
        }
        this.setRequestAttribute("DB.COUNT", String.valueOf(n));
        return n;
    }

    private DBTableModel makeDBTable(SplitReqJson splitReqJson) {
        String[] stringArray;
        String string;
        Map map;
        String string2;
        DBTableModel dBTableModel = DBTableModelUtil.newDBTable();
        String string3 = splitReqJson.getClmJson();
        JSONScan jSONScan = new JSONScan(string3, '{', '}');
        int n = jSONScan.countBlock();
        dBTableModel.init(n);
        int n2 = 0;
        while (jSONScan.hasNext()) {
            string2 = jSONScan.next();
            map = JSONScan.json2Map((String)string2);
            string = (String)map.get(IOR_DISP_LBL);
            stringArray = (String[])map.get(IOR_DISP_KEY);
            DBColumn dBColumn = this.getResource().makeDBColumn((String)stringArray, string);
            dBTableModel.setDBColumn(n2++, dBColumn);
        }
        string2 = splitReqJson.getRowJson();
        map = new JSONScan(string2, '[', ']');
        while (map.hasNext()) {
            string = map.next();
            stringArray = JSONScan.json2Array((String)string);
            dBTableModel.addColumnValues(stringArray);
        }
        return dBTableModel;
    }

    protected int makeMessage() {
        String string;
        int n = 0;
        ErrorMessage errorMessage = new ErrorMessage("iorQueryTag Error!");
        StringBuilder stringBuilder = new StringBuilder(200);
        if (this.table != null && !this.commitTableObject(this.tableId, this.table)) {
            n = 2;
            errorMessage.addMessage(0, n, "ERR0041", new String[0]);
        }
        if ((string = TaglibUtil.makeHTMLErrorTable(errorMessage, this.getResource())) != null && string.length() > 0) {
            stringBuilder.append(string);
            this.setSessionAttribute(ERR_MSG_ID, errorMessage);
        } else if (CMD_NEW.equals(this.command)) {
            this.removeSessionAttribute(ERR_MSG_ID);
        }
        String string2 = stringBuilder.toString();
        if (this.dispError) {
            this.jspPrint(string2);
        }
        this.setRequestAttribute("DB.ERR_CODE", String.valueOf(n));
        this.setRequestAttribute("DB.ERR_MSG", string2);
        return n;
    }

    public void setUrl(String string) {
        this.urlStr = StringUtil.nval((String)this.getRequestParameter(string), (String)this.urlStr);
    }

    public void setProxyHost(String string) {
        this.proxyHost = StringUtil.nval((String)this.getRequestParameter(string), (String)this.proxyHost);
    }

    public void setProxyPort(String string) {
        this.proxyPort = StringUtil.nval((String)this.getRequestParameter(string), (int)this.proxyPort);
    }

    public void setTimeout(String string) {
        this.timeout = StringUtil.nval((String)this.getRequestParameter(string), (int)this.timeout);
    }

    public void setAuthURL(String string) {
        this.authURL = StringUtil.nval((String)this.getRequestParameter(string), (String)this.authURL);
    }

    public void setAuthUserPass(String string) {
        this.authUserPass = StringUtil.nval((String)this.getRequestParameter(string), (String)this.authUserPass);
    }

    public void setCompanyId(String string) {
        this.companyId = StringUtil.nval((String)this.getRequestParameter(string), (String)this.companyId);
    }

    public void setAppliName(String string) {
        this.appliName = StringUtil.nval((String)this.getRequestParameter(string), (String)this.appliName);
    }

    public void setCallMethod(String string) {
        this.callMethod = StringUtil.nval((String)this.getRequestParameter(string), (String)this.callMethod);
    }

    public void setDisplay(String string) {
        this.display = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.display);
        if (this.display && this.saveFile != null) {
            throw new HybsSystemException("display=\"true\" \u3068\u3001saveFile \u3092\u4f75\u7528\u3059\u308b\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093\u3002");
        }
    }

    public void setSaveFile(String string) {
        this.saveFile = StringUtil.nval((String)this.getRequestParameter(string), (String)this.saveFile);
        if (this.saveFile != null) {
            this.saveFile = HybsSystem.url2dir(StringUtil.urlAppend((CharSequence)this.fileURL, (CharSequence[])new CharSequence[]{this.saveFile}));
            if (this.display) {
                throw new HybsSystemException("display=\"true\" \u3068\u3001saveFile \u3092\u4f75\u7528\u3059\u308b\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093\u3002");
            }
        }
    }

    public void setLoadFile(String string) {
        this.loadFile = StringUtil.nval((String)this.getRequestParameter(string), (String)this.loadFile);
        if (this.loadFile != null) {
            this.loadFile = HybsSystem.url2dir(StringUtil.urlAppend((CharSequence)this.fileURL, (CharSequence[])new CharSequence[]{this.loadFile}));
        }
    }

    public void setCommand(String string) {
        String string2 = this.getRequestParameter(string);
        if (string2 != null && string2.length() >= 0) {
            this.command = string2.toUpperCase(Locale.JAPAN);
        }
    }

    public void setDisplayMsg(String string) {
        String string2 = this.getRequestParameter(string);
        if (string2 != null) {
            this.displayMsg = string2;
        }
    }

    public void setNotfoundMsg(String string) {
        String string2 = this.getRequestParameter(string);
        if (string2 != null) {
            this.notfoundMsg = string2;
        }
    }

    public void setStopZero(String string) {
        this.stopZero = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.stopZero);
    }

    public void setTableId(String string) {
        this.tableId = StringUtil.nval((String)this.getRequestParameter(string), (String)this.tableId);
    }

    public void setStopError(String string) {
        this.stopError = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.stopError);
    }

    public void setDispError(String string) {
        this.dispError = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.dispError);
    }

    public void setQuotCheck(String string) {
        this.quotCheck = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.quotCheck);
    }

    public void setXssCheck(String string) {
        this.xssCheck = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.xssCheck);
    }

    public void setMainTrans(String string) {
        this.isMainTrans = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.isMainTrans);
    }

    public void setUseBeforeHtmlTag(String string) {
        this.useBeforeHtmlTag = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useBeforeHtmlTag);
    }

    public void setUseTimeView(String string) {
        this.useTimeView = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useTimeView);
    }

    @Override
    public String toString() {
        return ToString.title((String)((Object)((Object)this)).getClass().getName()).println("VERSION", (Object)VERSION).println("urlStr", (Object)this.urlStr).println("timeout", (Object)this.timeout).println("authURL", (Object)this.authURL).println("authUserPass", (Object)this.authUserPass).println("companyId", (Object)this.companyId).println("appliName", (Object)this.appliName).println("callMethod", (Object)this.callMethod).println(IOR_DISP_KEY, (Object)this.display).println("postData", (Object)this.postData).println("saveFile", (Object)this.saveFile).println("loadFile", (Object)this.loadFile).println("tableId", (Object)this.tableId).println("Other...", (Object)this.getAttributes().getAttribute()).fixForm().toString();
    }

    private static final class SplitReqJson {
        private final String strJson;
        private int endPos;

        public SplitReqJson(String string) {
            this.strJson = string;
            this.endPos = this.strJson.indexOf("\"data\"");
        }

        public String getSttsJson() {
            if (this.endPos >= 0) {
                return this.strJson.substring(0, this.endPos);
            }
            throw new HybsSystemException("data \uff77\uff70\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
        }

        public String getClmJson() {
            int n = this.strJson.indexOf("\"headers\"", this.endPos);
            this.endPos = this.strJson.indexOf("\"rows\"", n);
            if (n >= 0 && this.endPos >= 0) {
                return this.strJson.substring(n, this.endPos);
            }
            throw new HybsSystemException("headers\u3001rows \uff77\uff70\u306e\u3044\u305a\u308c\u304b\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
        }

        public String getRowJson() {
            int n = this.strJson.indexOf("\"cols\"", this.endPos);
            if (n >= 0) {
                return this.strJson.substring(n);
            }
            throw new HybsSystemException("cols \uff77\uff70\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
        }

        public String getCntJson() {
            int n = this.strJson.lastIndexOf("\"count\"");
            if (n >= 0) {
                return this.strJson.substring(n);
            }
            throw new HybsSystemException("count \uff77\uff70\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
        }
    }
}

