<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="init" >
	<link rel="stylesheet" href="{@SYS.JSP}/menu/matrixMenu.css?v={@SYS.START_TIME}" />
	<style>
		<og:equals val1="{@group}" notNull="true">
			table.MTRIX_GRP td.{@group} { background-color:linen; }
		</og:equals>

		<og:equals val1="{@group}" isNull="true" >
			table.MTRIX_GRP td.GUI_ALL { background-color:linen; }
		</og:equals>
	</style>
</og:head>

<body oncontextmenu="return true;">

<jsp:directive.include file="/jsp/custom/matrix_info.jsp" />

<!-- セッションがない場合は、jspInit(セッションタイムアウト対策) -->
<og:equals val1="{@menuType}" isNull="true">
	<og:jspInit />
</og:equals>

<!-- 6.3.8.3 (2015/10/03) autoRun.jsp の実行。TYPE=1 は、マトリクスメニュー用 -->
<og:input type="button" lbl="autoRun" caseIf="{@SYS.USE_AUTO_RUN}"
	onClick="window.open('autoRun.jsp?TYPE=1&amp;DATE={@DATE.YMDHMS}','sub','width=800,height=480,scrollbars=yes');return false;" />

<!-- メニューのタイプ分け -->
<og:value command="SET" key="menuType" scope="session" value="matrix" />
<og:value command="SET" key="menuTop"  scope="session" value="{@SYS.JSP}/menu/matrixMenu.jsp" />

<!-- 検索ボックス -->
<og:input type="text" id="searchmenu" name="searchmenu" td="false"  size="17" />
<script src="searchWord_matrix.js?v={@SYS.START_TIME}"><!-- --></script>

<!-- グループ部分 -->
<table class="MTRIX_GRP" >
	<og:topMenu
		menuType	= "GROUP"
		href		= "matrixMenu.jsp"
		target		= "_top"
		imageOnly	= "false"
		sideCount	= "8"
		cache		= "{@cache}"
		match		= "{@match}"
		unmatch		= "{@unmatch}"
	/>
</table>

<!-- MATRIX2（大分類無しボタンメニュー） -->
<table class="MTRIX_BTN" >
	<og:topMenu
		menuType	= "MATRIX2"
		href		= "matrixMenu.jsp"
		target		= "_top"
		imageOnly	= "false"
		cache		= "{@cache}"
		match		= "{@match}"
		unmatch		= "{@unmatch}"
		sideCount	= "{@NVL.DEF_MENU_COLUMN 6}"
		minCellCount= "4"
		maxCellCount= "20"
		groups		= "{@group}"
	>
		<og:help useFaq="true" />
	</og:topMenu>
</table>

<jsp:directive.include file="/jsp/custom/menu_end.jsp" />

</body>
</jsp:root>
