package jp.gr.java_conf.miya.pglauncher.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Event;

public abstract class AbstractAction extends Action{
	
	//======================================================================
	// RXgN^
	//======================================================================
	//------------------------------------------------------------ public
	public AbstractAction(String text,
							ImageDescriptor image,
							ActionEventProvider provider){
		super(text,image);
		provider.addListener(new ActionEventListener());
	}
	
	//======================================================================
	// CX^X\bh
	//======================================================================
	//------------------------------------------------------------ public
	public abstract void rightClick(Event event);
	public abstract void doubleClick(Event event);
	public abstract void keyDown(Event event);
	
	//======================================================================
	// NX
	//======================================================================
	class ActionEventListener implements IActionEventListener{
		
		public void handleRightClick(Event event){
			rightClick(event);
		}
		public void handleDoubleClick(Event event){
			doubleClick(event);
		}
		public void handleKeyDown(Event event){
			keyDown(event);
		}
	}
}
