package jp.gr.java_conf.miya.pglauncher.actions;

import jp.gr.java_conf.miya.pglauncher.common.Const;
import jp.gr.java_conf.miya.pglauncher.dialogs.ConfigDialog;
import jp.gr.java_conf.miya.pglauncher.dialogs.GroupDialog;
import jp.gr.java_conf.miya.pglauncher.dialogs.ProgramDialog;
import jp.gr.java_conf.miya.pglauncher.utils.TreeUtils;

import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Event;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class UpdateAction extends AbstractAction {

	//======================================================================
	// CX^Xϐ
	//======================================================================
	//------------------------------------------------------------ private
	private ConfigDialog dialog_;
	private TreeViewer viewer_;

	//======================================================================
	// RXgN^
	//======================================================================
	//------------------------------------------------------------ public
	public UpdateAction(ConfigDialog dialog,
						TreeViewer viewer,
						ActionEventProvider provider){
		super("C(&U)",null,provider);
		dialog_ = dialog;
		viewer_ = viewer;
	}

	//======================================================================
	// CX^X\bh
	//======================================================================
	//------------------------------------------------------------ public
	public void run(){
		Element el = TreeUtils.getSelectedElement(viewer_);
		String type = el.getNodeName();
		if(type.equals(Const.NODE_GROUP)){
			el = updateGroup(el);
		}else if(type.equals(Const.NODE_PROGRAM)){
			el = updateProgram(el,ProgramDialog.FOCUS_PROGRAM);
		}else if(type.equals(Const.NODE_FOLDER)){
			el = updateProgram(el,ProgramDialog.FOCUS_FOLDER);
		}
		viewer_.refresh();
		viewer_.setSelection(new StructuredSelection(el),true);
	}
	
	public Element updateGroup(Element el){
		NamedNodeMap map = el.getAttributes();
		Node attr = map.getNamedItem(Const.ATTR_NAME);
		String name = attr.getNodeValue();
		GroupDialog dialog = new GroupDialog(viewer_.getControl().getShell(),name);
		dialog.open();
		if(dialog.getReturnCode() == GroupDialog.OK){
			attr.setNodeValue(dialog.getGroupName());
			dialog_.modified();
		}
		return el;
	}
	
	public Element updateProgram(Element el, int focus){
		NamedNodeMap map = el.getAttributes();
		Node attrName = map.getNamedItem(Const.ATTR_NAME);
		String name = attrName.getNodeValue();
		Node attrPath = map.getNamedItem(Const.ATTR_PATH);
		String path = attrPath.getNodeValue();
		Node attrArg = map.getNamedItem(Const.ATTR_ARG);
		String arg = null;
		if(attrArg != null) arg = attrArg.getNodeValue();
		
		ProgramDialog dialog = new ProgramDialog(viewer_.getControl().getShell(),name,path,arg,focus);
		dialog.open();
		if(dialog.getReturnCode() == ProgramDialog.OK){
			Element el2 = null;
			if(dialog.isFolder()){
				el2 = ((Document)viewer_.getInput()).createElement(Const.NODE_FOLDER);
				el2.setAttribute(Const.ATTR_NAME,dialog.getProgramName());
				el2.setAttribute(Const.ATTR_PATH,dialog.getPath());
			}else if(dialog.isProgram()){
				el2 = ((Document)viewer_.getInput()).createElement(Const.NODE_PROGRAM);
				el2.setAttribute(Const.ATTR_NAME,dialog.getProgramName());
				el2.setAttribute(Const.ATTR_PATH,dialog.getPath());
				el2.setAttribute(Const.ATTR_ARG,dialog.getArg());
			}
			el.getParentNode().replaceChild(el2,el);
			el = el2;
			dialog_.modified();
		}
		return el;
	}
	
	public void doubleClick(Event event){
		run();
	}
	
	public void rightClick(Event event){
		Element el = TreeUtils.getSelectedElement(viewer_);
		String type = el.getNodeName();
		if(type.equals(Const.NODE_ROOT)) setEnabled(false);
		else setEnabled(true);
	}
	
	public void keyDown(Event event){
		switch(event.keyCode){
			case SWT.F2:
				run();
		}
	}
}
