package jp.gr.java_conf.miya.pglauncher.dialogs;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class GroupDialog extends TitleAreaDialog{
	
	//======================================================================
	// CX^Xϐ
	//======================================================================
	//------------------------------------------------------------ private
	private String groupName_;
	private Text text_;
	
	//======================================================================
	// RXgN^
	//======================================================================
	//------------------------------------------------------------ public
	public GroupDialog(Shell parent,String groupName){
		super(parent);
		this.groupName_ = groupName;
	}
	
	//======================================================================
	// CX^X\bh
	//======================================================================
	//------------------------------------------------------------ public
	protected void configureShell(Shell newShell){
		super.configureShell(newShell);
		newShell.setText("O[vo^");
	}
	
	public void create(){
		super.create();
		if(groupName_.equals("")){
			getButton(IDialogConstants.OK_ID).setEnabled(false);
		}
	}
	
	public String getGroupName(){
		return groupName_;
	}
	
	//------------------------------------------------------------ protected
	protected Point getInitialSize(){
		return new Point(400,180);
	}
	
	protected void okPressed(){
		groupName_ = text_.getText();
		super.okPressed();
	}
	
	protected Control createDialogArea(Composite parent){
		Composite composite = (Composite)super.createDialogArea(parent);
		
		Composite contents = new Composite(composite,SWT.NONE);
		contents.setLayout(new GridLayout(2,false));
		contents.setLayoutData(new GridData(GridData.FILL_BOTH));
		
		setMessage("O[v͂ĂB", IMessageProvider.INFORMATION);
		
		Label nameLabel = new Label(contents, SWT.NONE);
		nameLabel.setText("O[v(&G):");
		text_ = new Text(contents, SWT.BORDER);
		text_.setText(groupName_);
		text_.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		text_.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				String str = ((Text)e.getSource()).getText();
				if(str.length() == 0){
					setMessage("O[v͂łB", IMessageProvider.ERROR);
					getButton(IDialogConstants.OK_ID).setEnabled(false);
				} else {
					setMessage("O[v͂ĂB", IMessageProvider.INFORMATION);
					getButton(IDialogConstants.OK_ID).setEnabled(true);
				}
			}
		});
		return composite;
	}
}
