<?php
// PostWiki - Yet another WikiWikiWeb clone
// $Id: postwiki.ini.php.dist,v 1.7 2006/05/07 14:44:07 raymax Exp $
// Copyright (C)
//   2005-2006 PostWiki Developers Team
//   2002-2005 PukiWiki Developers Team
//   2001-2002 Originally written by yu-ji
// License: GPL v2 or (at your option) any later version
//

/////////////////////////////////////////////////
/////////////////////////////////////////////////
/////////////////////////////////////////////////
/////////////////////////////////////////////////
// PostWiki 設定ファイル
//    まずは(※)のついている以下の4項目を設定する必要があります。
//
// ホームページのタイトル(修正してください)(※)
// * RSS に出力するチャンネル名を兼ねます。
$page_title = 'PostWiki';

// 管理者の名前(修正してください)(※)
$modifier = 'anonymous';

// 管理者のホームページ(修正してください)(※)
$modifierlink = 'http://postwiki.example.com/';

// 管理者のパスワード(必ず変更してください)(※)
$adminpass = '{x-php-md5}1a1dc91c907325c69271ddf0c944bc72'; // md5('pass')
//$adminpass = '{CRYPT}$1$AR.Gk94x$uCe8fUUGMfxAPH83psCZG/'; // CRYPT 'pass'
//$adminpass = '{MD5}Gh3JHJBzJcaScd3wyUS8cg==';             // MD5   'pass'
//$adminpass = '{SMD5}o7lTdtHFJDqxFOVX09C8QnlmYmZnd2Qx';    // SMD5  'pass'

// 上記の文字列は、'pass'をMD5などにより暗号化したものです。
// MD5ハッシュは、Linuxやcygwinであれば、以下の様にして計算させる事ができます。
// ('-n' オプションを忘れずに!)
//     $ echo -n 'pass' | md5sum
// 得られた文字列を
// $adminpass = '{x-php-md5}生成された文字列';
// のように記入して指定します。
//
// お勧めできませんが、PostWikiのmd5コマンドでも算出が可能です。
//
// http://<設置した場所>/pukiwiki.php?md5=pass
//
// このURLにアクセスすることで、算出結果が表示されます。
// そのかわり、あなたがタイプしたパスワードはネットワークを流れ、
// 誰にでも覗き見ができ、Webサーバーのログにも残ってしまう、
// といった様々なリスクを負う可能性があります。あなたが使っている
// コンピュータ、サーバーまでのネットワーク、サーバーの
// どこかが信頼できないのであれば、この方法は使わないで下さい。
//
/////////////////////////////////////////////////
/////////////////////////////////////////////////
/////////////////////////////////////////////////
/////////////////////////////////////////////////


/////////////////////////////////////////////////
// 以下は任意の設定項目になります。

/////////////////////////////////////////////////
// 機能設定

// PKWK_OPTIMISE - 最適化(厳密なチェックや警告をおこなわない)
//   これは開発者のみ使用します.
//   安定バージョンならば '1', 開発バージョンならば '0' を設定.
if (! defined('PKWK_OPTIMISE'))
	define('PKWK_OPTIMISE', 0);

/////////////////////////////////////////////////
// セキュリティ設定

// PKWK_READONLY - 編集を禁止する
//   注意：カウンタ関係の機能は動作します(counter, attach, count, 他)
if (! defined('PKWK_READONLY'))
	define('PKWK_READONLY', 0); // (0:無効,1:有効)

// PKWK_SAFE_MODE - 利用されていない機能を禁止する
//   注意：設定が施されている箇所は潜在的な問題を抱えています。
if (! defined('PKWK_SAFE_MODE'))
	define('PKWK_SAFE_MODE', 0); // (0:無効,1:有効)

// PKWK_DISABLE_INLINE_IMAGE_FROM_URI - URIをインライン画像として表示させない
//   URIをインライン画像としてリンクすることは閲覧者の情報の漏洩("Webバグ"に
//   よって)と、外部の悪意があるCGIプログラム(URIが画像のものに似ている)の閲覧者
//   への攻撃を許すことになるかもしれません。しかし、画像を表示する簡単な方法
//   ではあります。
if (! defined('PKWK_DISABLE_INLINE_IMAGE_FROM_URI'))
	define('PKWK_DISABLE_INLINE_IMAGE_FROM_URI', 0);

// PKWK_QUERY_STRING_MAX
//   GET メソッドの最大長を決めます。これは、不必要なURL長の不正アクセスからシステムを守るためです。
//   注意: (ページ名の文字数 + 添付ファイル名の文字数) <= PKWK_QUERY_STRING_MAX となるようにしてください。
define('PKWK_QUERY_STRING_MAX', 640); // 単位は Bytes です。0でOFFになります。

/////////////////////////////////////////////////
// Experimental features

// Multiline plugin hack (See BugTrack2/84)
// EXAMPLE(with a known BUG):
//   #plugin(args1,args2,...,argsN){{
//   argsN+1
//   argsN+1
//   #memo(foo)
//   argsN+1
//   }}
//   #memo(This makes '#memo(foo)' to this)
define('PKWKEXP_DISABLE_MULTILINE_PLUGIN_HACK', 0); // 1 = Disabled

/////////////////////////////////////////////////
// 言語および文字コードの設定

// LANG - Wikiコンテンツ内の言語 ('en', 'ja', or ...)
define('LANG', 'ja');

// UI_LANG - ボタンやメニューなどの言語
define('UI_LANG', LANG); // 'en' は国際化されたWikiサイト向けです。

/////////////////////////////////////////////////
// ディレクトリの設定(1) (最後に '/' が必要, 権限は '777')

// You may hide these directories (from web browsers)
// by setting DATA_HOME at index.php.

define('DATA_DIR',      DATA_HOME . 'wiki/'     ); // Latest wiki texts
define('DIFF_DIR',      DATA_HOME . 'diff/'     ); // Latest diffs
define('BACKUP_DIR',    DATA_HOME . 'backup/'   ); // Backups
define('CACHE_DIR',     DATA_HOME . 'cache/'    ); // Some sort of caches
define('UPLOAD_DIR',    DATA_HOME . 'attach/'   ); // Attached files and logs
define('COUNTER_DIR',   DATA_HOME . 'counter/'  ); // Counter plugin's counts
define('TRACKBACK_DIR', DATA_HOME . 'trackback/'); // TrackBack logs
define('PLUGIN_DIR',    DATA_HOME . 'plugin/'   ); // Plugin directory

/////////////////////////////////////////////////
// ディレクトリの設定(2) (最後に '/' が必要)

// スキン/スタイルシートファイル格納ディレクトリ(URL)
//  このディレクトリ以下のスキンファイル(*.php) は
//  PukiWiki本体側(DATA_HOME/SKIN_DIR) に必要ですが、
//  CSSファイル(*.css) および JavaScriptファイル( *.js) は
//  Webブラウザから見える場所(./SKIN_DIR) に配置して下さい。
define('SKIN_DIR', 'skin/'); // table, css.php
//define('SKIN_DIR', 'skin/basis/'); // div, css.php(色はcss)
//define('SKIN_DIR', 'skin/irid/'); // div, css

// 画像ファイル格納ディレクトリ(URL)
define('IMAGE_DIR', 'image/');
//  このディレクトリ以下の全てのファイルは
//  Webブラウザから見える場所(./IMAGE_DIR) に配置して下さい。

/////////////////////////////////////////////////
// ロケール時間の設定
switch (LANG) { // どれか１つを選択
case 'ja':
	define('ZONE', 'JST');
	define('ZONETIME', 9 * 3600); // JST = GMT + 9
	break;
default  :
	define('ZONE', 'GMT');
	define('ZONETIME', 0);
	break;
}

//文字コード(エンコーディング)の設定
define('CONTENT_CHARSET', 'UTF-8');
define('SOURCE_ENCODING', 'UTF-8');

switch (LANG){
case 'en':
	define('MB_LANGUAGE', 'English');
	break;
case 'ja':
	define('MB_LANGUAGE', 'Japanese');
	break;
case 'ko':
	// UTF-8 (See BugTrack2/13 for all hack about Korean support, and give us your report!)
	define('MB_LANGUAGE', 'Korean');
	break;
default:
	define('MB_LANGUAGE', 'English');
	//die_message('No such language "' . LANG . '"');
}

/////////////////////////////////////////////////
// スクリプト名の設定(とくに設定しなくても問題なし)
//$script = 'http://example.com/postwiki/';

// $script からファイル名をカットする (URLを短くする)
// Webサーバー側の設定で、ディレクトリを指定したときに
// 表示するデフォルトのファイル名の候補に、ここで指定する
// ファイル名が含まれている必要があります。
//$script_directory_index = 'index.php';

// デフォルトのページ名
$defaultpage  = 'FrontPage';     // トップ / デフォルトページ
$whatsnew     = 'RecentChanges'; // 更新履歴
$whatsdeleted = 'RecentDeleted'; // 削除履歴
$interwiki    = 'InterWikiName'; // InterWikiName の一覧を書くページ
$menubar      = 'MenuBar';       // メニューとして表示させる内容を書くページ

/////////////////////////////////////////////////
// DOCTYPE設定

// Webブラウザのバグや、Java applet などが Strict でない DOCTYPE を要求することがあります。
// いくつかのプラグインは自動的に値を設定します (例:paint)

//$pkwk_dtd = PKWK_DTD_XHTML_1_1; // Default
//$pkwk_dtd = PKWK_DTD_XHTML_1_0_STRICT;
//$pkwk_dtd = PKWK_DTD_XHTML_1_0_TRANSITIONAL;
//$pkwk_dtd = PKWK_DTD_HTML_4_01_STRICT;
//$pkwk_dtd = PKWK_DTD_HTML_4_01_TRANSITIONAL;

/////////////////////////////////////////////////
// Always output "nofollow,noindex" attribute

$nofollow = 0; // 1 = Try hiding from search engines

/////////////////////////////////////////////////

// PKWK_ALLOW_JAVASCRIPT JavaScriptを使用する
define('PKWK_ALLOW_JAVASCRIPT', 0); // (0:無効,1:有効)

/////////////////////////////////////////////////
// トラックバックの設定

// トラックバック機能を使用する
$trackback = 0; // (0:無効,1:有効)

// 別ウィンドウでトラックバックを表示する (JavaScriptが必要)
$trackback_javascript = 0; // (0:無効,1:有効)

/////////////////////////////////////////////////
// リファラ(リンク逆探知)機能を使用する
$referer = 0; // (0:無効,1:有効)

/////////////////////////////////////////////////
// WikiNameを *無効に* する
$nowikiname = 0; // (1:WikiName無効,0:WikiName有効)

/////////////////////////////////////////////////
// オートリンクの設定

// オートエイリアス対象になるキーワードの最短文字数を設定
$autolink = 8; // (0:オートエイリアス無効)

/////////////////////////////////////////////////
// 凍結機能を有効にする
$function_freeze = 1; // (0:無効,1:有効)

/////////////////////////////////////////////////
// 「タイムスタンプを変更しない」機能の設定
$notimeupdate = 1; // (1:有効, 2:管理者パスワードで制限, 0:無効)

/////////////////////////////////////////////////
// Page-reading 機能設定
// 漢字が含まれたページ名を、自動で読みの順に並べ替えて
// 正しく一覧表示したい場合に設定してください。

// ChaSen, KAKASI による、ページ名の読みの取得
$pagereading_enable = 0; // (0:無効,1:有効)

// 読みを取得するソフトウェアの選択
// ChaSen('chasen') or KAKASI('kakasi') or なし('none')
$pagereading_kanji2kana_converter = 'none';

// ChaSen/KAKASI との受け渡しに使う漢字コード
$pagereading_kanji2kana_encoding = 'EUC'; // UNIX系の基本コード
//$pagereading_kanji2kana_encoding = 'SJIS'; // Windows系の基本コード

// Absolute path of the converter (ChaSen)
$pagereading_chasen_path = '/usr/local/bin/chasen';
//$pagereading_chasen_path = 'c:\progra~1\chasen21\chasen.exe';

// ChaSen の実行ファイル (各自の環境に合わせて設定)
$pagereading_kakasi_path = '/usr/local/bin/kakasi';
//$pagereading_kakasi_path = 'c:\kakasi\bin\kakasi.exe';

// ページ名読みを格納したページの名前
$pagereading_config_page = ':config/PageReading';

// 読み仮名辞書(converter ='none' の場合)
$pagereading_config_dict = ':config/PageReading/dict';

/////////////////////////////////////////////////
// 認証ユーザの定義
$auth_users = array(
	'foo'	=> 'foo_passwd', // Cleartext
	'bar'	=> '{x-php-md5}f53ae779077e987718cc285b14dfbe86', // md5('bar_passwd')
	'hoge'	=> '{SMD5}OzJo/boHwM4q5R+g7LCOx2xGMkFKRVEx', // SMD5 'hoge_passwd'
);

/////////////////////////////////////////////////
// 認証方式の単位

$auth_method_type = 'contents';	// ページ内容で認証する
//$auth_method_type = 'pagename';	// ページ名で認証する

/////////////////////////////////////////////////
// 閲覧認証
$read_auth = 0; // (0:不要 1:必要)

// 閲覧認証対象パターン定義 (正規表現)
$read_auth_pages = array(
	'#ひきこもるほげ#'	=> 'hoge',
	'#(ネタバレ|ねたばれ)#'	=> 'foo,bar,hoge',
);

/////////////////////////////////////////////////
// 編集認証
$edit_auth = 0; // (0:不要 1:必要)

// 編集認証対象パターン定義 (正規表現)
$edit_auth_pages = array(
	'#Barの公開日記#'	=> 'bar',
	'#ひきこもるほげ#'	=> 'hoge',
	'#(ネタバレ|ねたばれ)#'	=> 'foo,bar,hoge',
);

/////////////////////////////////////////////////
// 検索認証
// 0: 閲覧が許可されていないページ内容も検索対象とする。
// 1: 検索時のログインユーザに許可されたページのみ検索対象とする。
$search_auth = 0;

/////////////////////////////////////////////////
// $whatsnew: 更新履歴を表示するときの最大件数
$maxshow = 60;

// $whatsdeleted: 削除履歴の最大件数 (0で記録しない)
$maxshow_deleted = 60;

/////////////////////////////////////////////////
// 編集することのできないページの名前 (カンマで区切る)
$cantedit = array( $whatsnew, $whatsdeleted );

/////////////////////////////////////////////////
// HTTP: Last-Modified ヘッダを出力する
$lastmod = 0;  // (0:無効,1:有効)

/////////////////////////////////////////////////
// 日付フォーマット
$date_format = 'Y-m-d';

// 時刻フォーマット
$time_format = 'H:i:s';

/////////////////////////////////////////////////
// RSS に出力するページ数
$rss_max = 15;

/////////////////////////////////////////////////
// バックアップの設定

// バックアップを行う
$do_backup = 1; // (0:無効,1:有効)

// ページを削除した際にバックアップもすべて削除する
$del_backup = 0; // (0:無効,1:有効)

// バックアップ間隔と世代数
$cycle  =   3; // 直前の修正から何時間経過していたらバックアップするか (0で更新毎)
$maxage = 120; // 世代数

// 補足: $cycle x $maxage / 24 = データを失うために最低限必要な日数
//          3   x   120   / 24 = 15

// バックアップの世代を区切る文字列 (注意：変更しないでください)
define('PKWK_SPLITTER', '>>>>>>>>>>');

/////////////////////////////////////////////////
// ページの更新時にバックグランドで実行するコマンド
$update_exec = '';
//$update_exec = '/usr/bin/mknmz --media-type=text/pukiwiki -O /var/lib/namazu/index/ -L ja -c -K /var/www/wiki/';

/////////////////////////////////////////////////
// プロキシの設定（TrackBack Ping 等に使用）

// HTTPリクエストにプロキシサーバを使用する
$use_proxy = 0; // (0:不使用,1:使用)

$proxy_host = 'proxy.example.com';
$proxy_port = 8080;

// プロキシに対して Basic 認証を行う
$need_proxy_auth = 0; // (0:不使用,1:使用)
$proxy_auth_user = 'username';
$proxy_auth_pass = 'password';

// プロキシサーバを使用しないホストのリスト
$no_proxy = array(
	'localhost',	// localhost
	'127.0.0.0/8',	// loopback
//	'10.0.0.0/8'	// private class A
//	'172.16.0.0/12'	// private class B
//	'192.168.0.0/16'	// private class C
//	'no-proxy.com',
);

////////////////////////////////////////////////
// メール送信の設定

// ページの更新時にメールを送信
$notify = 0; // (0:送信しない,1:送信する)

// 差分だけを送信
$notify_diff_only = 1; // (0:???,1:差分のみ)

// SMTPサーバ (Windows のみ, 通常は php.ini で指定)
$smtp_server = 'localhost';

// Mail recipient (To:) and sender (From:)
$notify_to   = 'to@example.com';	// To:(宛先)
$notify_from = 'from@example.com';	// From:(差出人)

// Subject: ($page はページ名に置換されます。)
$notify_subject = '[PukiWiki] $page';

// メールヘッダ
// NOTE: Multiple items must be divided by "\r\n", not "\n".
$notify_header = '';

/////////////////////////////////////////////////
// メール送信のセキュリティ設定
// Mail: POP / APOP Before SMTP

// メール送信前にPOPまたはAPOPによる認証を行う
$smtp_auth = 0; // (0:無効,1:有効)

$pop_server = 'localhost';
$pop_port   = 110;
$pop_userid = '';
$pop_passwd = '';

// 認証に APOP を利用するかどうか (※サーバ側の対応が必要)
//   未設定 = 自動 (可能であればAPOPを使用する)
//   1 = APOP固定  (必ずAPOPを使用する)
//   0 = POP固定   (必ずPOPを使用する)
// $pop_auth_use_apop = 1;

/////////////////////////////////////////////////
// 無視リスト

// 一覧・更新一覧に含めないページ名 (正規表現)
$non_list = '^\:';

// 上記ページ名を単語検索からも除外するかを設定する。
$search_non_list = 1; // (0:無効,1:有効)

/////////////////////////////////////////////////
// テンプレートの設定
// ページ名に従って自動で雛形とするページの読み込む

$auto_template_func = 1; // (0:無効,1:有効)
$auto_template_rules = array(
	'((.+)\/([^\/]+))' => '\2/template'
);

/////////////////////////////////////////////////
// 見出し行に固有のアンカーを自動挿入する
$fixed_heading_anchor = 1; // (0:無効,1:有効)

/////////////////////////////////////////////////
// 見出しごとの編集を可能にする
// (固有のアンカーが挿入されている見出し行にのみ有効)
$fixed_heading_anchor_edit = 1; // (0:無効,1:有効)

/////////////////////////////////////////////////
// <pre>の行頭スペースをひとつ取り除く
$preformat_ltrim = 1; // (0:無効,1:有効)

/////////////////////////////////////////////////
// 改行を反映する(改行を<br />に置換する)
$line_break = 0; // (0:無効,1:有効)

/////////////////////////////////////////////////
// Use date-time rules (See rules.ini.php)
$usedatetime = 1; // (0:無効,1:有効)

/////////////////////////////////////////////////
// User-Agent 設定
//
// リッチクライアントを前提としたサイトを構築する
// ために、携帯電話などに意図的に非対応としたい場合、
// 最後のデフォルト設定以外の行を全て削除あるいは
// コメントアウトして下さい。
//
// デザインやスタイルを簡素なkeitaiプロファイルに
// 統一したい時は、デフォルト設定以外の行を全て削除
// あるいはコメントアウトした後に、デフォルト設定を
// 'profile'=>'keitai' と修正して下さい。
//

$agents = array(
// pattern: A regular-expression that matches device(browser)'s name and version
// profile: A group of browsers

    // Embedded browsers (Rich-clients for PostWiki)

	// Windows CE (Microsoft(R) Internet Explorer 5.5 for Windows(R) CE)
	// Sample: "Mozilla/4.0 (compatible; MSIE 5.5; Windows CE; sigmarion3)" (sigmarion, Hand-held PC)
	array('pattern'=>'#\b(?:MSIE [5-9]).*\b(Windows CE)\b#', 'profile'=>'default'),

	// ACCESS "NetFront" / "Compact NetFront" and thier OEM, expects to be "Mozilla/4.0"
	// Sample: "Mozilla/4.0 (PS2; PlayStation BB Navigator 1.0) NetFront/3.0" (PlayStation BB Navigator, for SONY PlayStation 2)
	// Sample: "Mozilla/4.0 (PDA; PalmOS/sony/model crdb/Revision:1.1.19) NetFront/3.0" (SONY Clie series)
	// Sample: "Mozilla/4.0 (PDA; SL-A300/1.0,Embedix/Qtopia/1.1.0) NetFront/3.0" (SHARP Zaurus)
	array('pattern'=>'#^(?:Mozilla/4).*\b(NetFront)/([0-9\.]+)#',	'profile'=>'default'),

    // Embedded browsers (Non-rich)

	// Windows CE (the others)
	// Sample: "Mozilla/2.0 (compatible; MSIE 3.02; Windows CE; 240x320 )" (GFORT, NTT DoCoMo)
	array('pattern'=>'#\b(Windows CE)\b#', 'profile'=>'keitai'),

	// ACCESS "NetFront" / "Compact NetFront" and thier OEM
	// Sample: "Mozilla/3.0 (AveFront/2.6)" ("SUNTAC OnlineStation", USB-Modem for PlayStation 2)
	// Sample: "Mozilla/3.0(DDIPOCKET;JRC/AH-J3001V,AH-J3002V/1.0/0100/c50)CNF/2.0" (DDI Pocket: AirH" Phone by JRC)
	array('pattern'=>'#\b(NetFront)/([0-9\.]+)#',	'profile'=>'keitai'),
	array('pattern'=>'#\b(CNF)/([0-9\.]+)#',	'profile'=>'keitai'),
	array('pattern'=>'#\b(AveFront)/([0-9\.]+)#',	'profile'=>'keitai'),
	array('pattern'=>'#\b(AVE-Front)/([0-9\.]+)#',	'profile'=>'keitai'), // The same?

	// NTT-DoCoMo, i-mode (embeded Compact NetFront) and FOMA (embedded NetFront) phones
	// Sample: "DoCoMo/1.0/F501i", "DoCoMo/1.0/N504i/c10/TB/serXXXX" // c以降は可変
	// Sample: "DoCoMo/2.0 MST_v_SH2101V(c100;TB;W22H12;serXXXX;iccxxxx)" // ()の中は可変
	array('pattern'=>'#^(DoCoMo)/([0-9\.]+)#',	'profile'=>'keitai'),

	// Vodafone's embedded browser
	// Sample: "J-PHONE/2.0/J-T03"	// 2.0は"ブラウザの"バージョン
	// Sample: "J-PHONE/4.0/J-SH51/SNxxxx SH/0001a Profile/MIDP-1.0 Configuration/CLDC-1.0 Ext-Profile/JSCL-1.1.0"
	array('pattern'=>'#^(J-PHONE)/([0-9\.]+)#',	'profile'=>'keitai'),

	// Openwave(R) Mobile Browser (EZweb, WAP phone, etc)
	// Sample: "OPWV-SDK/62K UP.Browser/6.2.0.5.136 (GUI) MMP/2.0"
	array('pattern'=>'#\b(UP\.Browser)/([0-9\.]+)#',	'profile'=>'keitai'),

	// Opera, dressing up as other embedded browsers
	// Sample: "Mozilla/3.0(DDIPOCKET;KYOCERA/AH-K3001V/1.4.1.67.000000/0.1/C100) Opera 7.0" (Like CNF at 'keitai'-mode)
	array('pattern'=>'#\bDDIPOCKET\b.+\b(Opera) ([0-9\.]+)\b#',	'profile'=>'keitai'),

	// Planetweb http://www.planetweb.com/
	// Sample: "Mozilla/3.0 (Planetweb/v1.07 Build 141; SPS JP)" ("EGBROWSER", Web browser for PlayStation 2)
	array('pattern'=>'#\b(Planetweb)/v([0-9\.]+)#', 'profile'=>'keitai'),

	// DreamPassport, Web browser for SEGA DreamCast
	// Sample: "Mozilla/3.0 (DreamPassport/3.0)"
	array('pattern'=>'#\b(DreamPassport)/([0-9\.]+)#',	'profile'=>'keitai'),

	// Palm "Web Pro" http://www.palmone.com/us/support/accessories/webpro/
	// Sample: "Mozilla/4.76 [en] (PalmOS; U; WebPro)"
	array('pattern'=>'#\b(WebPro)\b#',	'profile'=>'keitai'),

	// ilinx "Palmscape" / "Xiino" http://www.ilinx.co.jp/
	// Sample: "Xiino/2.1SJ [ja] (v. 4.1; 153x130; c16/d)"
	array('pattern'=>'#^(Palmscape)/([0-9\.]+)#',	'profile'=>'keitai'),
	array('pattern'=>'#^(Xiino)/([0-9\.]+)#',	'profile'=>'keitai'),

	// SHARP PDA Browser (SHARP Zaurus)
	// Sample: "sharp pda browser/6.1[ja](MI-E1/1.0) "
	array('pattern'=>'#^(sharp [a-z]+ browser)/([0-9\.]+)#',	'profile'=>'keitai'),

	// WebTV
	array('pattern'=>'#^(WebTV)/([0-9\.]+)#',	'profile'=>'keitai'),

    // Desktop-PC browsers

	// Opera (for desktop PC, not embedded) -- See BugTrack/743 for detail
	// NOTE: Keep this pattern above MSIE and Mozilla
	// Sample: "Opera/7.0 (OS; U)" (not disguise)
	// Sample: "Mozilla/4.0 (compatible; MSIE 5.0; OS) Opera 6.0" (disguise)
	array('pattern'=>'#\b(Opera)[/ ]([0-9\.]+)\b#',	'profile'=>'default'),

	// MSIE: Microsoft Internet Explorer (or something disguised as MSIE)
	// Sample: "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.0)"
	array('pattern'=>'#\b(MSIE) ([0-9\.]+)\b#',	'profile'=>'default'),

	// Mozilla Firefox
	// NOTE: Keep this pattern above Mozilla
	// Sample: "Mozilla/5.0 (Windows; U; Windows NT 5.0; ja-JP; rv:1.7) Gecko/20040803 Firefox/0.9.3"
	array('pattern'=>'#\b(Firefox)/([0-9\.]+)\b#',	'profile'=>'default'),

    	// Loose default: Including something Mozilla
	array('pattern'=>'#^([a-zA-z0-9 ]+)/([0-9\.]+)\b#',	'profile'=>'default'),

	array('pattern'=>'#^#',	'profile'=>'default'),	// Sentinel
);
?>
