/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.preference;

import java.io.UnsupportedEncodingException;
import jp.gr.java_conf.ussiy.app.propedit.PropertiesEditor;
import jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.PropertiesEditorPlugin;
import jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.editors.MultiPagePropertiesEditor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.FontFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchWindow;

public class PropertiesEditorPreference
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String P_CHECK_KEY = "checkKeyPreference";
    public static final String P_COMMENT_CHARACTER = "commentCharacter";
    public static final String P_ENCODE = "readEncode";
    public static final String P_FONT = "fontPreference";
    public static final String P_NOT_CONVERT = "notConvert";
    public static final String P_NOT_CONVERT_COMMENT = "notConvertComment";
    private Combo encodeCombo;
    private BooleanFieldEditor notConvertCommentField;

    public PropertiesEditorPreference() {
        super(1);
        this.setPreferenceStore(PropertiesEditorPlugin.getDefault().getPreferenceStore());
        this.setDescription(PropertiesEditor.res.getString("eclipse.propertieseditor.preference.page.title"));
        this.initializeDefaults();
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        Composite composite = null;
        if (control instanceof Composite) {
            composite = (Composite)control;
        }
        if (composite == null) {
            return control;
        }
        Label label = new Label(composite, 0);
        label.setText(PropertiesEditor.res.getString("eclipse.propertieseditor.preference.read.encode"));
        this.encodeCombo = new Combo(composite, 0);
        this.encodeCombo.setItems(new String[]{System.getProperty("file.encoding"), "US-ASCII", "UTF-8", "UTF-16"});
        this.encodeCombo.setText(this.getPreferenceStore().getString(P_ENCODE));
        return composite;
    }

    public void createFieldEditors() {
        this.addField((FieldEditor)new FontFieldEditor(P_FONT, "&" + PropertiesEditor.res.getString("eclipse.propertieseditor.preference.font"), this.getFieldEditorParent()));
        StringFieldEditor commentCharFieldEditor = new StringFieldEditor(P_COMMENT_CHARACTER, "&" + PropertiesEditor.res.getString("eclipse.propertieseditor.preference.comment.character"), 2, this.getFieldEditorParent());
        commentCharFieldEditor.setTextLimit(1);
        this.addField((FieldEditor)commentCharFieldEditor);
        this.addField((FieldEditor)new BooleanFieldEditor(P_CHECK_KEY, "&" + PropertiesEditor.res.getString("eclipse.propertieseditor.preference.checkduplication"), this.getFieldEditorParent()));
        this.notConvertCommentField = new BooleanFieldEditor(P_NOT_CONVERT_COMMENT, "&" + PropertiesEditor.res.getString("eclipse.propertieseditor.preference.convert.comment"), this.getFieldEditorParent());
        this.notConvertCommentField.setEnabled(!PropertiesEditorPlugin.getDefault().getPreferenceStore().getBoolean(P_NOT_CONVERT), this.getFieldEditorParent());
        this.addField((FieldEditor)this.notConvertCommentField);
        this.addField((FieldEditor)new EventBooleanFieldEditor(P_NOT_CONVERT, "&" + PropertiesEditor.res.getString("eclipse.propertieseditor.preference.convert"), this.getFieldEditorParent()));
    }

    public void init(IWorkbench workbench) {
    }

    private void initializeDefaults() {
    }

    protected void performDefaults() {
        super.performDefaults();
        this.encodeCombo.setText(System.getProperty("file.encoding"));
    }

    public boolean performOk() {
        boolean ret = true;
        try {
            if (!this.encodeCombo.getText().equals("")) {
                new String(this.toString().getBytes(), this.encodeCombo.getText());
            }
        }
        catch (UnsupportedEncodingException ex) {
            PropertiesEditorPlugin plugin = PropertiesEditorPlugin.getDefault();
            String pluginId = plugin.getDescriptor().getUniqueIdentifier();
            Status status = new Status(4, pluginId, -1, ex.getMessage(), (Throwable)ex);
            ErrorDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error", (String)"The encoding is not supported.", (IStatus)status);
            return false;
        }
        this.getPreferenceStore().setValue(P_ENCODE, this.encodeCombo.getText());
        ret = super.performOk();
        this.setFontToEditor();
        return ret;
    }

    private void setFontToEditor() {
        Font font = new Font((Device)Display.getCurrent(), PreferenceConverter.getFontDataArray((IPreferenceStore)this.getPreferenceStore(), (String)P_FONT));
        IWorkbenchWindow[] workbenchWindow = PropertiesEditorPlugin.getDefault().getWorkbench().getWorkbenchWindows();
        int i = 0;
        while (i < workbenchWindow.length) {
            IWorkbenchPage[] workbenchPage = workbenchWindow[i].getPages();
            int j = 0;
            while (j < workbenchPage.length) {
                IEditorReference[] editorReferences = workbenchPage[j].getEditorReferences();
                int k = 0;
                while (k < editorReferences.length) {
                    IEditorReference ref = editorReferences[k];
                    IEditorPart editorPart = ref.getEditor(false);
                    if (editorPart instanceof MultiPagePropertiesEditor) {
                        ((MultiPagePropertiesEditor)editorPart).getEditor().setFont(font);
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    private class EventBooleanFieldEditor
    extends BooleanFieldEditor {
        public EventBooleanFieldEditor(String name, String label, Composite parent) {
            super(name, label, parent);
        }

        public EventBooleanFieldEditor(String name, String labelText, int style, Composite parent) {
            super(name, labelText, style, parent);
        }

        public EventBooleanFieldEditor() {
        }

        public void valueChanged(boolean oldValue, boolean newValue) {
            if (newValue) {
                PropertiesEditorPreference.this.notConvertCommentField.setEnabled(false, PropertiesEditorPreference.this.getFieldEditorParent());
            } else {
                PropertiesEditorPreference.this.notConvertCommentField.setEnabled(true, PropertiesEditorPreference.this.getFieldEditorParent());
            }
            super.valueChanged(oldValue, newValue);
        }
    }
}

