#!/usr/bin/perl
BEGIN {
	push @INC, 'lib';
	unshift @INC, 'lib';
}

use CGI qw(:standard);
use CGI::Carp qw(fatalsToBrowser);

require "pyukiwiki.ini.cgi";
require $::setup_file if (-r $::setup_file);	# for feature
require "plugin/counter.inc.pl";
require "plugin/playvideo.inc.pl";
$::counter_ext = '.count';
$::info_dir="./info";
use Nana::Cache;
use Jcode;
use Image::ExifTool;
#use LWP::UserAgent;

$::zip_cmds=$playvideo_plugin_zipcmds;
$::zip_opts=$playvideo_plugin_zipflags;
$::zip_tmp=$playvideo_plugin_ziptmp;

&main;

sub main {
	foreach my $i (0x00 .. 0xFF) {
		$::_urlescape{chr($i)} = sprintf('%%%02x', $i);
		$::_dbmname_encode{chr($i)} = sprintf('%02X', $i);
	}

	$ENV{PATH_INFO}=~s/^\///g;
	$file=$ENV{PATH_INFO};
	$file=~s/\..*//g;
	$ext=$ENV{PATH_INFO};
	$ext=~s/.*\.//g;
	$wmv="wmv";
	$videopath=$playvideo_plugin_videopath;
	$videourl=$playvideo_plugin_videourl;

	my $exifTool = new Image::ExifTool;
	my $info = $exifTool->ImageInfo("$videopath/$file.$wmv");

	$title=&Jcode::convert($$info{Title}, 'sjis', 'utf8');
	$author=&Jcode::convert($$info{Author}, 'sjis', 'utf8');
	$copyright=&Jcode::convert($$info{Copyright}, 'sjis', 'utf8');
	if($ext eq "asx" || $ext eq "wmx" || $ext eq "wvx") {
		&plugin_counter_do("playvideo_$file","w");
		print <<EOM;
Content-Type: video/x-ms-wvx

<asx version="3.0">
<entry>
<title>$$info{Title}</title>
<author>$$info{Author}</author>
<copyright>$$info{Copyright}</copyright>
<ref href="$videourl/$file.$wmv" />
</entry>
</asx>
EOM
	} elsif($ext eq "zip" && $playvideo_plugin_usedownload eq 1) {
		&plugin_counter_do("playvideo_$file","w");
		foreach $cmd (split(/\n/,$::zip_cmds)) {
			if (-x $cmd) {
				$fname="$zip_tmp/$file.$wmv-$ENV{REMOTE_ADDR}.zip";
				# ʰץå
				do {
					sleep 1;
				} if (-r $fname);

				chdir($videopath);
				if(open(PIPE,"$cmd $zip_opts $fname $file.$wmv |")) {
					@TMP=<PIPE>;
					close(PIPE);
					$size = -s $fname;
					if(open(R, $fname)) {
						my $downloadfile="$file.zip";
						if($::playvideo_plugin_downloadfilename_inwmv) {
							my $in_author;
							
							if($::playvideo_plugin_downloadfilename_inwmv_withauthor) {
								$in_author=" ($author)" if($author ne '');
							}
							if($title ne '') {
								$downloadfile="$title$in_author.zip";
							}
						}
						$::defaultcode='sjis';
						if($downloadfile=~/[\x81-\xfe]/) {
							if($ENV{HTTP_USER_AGENT}=~/Opera/ || $ENV{HTTP_USER_AGENT} =~/Chrome/) {
							$downloadfile=&code_convert(\$downloadfile,"utf8");
							$downloadfile=qq(filename="$downloadfile");
#							$downloadfile="filename*=ISO-2022-JP" . qq{''} . &encode($downloadfile) . qq{"};
							$downloadfile=~s/%2e/\./g;
						} elsif($ENV{HTTP_USER_AGENT}=~/MSIE/) {
								$downloadfile=qq{filename="} . &code_convert(\$downloadfile,"sjis") . qq{"};
						} else {
								$downloadfile=&code_convert(\$downloadfile,$::kanjicode);
								$downloadfile=qq(filename="$downloadfile");
#								$downloadfile=qq{filename="} . $::charset . qq{''} . &encode($downloadfile) . qq{"};
#								$downloadfile=~s/%2e/\./g;
							}
						} else {
							$downloadfile=qq(filename="$downloadfile.zip");
						}

						print <<EOM;
Content-Type: application/zip
Pragma: no-cache
Content-Length: $size
Content-disposition: attachment; $downloadfile

EOM
						binmode	R;
						binmode STDOUT;
						print <R>;
						close(R);
						unlink($fname);
						exit;
					} else {
						unlink($fname);
						&err("Can't create zip file. sorry.");
						exit;
					}
				} else {
					unlink($fname);
					&err("Can't create pipe. sorry.");#
					exit;
				}
				exit;
			}
		}
		&err("Not found zip command.");
		exit;
	} elsif($ext=~/^sm(\d+)/) {
		&plugin_counter_do("playvideo_$file","w");
		print <<EOM;
Location: http://www.nicovideo.jp/watch/$ext

EOM
	} else {
		&plugin_counter_do("playvideo_$file","w");
		print <<EOM;
Location: http://www.youtube.com/watch?v=$ext

EOM
	}
}

sub is_exist_page {
	return 1;
}

sub encode {
	my ($encoded) = @_;
	$encoded =~ s/(\W)/$::_urlescape{$1}/g;
	return $encoded;
}

sub dbmname {
	my ($name) = @_;
	$name =~ s/(.)/$::_dbmname_encode{$1}/g;
	return $name;
}

my $_tz='';
sub gettz {
	if($_tz eq '') {
		$_tz=(localtime(time))[2]+(localtime(time))[3]*24+(localtime(time))[4]*24
			+(localtime(time))[5]*24-(gmtime(time))[2]-(gmtime(time))[3]*24
			-(gmtime(time))[4]*24-(gmtime(time))[5]*24;
	}
	return $_tz;
}

sub code_convert {
	my ($contentref, $kanjicode, $icode) = @_;
	if($$contentref ne '') {
		if ($::lang eq 'ja') {
			&Jcode::convert($contentref, $kanjicode, $icode);
		}
	}
	return $$contentref;
}

sub err {
	($msg)=@_;
	print <<EOM;
Content-type: text/plain

$msg
EOM
}
