/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure;

import java.awt.Color;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementRectangle;

public abstract class SGDrawingElementBar
extends SGDrawingElementRectangle {
    protected double mBaselineValue;
    public static final String KEY_BAR_WIDTH = "Width";
    public static final String KEY_EDGE_LINE_WIDTH = "Edge Line Width";
    public static final String KEY_EDGE_LINE_COLOR = "Edge Line Color";
    public static final String KEY_BASELINE_VALUE = "Baseline Value";

    public double getBaselineValue() {
        return this.mBaselineValue;
    }

    public boolean setBaselineValue(double d) {
        this.mBaselineValue = d;
        return true;
    }

    public boolean setProperty(SGDrawingElement sGDrawingElement) {
        if (!(sGDrawingElement instanceof SGDrawingElementBar)) {
            return false;
        }
        if (!super.setProperty(sGDrawingElement)) {
            return false;
        }
        SGDrawingElementBar sGDrawingElementBar = (SGDrawingElementBar)sGDrawingElement;
        this.setBaselineValue(sGDrawingElementBar.getBaselineValue());
        return true;
    }

    public SGProperties getProperties() {
        BarProperties barProperties = new BarProperties();
        this.getProperties(barProperties);
        return barProperties;
    }

    public boolean getProperties(SGProperties sGProperties) {
        if (sGProperties == null) {
            return false;
        }
        if (!(sGProperties instanceof BarProperties)) {
            return false;
        }
        super.getProperties(sGProperties);
        BarProperties barProperties = (BarProperties)sGProperties;
        barProperties.setBarWidth(this.getRectangleWidth());
        barProperties.setEdgeLineWidth(this.getEdgeLineWidth());
        barProperties.setEdgeLineColor(this.getEdgeLineColor());
        barProperties.setBaselineValue(this.getBaselineValue());
        return true;
    }

    public static class BarProperties
    extends SGDrawingElement.DrawingElementProperties {
        public static final String[] keys = new String[]{"Width", "Edge Line Width", "Edge Line Color", "Baseline Value"};

        public boolean equals(Object object) {
            if (!(object instanceof BarProperties)) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            BarProperties barProperties = (BarProperties)object;
            for (int i = 0; i < keys.length; ++i) {
                if (this.getProperty(keys[i]).equals(barProperties.getProperty(keys[i]))) continue;
                return false;
            }
            return true;
        }

        public Float getBarWidth() {
            String string = this.getProperty(SGDrawingElementBar.KEY_BAR_WIDTH);
            return SGUtilityText.getFloat(string);
        }

        public Float getEdgeLineWidth() {
            String string = this.getProperty(SGDrawingElementBar.KEY_EDGE_LINE_WIDTH);
            return SGUtilityText.getFloat(string);
        }

        public Color getEdgeLineColor() {
            String string = this.getProperty(SGDrawingElementBar.KEY_EDGE_LINE_COLOR);
            return SGUtilityText.getColorFromString(string);
        }

        public Double getBaselineValue() {
            String string = this.getProperty(SGDrawingElementBar.KEY_BASELINE_VALUE);
            return SGUtilityText.getDouble(string);
        }

        public boolean setBarWidth(float f) {
            if (f < 0.0f) {
                return false;
            }
            this.setProperty(SGDrawingElementBar.KEY_BAR_WIDTH, new Float(f).toString());
            return true;
        }

        public boolean setBaselineValue(double d) {
            this.setProperty(SGDrawingElementBar.KEY_BASELINE_VALUE, new Double(d).toString());
            return true;
        }

        public boolean setEdgeLineWidth(float f) {
            if (f < 0.0f) {
                return false;
            }
            this.setProperty(SGDrawingElementBar.KEY_EDGE_LINE_WIDTH, new Float(f).toString());
            return true;
        }

        public boolean setEdgeLineColor(Color color) {
            if (color == null) {
                return false;
            }
            String string = SGUtilityText.getColorString(color);
            if (string == null) {
                return false;
            }
            this.setProperty(SGDrawingElementBar.KEY_EDGE_LINE_COLOR, string);
            return true;
        }
    }
}

