/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.TreeMap;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import jp.riken.brain.ni.samuraigraph.base.SGData;
import jp.riken.brain.ni.samuraigraph.base.SGDefaultValues;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGIAxisElement;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElement;
import jp.riken.brain.ni.samuraigraph.base.SGIGraphElement;
import jp.riken.brain.ni.samuraigraph.base.SGILegendElement;
import jp.riken.brain.ni.samuraigraph.base.SGIStringElement;
import jp.riken.brain.ni.samuraigraph.base.SGIUndoable;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.data.SGSXYData;
import jp.riken.brain.ni.samuraigraph.data.SGSXYMultipleData;
import jp.riken.brain.ni.samuraigraph.data.SGVXYData;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementArrow;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementBar;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementLine;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementRectangle;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementSymbol;
import jp.riken.brain.ni.samuraigraph.figure.SGFigureElement;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementBar2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementString2DExtended;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementSymbol2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroup;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupArrow;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupBar;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupLine;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupSet;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupSetInFigureElement;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupSymbol;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGLegendDialog;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGPropertyDialogSXYData;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGPropertyDialogVXYData;

public class SGLegendElement
extends SGFigureElement
implements SGILegendElement,
CaretListener,
WindowListener {
    private SGIGraphElement mGraphElement = null;
    private ArrayList mGroupSetList = new ArrayList();
    private float mLegendX = 0.0f;
    private float mLegendY = 0.0f;
    private float mLegendWidth = 0.0f;
    private float mLegendHeight = 0.0f;
    private float mFontSize;
    private int mFontStyle;
    private String mFontFamilyName;
    private Color mStringColor;
    private float mWidthOfDataElement = 85.039375f;
    private float mFrameLineWidth;
    private Color mFrameLineColor;
    private Color mBackgroundColor;
    private boolean mLegendVisibleFlag = true;
    private boolean mEnteredFlag = false;
    private boolean mFrameVisibleFlag = true;
    private boolean mLegendTransparentFlag = true;
    private SGProperties mTemporaryProperties = null;
    private JPopupMenu mPopupMenu = new JPopupMenu();
    private SGLegendDialog mDialog = null;
    private JTextField mEditField = new JTextField();
    public static final String MENUCMD_HIDE = "Hide";
    private ElementGroupSetInLegend mFocusedGroup = null;
    private Point mLegendLocation = null;
    private Point mPressedLegendOrigin = null;

    public SGLegendElement() {
        this.initEditField();
        if (!this.init()) {
            throw new Error();
        }
    }

    private boolean init() {
        this.setLegendVisible(true);
        this.setFontFamilyName("Serif");
        this.setFontSize(16.0f);
        int n = SGUtilityText.getFontStyle("Plain");
        if (n == -1) {
            return false;
        }
        this.setFontStyle(n);
        this.setStringColor(SGDefaultValues.LEGEND_STRING_COLOR);
        this.setFrameVisible(true);
        this.setFrameLineWidth(0.5f);
        this.setFrameLineColor(SGDefaultValues.LEGEND_FRAME_COLOR);
        this.setBackgroundColor(SGDefaultValues.LEGEND_BACKGROUND_COLOR);
        this.setLegendTransparent(true);
        this.createPopupMenu();
        return true;
    }

    private boolean createPopupMenu() {
        this.mPopupMenu.setBounds(0, 0, 100, 100);
        JMenuItem jMenuItem = new JMenuItem(MENUCMD_HIDE);
        jMenuItem.addActionListener(this);
        this.mPopupMenu.add(jMenuItem);
        this.mPopupMenu.addSeparator();
        jMenuItem = new JMenuItem("Property");
        jMenuItem.addActionListener(this);
        this.mPopupMenu.add(jMenuItem);
        return true;
    }

    public String toString() {
        return new String("SGLegendElement");
    }

    public boolean addData(SGData sGData) {
        if (this.mGraphElement == null || sGData == null) {
            throw new Error("mGraphElement==null || data==null");
        }
        super.addData(sGData);
        ElementGroupSetInLegend elementGroupSetInLegend = this.createLegendElement(sGData);
        if (elementGroupSetInLegend == null) {
            return false;
        }
        elementGroupSetInLegend.setMagnification(this.mMagnification);
        this.mGroupSetList.add(elementGroupSetInLegend);
        this.createAllDrawingElements();
        return true;
    }

    private ElementGroupSetInLegend createLegendElement(SGData sGData) {
        Object object;
        int n;
        ElementGroupSetInLegend elementGroupSetInLegend = null;
        if (sGData instanceof SGSXYData || sGData instanceof SGSXYMultipleData) {
            elementGroupSetInLegend = new ElementGroupSetInLegendSXY();
        } else if (sGData instanceof SGVXYData) {
            elementGroupSetInLegend = new ElementGroupSetInLegendVXY();
        } else {
            return null;
        }
        String string = this.mGraphElement.getDataName(sGData);
        elementGroupSetInLegend.setName(string);
        ArrayList arrayList = this.mGraphElement.getDrawingElementList(sGData);
        if (sGData instanceof SGSXYData || sGData instanceof SGSXYMultipleData) {
            for (n = 0; n < arrayList.size(); ++n) {
                object = (SGDrawingElement)arrayList.get(n);
                if (object instanceof SGDrawingElementLine) {
                    elementGroupSetInLegend.addDrawingElementGroup(0);
                    continue;
                }
                if (object instanceof SGDrawingElementRectangle) {
                    elementGroupSetInLegend.addDrawingElementGroup(2);
                    continue;
                }
                if (object instanceof SGDrawingElementSymbol) {
                    elementGroupSetInLegend.addDrawingElementGroup(1);
                    continue;
                }
                throw new Error();
            }
        } else if (sGData instanceof SGVXYData) {
            for (n = 0; n < arrayList.size(); ++n) {
                object = (SGDrawingElement)arrayList.get(n);
                if (!(object instanceof SGDrawingElementArrow)) {
                    throw new Error();
                }
                elementGroupSetInLegend.addDrawingElementGroup(3);
            }
        } else {
            throw new Error("This data-type is not defined.");
        }
        ArrayList arrayList2 = this.mGraphElement.getVisibleFlagList(sGData);
        object = elementGroupSetInLegend.mDrawingElementGroupList;
        if (arrayList2.size() != ((ArrayList)object).size()) {
            throw new Error();
        }
        for (int i = 0; i < ((ArrayList)object).size(); ++i) {
            SGElementGroup sGElementGroup = (SGElementGroup)((ArrayList)object).get(i);
            boolean bl = (Boolean)arrayList2.get(i);
            sGElementGroup.setVisible(bl);
        }
        elementGroupSetInLegend.initPropertiesHistory();
        return elementGroupSetInLegend;
    }

    public ArrayList getDrawingElementList(SGData sGData) {
        return this.getLegendData(sGData).getDrawingElementList();
    }

    public String getDataName(SGData sGData) {
        ElementGroupSetInLegend elementGroupSetInLegend = this.getLegendData(sGData);
        if (elementGroupSetInLegend != null) {
            return elementGroupSetInLegend.mName;
        }
        return null;
    }

    public boolean isDataVisible(SGData sGData) {
        SGElementGroupSet sGElementGroupSet = this.getElementGroupSet(sGData);
        boolean bl = sGElementGroupSet.isVisible();
        return bl;
    }

    protected ElementGroupSetInLegend getLegendData(SGData sGData) {
        for (int i = 0; i < this.mDataList.size(); ++i) {
            SGData sGData2 = (SGData)this.mDataList.get(i);
            if (!sGData2.equals(sGData)) continue;
            ElementGroupSetInLegend elementGroupSetInLegend = (ElementGroupSetInLegend)this.mGroupSetList.get(i);
            return elementGroupSetInLegend;
        }
        return null;
    }

    public ArrayList getVisibleFlagList(SGData sGData) {
        if (sGData == null) {
            return null;
        }
        ArrayList<Boolean> arrayList = new ArrayList<Boolean>();
        ElementGroupSetInLegend elementGroupSetInLegend = this.getLegendData(sGData);
        ArrayList arrayList2 = elementGroupSetInLegend.mDrawingElementGroupList;
        for (int i = 0; i < arrayList2.size(); ++i) {
            SGElementGroup sGElementGroup = (SGElementGroup)arrayList2.get(i);
            boolean bl = sGElementGroup.isVisible();
            arrayList.add(new Boolean(bl));
        }
        return arrayList;
    }

    public float getLegendX() {
        return this.mGraphAreaX + this.mLegendX * this.mMagnification;
    }

    public float getLegendY() {
        return this.mGraphAreaY + this.mLegendY * this.mMagnification;
    }

    public float getLegendWidth() {
        return this.mLegendWidth;
    }

    public float getLegendHeight() {
        return this.mLegendHeight;
    }

    public Point2D getLegendLocation() {
        Point2D.Float float_ = new Point2D.Float(this.getLegendX(), this.getLegendY());
        return float_;
    }

    public boolean setLegendLocation(float f, float f2) {
        this.mLegendX = (f - this.mGraphAreaX) / this.mMagnification;
        this.mLegendY = (f2 - this.mGraphAreaY) / this.mMagnification;
        return true;
    }

    private boolean initEditField() {
        this.setLayout(null);
        this.add(this.mEditField);
        this.mEditField.setVisible(false);
        this.mEditField.addActionListener(this);
        this.mEditField.addCaretListener(this);
        return true;
    }

    public boolean clearSelectedElements() {
        super.clearSelectedElements();
        if (!this.mLegendVisibleFlag) {
            return true;
        }
        if (this.mEditField.isVisible()) {
            this.terminateEditField();
        }
        this.clearFocusedGroup();
        return true;
    }

    public boolean setDialogOwner(Frame frame) {
        super.setDialogOwner(frame);
        this.createDialog();
        return true;
    }

    public JDialog getDialog() {
        this.mDialog.setColorButtonBorder(true);
        this.mDialog.setLocation(this.mDialogOwner.getLocation());
        this.setDialogProperty();
        this.mTemporaryProperties = this.getProperties();
        return this.mDialog;
    }

    private boolean createDialog() {
        SGLegendDialog sGLegendDialog = new SGLegendDialog(this.mDialogOwner, true);
        sGLegendDialog.setActionListener(this);
        sGLegendDialog.addWindowListener(this);
        this.mDialog = sGLegendDialog;
        return true;
    }

    private boolean setDialogProperty() {
        SGLegendDialog sGLegendDialog = this.mDialog;
        sGLegendDialog.setLegendVisible(this.mLegendVisibleFlag);
        sGLegendDialog.setFrameVisible(this.mFrameVisibleFlag);
        sGLegendDialog.setFrameLineWidth(this.mFrameLineWidth);
        sGLegendDialog.setFrameLineColor(this.mFrameLineColor);
        sGLegendDialog.setFontFamilyName(this.mFontFamilyName);
        sGLegendDialog.setFontSize(this.mFontSize);
        sGLegendDialog.setTextColor(this.mStringColor);
        sGLegendDialog.setFontStyle(this.mFontStyle);
        sGLegendDialog.setBackgroundColor(this.mBackgroundColor);
        sGLegendDialog.setLegendTransparent(this.mLegendTransparentFlag);
        return true;
    }

    private LegendCommonProperties getCommonPropertiesFromDialog() {
        SGLegendDialog sGLegendDialog = this.mDialog;
        LegendCommonProperties legendCommonProperties = sGLegendDialog.getCommonProperties();
        if (legendCommonProperties == null) {
            return null;
        }
        legendCommonProperties.x = this.mLegendX;
        legendCommonProperties.y = this.mLegendY;
        return legendCommonProperties;
    }

    protected SGProperties getCommonProperties() {
        LegendCommonProperties legendCommonProperties = new LegendCommonProperties();
        legendCommonProperties.x = this.mLegendX;
        legendCommonProperties.y = this.mLegendY;
        legendCommonProperties.visible = this.isLegendVisible();
        legendCommonProperties.frameLineVisible = this.isFrameLineVisible();
        legendCommonProperties.frameLineWidth = this.getFrameLineWidth();
        legendCommonProperties.frameLineColor = this.getFrameLineColor();
        legendCommonProperties.backgroundColor = this.getBackgroundColor();
        legendCommonProperties.transparent = this.isLegendTransparent();
        legendCommonProperties.fontFamilyName = this.getFontFamilyName();
        legendCommonProperties.fontSize = this.getFontSize();
        legendCommonProperties.fontStyle = this.getFontStyle();
        legendCommonProperties.stringColor = this.getStringColor();
        return legendCommonProperties;
    }

    protected TreeMap getDataPropertiesMap() {
        TreeMap<Integer, SGProperties> treeMap = new TreeMap<Integer, SGProperties>();
        for (int i = 0; i < this.mGroupSetList.size(); ++i) {
            ElementGroupSetInLegend elementGroupSetInLegend = (ElementGroupSetInLegend)this.mGroupSetList.get(i);
            if (!elementGroupSetInLegend.isVisible()) continue;
            SGProperties sGProperties = elementGroupSetInLegend.getProperties();
            SGData sGData = this.getData(elementGroupSetInLegend);
            treeMap.put(new Integer(sGData.hashCode()), sGProperties);
        }
        return treeMap;
    }

    public SGProperties getProperties() {
        LegendCommonProperties legendCommonProperties = new LegendCommonProperties();
        legendCommonProperties = (LegendCommonProperties)this.getCommonProperties();
        return legendCommonProperties;
    }

    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof LegendCommonProperties)) {
            return false;
        }
        LegendCommonProperties legendCommonProperties = (LegendCommonProperties)sGProperties;
        return this.setCommonProperties(legendCommonProperties);
    }

    protected SGData getData(int n) {
        for (int i = 0; i < this.mDataList.size(); ++i) {
            SGData sGData = (SGData)this.mDataList.get(i);
            if (sGData.hashCode() != n) continue;
            return sGData;
        }
        return null;
    }

    private boolean setCommonProperties(LegendCommonProperties legendCommonProperties) {
        this.mLegendX = legendCommonProperties.x;
        this.mLegendY = legendCommonProperties.y;
        this.setLegendVisible(legendCommonProperties.visible);
        this.setFrameVisible(legendCommonProperties.frameLineVisible);
        this.setFrameLineWidth(legendCommonProperties.frameLineWidth);
        this.setFrameLineColor(legendCommonProperties.frameLineColor);
        this.setBackgroundColor(legendCommonProperties.backgroundColor);
        this.setLegendTransparent(legendCommonProperties.transparent);
        this.setFontFamilyName(legendCommonProperties.fontFamilyName);
        this.setFontSize(legendCommonProperties.fontSize);
        this.setFontStyle(legendCommonProperties.fontStyle);
        this.setStringColor(legendCommonProperties.stringColor);
        return true;
    }

    private boolean setPropertyWithDialog() {
        LegendCommonProperties legendCommonProperties = this.getCommonPropertiesFromDialog();
        if (legendCommonProperties == null) {
            return false;
        }
        this.setCommonProperties(legendCommonProperties);
        return true;
    }

    private boolean createAllDrawingElements() {
        float f;
        float f2;
        int n;
        float f3;
        int n2;
        ElementGroupSetInLegend[] elementGroupSetInLegendArray;
        int n3;
        ArrayList<ElementGroupSetInLegend[]> arrayList = new ArrayList<ElementGroupSetInLegend[]>();
        for (n3 = 0; n3 < this.mGroupSetList.size(); ++n3) {
            elementGroupSetInLegendArray = (ElementGroupSetInLegend[])this.mGroupSetList.get(n3);
            if (!elementGroupSetInLegendArray.isVisible()) continue;
            arrayList.add(elementGroupSetInLegendArray);
        }
        n3 = arrayList.size();
        elementGroupSetInLegendArray = new ElementGroupSetInLegend[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            elementGroupSetInLegendArray[n2] = (ElementGroupSetInLegend)arrayList.get(n2);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            elementGroupSetInLegendArray[n2].createDrawingString();
        }
        Rectangle2D[] rectangle2DArray = new Rectangle2D[n3];
        for (int i = 0; i < n3; ++i) {
            rectangle2DArray[i] = elementGroupSetInLegendArray[i].getDrawingStringBounds();
        }
        float[] fArray = new float[n3];
        for (int i = 0; i < n3; ++i) {
            fArray[i] = (float)rectangle2DArray[i].getHeight();
        }
        float f4 = 0.0f;
        for (int i = 0; i < n3; ++i) {
            f3 = (float)rectangle2DArray[i].getWidth();
            if (!(f3 > f4)) continue;
            f4 = f3;
        }
        float f5 = f4;
        f3 = 0.0f;
        for (int i = 0; i < n3; ++i) {
            float f6 = elementGroupSetInLegendArray[i].getMaxDataElementWidth();
            if (!(f6 > f3)) continue;
            f3 = f6;
        }
        f3 = this.mMagnification * this.mWidthOfDataElement;
        this.mLegendWidth = this.mWidthOfDataElement + f5 / this.mMagnification;
        double[] dArray = new double[n3];
        for (int i = 0; i < n3; ++i) {
            dArray[i] = elementGroupSetInLegendArray[i].getMaxDataElementHeight();
        }
        float[] fArray2 = new float[n3];
        for (int i = 0; i < n3; ++i) {
            fArray2[i] = (float)Math.max(dArray[i], (double)fArray[i]);
        }
        float[] fArray3 = new float[n3];
        for (int i = 0; i < n3; ++i) {
            fArray3[i] = fArray2[i];
        }
        Rectangle2D[] rectangle2DArray2 = new Rectangle2D[n3];
        float f7 = this.getLegendY();
        for (n = 0; n < n3; ++n) {
            f2 = this.getLegendX();
            f = f7;
            float f8 = this.mMagnification * this.mLegendWidth;
            float f9 = fArray3[n];
            f7 += f9;
            rectangle2DArray2[n] = new Rectangle2D.Float(f2, f, f8, f9);
        }
        for (n = 0; n < n3; ++n) {
            elementGroupSetInLegendArray[n].mDataRect = rectangle2DArray2[n];
        }
        this.mLegendHeight = 0.0f;
        for (n = 0; n < n3; ++n) {
            this.mLegendHeight += fArray3[n] / this.mMagnification;
        }
        for (n = 0; n < n3; ++n) {
            elementGroupSetInLegendArray[n].createDrawingElement();
        }
        for (n = 0; n < n3; ++n) {
            f2 = this.getLegendX() + this.mWidthOfDataElement * this.mMagnification;
            f = (float)rectangle2DArray2[n].getY() + 0.5f * (float)rectangle2DArray2[n].getHeight() - 0.5f * fArray[n];
            elementGroupSetInLegendArray[n].mDrawingString.setLocation(f2, f);
        }
        return true;
    }

    public boolean setGraphAreaRect(float f, float f2, float f3, float f4) {
        super.setGraphAreaRect(f, f2, f3, f4);
        this.createAllDrawingElements();
        return true;
    }

    public void paintGraphics2D(Graphics2D graphics2D) {
        super.paintGraphics2D(graphics2D);
        if (this.mLegendVisibleFlag || this.mEnteredFlag) {
            if (!this.mLegendTransparentFlag) {
                Rectangle2D rectangle2D = this.getLegendRect();
                graphics2D.setPaint(this.getBackgroundColor());
                graphics2D.fill(rectangle2D);
            }
            for (int i = 0; i < this.mGroupSetList.size(); ++i) {
                ElementGroupSetInLegend elementGroupSetInLegend = (ElementGroupSetInLegend)this.mGroupSetList.get(i);
                if (!elementGroupSetInLegend.isVisible()) continue;
                elementGroupSetInLegend.paintGraphics2D(graphics2D);
            }
            if (this.mFrameVisibleFlag && this.mGroupSetList.size() != 0) {
                this.drawLegendFrameLines(graphics2D);
            }
        }
    }

    private void drawLegendFrameLines(Graphics2D graphics2D) {
        boolean bl = false;
        for (int i = 0; i < this.mGroupSetList.size(); ++i) {
            SGElementGroupSet sGElementGroupSet = (SGElementGroupSet)this.mGroupSetList.get(i);
            if (!sGElementGroupSet.isVisible()) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return;
        }
        graphics2D.setPaint(this.mFrameLineColor);
        graphics2D.setStroke(new BasicStroke(this.mMagnification * this.mFrameLineWidth, 0, 0));
        double d = this.getLegendX();
        double d2 = this.getLegendY();
        double d3 = this.mMagnification * this.mLegendWidth;
        double d4 = this.mMagnification * this.mLegendHeight;
        graphics2D.drawRect((int)d, (int)d2, (int)d3, (int)d4);
    }

    public boolean contains(int n, int n2) {
        Rectangle2D.Float float_ = new Rectangle2D.Float(this.getLegendX(), this.getLegendY(), this.mLegendWidth, this.mLegendHeight);
        return float_.contains(n, n2);
    }

    public boolean removeData(SGData sGData) {
        for (int i = this.mDataList.size() - 1; i >= 0; --i) {
            SGData sGData2 = (SGData)this.mDataList.get(i);
            if (!sGData2.equals(sGData)) continue;
            this.mDataList.remove(i);
            this.mGroupSetList.remove(i);
        }
        return true;
    }

    protected boolean moveGraphToFront(SGElementGroupSet sGElementGroupSet) {
        SGData sGData = null;
        for (int i = 0; i < this.mGroupSetList.size(); ++i) {
            if (!sGElementGroupSet.equals(this.mGroupSetList.get(i))) continue;
            this.mGroupSetList.remove(i);
            sGData = (SGData)this.mDataList.remove(i);
            break;
        }
        this.mGroupSetList.add(this.mGroupSetList.size(), sGElementGroupSet);
        this.mDataList.add(this.mDataList.size(), sGData);
        return true;
    }

    protected boolean moveGraphToBack(SGElementGroupSet sGElementGroupSet) {
        SGData sGData = null;
        for (int i = 0; i < this.mGroupSetList.size(); ++i) {
            if (!sGElementGroupSet.equals(this.mGroupSetList.get(i))) continue;
            this.mGroupSetList.remove(i);
            sGData = (SGData)this.mDataList.remove(i);
            break;
        }
        this.mGroupSetList.add(0, sGElementGroupSet);
        this.mDataList.add(0, sGData);
        return true;
    }

    protected boolean removeGraph(SGElementGroupSet sGElementGroupSet) {
        for (int i = 0; i < this.mGroupSetList.size(); ++i) {
            if (!sGElementGroupSet.equals(this.mGroupSetList.get(i))) continue;
            this.mGroupSetList.remove(i);
            this.mDataList.remove(i);
            return true;
        }
        return false;
    }

    public boolean synchronize(SGIFigureElement sGIFigureElement) {
        boolean bl = true;
        if (!(sGIFigureElement instanceof SGIAxisElement)) {
            if (sGIFigureElement instanceof SGIGraphElement) {
                SGIGraphElement sGIGraphElement = (SGIGraphElement)sGIFigureElement;
                bl = this.synchronizeToGraphElement(sGIGraphElement);
            } else if (!(sGIFigureElement instanceof SGIStringElement) && !(sGIFigureElement instanceof SGILegendElement)) {
                bl = sGIFigureElement.synchronizeArgument(this);
            }
        }
        return bl;
    }

    private boolean synchronizeToGraphElement(SGIGraphElement sGIGraphElement) {
        int n;
        Object object;
        int n2;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList arrayList2 = sGIGraphElement.getDataList();
        if (arrayList2.size() != this.mDataList.size()) {
            throw new Error("dataList.size() != this.mDataList.size()");
        }
        ArrayList<SGData> arrayList3 = new ArrayList<SGData>();
        ArrayList<SGElementGroupSet> arrayList4 = new ArrayList<SGElementGroupSet>();
        block0: for (n2 = 0; n2 < arrayList2.size(); ++n2) {
            SGData sGData = (SGData)arrayList2.get(n2);
            for (int i = this.mDataList.size() - 1; i >= 0; --i) {
                object = (SGData)this.mDataList.get(i);
                if (!sGData.equals(object)) continue;
                SGData sGData2 = (SGData)this.mDataList.remove(i);
                arrayList3.add(sGData2);
                SGElementGroupSet sGElementGroupSet = (SGElementGroupSet)this.mGroupSetList.remove(i);
                arrayList4.add(sGElementGroupSet);
                continue block0;
            }
        }
        this.mDataList = arrayList3;
        this.mGroupSetList = arrayList4;
        n2 = 1;
        for (n = this.mDataList.size() - 1; n >= 0; --n) {
            SGDrawingElement sGDrawingElement;
            int n3;
            String string;
            SGData sGData = (SGData)this.mDataList.get(n);
            object = (ElementGroupSetInLegend)this.mGroupSetList.get(n);
            boolean bl = false;
            boolean bl2 = sGIGraphElement.isCommited(sGData);
            if (!bl2) {
                n2 = 0;
            }
            if (!(string = sGIGraphElement.getDataName(sGData)).equals(((ElementGroupSetInLegend)object).mName)) {
                bl = true;
            }
            ((ElementGroupSetInLegend)object).mName = string;
            boolean bl3 = sGIGraphElement.isDataVisible(sGData);
            if (bl3 != ((ElementGroupSetInLegend)object).isVisible()) {
                // empty if block
            }
            ((ElementGroupSetInLegend)object).setVisible(bl3);
            ArrayList arrayList5 = sGIGraphElement.getDrawingElementList(sGData);
            ArrayList<SGDrawingElement> arrayList6 = new ArrayList<SGDrawingElement>();
            for (n3 = arrayList5.size() - 1; n3 >= 0; --n3) {
                SGProperties sGProperties;
                sGDrawingElement = (SGDrawingElement)arrayList5.get(n3);
                ArrayList arrayList7 = ((ElementGroupSetInLegend)object).mDrawingElementGroupList;
                SGElementGroup sGElementGroup = (SGElementGroup)arrayList7.remove(n3);
                SGDrawingElement sGDrawingElement2 = sGElementGroup.getDrawingElement();
                SGProperties sGProperties2 = sGDrawingElement.getProperties();
                if (!sGProperties2.equals(sGProperties = sGDrawingElement2.getProperties())) {
                    bl = true;
                }
                arrayList6.add(sGDrawingElement);
            }
            for (n3 = arrayList6.size() - 1; n3 >= 0; --n3) {
                sGDrawingElement = (SGDrawingElement)arrayList6.get(n3);
                ((ElementGroupSetInLegend)object).addDrawingElementGroup(sGDrawingElement);
            }
            this.mGroupSetList.set(n, object);
            if (!bl) continue;
            arrayList.add(object);
        }
        this.createAllDrawingElements();
        if (arrayList.size() != 0 && n2 != 0) {
            for (n = 0; n < arrayList.size(); ++n) {
                ElementGroupSetInLegend elementGroupSetInLegend = (ElementGroupSetInLegend)arrayList.get(n);
                elementGroupSetInLegend.updateThisObjectHistory();
            }
            this.updateObjectHistory(arrayList);
            this.addToLatestHistory();
        }
        return true;
    }

    public boolean synchronizeArgument(SGIFigureElement sGIFigureElement) {
        throw new Error("");
    }

    public boolean setISize(SGTuple2f sGTuple2f) {
        super.setISize(sGTuple2f);
        this.drawBackLegend();
        this.createAllDrawingElements();
        return true;
    }

    public boolean zoom(float f) {
        super.zoom(f);
        for (int i = 0; i < this.mGroupSetList.size(); ++i) {
            ElementGroupSetInLegend elementGroupSetInLegend = (ElementGroupSetInLegend)this.mGroupSetList.get(i);
            elementGroupSetInLegend.zoom(f);
        }
        this.createAllDrawingElements();
        return true;
    }

    public boolean getMarginAroundGraphAreaRect(SGTuple2f sGTuple2f, SGTuple2f sGTuple2f2) {
        if (!super.getMarginAroundGraphAreaRect(sGTuple2f, sGTuple2f2)) {
            return false;
        }
        Rectangle2D rectangle2D = this.getGraphAreaRect();
        Rectangle2D rectangle2D2 = this.getLegendRect();
        if (rectangle2D2.getWidth() < Double.MIN_VALUE || rectangle2D2.getHeight() < Double.MIN_VALUE) {
            return true;
        }
        ArrayList<Rectangle2D> arrayList = new ArrayList<Rectangle2D>();
        arrayList.add(rectangle2D);
        arrayList.add(rectangle2D2);
        Rectangle2D rectangle2D3 = SGUtility.createUnion(arrayList);
        float f = (float)(rectangle2D.getY() - rectangle2D3.getY());
        float f2 = (float)(rectangle2D3.getY() + rectangle2D3.getHeight() - (rectangle2D.getY() + rectangle2D.getHeight()));
        float f3 = (float)(rectangle2D.getX() - rectangle2D3.getX());
        float f4 = (float)(rectangle2D3.getX() + rectangle2D3.getWidth() - (rectangle2D.getX() + rectangle2D.getWidth()));
        sGTuple2f.x += f;
        sGTuple2f.y += f2;
        sGTuple2f2.x += f3;
        sGTuple2f2.y += f4;
        return true;
    }

    public boolean onMouseClicked(MouseEvent mouseEvent) {
        if (!super.onMouseClicked(mouseEvent)) {
            return false;
        }
        if (!this.mLegendVisibleFlag) {
            return false;
        }
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        for (int i = 0; i < this.mGroupSetList.size(); ++i) {
            Rectangle2D rectangle2D;
            ElementGroupSetInLegend elementGroupSetInLegend = (ElementGroupSetInLegend)this.mGroupSetList.get(i);
            if (!elementGroupSetInLegend.isVisible() || (rectangle2D = elementGroupSetInLegend.getRect()) == null || !rectangle2D.contains(mouseEvent.getX(), mouseEvent.getY())) continue;
            ArrayList arrayList = elementGroupSetInLegend.mDrawingElementGroupList;
            for (int j = arrayList.size() - 1; j >= 0; --j) {
                SGElementGroup sGElementGroup = (SGElementGroup)arrayList.get(j);
                if (!sGElementGroup.isVisible()) continue;
                SGDrawingElement[] sGDrawingElementArray = sGElementGroup.mDrawingElementArray;
                for (int k = 0; k < sGDrawingElementArray.length; ++k) {
                    boolean bl = sGDrawingElementArray[k].contains(n, n2);
                    if (!bl) continue;
                    if (SwingUtilities.isRightMouseButton(mouseEvent) && mouseEvent.getClickCount() == 1 || !SwingUtilities.isLeftMouseButton(mouseEvent) || mouseEvent.getClickCount() == 2) {
                        // empty if block
                    }
                    return true;
                }
            }
            if (SwingUtilities.isRightMouseButton(mouseEvent) && mouseEvent.getClickCount() == 1) {
                this.mPopupMenu.show(this, mouseEvent.getX(), mouseEvent.getY());
            } else if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 1) {
                Rectangle2D rectangle2D2 = elementGroupSetInLegend.getDrawingStringBounds();
                if (rectangle2D2.contains(n, n2)) {
                    this.showEditField(elementGroupSetInLegend);
                }
            } else if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2) {
                this.getDialog().setVisible(true);
            }
            return true;
        }
        return false;
    }

    public String getFontFamilyName() {
        return this.mFontFamilyName;
    }

    public int getFontStyle() {
        return this.mFontStyle;
    }

    public float getFontSize() {
        return this.mFontSize;
    }

    public float getFrameLineWidth() {
        return this.mFrameLineWidth;
    }

    public Color getFrameLineColor() {
        return this.mFrameLineColor;
    }

    public Color getBackgroundColor() {
        return this.mBackgroundColor;
    }

    public Color getStringColor() {
        return this.mStringColor;
    }

    private boolean showEditField(ElementGroupSetInLegend elementGroupSetInLegend) {
        this.mFocusedGroup = elementGroupSetInLegend;
        Rectangle2D rectangle2D = elementGroupSetInLegend.getRect();
        float f = this.getMagnification() * this.getFontSize();
        this.mEditField.setFont(new Font(this.getFontFamilyName(), this.getFontStyle(), (int)f));
        double d = rectangle2D.getX() + (double)(this.mMagnification * this.mWidthOfDataElement);
        double d2 = rectangle2D.getY() + (rectangle2D.getHeight() - (double)f) / 2.0;
        this.mEditField.setLocation((int)d, (int)d2);
        double d3 = rectangle2D.getWidth() - (double)(this.getMagnification() * this.mWidthOfDataElement);
        this.mEditField.setSize((int)(1.1 * d3), (int)(1.1 * (double)f));
        this.mEditField.setForeground(this.mStringColor);
        this.mEditField.setText(elementGroupSetInLegend.getName());
        this.mEditField.setVisible(true);
        return true;
    }

    private boolean isMoved() {
        boolean bl = (int)this.mLegendX == (int)this.mLegendLocation.getX();
        boolean bl2 = (int)this.mLegendY == (int)this.mLegendLocation.getY();
        boolean bl3 = !bl || !bl2;
        return bl3;
    }

    private boolean terminateEditField() {
        this.commitEdit();
        this.hideEditField();
        this.clearFocusedGroup();
        return true;
    }

    private boolean commitEdit() {
        char c;
        String string = this.mEditField.getText();
        if (string.length() == 0) {
            return false;
        }
        int n = 0;
        if (n < string.length() && ((c = string.charAt(n)) == ' ' || c == '\u3000')) {
            return false;
        }
        String string2 = this.mFocusedGroup.getName();
        String string3 = string;
        this.mFocusedGroup.setName(string3);
        this.drawBackLegend();
        this.createAllDrawingElements();
        if (!string2.equals(string3)) {
            if (!this.mFocusedGroup.updateHistory()) {
                return false;
            }
            this.notifyToRoot();
        }
        this.notifyChange();
        return true;
    }

    private boolean hideEditField() {
        this.mEditField.setText("");
        this.mEditField.setVisible(false);
        return true;
    }

    private boolean clearFocusedGroup() {
        this.mFocusedGroup = null;
        return true;
    }

    public boolean onMousePressed(MouseEvent mouseEvent) {
        if (!super.onMousePressed(mouseEvent)) {
            return false;
        }
        if (!this.mLegendVisibleFlag) {
            return false;
        }
        Rectangle2D rectangle2D = this.getLegendRect();
        if (rectangle2D.contains(mouseEvent.getX(), mouseEvent.getY())) {
            this.mPressedLegendOrigin = new Point((int)((double)mouseEvent.getX() - rectangle2D.getX()), (int)((double)mouseEvent.getY() - rectangle2D.getY()));
            this.mLegendLocation = new Point((int)this.mLegendX, (int)this.mLegendY);
            return true;
        }
        if (this.mEditField.isVisible()) {
            this.terminateEditField();
        }
        this.clearFocusedGroup();
        return false;
    }

    public boolean onMouseDragged(MouseEvent mouseEvent) {
        if (!super.onMouseDragged(mouseEvent)) {
            return false;
        }
        float f = mouseEvent.getX() - this.mPressedLegendOrigin.x;
        float f2 = mouseEvent.getY() - this.mPressedLegendOrigin.y;
        this.setLegendLocation(f, f2);
        return this.createAllDrawingElements();
    }

    public boolean onMouseReleased(MouseEvent mouseEvent) {
        this.drawBackLegend();
        if (this.isMoved()) {
            this.updateHistory();
            this.notifyToRoot();
        }
        this.mPressedLegendOrigin = null;
        return true;
    }

    public boolean chkBoundsVisible() {
        return true;
    }

    public boolean drawBackLegend() {
        return true;
    }

    public Rectangle2D getLegendRect() {
        Rectangle2D.Float float_ = new Rectangle2D.Float(this.getLegendX(), this.getLegendY(), this.mMagnification * this.mLegendWidth, this.mMagnification * this.mLegendHeight);
        return float_;
    }

    public boolean isResizable(double d, double d2) {
        Rectangle2D rectangle2D = this.getLegendRect();
        return !(d < rectangle2D.getWidth()) && !(d2 < rectangle2D.getHeight());
    }

    public void caretUpdate(CaretEvent caretEvent) {
        String string = this.mEditField.getText();
        Font font = new Font(this.getFontFamilyName(), this.getFontStyle(), (int)(this.getFontSize() * this.getMagnification()));
        Rectangle2D rectangle2D = font.getStringBounds(string, new FontRenderContext(null, false, false));
        double d = rectangle2D.getWidth();
        if (d > (double)this.mEditField.getWidth()) {
            this.mEditField.setSize((int)(rectangle2D.getWidth() + (double)(this.getMagnification() * this.getFontSize())), this.mEditField.getHeight());
        }
    }

    public boolean onKeyPressed(KeyEvent keyEvent) {
        return true;
    }

    public boolean onKeyReleased(KeyEvent keyEvent) {
        return true;
    }

    public boolean onKeyTyped(KeyEvent keyEvent) {
        return true;
    }

    public boolean onDrawingElement(int n, int n2) {
        return this.getLegendRect().contains(n, n2);
    }

    public boolean setGraphElement(SGIGraphElement sGIGraphElement) {
        this.mGraphElement = sGIGraphElement;
        return true;
    }

    public boolean setLegendVisible(boolean bl) {
        this.mLegendVisibleFlag = bl;
        return true;
    }

    public boolean setLegendTransparent(boolean bl) {
        this.mLegendTransparentFlag = bl;
        return true;
    }

    public boolean setFrameVisible(boolean bl) {
        this.mFrameVisibleFlag = bl;
        return true;
    }

    public boolean setFrameLineWidth(float f) {
        this.mFrameLineWidth = f;
        return true;
    }

    public boolean setFrameLineColor(Color color) {
        this.mFrameLineColor = color;
        return true;
    }

    public boolean setBackgroundColor(Color color) {
        this.mBackgroundColor = color;
        return true;
    }

    public boolean setFontSize(float f) {
        this.mFontSize = f;
        return true;
    }

    public boolean setFontStyle(int n) {
        this.mFontStyle = n;
        return true;
    }

    public boolean setStringColor(Color color) {
        this.mStringColor = color;
        return true;
    }

    public boolean setFontFamilyName(String string) {
        this.mFontFamilyName = string;
        return true;
    }

    public boolean setWidthOfDataElement(float f) {
        this.mWidthOfDataElement = f;
        return true;
    }

    private SGData getData(ElementGroupSetInLegend elementGroupSetInLegend) {
        for (int i = 0; i < this.mGroupSetList.size(); ++i) {
            ElementGroupSetInLegend elementGroupSetInLegend2 = (ElementGroupSetInLegend)this.mGroupSetList.get(i);
            if (!elementGroupSetInLegend2.equals(elementGroupSetInLegend)) continue;
            SGData sGData = (SGData)this.mDataList.get(i);
            return sGData;
        }
        return null;
    }

    public boolean isLegendVisible() {
        return this.mLegendVisibleFlag;
    }

    public boolean isFrameLineVisible() {
        return this.mFrameVisibleFlag;
    }

    public boolean isLegendTransparent() {
        return this.mLegendTransparentFlag;
    }

    public Rectangle2D getRectOfGroup(SGElementGroup sGElementGroup) {
        for (int i = 0; i < this.mGroupSetList.size(); ++i) {
            ElementGroupSetInLegend elementGroupSetInLegend = (ElementGroupSetInLegend)this.mGroupSetList.get(i);
            ArrayList arrayList = elementGroupSetInLegend.mDrawingElementGroupList;
            for (int j = 0; j < arrayList.size(); ++j) {
                SGElementGroup sGElementGroup2 = (SGElementGroup)arrayList.get(j);
                if (!sGElementGroup2.equals(sGElementGroup)) continue;
                return elementGroupSetInLegend.mDataRect;
            }
        }
        return null;
    }

    public Rectangle2D getRectOfGroupSet(SGElementGroupSet sGElementGroupSet) {
        for (int i = 0; i < this.mGroupSetList.size(); ++i) {
            ElementGroupSetInLegend elementGroupSetInLegend = (ElementGroupSetInLegend)this.mGroupSetList.get(i);
            if (!sGElementGroupSet.equals(elementGroupSetInLegend)) continue;
            return elementGroupSetInLegend.mDataRect;
        }
        return null;
    }

    private ElementGroupLine getGroupLine(ElementGroupSetInLegend elementGroupSetInLegend) {
        ArrayList arrayList = elementGroupSetInLegend.mDrawingElementGroupList;
        for (int i = 0; i < arrayList.size(); ++i) {
            SGElementGroup sGElementGroup = (SGElementGroup)arrayList.get(i);
            if (!(sGElementGroup instanceof ElementGroupLine)) continue;
            return (ElementGroupLine)sGElementGroup;
        }
        return null;
    }

    private ElementGroupBar getGroupBar(ElementGroupSetInLegend elementGroupSetInLegend) {
        ArrayList arrayList = elementGroupSetInLegend.mDrawingElementGroupList;
        for (int i = 0; i < arrayList.size(); ++i) {
            SGElementGroup sGElementGroup = (SGElementGroup)arrayList.get(i);
            if (!(sGElementGroup instanceof ElementGroupBar)) continue;
            return (ElementGroupBar)sGElementGroup;
        }
        return null;
    }

    private ElementGroupSymbol getGroupSymbol(ElementGroupSetInLegend elementGroupSetInLegend) {
        ArrayList arrayList = elementGroupSetInLegend.mDrawingElementGroupList;
        for (int i = 0; i < arrayList.size(); ++i) {
            SGElementGroup sGElementGroup = (SGElementGroup)arrayList.get(i);
            if (!(sGElementGroup instanceof ElementGroupSymbol)) continue;
            return (ElementGroupSymbol)sGElementGroup;
        }
        return null;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        Object object = actionEvent.getSource();
        if (object.equals(this.mEditField)) {
            this.terminateEditField();
            return;
        }
        if (string.equals(MENUCMD_HIDE)) {
            this.setLegendVisible(false);
            this.updateHistory();
            this.notifyToRoot();
            this.repaint();
            return;
        }
        if (string.equals("Property")) {
            this.getDialog().setVisible(true);
        }
        if (string.equals("OK") || this.mDialog.getActiveComponentList().contains(object) ? !this.onOK() : (string.equals("Cancel") ? !this.onCanceled() : string.equals("Preview") && !this.onPreviewed())) {
            return;
        }
    }

    private boolean onOK() {
        boolean bl = this.setPropertyWithDialog();
        if (!bl) {
            return false;
        }
        SGProperties sGProperties = this.mTemporaryProperties;
        SGProperties sGProperties2 = this.getProperties();
        if (!sGProperties.equals(sGProperties2)) {
            this.updateHistory();
            this.notifyToRoot();
        }
        this.mTemporaryProperties = null;
        this.mDialog.setVisible(false);
        this.createAllDrawingElements();
        this.notifyChange();
        return true;
    }

    public boolean addPropertiesHistory(SGProperties sGProperties) {
        if (!(sGProperties instanceof LegendCommonProperties)) {
            return false;
        }
        super.addPropertiesHistory(sGProperties);
        return true;
    }

    private boolean onCanceled() {
        boolean bl = this.recover();
        if (!bl) {
            return false;
        }
        this.mTemporaryProperties = null;
        this.mDialog.setVisible(false);
        this.createAllDrawingElements();
        this.notifyChange();
        return true;
    }

    private boolean onPreviewed() {
        boolean bl = this.setPropertyWithDialog();
        if (!bl) {
            return false;
        }
        this.createAllDrawingElements();
        this.notifyChange();
        return true;
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        Object object = windowEvent.getSource();
        if (object.equals(this.mDialog)) {
            this.onCanceled();
        }
    }

    public boolean undo() {
        boolean bl = super.undo();
        if (!bl) {
            return false;
        }
        this.createAllDrawingElements();
        this.notifyChange();
        return true;
    }

    public boolean redo() {
        boolean bl = super.redo();
        if (!bl) {
            return false;
        }
        this.createAllDrawingElements();
        this.notifyChange();
        return true;
    }

    public boolean recover() {
        return this.setProperties(this.mTemporaryProperties);
    }

    protected SGElementGroupSet getElementGroupSet(SGData sGData) {
        for (int i = 0; i < this.mDataList.size(); ++i) {
            SGData sGData2 = (SGData)this.mDataList.get(i);
            if (!sGData2.equals(sGData)) continue;
            SGElementGroupSet sGElementGroupSet = (SGElementGroupSet)this.mGroupSetList.get(i);
            return sGElementGroupSet;
        }
        return null;
    }

    protected SGData getData(SGElementGroupSet sGElementGroupSet) {
        for (int i = 0; i < this.mGroupSetList.size(); ++i) {
            SGElementGroupSet sGElementGroupSet2 = (SGElementGroupSet)this.mGroupSetList.get(i);
            if (!sGElementGroupSet2.equals(sGElementGroupSet)) continue;
            SGData sGData = (SGData)this.mDataList.get(i);
            return sGData;
        }
        return null;
    }

    public boolean createDataObject(BufferedReader bufferedReader, SGData sGData) throws IOException {
        super.createDataObject(bufferedReader, sGData);
        ElementGroupSetInLegend elementGroupSetInLegend = this.createLegendElement(sGData);
        if (elementGroupSetInLegend == null) {
            return false;
        }
        this.mGroupSetList.add(elementGroupSetInLegend);
        this.createAllDrawingElements();
        return true;
    }

    public boolean writeProperty(Writer writer) throws IOException {
        writer.write("[Legend]\n");
        SGUtilityText.writePropertyLine(writer, "Legend Visible", new Boolean(this.mLegendVisibleFlag));
        SGUtilityText.writePropertyLine(writer, "Legend X", new Float(this.mLegendX * 0.035277776f));
        SGUtilityText.writePropertyLine(writer, "Legend Y", new Float(this.mLegendY * 0.035277776f));
        SGUtilityText.writePropertyLine(writer, "Frame Visible", new Boolean(this.mFrameVisibleFlag));
        SGUtilityText.writePropertyLine(writer, "Frame Line Width", new Float(this.mFrameLineWidth));
        SGUtilityText.writeColorPropertyLine(writer, "Frame Line Color", this.mFrameLineColor);
        SGUtilityText.writeColorPropertyLine(writer, "Background Color", this.mBackgroundColor);
        SGUtilityText.writePropertyLine(writer, "Background Transparent", new Boolean(this.mLegendTransparentFlag));
        SGUtilityText.writePropertyLine(writer, "Font Family Name", this.mFontFamilyName);
        SGUtilityText.writePropertyLine(writer, "Font Size", new Float(this.mFontSize));
        SGUtilityText.writePropertyLine(writer, "Font Style", SGUtilityText.getFontStyleName(this.mFontStyle));
        SGUtilityText.writeColorPropertyLine(writer, "String Color", this.mStringColor);
        writer.write("\n\n");
        return true;
    }

    public boolean readProperty(BufferedReader bufferedReader) throws IOException {
        LegendCommonProperties legendCommonProperties = this.readProperties(bufferedReader);
        if (legendCommonProperties == null) {
            return false;
        }
        return this.setProperties(legendCommonProperties);
    }

    private boolean updateParentHistoryFromElementGroupSet(SGIUndoable sGIUndoable) {
        this.updateParentHistory();
        this.updateObjectHistory(sGIUndoable);
        return true;
    }

    private LegendCommonProperties readProperties(BufferedReader bufferedReader) throws IOException {
        String string = null;
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return null;
        }
        Boolean bl = SGUtilityText.getBooleanPropertyFromLine(string, "Legend Visible");
        if (bl == null) {
            return null;
        }
        boolean bl2 = bl;
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return null;
        }
        Double d = SGUtilityText.getDoublePropertyFromLine(string, "Legend X");
        if (d == null) {
            return null;
        }
        float f = d.floatValue() / 0.035277776f;
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return null;
        }
        Double d2 = SGUtilityText.getDoublePropertyFromLine(string, "Legend Y");
        if (d2 == null) {
            return null;
        }
        float f2 = d2.floatValue() / 0.035277776f;
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return null;
        }
        Boolean bl3 = SGUtilityText.getBooleanPropertyFromLine(string, "Frame Visible");
        if (bl3 == null) {
            return null;
        }
        boolean bl4 = bl3;
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return null;
        }
        Double d3 = SGUtilityText.getDoublePropertyFromLine(string, "Frame Line Width");
        if (d3 == null) {
            return null;
        }
        float f3 = d3.floatValue();
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return null;
        }
        Color color = SGUtilityText.getColorPropertyFromLine(string, "Frame Line Color");
        if (color == null) {
            return null;
        }
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return null;
        }
        Color color2 = SGUtilityText.getColorPropertyFromLine(string, "Background Color");
        if (color2 == null) {
            return null;
        }
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return null;
        }
        Boolean bl5 = SGUtilityText.getBooleanPropertyFromLine(string, "Background Transparent");
        if (bl5 == null) {
            return null;
        }
        boolean bl6 = bl5;
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return null;
        }
        String string2 = SGUtilityText.getPropertyFromLine(string, "Font Family Name");
        if (string2 == null) {
            return null;
        }
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return null;
        }
        Double d4 = SGUtilityText.getDoublePropertyFromLine(string, "Font Size");
        if (d4 == null) {
            return null;
        }
        float f4 = d4.floatValue();
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return null;
        }
        Integer n = SGUtilityText.getFontStyleFromLine(string, "Font Style");
        if (n == null) {
            return null;
        }
        int n2 = n;
        string = SGUtilityText.readLine(bufferedReader);
        if (string == null) {
            return null;
        }
        Color color3 = SGUtilityText.getColorPropertyFromLine(string, "String Color");
        if (color3 == null) {
            return null;
        }
        LegendCommonProperties legendCommonProperties = new LegendCommonProperties();
        legendCommonProperties.visible = bl2;
        legendCommonProperties.x = f;
        legendCommonProperties.y = f2;
        legendCommonProperties.frameLineVisible = bl4;
        legendCommonProperties.frameLineWidth = f3;
        legendCommonProperties.frameLineColor = color;
        legendCommonProperties.backgroundColor = color2;
        legendCommonProperties.transparent = bl6;
        legendCommonProperties.fontFamilyName = string2;
        legendCommonProperties.fontSize = f4;
        legendCommonProperties.fontStyle = n2;
        legendCommonProperties.stringColor = color3;
        return legendCommonProperties;
    }

    public static class LegendCommonProperties
    extends SGProperties {
        float x;
        float y;
        boolean visible;
        boolean frameLineVisible;
        float frameLineWidth;
        Color frameLineColor;
        String fontFamilyName;
        float fontSize;
        int fontStyle;
        Color stringColor;
        Color backgroundColor;
        boolean transparent;

        public boolean equals(Object object) {
            if (!(object instanceof LegendCommonProperties)) {
                return false;
            }
            LegendCommonProperties legendCommonProperties = (LegendCommonProperties)object;
            if (legendCommonProperties.x != this.x) {
                return false;
            }
            if (legendCommonProperties.y != this.y) {
                return false;
            }
            if (legendCommonProperties.visible != this.visible) {
                return false;
            }
            if (legendCommonProperties.frameLineVisible != this.frameLineVisible) {
                return false;
            }
            if (legendCommonProperties.frameLineWidth != this.frameLineWidth) {
                return false;
            }
            if (!legendCommonProperties.frameLineColor.equals(this.frameLineColor)) {
                return false;
            }
            if (!legendCommonProperties.fontFamilyName.equals(this.fontFamilyName)) {
                return false;
            }
            if (legendCommonProperties.fontSize != this.fontSize) {
                return false;
            }
            if (legendCommonProperties.fontStyle != this.fontStyle) {
                return false;
            }
            if (!legendCommonProperties.stringColor.equals(this.stringColor)) {
                return false;
            }
            if (!legendCommonProperties.backgroundColor.equals(this.backgroundColor)) {
                return false;
            }
            return legendCommonProperties.transparent == this.transparent;
        }

        public String toString() {
            String string = new String("[");
            string = string + new String("x=" + this.x + ", ");
            string = string + new String("y=" + this.y + ", ");
            string = string + new String("visible=" + this.visible + ", ");
            string = string + new String("frameLineVisible=" + this.frameLineVisible + ", ");
            string = string + new String("frameLineWidth=" + this.frameLineWidth + ", ");
            string = string + new String("frameLineColor=" + this.frameLineColor + ", ");
            string = string + new String("fontFamilyName=" + this.fontFamilyName + ", ");
            string = string + new String("fontSize=" + this.fontSize + ", ");
            string = string + new String("fontStyle=" + this.fontStyle + ", ");
            string = string + new String("stringColor=" + this.stringColor + ", ");
            string = string + new String("innerColor=" + this.backgroundColor + ", ");
            string = string + new String("transparent=" + this.transparent + ", ");
            string = string + new String("]");
            return string;
        }
    }

    class ElementGroupArrow
    extends SGElementGroupArrow
    implements ILegendElement {
        protected ElementGroupArrow() {
        }

        public float getDataElementWidth() {
            return this.mMagnification * SGLegendElement.this.mWidthOfDataElement;
        }

        public float getDataElementHeight() {
            return 0.0f;
        }

        public int getNumberOfPoints() {
            return 1;
        }

        public boolean createDrawingElementInLegend() {
            Rectangle2D rectangle2D = SGLegendElement.this.getRectOfGroupSet(this.mGroupSet);
            SGTuple2f sGTuple2f = new SGTuple2f();
            sGTuple2f.x = (float)rectangle2D.getX() + 0.1f * this.mMagnification * SGLegendElement.this.mWidthOfDataElement;
            sGTuple2f.y = (float)rectangle2D.getY() + 0.5f * (float)rectangle2D.getHeight();
            SGTuple2f sGTuple2f2 = new SGTuple2f();
            sGTuple2f2.x = sGTuple2f.x + 0.8f * this.mMagnification * SGLegendElement.this.mWidthOfDataElement;
            sGTuple2f2.y = sGTuple2f.y;
            SGTuple2f[] sGTuple2fArray = new SGTuple2f[]{sGTuple2f};
            SGTuple2f[] sGTuple2fArray2 = new SGTuple2f[]{sGTuple2f2};
            return this.setLocation(sGTuple2fArray, sGTuple2fArray2);
        }

        Rectangle2D getDataElementBounds() {
            Rectangle2D.Double double_ = new Rectangle2D.Double();
            return double_;
        }
    }

    class ElementGroupSymbol
    extends SGElementGroupSymbol
    implements ILegendElement {
        protected ElementGroupSymbol() {
            if (!this.init()) {
                throw new Error();
            }
        }

        private boolean init() {
            this.setVisible(false);
            Integer n = SGDrawingElementSymbol.getSymbolTypeFromName("Circle");
            if (n == null) {
                return false;
            }
            this.setType(n);
            this.setSize(8.503938f);
            this.setColor(SGDefaultValues.SYMBOL_BODY_COLOR);
            this.setLineWidth(1.0f);
            this.setLineColor(SGDefaultValues.SYMBOL_LINE_COLOR);
            return true;
        }

        public float getDataElementWidth() {
            float f;
            float f2 = this.mMagnification * SGLegendElement.this.mWidthOfDataElement;
            if (f2 < (f = this.getDataElementSize())) {
                return f;
            }
            return f2;
        }

        public float getDataElementHeight() {
            return 1.5f * this.getDataElementSize();
        }

        private float getDataElementSize() {
            if (this.mDrawingElementArray != null) {
                if (this.mDrawingElementArray.length == 0) {
                    return 0.0f;
                }
                SGDrawingElementSymbol2D sGDrawingElementSymbol2D = (SGDrawingElementSymbol2D)this.mDrawingElementArray[0];
                Rectangle2D rectangle2D = sGDrawingElementSymbol2D.getElementBounds().getBounds2D();
                return (float)rectangle2D.getHeight();
            }
            return 0.0f;
        }

        public int getNumberOfPoints() {
            return 1;
        }

        public boolean createDrawingElementInLegend() {
            Rectangle2D rectangle2D = SGLegendElement.this.getRectOfGroupSet(this.mGroupSet);
            SGTuple2f sGTuple2f = new SGTuple2f();
            sGTuple2f.x = (float)rectangle2D.getX() + 0.5f * this.mMagnification * SGLegendElement.this.mWidthOfDataElement;
            sGTuple2f.y = (float)rectangle2D.getY() + 0.5f * (float)rectangle2D.getHeight();
            SGTuple2f[] sGTuple2fArray = new SGTuple2f[]{sGTuple2f};
            this.setLocation(sGTuple2fArray);
            return true;
        }
    }

    class ElementGroupBar
    extends SGElementGroupBar
    implements ILegendElement {
        protected ElementGroupBar() {
            if (!this.init()) {
                throw new Error();
            }
        }

        private boolean init() {
            this.setVisible(false);
            this.setBaselineValue(0.0);
            this.setRectangleWidth(14.173229f);
            this.setColor(SGDefaultValues.BAR_COLOR);
            this.setEdgeLineWidth(0.5f);
            this.setEdgeLineColor(SGDefaultValues.BAR_LINE_COLOR);
            return true;
        }

        public float getDataElementWidth() {
            return this.mMagnification * SGLegendElement.this.mWidthOfDataElement;
        }

        public float getDataElementHeight() {
            return 1.5f * this.mRectangleWidth * this.mMagnification;
        }

        public int getNumberOfPoints() {
            return 1;
        }

        public boolean createDrawingElementInLegend() {
            Rectangle2D rectangle2D = SGLegendElement.this.getRectOfGroupSet(this.mGroupSet);
            float f = this.mMagnification * this.mRectangleWidth;
            SGTuple2f sGTuple2f = new SGTuple2f();
            sGTuple2f.x = (float)rectangle2D.getX() + 0.2f * this.getDataElementWidth();
            sGTuple2f.y = (float)rectangle2D.getY() + 0.5f * (float)rectangle2D.getHeight() - 0.5f * f;
            SGTuple2f[] sGTuple2fArray = new SGTuple2f[]{sGTuple2f};
            this.setLocation(sGTuple2fArray);
            return true;
        }

        public boolean setLocation(SGTuple2f[] sGTuple2fArray) {
            if (this.mDrawingElementArray == null) {
                return true;
            }
            if (sGTuple2fArray.length != this.mDrawingElementArray.length) {
                throw new IllegalArgumentException();
            }
            for (int i = 0; i < this.mDrawingElementArray.length; ++i) {
                SGDrawingElementBar2D sGDrawingElementBar2D = (SGDrawingElementBar2D)this.mDrawingElementArray[i];
                SGTuple2f sGTuple2f = sGTuple2fArray[i];
                sGDrawingElementBar2D.setBounds(sGTuple2f.x, sGTuple2f.y, 0.6f * this.getDataElementWidth(), this.mMagnification * this.mRectangleWidth);
            }
            return true;
        }
    }

    class ElementGroupLine
    extends SGElementGroupLine
    implements ILegendElement {
        protected ElementGroupLine() {
            if (!this.init()) {
                throw new Error();
            }
        }

        private boolean init() {
            this.setVisible(true);
            this.setLineWidth(1.0f);
            Integer n = SGDrawingElementLine.getLineTypeFromName("Solid");
            if (n == null) {
                return false;
            }
            this.setLineType(n);
            this.setColor(SGDefaultValues.LINE_COLOR);
            return true;
        }

        public float getDataElementWidth() {
            return this.mMagnification * SGLegendElement.this.mWidthOfDataElement;
        }

        public float getDataElementHeight() {
            return 1.5f * this.mMagnification * this.mLineWidth;
        }

        public int getNumberOfPoints() {
            return 2;
        }

        public boolean createDrawingElementInLegend() {
            Rectangle2D rectangle2D = SGLegendElement.this.getRectOfGroupSet(this.mGroupSet);
            SGTuple2f sGTuple2f = new SGTuple2f();
            sGTuple2f.x = (float)rectangle2D.getX() + 0.1f * this.getDataElementWidth();
            sGTuple2f.y = (float)rectangle2D.getY() + 0.5f * (float)rectangle2D.getHeight();
            SGTuple2f sGTuple2f2 = new SGTuple2f();
            sGTuple2f2.x = sGTuple2f.x + 0.8f * this.mMagnification * SGLegendElement.this.mWidthOfDataElement;
            sGTuple2f2.y = sGTuple2f.y;
            SGTuple2f[] sGTuple2fArray = new SGTuple2f[]{sGTuple2f, sGTuple2f2};
            this.setLocation(sGTuple2fArray);
            return true;
        }
    }

    class ElementGroupSetInLegendVXY
    extends ElementGroupSetInLegend {
        protected SGPropertyDialogVXYData mDialog = null;

        protected ElementGroupSetInLegendVXY() {
        }
    }

    class ElementGroupSetInLegendSXY
    extends ElementGroupSetInLegend {
        protected SGPropertyDialogSXYData mDialog = null;

        protected ElementGroupSetInLegendSXY() {
        }
    }

    class ElementGroupSetInLegend
    extends SGElementGroupSetInFigureElement
    implements ActionListener,
    SGIUndoable {
        protected final String SET_FONT_SIZE = "Set font size";
        private final String SET_FONT_STYLE = "Set font style";
        protected final String SET_FONT_FAMILY_NAME = "Set font family name";
        protected final String SET_STRING_COLOR = "Set the color of string";
        protected Rectangle2D mDataRect = null;
        protected SGDrawingElementString2DExtended mDrawingString = null;
        protected JPopupMenu mPopupMenu = new JPopupMenu();
        private SGTuple2f[] mPointsArray = null;
        private ArrayList mElementGroupSetPropertyHistoryList = new ArrayList();
        private int mElementGroupSetStateCounter = 0;
        private int mCurrentStateCounter = 0;
        protected ArrayList mUndoableObjectHistoryList = new ArrayList();

        protected ElementGroupSetInLegend() {
            this.createPopupMenu();
        }

        public void setVisible(boolean bl) {
            this.mVisibleFlag = bl;
        }

        public boolean isVisible() {
            return this.mVisibleFlag;
        }

        private boolean createDrawingString() {
            String string = this.mName + " ";
            this.mDrawingString = new SGDrawingElementString2DExtended(string, SGLegendElement.this.mFontFamilyName, SGLegendElement.this.mFontStyle, SGLegendElement.this.mFontSize);
            this.mDrawingString.setColor(SGLegendElement.this.mStringColor);
            this.mDrawingString.setMagnification(this.mMagnification);
            return true;
        }

        private boolean paintString(Graphics2D graphics2D) {
            if (this.mDrawingString != null) {
                this.mDrawingString.drawString(graphics2D);
            }
            return true;
        }

        private Rectangle2D getDrawingStringBounds() {
            if (this.mDrawingString == null) {
                return null;
            }
            Rectangle2D rectangle2D = this.mDrawingString.getElementBounds();
            return rectangle2D;
        }

        private Rectangle2D getRect() {
            if (this.mDataRect == null) {
                return null;
            }
            float f = (float)this.mDataRect.getX();
            float f2 = (float)this.mDataRect.getY();
            float f3 = (float)this.mDataRect.getWidth();
            float f4 = (float)this.mDataRect.getHeight();
            return new Rectangle2D.Float(f, f2, f3, f4);
        }

        public float getMaxDataElementWidth() {
            float f = 0.0f;
            for (int i = 0; i < this.mDrawingElementGroupList.size(); ++i) {
                ILegendElement iLegendElement = (ILegendElement)this.mDrawingElementGroupList.get(i);
                float f2 = iLegendElement.getDataElementWidth();
                if (!(f2 > f)) continue;
                f = f2;
            }
            return f;
        }

        public double getMaxDataElementHeight() {
            double d = 0.0;
            for (int i = 0; i < this.mDrawingElementGroupList.size(); ++i) {
                ILegendElement iLegendElement = (ILegendElement)this.mDrawingElementGroupList.get(i);
                double d2 = iLegendElement.getDataElementHeight();
                if (!(d2 > d)) continue;
                d = d2;
            }
            return d;
        }

        public boolean onDrawingElement(int n, int n2) {
            return this.mDataRect.contains(n, n2);
        }

        private boolean createDrawingElement() {
            for (int i = 0; i < this.mDrawingElementGroupList.size(); ++i) {
                ILegendElement iLegendElement = (ILegendElement)this.mDrawingElementGroupList.get(i);
                iLegendElement.createDrawingElementInLegend();
            }
            return true;
        }

        public void paintGraphics2D(Graphics2D graphics2D) {
            ElementGroupSymbol elementGroupSymbol;
            ElementGroupLine elementGroupLine;
            graphics2D.setPaint(SGLegendElement.this.mStringColor);
            this.paintString(graphics2D);
            ElementGroupBar elementGroupBar = SGLegendElement.this.getGroupBar(this);
            if (elementGroupBar != null && elementGroupBar.isVisible()) {
                elementGroupBar.paintElement(graphics2D);
            }
            if ((elementGroupLine = SGLegendElement.this.getGroupLine(this)) != null && elementGroupLine.isVisible()) {
                elementGroupLine.paintElement(graphics2D);
            }
            if ((elementGroupSymbol = SGLegendElement.this.getGroupSymbol(this)) != null && elementGroupSymbol.isVisible()) {
                elementGroupSymbol.paintElement(graphics2D);
            }
        }

        protected boolean clickDrawingElements(MouseEvent mouseEvent) {
            return false;
        }

        protected boolean createPopupMenu() {
            return true;
        }

        private JPopupMenu getPopupMenu() {
            return this.mPopupMenu;
        }

        public boolean addDrawingElementGroup(int n) {
            SGElementGroup sGElementGroup = null;
            if (n == 0) {
                sGElementGroup = new ElementGroupLine();
            } else if (n == 2) {
                sGElementGroup = new ElementGroupBar();
            } else if (n == 1) {
                sGElementGroup = new ElementGroupSymbol();
            } else if (n == 3) {
                sGElementGroup = new ElementGroupArrow();
            } else {
                throw new Error("");
            }
            this.addDrawingElementGroup(sGElementGroup);
            return true;
        }

        public boolean addDrawingElementGroup(SGDrawingElement sGDrawingElement) {
            SGElementGroup sGElementGroup = null;
            if (sGDrawingElement instanceof SGDrawingElementLine) {
                sGElementGroup = new ElementGroupLine();
            } else if (sGDrawingElement instanceof SGDrawingElementBar) {
                sGElementGroup = new ElementGroupBar();
            } else if (sGDrawingElement instanceof SGDrawingElementSymbol) {
                sGElementGroup = new ElementGroupSymbol();
            } else if (sGDrawingElement instanceof SGDrawingElementArrow) {
                sGElementGroup = new ElementGroupArrow();
            } else {
                throw new Error("");
            }
            ((SGElementGroup)sGElementGroup).setProperty(sGDrawingElement);
            sGElementGroup.setMagnification(this.mMagnification);
            this.addDrawingElementGroup(sGElementGroup);
            SGLegendElement.this.createAllDrawingElements();
            return true;
        }

        private boolean addDrawingElementGroup(SGElementGroup sGElementGroup) {
            sGElementGroup.mGroupSet = this;
            ILegendElement iLegendElement = (ILegendElement)((Object)sGElementGroup);
            sGElementGroup.initDrawingElement(iLegendElement.getNumberOfPoints());
            if (!sGElementGroup.setPropertiesOfDrawingElements()) {
                return false;
            }
            sGElementGroup.setMagnification(this.mMagnification);
            this.mDrawingElementGroupList.add(sGElementGroup);
            return true;
        }

        public boolean writePropertyOfData(Writer writer) throws IOException {
            return true;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            Object object = actionEvent.getSource();
            SGLegendElement.this.createAllDrawingElements();
            SGLegendElement.this.notifyChange();
        }

        public boolean setProperties(SGProperties sGProperties) {
            SGElementGroupSet.ElementGroupSetProperties elementGroupSetProperties = (SGElementGroupSet.ElementGroupSetProperties)sGProperties;
            elementGroupSetProperties.visible = this.isVisible();
            return super.setProperties(elementGroupSetProperties);
        }

        public boolean initPropertiesHistory() {
            this.addElementGroupSetPropertyHistory((SGElementGroupSet.WholeProperties)this.getWholeProperties());
            return true;
        }

        private boolean addElementGroupSetPropertyHistory(SGElementGroupSet.WholeProperties wholeProperties) {
            ArrayList arrayList = new ArrayList();
            for (int i = 0; i < this.mElementGroupSetStateCounter; ++i) {
                arrayList.add(this.mElementGroupSetPropertyHistoryList.get(i));
            }
            arrayList.add(wholeProperties);
            this.mElementGroupSetPropertyHistoryList = arrayList;
            return true;
        }

        public boolean undo() {
            --this.mElementGroupSetStateCounter;
            SGElementGroupSet.WholeProperties wholeProperties = (SGElementGroupSet.WholeProperties)this.mElementGroupSetPropertyHistoryList.get(this.mElementGroupSetStateCounter);
            this.setWholeProperties(wholeProperties);
            SGLegendElement.this.createAllDrawingElements();
            return true;
        }

        public boolean redo() {
            ++this.mElementGroupSetStateCounter;
            SGElementGroupSet.WholeProperties wholeProperties = (SGElementGroupSet.WholeProperties)this.mElementGroupSetPropertyHistoryList.get(this.mElementGroupSetStateCounter);
            this.setWholeProperties(wholeProperties);
            SGLegendElement.this.createAllDrawingElements();
            return true;
        }

        public boolean onUndo() {
            return this.undo();
        }

        public boolean onRedo() {
            return this.redo();
        }

        public boolean updateObjectHistory(SGIUndoable sGIUndoable) {
            ArrayList<SGIUndoable> arrayList = new ArrayList<SGIUndoable>();
            arrayList.add(sGIUndoable);
            boolean bl = this.updateObjectHistory(arrayList);
            return bl;
        }

        public boolean updateObjectHistory(ArrayList arrayList) {
            ArrayList arrayList2 = new ArrayList();
            for (int i = 0; i < this.mCurrentStateCounter; ++i) {
                Object e = this.mUndoableObjectHistoryList.get(i);
                arrayList2.add(e);
            }
            arrayList2.add(new ArrayList(arrayList));
            this.mUndoableObjectHistoryList = arrayList2;
            ++this.mCurrentStateCounter;
            return true;
        }

        public boolean updateHistory() {
            this.updateParentHistory();
            this.updateThisObjectHistory();
            return true;
        }

        public boolean updateThisObjectHistory() {
            this.updateObjectHistory(this);
            ++this.mElementGroupSetStateCounter;
            this.addElementGroupSetPropertyHistory((SGElementGroupSet.WholeProperties)this.getWholeProperties());
            return true;
        }

        public boolean updateParentHistory() {
            return SGLegendElement.this.updateParentHistoryFromElementGroupSet(this);
        }

        public void notifyToRoot() {
            SGLegendElement.this.notifyToRootFromFigureElement();
        }
    }

    static interface ILegendElement {
        public float getDataElementWidth();

        public float getDataElementHeight();

        public boolean createDrawingElementInLegend();

        public int getNumberOfPoints();
    }
}

