/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.application;

import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.JTextComponent;
import jp.riken.brain.ni.samuraigraph.application.SGWizardDialog;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;

public class SGFigureIDSelectionWizardDialog
extends SGWizardDialog
implements CaretListener {
    public static final String TITLE = "Figure ID";
    private JPanel mButtonPanel;
    private JButton mCancelButton;
    private JLabel mFigureIDLabel;
    protected JTextField mFigureIDTextField;
    private JButton mNextButton;
    private JButton mOKButton;
    private JPanel mPanel;
    private JButton mPreviousButton;

    public SGFigureIDSelectionWizardDialog() {
        this.initComponents();
        this.initProperty();
    }

    public SGFigureIDSelectionWizardDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
        this.initProperty();
    }

    private void initComponents() {
        this.mButtonPanel = new JPanel();
        this.mPreviousButton = new JButton();
        this.mNextButton = new JButton();
        this.mOKButton = new JButton();
        this.mCancelButton = new JButton();
        this.mPanel = new JPanel();
        this.mFigureIDLabel = new JLabel();
        this.mFigureIDTextField = new JTextField();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(2);
        this.mPreviousButton.setFont(new Font("Dialog", 1, 12));
        this.mPreviousButton.setText("<Prev");
        this.mButtonPanel.add(this.mPreviousButton);
        this.mNextButton.setFont(new Font("Dialog", 1, 12));
        this.mNextButton.setText("Next>");
        this.mButtonPanel.add(this.mNextButton);
        this.mOKButton.setFont(new Font("Dialog", 1, 12));
        this.mOKButton.setText("OK");
        this.mButtonPanel.add(this.mOKButton);
        this.mCancelButton.setFont(new Font("Dialog", 1, 12));
        this.mCancelButton.setText("Cancel");
        this.mButtonPanel.add(this.mCancelButton);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 13;
        this.getContentPane().add((Component)this.mButtonPanel, gridBagConstraints);
        this.mPanel.setLayout(new GridBagLayout());
        this.mPanel.setBorder(new TitledBorder(null, "Input the Figure ID", 0, 0, new Font("Dialog", 1, 12)));
        this.mFigureIDLabel.setFont(new Font("Dialog", 0, 12));
        this.mFigureIDLabel.setText(TITLE);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 20, 10, 5);
        this.mPanel.add((Component)this.mFigureIDLabel, gridBagConstraints);
        this.mFigureIDTextField.setColumns(3);
        this.mFigureIDTextField.setFont(new Font("Dialog", 0, 12));
        this.mFigureIDTextField.setText("1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 10, 20);
        this.mPanel.add((Component)this.mFigureIDTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.getContentPane().add((Component)this.mPanel, gridBagConstraints);
        this.pack();
    }

    private boolean initProperty() {
        this.setTitle(TITLE);
        this.mFigureIDTextField.addCaretListener(this);
        this.getPreviousButton().addActionListener(this);
        this.getNextButton().addActionListener(this);
        this.getOKButton().addActionListener(this);
        this.getCancelButton().addActionListener(this);
        return true;
    }

    public int getFigureID() {
        String string = this.getFigureIDString();
        Integer n = SGUtilityText.getInteger(string);
        if (n == null) {
            return -1;
        }
        int n2 = n;
        return n2;
    }

    public String getFigureIDString() {
        return this.mFigureIDTextField.getText();
    }

    public boolean setFigureID(int n) {
        this.mFigureIDTextField.setText(Integer.toString(n));
        return true;
    }

    public void caretUpdate(CaretEvent caretEvent) {
        Object object = caretEvent.getSource();
        if (object.equals(this.mFigureIDTextField)) {
            float f;
            int n;
            JTextComponent jTextComponent = (JTextComponent)object;
            String string = jTextComponent.getText();
            Float f2 = SGUtilityText.getFloat(string);
            boolean bl = false;
            if (f2 != null && (n = (int)(f = f2.floatValue())) > 0) {
                bl = true;
            }
            this.mNextButton.setEnabled(bl);
        }
    }

    protected JButton getPreviousButton() {
        return this.mPreviousButton;
    }

    protected JButton getNextButton() {
        return this.mNextButton;
    }

    protected JButton getOKButton() {
        return this.mOKButton;
    }

    protected JButton getCancelButton() {
        return this.mCancelButton;
    }
}

