/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.application;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import jp.riken.brain.ni.samuraigraph.base.SGDialog;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingWindow;

public abstract class SGWizardDialog
extends SGDialog {
    private SGWizardDialog mPreviousWizardDialog = null;
    private SGWizardDialog mNextWizardDialog = null;

    public SGWizardDialog() {
        this.init();
    }

    public SGWizardDialog(Frame frame) {
        super(frame);
        this.init();
    }

    public SGWizardDialog(Frame frame, String string) {
        super(frame, string);
        this.init();
    }

    public SGWizardDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.init();
    }

    public SGWizardDialog(Frame frame, String string, boolean bl) {
        super(frame, string, bl);
        this.init();
    }

    private boolean init() {
        return true;
    }

    public SGDrawingWindow getOwnerWindow() {
        Window window = this.getOwner();
        SGDrawingWindow sGDrawingWindow = null;
        if (window instanceof SGDrawingWindow) {
            sGDrawingWindow = (SGDrawingWindow)window;
        }
        return sGDrawingWindow;
    }

    public SGWizardDialog getPrevious() {
        return this.mPreviousWizardDialog;
    }

    public SGWizardDialog getNext() {
        return this.mNextWizardDialog;
    }

    public boolean setPrevious(SGWizardDialog sGWizardDialog) {
        this.mPreviousWizardDialog = sGWizardDialog;
        return true;
    }

    public boolean setNext(SGWizardDialog sGWizardDialog) {
        this.mNextWizardDialog = sGWizardDialog;
        return true;
    }

    public void windowClosing(WindowEvent windowEvent) {
        super.windowClosing(windowEvent);
        this.close(windowEvent);
    }

    protected void close(WindowEvent windowEvent) {
        Object object = windowEvent.getSource();
        if (object.equals(this)) {
            this.onCanceled();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        AbstractButton abstractButton = (AbstractButton)object;
        if (object.equals(this.getOKButton())) {
            this.onOK();
        } else if (object.equals(this.getCancelButton())) {
            this.onCanceled();
        } else if (object.equals(this.getPreviousButton())) {
            this.onPrevious();
        } else if (object.equals(this.getNextButton())) {
            this.onNext();
        }
    }

    protected boolean onOK() {
        this.setCloseOption(0);
        this.setVisible(false);
        this.notifyToListener("OK");
        return true;
    }

    protected boolean onCanceled() {
        this.setCloseOption(1);
        this.setVisible(false);
        this.notifyToListener("Cancel");
        return true;
    }

    protected boolean onPrevious() {
        this.notifyToListener("<Prev");
        return true;
    }

    protected boolean onNext() {
        this.notifyToListener("Next>");
        return true;
    }

    public void showNext() {
        SGWizardDialog sGWizardDialog = this.getNext();
        if (sGWizardDialog != null) {
            this.setVisible(false);
            sGWizardDialog.setCenter(this);
            sGWizardDialog.setVisible(true);
        }
    }

    public void showPrevious() {
        SGWizardDialog sGWizardDialog = this.getPrevious();
        if (sGWizardDialog != null) {
            this.setVisible(false);
            sGWizardDialog.setCenter(this);
            sGWizardDialog.setVisible(true);
        }
    }

    public void setVisible(boolean bl) {
        Window window;
        if (bl && !((window = this.getOwner()) instanceof Window)) {
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            int n = this.getWidth();
            int n2 = this.getHeight();
            int n3 = (dimension.width - n) / 2;
            int n4 = (dimension.height - n2) / 2;
            this.setLocation(n3, n4);
        }
        super.setVisible(bl);
    }

    protected abstract JButton getPreviousButton();

    protected abstract JButton getNextButton();

    protected abstract JButton getOKButton();

    protected abstract JButton getCancelButton();
}

