/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.base;

import java.util.ArrayList;
import jp.riken.brain.ni.samuraigraph.base.SGIUndoable;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;

public class SGUndoManager {
    private SGIUndoable mUndoable = null;
    private ArrayList mMementList = new ArrayList();
    private int mElementStateCounter = 0;
    private int mCurrentStateCounter = 0;
    private ArrayList mUndoableObjectHistoryList = new ArrayList();

    public SGUndoManager(SGIUndoable sGIUndoable) {
        this.mUndoable = sGIUndoable;
    }

    public boolean initPropertiesHistory() {
        this.addPropertyHistory(this.mUndoable.getMement());
        return true;
    }

    public boolean undo() {
        --this.mElementStateCounter;
        return this.updateMement();
    }

    public boolean redo() {
        ++this.mElementStateCounter;
        return this.updateMement();
    }

    private boolean updateMement() {
        SGProperties sGProperties = (SGProperties)this.mMementList.get(this.mElementStateCounter);
        return this.mUndoable.setMement(sGProperties);
    }

    public boolean onUndo() {
        if (!this.isUndoable()) {
            return false;
        }
        ArrayList arrayList = (ArrayList)this.mUndoableObjectHistoryList.get(this.mCurrentStateCounter - 1);
        for (int i = 0; i < arrayList.size(); ++i) {
            SGIUndoable sGIUndoable = (SGIUndoable)arrayList.get(i);
            boolean bl = sGIUndoable.equals(this.mUndoable) ? this.mUndoable.undo() : sGIUndoable.onUndo();
            if (bl) continue;
            throw new Error("undo erorr:" + sGIUndoable);
        }
        --this.mCurrentStateCounter;
        return true;
    }

    public boolean onRedo() {
        if (!this.isRedoable()) {
            return false;
        }
        ArrayList arrayList = (ArrayList)this.mUndoableObjectHistoryList.get(this.mCurrentStateCounter);
        for (int i = 0; i < arrayList.size(); ++i) {
            SGIUndoable sGIUndoable = (SGIUndoable)arrayList.get(i);
            boolean bl = sGIUndoable.equals(this.mUndoable) ? this.mUndoable.redo() : sGIUndoable.onRedo();
            if (bl) continue;
            throw new Error("redo erorr:" + sGIUndoable);
        }
        ++this.mCurrentStateCounter;
        return true;
    }

    public boolean updateObjectHistory(SGIUndoable sGIUndoable) {
        ArrayList<SGIUndoable> arrayList = new ArrayList<SGIUndoable>();
        arrayList.add(sGIUndoable);
        boolean bl = this.updateObjectHistory(arrayList);
        return bl;
    }

    public boolean updateObjectHistory(ArrayList arrayList) {
        int n = this.mCurrentStateCounter;
        ArrayList arrayList2 = this.mUndoableObjectHistoryList;
        ArrayList arrayList3 = new ArrayList();
        for (int i = 0; i < n; ++i) {
            Object e = arrayList2.get(i);
            arrayList3.add(e);
        }
        arrayList3.add(new ArrayList(arrayList));
        this.mUndoableObjectHistoryList = arrayList3;
        ++this.mCurrentStateCounter;
        return true;
    }

    public boolean updateHistory() {
        if (this.mUndoable.isChanged()) {
            this.updateThisObjectHistory();
            this.mUndoable.setChanged(false);
            this.updateObjectHistory(this.mUndoable);
        }
        return true;
    }

    public boolean updateThisObjectHistory() {
        ++this.mElementStateCounter;
        this.addPropertyHistory(this.mUndoable.getMement());
        return true;
    }

    private boolean addPropertyHistory(SGProperties sGProperties) {
        int n = this.mElementStateCounter;
        ArrayList arrayList = this.mMementList;
        ArrayList arrayList2 = new ArrayList();
        for (int i = 0; i < n; ++i) {
            arrayList2.add(arrayList.get(i));
        }
        arrayList2.add(sGProperties);
        this.mMementList = arrayList2;
        return true;
    }

    public boolean isUndoable() {
        return this.mCurrentStateCounter != 0;
    }

    public boolean isRedoable() {
        return this.mCurrentStateCounter != this.mUndoableObjectHistoryList.size();
    }

    public SGIUndoable getUndoable() {
        return this.mUndoable;
    }

    public void dump() {
        System.out.println(this.mElementStateCounter + "  " + this.mCurrentStateCounter + "  " + this.mMementList.size() + "  " + this.mUndoableObjectHistoryList.size());
    }
}

