/**
 * @file ssm2603.c
 * @author Copyright(C) 2012 Shinichiro Nakamura
 * @brief BlueTank ACB-BF592 Application Sample Codes.
 */

/*
 * ===============================================================
 *  BlueTank
 * ===============================================================
 * Copyright (c) 2012 Shinichiro Nakamura
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following
 * conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 * ===============================================================
 */

#include <cdefBF592-A.h>
#include <builtins.h>
#include "twi.h"
#include "ssm2603.h"

/* SSM2603のI2Cデバイスアドレス */
#define TWI_DEVICE_ADDR (0x1A)

/* SSM2603 TWI初期化データ列 */
static const uint8_t ssm2603_initdata[] =
{
    (0x0F << 1) | 0, 0x00,
    (0x00 << 1) | 1, 0x17,
    (0x01 << 1) | 1, 0x17,
    (0x02 << 1) | 1, 0x79,
    (0x03 << 1) | 1, 0x79,
    (0x04 << 1) | 0, 0x12,
    (0x05 << 1) | 0, 0x00,
    (0x06 << 1) | 0, 0x02,
    (0x07 << 1) | 0, 0x4E,
    (0x08 << 1) | 0, 0x00,
    (0x09 << 1) | 0, 0x01,
};

void ssm2603_init(void)
{
    uint32_t i;

    /*
     * TWIを初期化する。
     */
    twi_init();

    /*
     * I2Sポートの設定を実行する。
     */
    *pPORTG_MUX &= ~(PG1 | PG2 | PG3 | PG5 | PG6 | PG7);
    *pPORTG_FER |= (PG1 | PG2 | PG3 | PG5 | PG6 | PG7);

    /*
     * PG13(MUTE#)を出力ピンに設定する。
     */
    *pPORTGIO_DIR |= PG13;

    /*
     * ミュートする。
     */
    ssm2603_mute(true);

    /*
     * SSM2603に初期化コードを流す。
     */
    for (i = 0; i < sizeof(ssm2603_initdata); i+=2) {
        twi_master_write(TWI_DEVICE_ADDR, TWI_STOP, &ssm2603_initdata[i], 2);
        while (twi_master_xfer_state() != TWI_STATE_COMP) {
            ssync();
        }
    }
}

void ssm2603_mute(bool mute)
{
    if (mute) {
        *pPORTGIO_CLEAR = PG13;
    } else {
        *pPORTGIO_SET   = PG13;
    }
}

