/**
 * @file tinyrand.h
 * @author Copyright(C) 2012 Shinichiro Nakamura
 * @brief BlueTank ACB-BF592 Application Sample Codes.
 */

/*
 * ===============================================================
 *  BlueTank
 * ===============================================================
 * Copyright (c) 2012 Shinichiro Nakamura
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following
 * conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 * ===============================================================
 */

#ifndef TINYRAND_H
#define TINYRAND_H

#include <stdint.h>

/**
 * @brief 乱数生成用ハンドラ。
 */
typedef struct {
    uint32_t seed;
    uint32_t reg;
} tinyrand_t;

/**
 * @brief 乱数生成モジュールを初期化する。
 * @details
 * この乱数生成モジュールは24ビットM系列信号によって乱数を生成する。
 *
 * @param p 乱数生成用ハンドラ。
 * @param seed 乱数の種。(0以外の値を指定しなければならない)
 *
 * @return 0 成功。
 * @return !0 失敗。
 */
int tinyrand_init(tinyrand_t *p, const uint32_t seed);

/**
 * @brief 乱数を取り出す。
 * @details
 * このインターフェースは、指定したビット幅に収まる値を返す。
 *
 * @param p 乱数生成用ハンドラ。
 * @param nbits 生成する乱数のビット幅。
 * @param value 値格納先。
 *
 * @return 0 成功。
 * @return !0 失敗。
 */
int tinyrand_pop(tinyrand_t *p, const uint8_t nbits, uint32_t *value);

#endif

