/**
 * @file uzura.h
 * @author Copyright(C) 2012 Shinichiro Nakamura
 * @brief BlueTank ACB-BF592 Application Sample Codes.
 */

/*
 * ===============================================================
 *  BlueTank
 * ===============================================================
 * Copyright (c) 2012 Shinichiro Nakamura
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following
 * conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 * ===============================================================
 */

#ifndef UZURA_H
#define UZURA_H

#include <stdint.h>

typedef struct UZURA UZURA;
typedef void (*UZURA_EFFECT_FUNC)(UZURA *p,
        const int32_t *src, int32_t *des, int32_t count);
typedef void (*UZURA_SYSTEM_FUNC)(UZURA *p);

#define UZURA_LEVEL_INPUT(P)    ((P)->input)
#define UZURA_LEVEL_OUTPUT(P)   ((P)->output)
#define UZURA_USER_DATA(P)      ((P)->user_data)

/**
 * @brief Volume Memory.
 */
typedef struct {
    uint32_t left;   /**< Left. */
    uint32_t right;  /**< Right. */
} level_t;

struct UZURA {
    UZURA_EFFECT_FUNC effect;   /**< Effect callback. */
    UZURA_SYSTEM_FUNC system;   /**< System callback. */
    level_t input;              /**< Input volume. */
    level_t output;             /**< Output volume. */
    void *user_data;            /**< User external object. */
};

void uzura_init(UZURA *p, void *user_data);
void uzura_set_effect(UZURA *p, UZURA_EFFECT_FUNC effect);
void uzura_set_system(UZURA *p, UZURA_SYSTEM_FUNC system);
void uzura_execute(UZURA *p);

#endif

