/**
 * @file captime_linux.c
 * @author Shinichiro Nakamura
 * @brief キャプチャ時間モジュールのLinux実装。
 */

/*
 * ===============================================================
 *  Natural Tiny Logger (NT-Logger)
 * ===============================================================
 * Copyright (c) 2010-2012 Shinichiro Nakamura
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following
 * conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 * ===============================================================
 */

#include "captime.h"
#include <stdlib.h>
#include <time.h>
#include <sys/time.h>

struct CAPTIME {
    int dummy;
};

CAPTIME *captime_open(void)
{
    CAPTIME *cp = (CAPTIME *)malloc(sizeof(CAPTIME));
    return cp;
}

void captime_read(CAPTIME *cp, captime_t *t)
{
    struct timeval tv;
    struct timezone tz;
    gettimeofday(&tv, &tz);
    struct tm *tm = localtime(&tv.tv_sec);
    t->year = 1900 + tm->tm_year;
    t->month = 1 + tm->tm_mon;
    t->day = tm->tm_mday;
    t->hour = tm->tm_hour;
    t->min = tm->tm_min;
    t->sec = tm->tm_sec;
    t->usec = tv.tv_usec;
}

void captime_close(CAPTIME *cp)
{
    if (cp != NULL) {
        free(cp);
    }
}

