
#include <stdio.h>
#include <stdlib.h>
#include "wave.h"
#include "fft.h"
#include "wavfile.h"

/**
 * @brief G[ɕWo͂ɉoB
 *
 * @param RESULT G[R[hB
 */
#define WAVFILE_ERROR_PRINT(RESULT) \
    do { \
        WavFileResult R = RESULT; \
        if (R != WavFileResultOK) { \
            char wavfile_error_print_text[BUFSIZ]; \
            wavfile_result_string(R, wavfile_error_print_text, sizeof(wavfile_error_print_text)); \
            printf("%s (code=%d)\n", wavfile_error_print_text, R); \
            return 1; \
        } \
    } while(0)

/**
 * @brief Channel separation test.
 *
 * @param filename Source file name.
 */
static int channel_separation(const char *filename)
{
    WavFileResult result;
    wavfile_info_t info_input;
    wavfile_info_t info_output;
    WAVFILE *wf_input;
    WAVFILE *wf_output[WAVFILE_MAXIMUM_CHANNELS];
    int i;

    /*
     * ̓t@CJB
     */
    wf_input = wavfile_open(filename, WavFileModeRead, &result);
    WAVFILE_ERROR_PRINT(result);

    /*
     * ̓t@CǂݍށB
     */
    WAVFILE_ERROR_PRINT(wavfile_read_info(wf_input, &info_input));

    /*
     * ʏ\B
     */
    printf("[INPUT]\n");
    printf("\tWAVFILE_INFO_AUDIO_FORMAT(&info)    = %d\n", WAVFILE_INFO_AUDIO_FORMAT(&info_input));
    printf("\tWAVFILE_INFO_NUM_CHANNELS(&info)    = %d\n", WAVFILE_INFO_NUM_CHANNELS(&info_input));
    printf("\tWAVFILE_INFO_SAMPLE_RATE(&info)     = %d\n", WAVFILE_INFO_SAMPLE_RATE(&info_input));
    printf("\tWAVFILE_INFO_BYTE_RATE(&info)       = %d\n", WAVFILE_INFO_BYTE_RATE(&info_input));
    printf("\tWAVFILE_INFO_BLOCK_ALIGN(&info)     = %d\n", WAVFILE_INFO_BLOCK_ALIGN(&info_input));
    printf("\tWAVFILE_INFO_BITS_PER_SAMPLE(&info) = %d\n", WAVFILE_INFO_BITS_PER_SAMPLE(&info_input));

    /*
     * ͂瓾ɁAo͂̏𐶐B
     */
    WAVFILE_INFO_AUDIO_FORMAT(&info_output)    = WAVFILE_INFO_AUDIO_FORMAT(&info_input);
    WAVFILE_INFO_NUM_CHANNELS(&info_output)    = WAVFILE_INFO_NUM_CHANNELS(&info_input) / WAVFILE_INFO_NUM_CHANNELS(&info_input);
    WAVFILE_INFO_SAMPLE_RATE(&info_output)     = WAVFILE_INFO_SAMPLE_RATE(&info_input);
    WAVFILE_INFO_BYTE_RATE(&info_output)       = WAVFILE_INFO_BYTE_RATE(&info_input) / WAVFILE_INFO_NUM_CHANNELS(&info_input);
    WAVFILE_INFO_BLOCK_ALIGN(&info_output)     = WAVFILE_INFO_BLOCK_ALIGN(&info_input) / WAVFILE_INFO_NUM_CHANNELS(&info_input);
    WAVFILE_INFO_BITS_PER_SAMPLE(&info_output) = WAVFILE_INFO_BITS_PER_SAMPLE(&info_input);

    /*
     * ʏ\B
     */
    printf("[OUTPUT]\n");
    printf("\tWAVFILE_INFO_AUDIO_FORMAT(&info)    = %d\n", WAVFILE_INFO_AUDIO_FORMAT(&info_output));
    printf("\tWAVFILE_INFO_NUM_CHANNELS(&info)    = %d\n", WAVFILE_INFO_NUM_CHANNELS(&info_output));
    printf("\tWAVFILE_INFO_SAMPLE_RATE(&info)     = %d\n", WAVFILE_INFO_SAMPLE_RATE(&info_output));
    printf("\tWAVFILE_INFO_BYTE_RATE(&info)       = %d\n", WAVFILE_INFO_BYTE_RATE(&info_output));
    printf("\tWAVFILE_INFO_BLOCK_ALIGN(&info)     = %d\n", WAVFILE_INFO_BLOCK_ALIGN(&info_output));
    printf("\tWAVFILE_INFO_BITS_PER_SAMPLE(&info) = %d\n", WAVFILE_INFO_BITS_PER_SAMPLE(&info_output));

    /*
     * t@CJăwb_B
     */
    for (i = 0; i < WAVFILE_INFO_NUM_CHANNELS(&info_input); i++) {
        /*
         * o̓t@CJB
         */
        char buf[BUFSIZ];
        sprintf(buf, "%s-ch%02d.wav", filename, i);
        wf_output[i] = wavfile_open(buf, WavFileModeWrite, &result);
        WAVFILE_ERROR_PRINT(result);

        /*
         * o̓t@C֏ށB
         */
        WAVFILE_ERROR_PRINT(wavfile_write_info(wf_output[i], &info_output));
    }

    while (1) {
        wavfile_data_t data_input;
        wavfile_data_t data_output;

        /*
         * ̓t@Cf[^ǂݍށB
         */
        WAVFILE_ERROR_PRINT(wavfile_read_data(wf_input, &data_input));

        /*
         * f[^ȏȂΏIB
         */
        if (WAVFILE_DATA_IS_END_OF_DATA(&data_input)) {
            break;
        }

        /*
         * o̓t@Cփf[^ށB
         */
        for (i = 0; i < WAVFILE_DATA_NUM_CHANNELS(&data_input); i++) {
            WAVFILE_DATA_NUM_CHANNELS(&data_output) = 1;
            WAVFILE_DATA_CHANNEL_DATA(&data_output, 0) = WAVFILE_DATA_CHANNEL_DATA(&data_input, i);
            WAVFILE_ERROR_PRINT(wavfile_write_data(wf_output[i], &data_output));
        }
    }

    /*
     * ̓t@CB
     */
    WAVFILE_ERROR_PRINT(wavfile_close(wf_input));

    /*
     * o̓t@CB
     */
    for (i = 0; i < WAVFILE_INFO_NUM_CHANNELS(&info_input); i++) {
        WAVFILE_ERROR_PRINT(wavfile_close(wf_output[i]));
    }

    return 0;
}


int main(int argc, char **argv)
{
    MONO_PCM pcm0;
    int n, k, N;
    double *x_real, *x_imag;

    if (argc != 2) {
        printf("ffttool <wave file name>\n");
        return 1;
    }

    /* WAVEt@C烂m̉f[^͂ */
    mono_wave_read(&pcm0, argv[1]);

    N = 64;
    x_real = calloc(N, sizeof(double));
    x_imag = calloc(N, sizeof(double));

    for (n = 0; n < N; n++)
    {
        /* x(n)̎ */
        x_real[n] = pcm0.s[n];
        /* x(n)̋ */
        x_imag[n] = 0.0;
    }

    /* FFŤvZʂx_realx_imagɏ㏑ */
    FFT(x_real, x_imag, N);

    /* g */
    for (k = 0; k < N; k++) {
        printf("%d %f+j%f\n", k, x_real[k], x_imag[k]);
    }

    free(pcm0.s);
    free(x_real);
    free(x_imag);

    return 0;
}

