/**
 * @file main.c
 * @author Copyright(C) 2012 Shinichiro Nakamura
 */

/*
 * ===============================================================
 *  LCD Image Tool
 * ===============================================================
 * Copyright (c) 2012 Shinichiro Nakamura
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following
 * conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 * ===============================================================
 */

#include <stdio.h>
#include <string.h>
#include "lcdimg.h"
#include "util.h"

#define VERSION_MAJOR   (0)
#define VERSION_MINOR   (0)
#define VERSION_RELEASE (3)

int main(int argc, char **argv);

int main(int argc, char **argv)
{
    LCDIMG *lcdimg;
    int i, j;

    if (argc < 5) {
        printf("=================================================\n");
        printf(" LCD Tool (Version %d.%d.%d)\n", VERSION_MAJOR, VERSION_MINOR, VERSION_RELEASE);
        printf(" Copyright(C) 2012 Shinichiro Nakamura\n");
        printf("=================================================\n");
        printf("\n");
        printf(" lcdtool [LCD Profile] [LCD Fontfile] [BMP File] [Line 1] [Line 2] ...\n");
        printf("\n");
        return 0;
    }

    lcdimg = lcdimg_open(argv[1], argv[2]);
    if (lcdimg == NULL) {
        printf("Illegal configuration found.\n");
            return 1;
    }
    for (i = 0; i <= argc - 5; i++) {
        char buf[BUFSIZ];
        int bytes = 0;
        if (util_format(argv[4 + i], buf, sizeof(buf), &bytes) != 0) {
            printf("Illegal format string found.\n");
            return 2;
        }
        for (j = 0; j < bytes; j++) {
            lcdimg_text(lcdimg, j, i, buf[j]);
        }
    }
    lcdimg_write(lcdimg, argv[3]);
    lcdimg_close(lcdimg);

    return 0;
}

