/*

 Licensed under the Apache License, Version 2.0 (the "License"); you may not
 use this file except in compliance with the License. You may obtain a copy
 of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 License for the specific language governing permissions and limitations under
 the License.

 Copyright (c) 2011-2012 Almende B.V.

 @author 	Jos de Jong, <jos@almende.org>
 @date    2012-06-15
 @version 2.1.2
*/
typeof links==="undefined"&&(links={});typeof google==="undefined"&&(google=void 0);
links.Timeline=function(a){this.dom={};this.conversion={};this.eventParams={};this.groups=[];this.groupIndexes={};this.items=[];this.selection=void 0;this.listeners={};this.size={actualHeight:0,axis:{characterMajorHeight:0,characterMajorWidth:0,characterMinorHeight:0,characterMinorWidth:0,height:0,labelMajorTop:0,labelMinorTop:0,line:0,lineMajorWidth:0,lineMinorHeight:0,lineMinorTop:0,lineMinorWidth:0,top:0},contentHeight:0,contentLeft:0,contentWidth:0,dataChanged:!1,frameHeight:0,frameWidth:0,groupsLeft:0,
groupsWidth:0,items:{top:0}};this.dom.container=a;this.options={width:"100%",height:"auto",minHeight:0,autoHeight:!0,eventMargin:10,eventMarginAxis:20,dragAreaWidth:10,min:void 0,max:void 0,intervalMin:10,intervalMax:31536E10,moveable:!0,zoomable:!0,selectable:!0,editable:!1,snapEvents:!0,groupChangeable:!0,showCurrentTime:!0,showCustomTime:!1,showMajorLabels:!0,showNavigation:!1,showButtonAdd:!0,groupsOnRight:!1,axisOnTop:!1,stackEvents:!0,animate:!0,animateZoom:!0,style:"box"};this.clientTimeOffset=
0;for(a=this.dom;a.container.hasChildNodes();)a.container.removeChild(a.container.firstChild);this.step=new links.Timeline.StepDate;this.data=[];this.firstDraw=!0;this.setVisibleChartRange(void 0,void 0,!1);this.redrawFrame();if(!Array.prototype.indexOf)Array.prototype.indexOf=function(a){for(var c=0;c<this.length;c++)if(this[c]==a)return c;return-1};this.trigger("ready")};
links.Timeline.prototype.draw=function(a,b){this.setOptions(b);this.setData(a);b&&b.start&&b.end?this.setVisibleChartRange(b.start,b.end):this.firstDraw&&this.setVisibleChartRangeAuto();this.firstDraw=!1};links.Timeline.prototype.setOptions=function(a){if(a)for(var b in a)a.hasOwnProperty(b)&&(this.options[b]=a[b]);this.options.autoHeight=this.options.height==="auto"};
links.Timeline.prototype.setData=function(a){this.unselectItem();a||(a=[]);this.items=[];this.data=a;var b=this.items;this.setGroups(a);if(google&&google.visualization&&a instanceof google.visualization.DataTable)for(var c=a.getNumberOfColumns()>3,d=0,e=a.getNumberOfRows();d<e;d++)b.push(this.createItem({start:a.getValue(d,0),end:a.getValue(d,1),content:a.getValue(d,2),group:c?a.getValue(d,3):void 0}));else if(links.Timeline.isArray(a)){d=0;for(e=a.length;d<e;d++)c=this.createItem(a[d]),b.push(c)}else throw"Unknown data type. DataTable or Array expected.";
this.size.dataChanged=!0;this.redrawFrame();this.recalcSize();this.stackEvents(!1);this.redrawFrame();this.size.dataChanged=!1};
links.Timeline.prototype.setGroups=function(a){this.deleteGroups();if(google&&google.visualization&&a instanceof google.visualization.DataTable){if(a.getNumberOfColumns()>3)for(var a=a.getDistinctValues(3),b=0,c=a.length;b<c;b++)this.addGroup(a[b])}else if(links.Timeline.isArray(a)){b=0;for(c=a.length;b<c;b++){var d=a[b].group;d&&this.addGroup(d)}}else throw"Unknown data type. DataTable or Array expected.";};links.Timeline.prototype.getData=function(){return this.data};
links.Timeline.prototype.updateData=function(a,b){var c=this.data;if(google&&google.visualization&&c instanceof google.visualization.DataTable){var d=a+1-c.getNumberOfRows();d>0&&c.addRows(d);b.start&&c.setValue(a,0,b.start);b.end&&c.setValue(a,1,b.end);b.content&&c.setValue(a,2,b.content);b.group&&c.getNumberOfColumns()>3&&c.setValue(a,3,b.group)}else if(links.Timeline.isArray(c)){d=c[a];d==void 0&&(d={},c[a]=d);if(b.start)d.start=b.start;if(b.end)d.end=b.end;if(b.content)d.content=b.content;if(b.group)d.group=
b.group}else throw"Cannot update data, unknown type of data";};links.Timeline.prototype.getItemIndex=function(a){for(var b=this.dom,c=this.items,d=void 0;a.parentNode&&a.parentNode!==b.items.frame;)a=a.parentNode;if(a.parentNode===b.items.frame)for(var b=0,e=c.length;b<e;b++)if(c[b].dom===a){d=b;break}return d};
links.Timeline.prototype.setSize=function(a,b){if(a)this.options.width=a,this.dom.frame.style.width=a;if(b&&(this.options.height=b,this.options.autoHeight=this.options.height==="auto",b!=="auto"))this.dom.frame.style.height=b;this.recalcSize();this.stackEvents(!1);this.redrawFrame()};
links.Timeline.prototype.setVisibleChartRange=function(a,b,c){a==void 0&&(a=new Date,a.setDate(a.getDate()-3));b==void 0&&(b=new Date,b.setDate(a.getDate()+4));b.valueOf()<=a.valueOf()&&(b=new Date(a),b.setDate(b.getDate()+7));var d=this.options.min?this.options.min.valueOf():void 0;d&&a.valueOf()<d&&(a=new Date(d));(d=this.options.max?this.options.max.valueOf():void 0)&&b.valueOf()>d&&(b=new Date(d));this.applyRange(a,b);c==void 0||c==!0?(this.recalcSize(),this.stackEvents(!1),this.redrawFrame()):
this.recalcConversion()};links.Timeline.prototype.setVisibleChartRangeAuto=function(){for(var a=this.items,b=void 0,c=void 0,d=0,e=a.length;d<e;d++)var g=a[d],f=g.start?g.start.valueOf():void 0,g=g.end?g.end.valueOf():f,b=b!==void 0&&f!==void 0?Math.min(b,f):f,c=c!==void 0&&g!==void 0?Math.max(c,g):g;b!==void 0&&c!==void 0?(a=c-b,b-=a*0.05,c+=a*0.05,this.setVisibleChartRange(new Date(b),new Date(c))):this.setVisibleChartRange(void 0,void 0)};
links.Timeline.prototype.setVisibleChartRangeNow=function(){var a=new Date,b=this.end.getTime()-this.start.getTime(),a=new Date(a.getTime()-b/2),b=new Date(a.getTime()+b);this.setVisibleChartRange(a,b)};links.Timeline.prototype.getVisibleChartRange=function(){return{start:new Date(this.start),end:new Date(this.end)}};
links.Timeline.prototype.redrawFrame=function(){var a=this.dom,b=this.options,c=this.size;if(!a.frame)a.frame=document.createElement("DIV"),a.frame.className="timeline-frame",a.frame.style.position="relative",a.frame.style.overflow="hidden",a.container.appendChild(a.frame);a.frame.style.height=b.autoHeight?c.frameHeight+"px":b.height||"100%";a.frame.style.width=b.width||"100%";this.redrawContent();this.redrawGroups();this.redrawCurrentTime();this.redrawCustomTime();this.redrawNavigation()};
links.Timeline.prototype.redrawContent=function(){var a=this.dom,b=this.size;if(!a.content){a.content=document.createElement("DIV");a.content.style.position="relative";a.content.style.overflow="hidden";a.frame.appendChild(a.content);var c=document.createElement("DIV");c.style.position="absolute";c.style.left="0px";c.style.top="0px";c.style.height="100%";c.style.width="0px";a.content.appendChild(c);a.contentTimelines=c;var c=this.eventParams,d=this;if(!c.onMouseDown)c.onMouseDown=function(a){d.onMouseDown(a)},
links.Timeline.addEventListener(a.content,"mousedown",c.onMouseDown);if(!c.onTouchStart)c.onTouchStart=function(a){d.onTouchStart(a)},links.Timeline.addEventListener(a.content,"touchstart",c.onTouchStart);if(!c.onMouseWheel)c.onMouseWheel=function(a){d.onMouseWheel(a)},links.Timeline.addEventListener(a.content,"mousewheel",c.onMouseWheel);if(!c.onDblClick)c.onDblClick=function(a){d.onDblClick(a)},links.Timeline.addEventListener(a.content,"dblclick",c.onDblClick)}a.content.style.left=b.contentLeft+
"px";a.content.style.top="0px";a.content.style.width=b.contentWidth+"px";a.content.style.height=b.frameHeight+"px";this.redrawAxis();this.redrawItems();this.redrawDeleteButton();this.redrawDragAreas()};
links.Timeline.prototype.redrawAxis=function(){var a=this.dom,b=this.options,c=this.size,d=this.step,e=a.axis;if(!e)e={},a.axis=e;if(c.axis.properties===void 0)c.axis.properties={};if(e.minorTexts===void 0)e.minorTexts=[];if(e.minorLines===void 0)e.minorLines=[];if(e.majorTexts===void 0)e.majorTexts=[];if(e.majorLines===void 0)e.majorLines=[];if(!e.frame)e.frame=document.createElement("DIV"),e.frame.style.position="absolute",e.frame.style.left="0px",e.frame.style.top="0px",a.content.appendChild(e.frame);
a.content.removeChild(e.frame);e.frame.style.width=c.contentWidth+"px";e.frame.style.height=c.axis.height+"px";var g=this.screenToTime(0),f=this.screenToTime(c.contentWidth),j=c.contentWidth;this.minimumStep=this.screenToTime(c.axis.characterMinorWidth*6).valueOf()-this.screenToTime(0).valueOf();d.setRange(g,f,this.minimumStep);this.redrawAxisCharacters();this.redrawAxisStartOverwriting();d.start();for(g=void 0;!d.end();)j=this.timeToScreen(d.getCurrent()),f=d.isMajor(),this.redrawAxisMinorText(j,
d.getLabelMinor()),f&&b.showMajorLabels?(j>0&&(g===void 0&&(g=j),this.redrawAxisMajorText(j,d.getLabelMajor())),this.redrawAxisMajorLine(j)):this.redrawAxisMinorLine(j),d.next();b.showMajorLabels&&(b=this.screenToTime(0),d=this.step.getLabelMajor(b),j=d.length*c.axis.characterMajorWidth+10,(g===void 0||j<g)&&this.redrawAxisMajorText(0,d,b));this.redrawAxisHorizontal();this.redrawAxisEndOverwriting();a.content.insertBefore(e.frame,a.content.firstChild)};
links.Timeline.prototype.redrawAxisCharacters=function(){var a=this.dom.axis;if(!a.characterMinor){var b=document.createTextNode("0"),c=document.createElement("DIV");c.className="timeline-axis-text timeline-axis-text-minor";c.appendChild(b);c.style.position="absolute";c.style.visibility="hidden";c.style.paddingLeft="0px";c.style.paddingRight="0px";a.frame.appendChild(c);a.characterMinor=c}if(!a.characterMajor)b=document.createTextNode("0"),c=document.createElement("DIV"),c.className="timeline-axis-text timeline-axis-text-major",
c.appendChild(b),c.style.position="absolute",c.style.visibility="hidden",c.style.paddingLeft="0px",c.style.paddingRight="0px",a.frame.appendChild(c),a.characterMajor=c};links.Timeline.prototype.redrawAxisStartOverwriting=function(){var a=this.size.axis.properties;a.minorTextNum=0;a.minorLineNum=0;a.majorTextNum=0;a.majorLineNum=0};
links.Timeline.prototype.redrawAxisEndOverwriting=function(){for(var a=this.dom,b=this.size.axis.properties,c=this.dom.axis.frame,d=a.axis.minorTexts,e=b.minorTextNum;d.length>e;)c.removeChild(d[e]),d.splice(e,1);d=a.axis.minorLines;for(e=b.minorLineNum;d.length>e;)c.removeChild(d[e]),d.splice(e,1);d=a.axis.majorTexts;for(e=b.majorTextNum;d.length>e;)c.removeChild(d[e]),d.splice(e,1);a=a.axis.majorLines;for(e=b.majorLineNum;a.length>e;)c.removeChild(a[e]),a.splice(e,1)};
links.Timeline.prototype.redrawAxisHorizontal=function(){var a=this.dom.axis,b=this.size;if(!a.backgroundLine){var c=document.createElement("DIV");c.className="timeline-axis";c.style.position="absolute";c.style.left="0px";c.style.width="100%";c.style.border="none";a.frame.insertBefore(c,a.frame.firstChild);a.backgroundLine=c}a.backgroundLine.style.top=b.axis.top+"px";a.backgroundLine.style.height=b.axis.height+"px";a.line?(c=a.frame.removeChild(a.line),a.frame.appendChild(c)):(c=document.createElement("DIV"),
c.className="timeline-axis",c.style.position="absolute",c.style.left="0px",c.style.width="100%",c.style.height="0px",a.frame.appendChild(c),a.line=c);a.line.style.top=b.axis.line+"px"};
links.Timeline.prototype.redrawAxisMinorText=function(a,b){var c=this.size,d=this.dom,e=c.axis.properties,g=d.axis.frame,d=d.axis.minorTexts,f=e.minorTextNum;if(f<d.length)f=d[f];else{var j=document.createTextNode(""),f=document.createElement("DIV");f.appendChild(j);f.className="timeline-axis-text timeline-axis-text-minor";f.style.position="absolute";g.appendChild(f);d.push(f)}f.childNodes[0].nodeValue=b;f.style.left=a+"px";f.style.top=c.axis.labelMinorTop+"px";e.minorTextNum++};
links.Timeline.prototype.redrawAxisMinorLine=function(a){var b=this.size.axis,c=this.dom,d=b.properties,e=c.axis.frame,c=c.axis.minorLines,g=d.minorLineNum;g<c.length?g=c[g]:(g=document.createElement("DIV"),g.className="timeline-axis-grid timeline-axis-grid-minor",g.style.position="absolute",g.style.width="0px",e.appendChild(g),c.push(g));g.style.top=b.lineMinorTop+"px";g.style.height=b.lineMinorHeight+"px";g.style.left=a-b.lineMinorWidth/2+"px";d.minorLineNum++};
links.Timeline.prototype.redrawAxisMajorText=function(a,b){var c=this.size,d=c.axis.properties,e=this.dom.axis.frame,g=this.dom.axis.majorTexts,f=d.majorTextNum;if(f<g.length)f=g[f];else{var j=document.createTextNode(b),f=document.createElement("DIV");f.className="timeline-axis-text timeline-axis-text-major";f.appendChild(j);f.style.position="absolute";f.style.top="0px";e.appendChild(f);g.push(f)}f.childNodes[0].nodeValue=b;f.style.top=c.axis.labelMajorTop+"px";f.style.left=a+"px";d.majorTextNum++};
links.Timeline.prototype.redrawAxisMajorLine=function(a){var b=this.size,c=b.axis.properties,d=this.size.axis,e=this.dom.axis.frame,g=this.dom.axis.majorLines,f=c.majorLineNum;f<g.length?f=g[f]:(f=document.createElement("DIV"),f.className="timeline-axis-grid timeline-axis-grid-major",f.style.position="absolute",f.style.top="0px",f.style.width="0px",e.appendChild(f),g.push(f));f.style.left=a-d.lineMajorWidth/2+"px";f.style.height=b.frameHeight+"px";c.majorLineNum++};
links.Timeline.prototype.redrawItems=function(){var a=this.dom,b=this.options,c=b.box&&b.box.align?b.box.align:void 0,d=this.size,e=d.contentWidth,g=this.items;if(!a.items)a.items={};var f=a.items.frame;if(!f)f=document.createElement("DIV"),f.style.position="relative",a.content.appendChild(f),a.items.frame=f;f.style.left="0px";f.style.top=d.items.top+"px";f.style.height=d.frameHeight-d.axis.height+"px";var j=a.items.ranges;if(!j)j=[],a.items.ranges=j;var l=a.items.boxes;if(!l)l=[],a.items.boxes=l;
var p=a.items.dots;if(!p)p=[],a.items.dots=p;a.content.removeChild(f);if(d.dataChanged){for(var o=j.length,u=l.length,v=p.length,s=0,r=0,q=0,m=0,n=g.length;m<n;m++){var k=g[m];switch(k.type){case "range":if(s<o){var h=j[s];h.firstChild.innerHTML=k.content;h.style.display="";k.dom=h;s++}else h=this.createEventRange(k.content),j[s]=h,f.appendChild(h),k.dom=h,s++,o++;break;case "box":r<u?(h=l[r],h.firstChild.innerHTML=k.content,h.style.display="",k.dom=h,r++):(h=this.createEventBox(k.content),l[r]=h,
f.appendChild(h),f.insertBefore(h.line,f.firstChild),f.appendChild(h.dot),k.dom=h,r++,u++);break;case "dot":q<v?(h=p[q],h.firstChild.innerHTML=k.content,h.style.display="",k.dom=h,q++):(h=this.createEventDot(k.content),p[q]=h,f.appendChild(h),k.dom=h,q++,v++)}}for(m=s;m<o;m++)f.removeChild(j[m]);j.splice(s,o-s);for(m=r;m<u;m++)n=l[m],f.removeChild(n.line),f.removeChild(n.dot),f.removeChild(n);l.splice(r,u-r);for(m=q;m<v;m++)f.removeChild(p[m]);p.splice(q,v-q)}m=0;for(n=g.length;m<n;m++)switch(k=g[m],
h=k.dom,k.type){case "range":l=this.timeToScreen(k.start);p=this.timeToScreen(k.end);l<-e&&(l=-e);p>2*e&&(p=2*e);if((u=p>-e&&l<2*e)||d.dataChanged){if(k.hidden)k.hidden=!1,h.style.display="";h.style.top=k.top+"px";h.style.left=l+"px";h.style.width=Math.max(p-l,1)+"px"}else if(!k.hidden)h.style.display="none",k.hidden=!0;break;case "box":l=this.timeToScreen(k.start);v=b.axisOnTop;p=d.axis.top;if((u=l+k.width/2>-e&&l-k.width/2<2*e)||d.dataChanged){if(k.hidden)k.hidden=!1,h.style.display="",h.line.style.display=
"",h.dot.style.display="";h.style.top=k.top+"px";h.style.left=c=="right"?l-k.width+"px":c=="left"?l+"px":l-k.width/2+"px";u=h.line;u.style.left=l-k.lineWidth/2+"px";v?(u.style.top="0px",u.style.height=Math.max(k.top,0)+"px"):(u.style.top=k.top+k.height+"px",u.style.height=Math.max(p-k.top-k.height,0)+"px");h=h.dot;h.style.left=l-k.dotWidth/2+"px";h.style.top=p-k.dotHeight/2+"px"}else if(!k.hidden)h.style.display="none",h.line.style.display="none",h.dot.style.display="none",k.hidden=!0;break;case "dot":if(l=
this.timeToScreen(k.start),(u=l+k.width>-e&&l<2*e)||d.dataChanged){if(k.hidden)k.hidden=!1,h.style.display="";h.style.top=k.top+"px";h.style.left=l-k.dotWidth/2+"px";h.content.style.marginLeft=1.5*k.dotWidth+"px";h.dot.style.top=(k.height-k.dotHeight)/2+"px"}else if(!k.hidden)h.style.display="none",k.hidden=!0}if(this.selection)k=this.selection.item,f.removeChild(k),f.appendChild(k);a.content.appendChild(f)};
links.Timeline.prototype.createEventBox=function(a){var b=document.createElement("DIV");b.style.position="absolute";b.style.left="0px";b.style.top="0px";b.className="timeline-event timeline-event-box";var c=document.createElement("DIV");c.className="timeline-event-content";c.innerHTML=a;b.appendChild(c);a=document.createElement("DIV");a.style.position="absolute";a.style.width="0px";a.className="timeline-event timeline-event-line";b.line=a;a=document.createElement("DIV");a.style.position="absolute";
a.style.width="0px";a.style.height="0px";a.className="timeline-event timeline-event-dot";b.dot=a;return b};
links.Timeline.prototype.createEventDot=function(a){var b=document.createElement("DIV");b.style.position="absolute";var c=document.createElement("DIV");c.className="timeline-event-content";c.innerHTML=a;b.appendChild(c);a=document.createElement("DIV");a.style.position="absolute";a.className="timeline-event timeline-event-dot";a.style.width="0px";a.style.height="0px";b.appendChild(a);b.content=c;b.dot=a;return b};
links.Timeline.prototype.createEventRange=function(a){var b=document.createElement("DIV");b.style.position="absolute";b.className="timeline-event timeline-event-range";var c=document.createElement("DIV");c.className="timeline-event-content";c.innerHTML=a;b.appendChild(c);return b};
links.Timeline.prototype.redrawGroups=function(){var a=this.dom,b=this.options,c=this.size,d=this.groups;if(a.groups===void 0)a.groups={};var e=a.groups.labels;if(!e)e=[],a.groups.labels=e;var g=a.groups.labelLines;if(!g)g=[],a.groups.labelLines=g;var f=a.groups.itemLines;if(!f)f=[],a.groups.itemLines=f;var j=a.groups.frame;if(!j)j=document.createElement("DIV"),j.className="timeline-groups-axis",j.style.position="absolute",j.style.overflow="hidden",j.style.top="0px",j.style.height="100%",a.frame.appendChild(j),
a.groups.frame=j;j.style.left=c.groupsLeft+"px";j.style.width=b.groupsWidth!==void 0?b.groupsWidth:c.groupsWidth+"px";j.style.display=d.length==0?"none":"";if(c.dataChanged){for(var l=e.length,p=d.length,o=0,u=Math.min(l,p);o<u;o++){var v=d[o],s=e[o];s.innerHTML=v.content;s.style.display=""}for(o=l;o<p;o++){v=d[o];s=document.createElement("DIV");s.className="timeline-groups-text";s.style.position="absolute";if(b.groupsWidth===void 0)s.style.whiteSpace="nowrap";s.innerHTML=v.content;j.appendChild(s);
e[o]=s;var r=document.createElement("DIV");r.className="timeline-axis-grid timeline-axis-grid-minor";r.style.position="absolute";r.style.left="0px";r.style.width="100%";r.style.height="0px";r.style.borderTopStyle="solid";j.appendChild(r);g[o]=r;var q=document.createElement("DIV");q.className="timeline-axis-grid timeline-axis-grid-minor";q.style.position="absolute";q.style.left="0px";q.style.width="100%";q.style.height="0px";q.style.borderTopStyle="solid";a.content.insertBefore(q,a.content.firstChild);
f[o]=q}for(o=p;o<l;o++)s=e[o],r=g[o],q=f[o],j.removeChild(s),j.removeChild(r),a.content.removeChild(q);e.splice(p,l-p);g.splice(p,l-p);f.splice(p,l-p);j.style.borderStyle=b.groupsOnRight?"none none none solid":"none solid none none"}o=0;for(u=d.length;o<u;o++)v=d[o],s=e[o],r=g[o],q=f[o],s.style.top=v.labelTop+"px",r.style.top=v.lineTop+"px",q.style.top=v.lineTop+"px",q.style.width=c.contentWidth+"px";if(!a.groups.background)b=document.createElement("DIV"),b.className="timeline-axis",b.style.position=
"absolute",b.style.left="0px",b.style.width="100%",b.style.border="none",j.appendChild(b),a.groups.background=b;a.groups.background.style.top=c.axis.top+"px";a.groups.background.style.height=c.axis.height+"px";if(!a.groups.line)b=document.createElement("DIV"),b.className="timeline-axis",b.style.position="absolute",b.style.left="0px",b.style.width="100%",b.style.height="0px",j.appendChild(b),a.groups.line=b;a.groups.line.style.top=c.axis.line+"px"};
links.Timeline.prototype.redrawCurrentTime=function(){var a=this.dom,b=this.size;if(this.options.showCurrentTime){if(!a.currentTime){var c=document.createElement("DIV");c.className="timeline-currenttime";c.style.position="absolute";c.style.top="0px";c.style.height="100%";a.contentTimelines.appendChild(c);a.currentTime=c}var c=new Date((new Date).getTime()+this.clientTimeOffset),d=this.timeToScreen(c);a.currentTime.style.display=d>-b.contentWidth&&d<2*b.contentWidth?"":"none";a.currentTime.style.left=
d+"px";a.currentTime.title="Current time: "+c;this.currentTimeTimer!=void 0&&(clearTimeout(this.currentTimeTimer),delete this.currentTimeTimer);var e=this,a=1/this.conversion.factor/2;a<30&&(a=30);this.currentTimeTimer=setTimeout(function(){e.redrawCurrentTime()},a)}else a.currentTime&&(a.contentTimelines.removeChild(a.currentTime),delete a.currentTime)};
links.Timeline.prototype.redrawCustomTime=function(){var a=this.dom,b=this.size;if(this.options.showCustomTime){if(!a.customTime){var c=document.createElement("DIV");c.className="timeline-customtime";c.style.position="absolute";c.style.top="0px";c.style.height="100%";var d=document.createElement("DIV");d.style.position="relative";d.style.top="0px";d.style.left="-10px";d.style.height="100%";d.style.width="20px";c.appendChild(d);a.contentTimelines.appendChild(c);a.customTime=c;this.customTime=new Date}c=
this.timeToScreen(this.customTime);a.customTime.style.display=c>-b.contentWidth&&c<2*b.contentWidth?"":"none";a.customTime.style.left=c+"px";a.customTime.title="Time: "+this.customTime}else a.customTime&&(a.contentTimelines.removeChild(a.customTime),delete a.customTime)};
links.Timeline.prototype.redrawDeleteButton=function(){var a=this.dom,b=this.size,c=a.items.frame;if(this.options.editable){var d=a.items.deleteButton;if(!d)d=document.createElement("DIV"),d.className="timeline-navigation-delete",d.style.position="absolute",c.appendChild(d),a.items.deleteButton=d;if(this.selection){var a=this.items[this.selection.index],e,g=a.top;switch(a.type){case "range":e=this.timeToScreen(a.end);break;case "box":e=this.timeToScreen(a.start)+a.width/2;break;case "dot":e=this.timeToScreen(a.start)+
a.width}e<-b.contentWidth&&(e=-b.contentWidth);e>2*b.contentWidth&&(e=2*b.contentWidth);d.style.left=e+"px";d.style.top=g+"px";d.style.display="";c.removeChild(d);c.appendChild(d)}else d.style.display="none"}};
links.Timeline.prototype.redrawDragAreas=function(){var a=this.options,b=this.dom,c=this.dom.items.frame;if(a.editable){var d=b.items.dragLeft;if(!d)d=document.createElement("DIV"),d.className="timeline-event-range-drag-left",d.style.width=a.dragAreaWidth+"px",d.style.position="absolute",c.appendChild(d),b.items.dragLeft=d;var e=b.items.dragRight;if(!e)e=document.createElement("DIV"),e.className="timeline-event-range-drag-right",e.style.width=a.dragAreaWidth+"px",e.style.position="absolute",c.appendChild(e),
b.items.dragRight=e;if(this.selection){var g=this.items[this.selection.index];if(g.type=="range"){var b=this.timeToScreen(g.start),f=this.timeToScreen(g.end),j=g.top,g=g.height;d.style.left=b+"px";d.style.top=j+"px";d.style.height=g+"px";d.style.display="";c.removeChild(d);c.appendChild(d);e.style.left=f-a.dragAreaWidth+"px";e.style.top=j+"px";e.style.height=g+"px";e.style.display="";c.removeChild(e);c.appendChild(e)}}else d.style.display="none",e.style.display="none"}};
links.Timeline.prototype.redrawNavigation=function(){var a=this,b=this.options,c=this.dom,d=c.frame,e=c.navBar;if(!e){if(b.editable||b.showNavigation)e=document.createElement("DIV"),e.style.position="absolute",e.className="timeline-navigation",b.groupsOnRight?e.style.left="10px":e.style.right="10px",b.axisOnTop?e.style.bottom="10px":e.style.top="10px",c.navBar=e,d.appendChild(e);if(b.editable&&b.showButtonAdd)e.addButton=document.createElement("DIV"),e.addButton.className="timeline-navigation-new",
e.addButton.title="Create new event",links.Timeline.addEventListener(e.addButton,"mousedown",function(c){links.Timeline.preventDefault(c);links.Timeline.stopPropagation(c);var d=a.size.contentWidth,e=d/2,c=a.screenToTime(e-d/10),d=a.screenToTime(e+d/10);b.snapEvents&&(a.step.snap(c),a.step.snap(d));a.addItem({start:c,end:d,content:"New",group:a.groups.length?a.groups[0].content:void 0});c=a.items.length-1;a.selectItem(c);a.applyAdd=!0;a.trigger("add");a.applyAdd||a.deleteItem(c);a.redrawDeleteButton();
a.redrawDragAreas()}),e.appendChild(e.addButton);if(b.editable&&b.showButtonAdd&&b.showNavigation)e.addButton.style.borderRightWidth="1px",e.addButton.style.borderRightStyle="solid";if(b.showNavigation)e.zoomInButton=document.createElement("DIV"),e.zoomInButton.className="timeline-navigation-zoom-in",e.zoomInButton.title="Zoom in",links.Timeline.addEventListener(e.zoomInButton,"mousedown",function(b){links.Timeline.preventDefault(b);links.Timeline.stopPropagation(b);a.zoom(0.4);a.trigger("rangechange");
a.trigger("rangechanged")}),e.appendChild(e.zoomInButton),e.zoomOutButton=document.createElement("DIV"),e.zoomOutButton.className="timeline-navigation-zoom-out",e.zoomOutButton.title="Zoom out",links.Timeline.addEventListener(e.zoomOutButton,"mousedown",function(b){links.Timeline.preventDefault(b);links.Timeline.stopPropagation(b);a.zoom(-0.4);a.trigger("rangechange");a.trigger("rangechanged")}),e.appendChild(e.zoomOutButton),e.moveLeftButton=document.createElement("DIV"),e.moveLeftButton.className=
"timeline-navigation-move-left",e.moveLeftButton.title="Move left",links.Timeline.addEventListener(e.moveLeftButton,"mousedown",function(b){links.Timeline.preventDefault(b);links.Timeline.stopPropagation(b);a.move(-0.2);a.trigger("rangechange");a.trigger("rangechanged")}),e.appendChild(e.moveLeftButton),e.moveRightButton=document.createElement("DIV"),e.moveRightButton.className="timeline-navigation-move-right",e.moveRightButton.title="Move right",links.Timeline.addEventListener(e.moveRightButton,
"mousedown",function(b){links.Timeline.preventDefault(b);links.Timeline.stopPropagation(b);a.move(0.2);a.trigger("rangechange");a.trigger("rangechanged")}),e.appendChild(e.moveRightButton)}};links.Timeline.prototype.setCurrentTime=function(a){var b=new Date;this.clientTimeOffset=a.getTime()-b.getTime();this.redrawCurrentTime()};links.Timeline.prototype.getCurrentTime=function(){return new Date((new Date).getTime()+this.clientTimeOffset)};
links.Timeline.prototype.setCustomTime=function(a){this.customTime=new Date(a);this.redrawCustomTime()};links.Timeline.prototype.getCustomTime=function(){return new Date(this.customTime)};links.Timeline.prototype.setScale=function(a,b){this.step.setScale(a,b);this.redrawFrame()};links.Timeline.prototype.setAutoScale=function(a){this.step.setAutoScale(a);this.redrawFrame()};links.Timeline.prototype.redraw=function(){this.setData(this.data)};
links.Timeline.prototype.checkResize=function(){this.recalcSize()&&this.redrawFrame()};links.Timeline.filterImageUrls=function(a,b){for(var c=a.firstChild;c;){if(c.tagName=="IMG"){var d=c.src;b.indexOf(d)==-1&&b.push(d)}links.Timeline.filterImageUrls(c,b);c=c.nextSibling}};
links.Timeline.prototype.recalcSize=function(){var a=!1,b=this,c=this.size,d=this.options,e=d.axisOnTop,g=this.dom,f=g.axis,j=this.groups,l=g.groups.labels,p=this.items,o=c.groupsWidth,u=f.characterMinor?f.characterMinor.clientWidth:0,v=f.characterMinor?f.characterMinor.clientHeight:0,s=f.characterMajor?f.characterMajor.clientWidth:0,f=f.characterMajor?f.characterMajor.clientHeight:0,r=v+(d.showMajorLabels?f:0),q=c.actualHeight||r;if(c.dataChanged){for(var m=[],n=0,k=p.length;n<k;n++){var h=p[n],
t=h.dom;t&&links.Timeline.filterImageUrls(t,m)}if(m.length)for(n=0;n<m.length;n++)links.imageloader.load(m[n],function(){b.redraw()},!1)}if(c.dataChanged){n=o=0;for(k=l.length;n<k;n++)m=j[n],m.width=l[n].clientWidth,m.height=l[n].clientHeight,m.labelHeight=m.height,o=Math.max(o,m.width);n=0;for(k=p.length;n<k;n++){h=p[n];t=h.dom;m=h.group;q=t?t.clientWidth:0;l=t?t.clientHeight:0;a=(a=a||h.width!=q)||h.height!=l;h.width=q;h.height=l;switch(h.type){case "box":h.dotHeight=t.dot.offsetHeight;h.dotWidth=
t.dot.offsetWidth;h.lineWidth=t.line.offsetWidth;break;case "dot":h.dotHeight=t.dot.offsetHeight,h.dotWidth=t.dot.offsetWidth,h.contentHeight=t.content.offsetHeight}if(m)m.height=m.height?Math.max(m.height,h.height):h.height}q=r+2*d.eventMarginAxis;n=0;for(k=j.length;n<k;n++)q+=j[n].height+d.eventMargin}if(j.length==0&&d.autoHeight){m=q=0;if(this.animation&&this.animation.finalItems){h=this.animation.finalItems;if((t=h[0])&&t.top)q=t.top,m=t.top+t.height;n=1;for(k=h.length;n<k;n++)t=h[n],q=Math.min(q,
t.top),m=Math.max(m,t.top+t.height)}else{if((h=p[0])&&h.top)q=h.top,m=h.top+h.height;n=1;for(k=p.length;n<k;n++)h=p[n],h.top&&(q=Math.min(q,h.top),m=Math.max(m,h.top+h.height))}q=m-q+2*d.eventMarginAxis+r;if(c.actualHeight!=q&&d.autoHeight&&!d.axisOnTop)if(m=q-c.actualHeight,this.animation&&this.animation.finalItems){h=this.animation.finalItems;n=0;for(k=h.length;n<k;n++)h[n].top+=m,h[n].item.top+=m}else{n=0;for(k=p.length;n<k;n++)p[n].top+=m}}var t=g.frame?g.frame.offsetWidth:0,l=Math.max(d.autoHeight?
q:g.frame?g.frame.clientHeight:0,d.minHeight),x=e?0:l-r,w=e?r:x,y=e?r:0,z=Math.max(l-r,0);d.groupsWidth!==void 0&&(o=g.groups.frame?g.groups.frame.clientWidth:0);var A=d.groupsOnRight?t-o:0;if(c.dataChanged){a=d.eventMargin;h=e?d.eventMarginAxis+a/2:z-d.eventMarginAxis+a/2;n=0;for(k=j.length;n<k;n++)m=j[n],e?(m.top=h,m.labelTop=h+r+(m.height-m.labelHeight)/2,m.lineTop=h+r+m.height+a/2,h+=m.height+a):(h-=m.height+a,m.top=h,m.labelTop=h+(m.height-m.labelHeight)/2,m.lineTop=h-a/2);n=0;for(k=p.length;n<
k;n++)if(h=p[n],m=h.group)h.top=m.top;a=!0}a=(a=(a=a||c.groupsWidth!==o)||c.groupsLeft!==A)||c.actualHeight!==q;c.groupsWidth=o;c.groupsLeft=A;c.actualHeight=q;a=(a=a||c.frameWidth!==t)||c.frameHeight!==l;c.frameWidth=t;c.frameHeight=l;a=a||c.groupsWidth!==o;c.groupsWidth=o;c.contentLeft=d.groupsOnRight?0:o;c.contentWidth=Math.max(t-o,0);c.contentHeight=z;a=(a=(a=(a=a||c.axis.top!==x)||c.axis.line!==w)||c.axis.height!==r)||c.items.top!==y;c.axis.top=x;c.axis.line=w;c.axis.height=r;c.axis.labelMajorTop=
d.axisOnTop?0:w+v;c.axis.labelMinorTop=d.axisOnTop?d.showMajorLabels?f:0:w;c.axis.lineMinorTop=d.axisOnTop?c.axis.labelMinorTop:0;c.axis.lineMinorHeight=d.showMajorLabels?l-f:l;c.axis.lineMinorWidth=g.axis.minorLines.length?g.axis.minorLines[0].offsetWidth:1;c.axis.lineMajorWidth=g.axis.majorLines.length?g.axis.majorLines[0].offsetWidth:1;c.items.top=y;a=(a=(a=(a=a||c.axis.characterMinorWidth!==u)||c.axis.characterMinorHeight!==v)||c.axis.characterMajorWidth!==s)||c.axis.characterMajorHeight!==f;
c.axis.characterMinorWidth=u;c.axis.characterMinorHeight=v;c.axis.characterMajorWidth=s;c.axis.characterMajorHeight=f;this.recalcConversion();return a};links.Timeline.prototype.recalcConversion=function(){this.conversion.offset=parseFloat(this.start.valueOf());this.conversion.factor=parseFloat(this.size.contentWidth)/parseFloat(this.end.valueOf()-this.start.valueOf())};links.Timeline.prototype.screenToTime=function(a){var b=this.conversion;return new Date(parseFloat(a)/b.factor+b.offset)};
links.Timeline.prototype.timeToScreen=function(a){var b=this.conversion;return(a.valueOf()-b.offset)*b.factor};links.Timeline.prototype.onTouchStart=function(a){var b=this.eventParams,c=this;if(!b.touchDown){b.touchDown=!0;b.zoomed=!1;this.onMouseDown(a);if(!b.onTouchMove)b.onTouchMove=function(a){c.onTouchMove(a)},links.Timeline.addEventListener(document,"touchmove",b.onTouchMove);if(!b.onTouchEnd)b.onTouchEnd=function(a){c.onTouchEnd(a)},links.Timeline.addEventListener(document,"touchend",b.onTouchEnd)}};
links.Timeline.prototype.onTouchMove=function(a){var b=this.eventParams;if(a.scale&&a.scale!==1)b.zoomed=!0;if(b.zoomed){if(this.options.zoomable){b.zoomed=!0;var c=b.end.valueOf()-b.start.valueOf(),d=c/a.scale-c,c=new Date(parseInt(b.start.valueOf()-d/2)),b=new Date(parseInt(b.end.valueOf()+d/2));this.setVisibleChartRange(c,b);timeline.trigger("rangechange");links.Timeline.preventDefault(a)}}else this.onMouseMove(a)};
links.Timeline.prototype.onTouchEnd=function(a){var b=this.eventParams;b.touchDown=!1;b.zoomed&&timeline.trigger("rangechanged");b.onTouchMove&&(links.Timeline.removeEventListener(document,"touchmove",b.onTouchMove),delete b.onTouchMove);b.onTouchEnd&&(links.Timeline.removeEventListener(document,"touchend",b.onTouchEnd),delete b.onTouchEnd);this.onMouseUp(a)};
links.Timeline.prototype.onMouseDown=function(a){var a=a||window.event,b=this.eventParams,c=this.options,d=this.dom;if((a.which?a.which==1:a.button==1)||b.touchDown){this.recalcSize();b.touchDown?(b.mouseX=a.targetTouches[0].clientX,b.mouseY=a.targetTouches[0].clientY):(b.mouseX=a.clientX,b.mouseY=a.clientY);if(b.mouseX===void 0)b.mouseX=0;if(b.mouseY===void 0)b.mouseY=0;b.frameLeft=links.Timeline.getAbsoluteLeft(this.dom.content);b.frameTop=links.Timeline.getAbsoluteTop(this.dom.content);b.previousLeft=
0;b.previousOffset=0;b.moved=!1;b.start=new Date(this.start);b.end=new Date(this.end);b.target=links.Timeline.getTarget(a);b.itemDragLeft=b.target===this.dom.items.dragLeft;b.itemDragRight=b.target===this.dom.items.dragRight;b.itemIndex=b.itemDragLeft||b.itemDragRight?this.selection?this.selection.index:void 0:this.getItemIndex(b.target);b.customTime=b.target===d.customTime||b.target.parentNode===d.customTime?this.customTime:void 0;b.addItem=c.editable&&a.ctrlKey;if(b.addItem){var e=b.mouseY-b.frameTop,
d=this.screenToTime(b.mouseX-b.frameLeft);c.snapEvents&&this.step.snap(d);var g=new Date(d),e=this.getGroupFromHeight(e);this.addItem({start:d,end:g,content:"New",group:e.content});b.itemIndex=this.items.length-1;this.selectItem(b.itemIndex);b.itemDragRight=!0}b.editItem=c.editable?this.isSelected(b.itemIndex):void 0;b.editItem?(c=this.items[b.itemIndex],b.itemStart=c.start,b.itemEnd=c.end,b.itemType=c.type,b.itemType=="range"?(b.itemLeft=this.timeToScreen(c.start),b.itemRight=this.timeToScreen(c.end)):
b.itemLeft=this.timeToScreen(c.start)):this.dom.frame.style.cursor="move";if(!b.touchDown){var f=this;if(!b.onMouseMove)b.onMouseMove=function(a){f.onMouseMove(a)},links.Timeline.addEventListener(document,"mousemove",b.onMouseMove);if(!b.onMouseUp)b.onMouseUp=function(a){f.onMouseUp(a)},links.Timeline.addEventListener(document,"mouseup",b.onMouseUp);links.Timeline.preventDefault(a)}}};
links.Timeline.prototype.onMouseMove=function(a){var a=a||window.event,b=this.eventParams,c=this.size,d=this.dom,e=this.options,g,f;b.touchDown?(g=a.targetTouches[0].clientX,f=a.targetTouches[0].clientY):(g=a.clientX,f=a.clientY);g===void 0&&(g=0);f===void 0&&(f=0);if(b.mouseX===void 0)b.mouseX=g;if(b.mouseY===void 0)b.mouseY=f;g=parseFloat(g)-b.mouseX;parseFloat(f);b.moved=!0;if(b.customTime)this.customTime=this.screenToTime(this.timeToScreen(b.customTime)+g),this.redrawCustomTime(),this.trigger("timechange");
else if(b.editItem){var d=this.items[b.itemIndex],j;if(b.itemDragLeft){if(c=b.itemLeft+g,j=b.itemRight,d.start=this.screenToTime(c),e.snapEvents&&(this.step.snap(d.start),c=this.timeToScreen(d.start)),c>j)c=j,d.start=this.screenToTime(c)}else if(b.itemDragRight){if(c=b.itemLeft,j=b.itemRight+g,d.end=this.screenToTime(j),e.snapEvents&&(this.step.snap(d.end),j=this.timeToScreen(d.end)),j<c)j=c,d.end=this.screenToTime(j)}else if(c=b.itemLeft+g,d.start=this.screenToTime(c),e.snapEvents&&(this.step.snap(d.start),
c=this.timeToScreen(d.start)),d.end)j=c+(b.itemRight-b.itemLeft),d.end=this.screenToTime(j);this.repositionItem(d,c,j);if(this.groups.length==0)this.stackEvents(e.animate),e.animate||this.redrawFrame();else if(e.groupsChangeable&&(b=this.getGroupFromHeight(f-b.frameTop),d.group!==b))this.changeItem(this.items.indexOf(d),{group:b.content}),d.top=b.top,this.repositionItem(d);this.redrawDeleteButton();this.redrawDragAreas()}else if(e.moveable)e=b.end.valueOf()-b.start.valueOf(),f=Math.round(parseFloat(-g)/
c.contentWidth*e),g=new Date(b.start.valueOf()+f),this.applyRange(g,new Date(b.end.valueOf()+f)),(g=this.start.valueOf()-g.valueOf())&&(f+=g),this.recalcConversion(),g=b.previousLeft||0,j=parseFloat(d.items.frame.style.left)||0,g=(b.previousOffset||0)+(j-g),c=-f/e*c.contentWidth+g,b.previousOffset=g,b.previousLeft=c,d.items.frame.style.left=c+"px",this.redrawCurrentTime(),this.redrawCustomTime(),this.redrawAxis(),this.trigger("rangechange");links.Timeline.preventDefault(a)};
links.Timeline.prototype.onMouseUp=function(){var a=this.eventParams,b=this.options;this.dom.frame.style.cursor="auto";a.onMouseMove&&(links.Timeline.removeEventListener(document,"mousemove",a.onMouseMove),delete a.onMouseMove);a.onMouseUp&&(links.Timeline.removeEventListener(document,"mouseup",a.onMouseUp),delete a.onMouseUp);if(a.customTime)this.trigger("timechanged");else if(a.editItem){var c=this.items[a.itemIndex];if(a.moved||a.addItem)this.applyAdd=this.applyChange=!0,this.updateData(a.itemIndex,
{start:c.start,end:c.end}),this.trigger(a.addItem?"add":"change"),a.addItem?this.applyAdd?this.updateData(a.itemIndex,{start:c.start,end:c.end,content:c.content,group:c.group?c.group.content:void 0}):this.deleteItem(a.itemIndex):this.applyChange?this.updateData(a.itemIndex,{start:c.start,end:c.end}):(delete this.applyChange,delete this.applyAdd,c=this.items[a.itemIndex],c.start=a.itemStart,c.end=a.itemEnd,this.repositionItem(c,a.itemLeft,a.itemRight)),this.recalcSize(),this.stackEvents(b.animate),
b.animate||this.redrawFrame(),this.redrawDeleteButton(),this.redrawDragAreas()}else!a.moved&&!a.zoomed?b.editable&&a.target===this.dom.items.deleteButton?(this.selection&&this.confirmDeleteItem(this.selection.index),this.redrawFrame()):b.selectable&&(a.itemIndex!==void 0?this.isSelected(a.itemIndex)||(this.selectItem(a.itemIndex),this.redrawDeleteButton(),this.redrawDragAreas(),this.trigger("select")):(this.unselectItem(),this.redrawDeleteButton(),this.redrawDragAreas())):(this.redrawFrame(),(a.moved&&
b.moveable||a.zoomed&&b.zoomable)&&this.trigger("rangechanged"))};
links.Timeline.prototype.onDblClick=function(a){var b=this.eventParams,c=this.options,d=this.dom,e=this.size,a=a||window.event;if(c.editable){if(b.itemIndex!==void 0)this.trigger("edit");else{var g=a.clientX-links.Timeline.getAbsoluteLeft(d.content),f=a.clientY-links.Timeline.getAbsoluteTop(d.content),d=this.screenToTime(g),e=this.screenToTime(g+e.frameWidth/10);c.snapEvents&&(this.step.snap(d),this.step.snap(e));c=this.getGroupFromHeight(f);this.addItem({start:d,end:e,content:"New",group:c.content});
b.itemIndex=this.items.length-1;this.selectItem(b.itemIndex);this.applyAdd=!0;this.trigger("add");this.applyAdd||this.deleteItem(b.itemIndex);this.redrawDeleteButton();this.redrawDragAreas()}links.Timeline.preventDefault(a)}};
links.Timeline.prototype.onMouseWheel=function(a){if(this.options.zoomable){if(!a)a=window.event;var b=0;a.wheelDelta?b=a.wheelDelta/120:a.detail&&(b=-a.detail/3);if(b){var c=this;(function(){c.recalcSize();var d=b/5,e=links.Timeline.getAbsoluteLeft(c.dom.content),e=a.clientX!=void 0&&e!=void 0?c.screenToTime(a.clientX-e):void 0;c.zoom(d,e);c.trigger("rangechange");c.trigger("rangechanged")})()}links.Timeline.preventDefault(a)}};
links.Timeline.prototype.zoom=function(a,b){b==void 0&&(b=new Date((this.start.valueOf()+this.end.valueOf())/2));a>=1&&(a=0.9);a<=-1&&(a=-0.9);a<0&&(a/=1+a);var c=parseFloat(this.start.valueOf()-b.valueOf()),d=parseFloat(this.end.valueOf()-b.valueOf());this.applyRange(new Date(this.start.valueOf()-c*a),new Date(this.end.valueOf()-d*a),b);this.recalcSize();c=this.options.animate?this.options.animateZoom:!1;this.stackEvents(c);(!c||this.groups.length>0)&&this.redrawFrame()};
links.Timeline.prototype.move=function(a){var b=parseFloat(this.end.valueOf()-this.start.valueOf());this.applyRange(new Date(this.start.valueOf()+b*a),new Date(this.end.valueOf()+b*a));this.recalcConversion();this.redrawFrame()};
links.Timeline.prototype.repositionItem=function(a,b,c){var d=a.dom;switch(a.type){case "range":d.style.left=b+"px";d.style.width=Math.max(c-b,1)+"px";break;case "box":d.style.left=b-a.width/2+"px";d.line.style.left=b-a.lineWidth/2+"px";d.dot.style.left=b-a.dotWidth/2+"px";break;case "dot":d.style.left=b-a.dotWidth/2+"px"}if(this.groups.length>0)d.style.top=a.top+"px"};
links.Timeline.prototype.applyRange=function(a,b,c){var a=a.valueOf(),b=b.valueOf(),d=b-a,e=this.options,g=Number(e.intervalMin)||10;g<10&&(g=10);var f=Number(e.intervalMax)||31536E10;f>31536E10&&(f=31536E10);f<g&&(f=g);var j=e.min?e.min.valueOf():void 0,e=e.max?e.max.valueOf():void 0;j&&e&&(j>=e&&(e=j+864E5),f>e-j&&(f=e-j),g>e-j&&(g=e-j));a>=b&&(b+=864E5);if(d<g){g-=d;var l=c?(c.valueOf()-a)/d:0.5;a-=Math.round(g*l);b+=Math.round(g*(1-l))}d>f&&(g=d-f,l=c?(c.valueOf()-a)/d:0.5,a+=Math.round(g*l),
b-=Math.round(g*(1-l)));j&&(g=a-j,g<0&&(a-=g,b-=g));e&&(g=e-b,g<0&&(a+=g,b+=g));this.start=new Date(a);this.end=new Date(b)};links.Timeline.prototype.confirmDeleteItem=function(a){this.applyDelete=!0;this.isSelected(a)||this.selectItem(a);this.trigger("delete");this.applyDelete&&this.deleteItem(a);delete this.applyDelete};
links.Timeline.prototype.deleteItem=function(a){if(a>=this.items.length)throw"Cannot delete row, index out of range";this.unselectItem();this.items.splice(a,1);if(this.data)if(google&&google.visualization&&this.data instanceof google.visualization.DataTable)this.data.removeRow(a);else if(links.Timeline.isArray(this.data))this.data.splice(a,1);else throw"Cannot delete row from data, unknown data type";this.size.dataChanged=!0;this.redrawFrame();this.recalcSize();this.stackEvents(this.options.animate);
this.options.animate||this.redrawFrame();this.size.dataChanged=!1};
links.Timeline.prototype.deleteAllItems=function(){this.unselectItem();this.items=[];this.deleteGroups();if(this.data)if(google&&google.visualization&&this.data instanceof google.visualization.DataTable)this.data.removeRows(0,this.data.getNumberOfRows());else if(links.Timeline.isArray(this.data))this.data.splice(0,this.data.length);else throw"Cannot delete row from data, unknown data type";this.size.dataChanged=!0;this.redrawFrame();this.recalcSize();this.stackEvents(this.options.animate);this.options.animate||
this.redrawFrame();this.size.dataChanged=!1};links.Timeline.prototype.getGroupFromHeight=function(a){var b=this.groups,c=this.size;a-=this.options.axisOnTop?c.axis.height:0;if(b){for(var d,c=b.length-1;c>=0;c--)if(d=b[c],a>d.top)break;return d}};links.Timeline.prototype.getItem=function(a){if(a>=this.items.length)throw"Cannot get item, index out of range";var a=this.items[a],b={};b.start=new Date(a.start);if(a.end)b.end=new Date(a.end);b.content=a.content;if(a.group)b.group=a.group.content;return b};
links.Timeline.prototype.addItem=function(a){this.addItems([a])};links.Timeline.prototype.addItems=function(a){for(var b=this.items,c=0,d=a.length;c<d;c++){var e=a[c];this.addGroup(e.group);b.push(this.createItem(e));this.updateData(b.length-1,e)}this.size.dataChanged=!0;this.redrawFrame();this.recalcSize();this.stackEvents(!1);this.redrawFrame();this.size.dataChanged=!1};
links.Timeline.prototype.createItem=function(a){return{start:a.start,end:a.end,content:a.content,type:a.end?"range":this.options.style,group:this.findGroup(a.group),top:0,left:0,width:0,height:0,lineWidth:0,dotWidth:0,dotHeight:0}};
links.Timeline.prototype.changeItem=function(a,b){if(a>=this.items.length)throw"Cannot change item, index out of range";var c=this.items[a];if(b.start)c.start=b.start;if(b.end)c.end=b.end;if(b.content)c.content=b.content;if(b.group)c.group=this.addGroup(b.group);this.updateData(a,b);this.size.dataChanged=!0;this.redrawFrame();this.recalcSize();this.stackEvents(!1);this.redrawFrame();this.size.dataChanged=!1};
links.Timeline.prototype.findGroup=function(a){a=this.groupIndexes[a];return a!=void 0?this.groups[a]:void 0};links.Timeline.prototype.deleteGroups=function(){this.groups=[];this.groupIndexes={}};
links.Timeline.prototype.addGroup=function(a){var b=this.groups,c=this.groupIndexes,d=void 0,d=c[a];if(d===void 0&&a!==void 0){d={content:a,labelTop:0,lineTop:0};b.push(d);for(var b=b.sort(function(a,b){return a.content>b.content?1:a.content<b.content?-1:0}),a=0,e=b.length;a<e;a++)c[b[a].content]=a}else d=b[d];return d};links.Timeline.prototype.cancelChange=function(){this.applyChange=!1};links.Timeline.prototype.cancelDelete=function(){this.applyDelete=!1};
links.Timeline.prototype.cancelAdd=function(){this.applyAdd=!1};links.Timeline.prototype.setSelection=function(a){if(a!=void 0&&a.length>0){if(a[0].row!=void 0){var b=a[0].row;if(this.items[b])return a=this.items[b],this.selectItem(b),b=a.start,a=a.end,a=a!=void 0?new Date((a.valueOf()+b.valueOf())/2):new Date(b),b=this.end.valueOf()-this.start.valueOf(),this.setVisibleChartRange(new Date(a.valueOf()-b/2),new Date(a.valueOf()+b/2)),!0}}else this.unselectItem();return!1};
links.Timeline.prototype.getSelection=function(){var a=[];this.selection&&a.push({row:this.selection.index});return a};
links.Timeline.prototype.selectItem=function(a){this.unselectItem();this.selection=void 0;if(this.items[a]!==void 0){var b=this.items[a],c=b.dom;this.selection={index:a,item:c};if(this.options.editable)c.style.cursor="move";switch(b.type){case "range":c.className="timeline-event timeline-event-selected timeline-event-range";break;case "box":c.className="timeline-event timeline-event-selected timeline-event-box";c.line.className="timeline-event timeline-event-selected timeline-event-line";c.dot.className=
"timeline-event timeline-event-selected timeline-event-dot";break;case "dot":c.className="timeline-event timeline-event-selected",c.dot.className="timeline-event timeline-event-selected timeline-event-dot"}}};links.Timeline.prototype.isSelected=function(a){return this.selection&&this.selection.index===a};
links.Timeline.prototype.unselectItem=function(){if(this.selection){var a=this.items[this.selection.index];if(a&&a.dom){var b=a.dom;b.style.cursor="";switch(a.type){case "range":b.className="timeline-event timeline-event-range";break;case "box":b.className="timeline-event timeline-event-box";b.line.className="timeline-event timeline-event-line";b.dot.className="timeline-event timeline-event-dot";break;case "dot":b.className="",b.dot.className="timeline-event timeline-event-dot"}}}this.selection=void 0};
links.Timeline.prototype.stackEvents=function(a){if(!(this.groups.length>0)){a==void 0&&(a=!1);var b=this.stackOrder(this.items),c=this.stackCalculateFinal(b,a);if(a){var d=this.animation;if(!d)this.animation=d={};d.finalItems=c;var e=this,g=function(){var a=e.stackMoveOneStep(b,d.finalItems);e.recalcSize();e.redrawFrame();a?(delete d.finalItems,delete d.timer):d.timer=setTimeout(g,30)};if(!d.timer)d.timer=setTimeout(g,30)}else this.stackMoveToFinal(b,c),this.recalcSize()}};
links.Timeline.prototype.stackOrder=function(a){a=a.concat([]);a.sort(function(a,c){return a.type=="range"&&c.type!="range"?-1:a.type!="range"&&c.type=="range"?1:a.left-c.left});return a};
links.Timeline.prototype.stackCalculateFinal=function(a){for(var b=this.size.axis.top,c=this.options,d=c.axisOnTop,e=c.eventMargin,g=c.eventMarginAxis,c=[],f=0,j=a.length;f<j;f++){var l=a[f],p,o,u,v,s=l.height,r=l.width;p=d?b+g+e/2:b-s-g-e/2;v=p+s;switch(l.type){case "range":case "dot":o=this.timeToScreen(l.start);u=l.end?this.timeToScreen(l.end):o+r;break;case "box":o=this.timeToScreen(l.start)-r/2,u=o+r}c[f]={left:o,top:p,right:u,bottom:v,height:s,item:l}}if(this.options.stackEvents){f=0;for(j=
c.length;f<j;f++){a=c[f];b=null;do if(b=this.stackEventsCheckOverlap(c,f,0,f-1),b!=null)a.top=d?b.top+b.height+e:b.top-a.height-e,a.bottom=a.top+a.height;while(b)}}return c};
links.Timeline.prototype.stackMoveOneStep=function(a,b){var c=!0;for(i=0,iMax=a.length;i<iMax;i++){var d=b[i],e=d.item,g=parseInt(e.top),f=parseInt(d.top),j=f-g;if(j){var l=f==g?0:f>g?1:-1;Math.abs(j)>4&&(l=j/4);g=parseInt(g+l);g!=f&&(c=!1);e.top=g;e.bottom=e.top+e.height}else e.top=d.top,e.bottom=d.bottom;e.left=d.left;e.right=d.right}return c};
links.Timeline.prototype.stackMoveToFinal=function(a,b){for(i=0,iMax=a.length;i<iMax;i++){var c=a[i],d=b[i];c.left=d.left;c.top=d.top;c.right=d.right;c.bottom=d.bottom}};links.Timeline.prototype.stackEventsCheckOverlap=function(a,b,c,d){for(var e=this.options.eventMargin,g=this.collision,f=a[b];d>=c;d--){var j=a[d];if(g(f,j,e)&&d!=b)return j}};links.Timeline.prototype.collision=function(a,b,c){c==void 0&&(c=0);return a.left-c<b.right&&a.right+c>b.left&&a.top-c<b.bottom&&a.bottom+c>b.top};
links.Timeline.prototype.trigger=function(a){var b=null;switch(a){case "rangechange":case "rangechanged":b={start:new Date(this.start),end:new Date(this.end)};break;case "timechange":case "timechanged":b={time:new Date(this.customTime)}}links.events.trigger(this,a,b);google&&google.visualization&&google.visualization.events.trigger(this,a,b)};
links.events=links.events||{listeners:[],indexOf:function(a){for(var b=this.listeners,c=0,d=this.listeners.length;c<d;c++){var e=b[c];if(e&&e.object==a)return c}return-1},addListener:function(a,b,c){var d=this.listeners[this.indexOf(a)];d||(d={object:a,events:{}},this.listeners.push(d));a=d.events[b];a||(a=[],d.events[b]=a);a.indexOf(c)==-1&&a.push(c)},removeListener:function(a,b,c){var a=this.indexOf(a),d=this.listeners[a];if(d){var e=d.events[b];e&&(a=e.indexOf(c),a!=-1&&e.splice(a,1),e.length==
0&&delete d.events[b]);var b=0,c=d.events,g;for(g in c)c.hasOwnProperty(g)&&b++;b==0&&delete this.listeners[a]}},removeAllListeners:function(){this.listeners=[]},trigger:function(a,b,c){if(a=this.listeners[this.indexOf(a)])if(b=a.events[b])for(var a=0,d=b.length;a<d;a++)b[a](c)}};links.Timeline.StepDate=function(a,b,c){this.current=new Date;this._start=new Date;this._end=new Date;this.autoScale=!0;this.scale=links.Timeline.StepDate.SCALE.DAY;this.step=1;this.setRange(a,b,c)};
links.Timeline.StepDate.SCALE={MILLISECOND:1,SECOND:2,MINUTE:3,HOUR:4,DAY:5,MONTH:6,YEAR:7};links.Timeline.StepDate.prototype.setRange=function(a,b,c){if(!isNaN(a)&&!isNaN(b))this._start=a!=void 0?new Date(a):new Date,this._end=b!=void 0?new Date(b):new Date,this.autoScale&&this.setMinimumStep(c)};links.Timeline.StepDate.prototype.start=function(){this.current=new Date(this._start);this.roundToMinor()};
links.Timeline.StepDate.prototype.roundToMinor=function(){switch(this.scale){case links.Timeline.StepDate.SCALE.YEAR:this.current.setFullYear(this.step*Math.floor(this.current.getFullYear()/this.step)),this.current.setMonth(0);case links.Timeline.StepDate.SCALE.MONTH:this.current.setDate(1);case links.Timeline.StepDate.SCALE.DAY:this.current.setHours(0);case links.Timeline.StepDate.SCALE.HOUR:this.current.setMinutes(0);case links.Timeline.StepDate.SCALE.MINUTE:this.current.setSeconds(0);case links.Timeline.StepDate.SCALE.SECOND:this.current.setMilliseconds(0)}if(this.step!=
1)switch(this.scale){case links.Timeline.StepDate.SCALE.MILLISECOND:this.current.setMilliseconds(this.current.getMilliseconds()-this.current.getMilliseconds()%this.step);break;case links.Timeline.StepDate.SCALE.SECOND:this.current.setSeconds(this.current.getSeconds()-this.current.getSeconds()%this.step);break;case links.Timeline.StepDate.SCALE.MINUTE:this.current.setMinutes(this.current.getMinutes()-this.current.getMinutes()%this.step);break;case links.Timeline.StepDate.SCALE.HOUR:this.current.setHours(this.current.getHours()-
this.current.getHours()%this.step);break;case links.Timeline.StepDate.SCALE.DAY:this.current.setDate(this.current.getDate()-1-(this.current.getDate()-1)%this.step+1);break;case links.Timeline.StepDate.SCALE.MONTH:this.current.setMonth(this.current.getMonth()-this.current.getMonth()%this.step);break;case links.Timeline.StepDate.SCALE.YEAR:this.current.setFullYear(this.current.getFullYear()-this.current.getFullYear()%this.step)}};
links.Timeline.StepDate.prototype.end=function(){return this.current.getTime()>this._end.getTime()};
links.Timeline.StepDate.prototype.next=function(){var a=this.current.getTime();if(this.current.getMonth()<6)switch(this.scale){case links.Timeline.StepDate.SCALE.MILLISECOND:this.current=new Date(this.current.getTime()+this.step);break;case links.Timeline.StepDate.SCALE.SECOND:this.current=new Date(this.current.getTime()+this.step*1E3);break;case links.Timeline.StepDate.SCALE.MINUTE:this.current=new Date(this.current.getTime()+this.step*6E4);break;case links.Timeline.StepDate.SCALE.HOUR:this.current=
new Date(this.current.getTime()+this.step*36E5);var b=this.current.getHours();this.current.setHours(b-b%this.step);break;case links.Timeline.StepDate.SCALE.DAY:this.current.setDate(this.current.getDate()+this.step);break;case links.Timeline.StepDate.SCALE.MONTH:this.current.setMonth(this.current.getMonth()+this.step);break;case links.Timeline.StepDate.SCALE.YEAR:this.current.setFullYear(this.current.getFullYear()+this.step)}else switch(this.scale){case links.Timeline.StepDate.SCALE.MILLISECOND:this.current=
new Date(this.current.getTime()+this.step);break;case links.Timeline.StepDate.SCALE.SECOND:this.current.setSeconds(this.current.getSeconds()+this.step);break;case links.Timeline.StepDate.SCALE.MINUTE:this.current.setMinutes(this.current.getMinutes()+this.step);break;case links.Timeline.StepDate.SCALE.HOUR:this.current.setHours(this.current.getHours()+this.step);break;case links.Timeline.StepDate.SCALE.DAY:this.current.setDate(this.current.getDate()+this.step);break;case links.Timeline.StepDate.SCALE.MONTH:this.current.setMonth(this.current.getMonth()+
this.step);break;case links.Timeline.StepDate.SCALE.YEAR:this.current.setFullYear(this.current.getFullYear()+this.step)}if(this.step!=1)switch(this.scale){case links.Timeline.StepDate.SCALE.MILLISECOND:this.current.getMilliseconds()<this.step&&this.current.setMilliseconds(0);break;case links.Timeline.StepDate.SCALE.SECOND:this.current.getSeconds()<this.step&&this.current.setSeconds(0);break;case links.Timeline.StepDate.SCALE.MINUTE:this.current.getMinutes()<this.step&&this.current.setMinutes(0);break;
case links.Timeline.StepDate.SCALE.HOUR:this.current.getHours()<this.step&&this.current.setHours(0);break;case links.Timeline.StepDate.SCALE.DAY:this.current.getDate()<this.step+1&&this.current.setDate(1);break;case links.Timeline.StepDate.SCALE.MONTH:this.current.getMonth()<this.step&&this.current.setMonth(0)}if(this.current.getTime()==a)this.current=new Date(this._end)};links.Timeline.StepDate.prototype.getCurrent=function(){return this.current};
links.Timeline.StepDate.prototype.setScale=function(a,b){this.scale=a;if(b>0)this.step=b;this.autoScale=!1};links.Timeline.StepDate.prototype.setAutoScale=function(a){this.autoScale=a};
links.Timeline.StepDate.prototype.setMinimumStep=function(a){if(a!=void 0){if(31104E9>a)this.scale=links.Timeline.StepDate.SCALE.YEAR,this.step=1E3;if(15552E9>a)this.scale=links.Timeline.StepDate.SCALE.YEAR,this.step=500;if(31104E8>a)this.scale=links.Timeline.StepDate.SCALE.YEAR,this.step=100;if(15552E8>a)this.scale=links.Timeline.StepDate.SCALE.YEAR,this.step=50;if(31104E7>a)this.scale=links.Timeline.StepDate.SCALE.YEAR,this.step=10;if(15552E7>a)this.scale=links.Timeline.StepDate.SCALE.YEAR,this.step=
5;if(31104E6>a)this.scale=links.Timeline.StepDate.SCALE.YEAR,this.step=1;if(7776E6>a)this.scale=links.Timeline.StepDate.SCALE.MONTH,this.step=3;if(2592E6>a)this.scale=links.Timeline.StepDate.SCALE.MONTH,this.step=1;if(432E6>a)this.scale=links.Timeline.StepDate.SCALE.DAY,this.step=5;if(1728E5>a)this.scale=links.Timeline.StepDate.SCALE.DAY,this.step=2;if(864E5>a)this.scale=links.Timeline.StepDate.SCALE.DAY,this.step=1;if(144E5>a)this.scale=links.Timeline.StepDate.SCALE.HOUR,this.step=4;if(36E5>a)this.scale=
links.Timeline.StepDate.SCALE.HOUR,this.step=1;if(9E5>a)this.scale=links.Timeline.StepDate.SCALE.MINUTE,this.step=15;if(6E5>a)this.scale=links.Timeline.StepDate.SCALE.MINUTE,this.step=10;if(3E5>a)this.scale=links.Timeline.StepDate.SCALE.MINUTE,this.step=5;if(6E4>a)this.scale=links.Timeline.StepDate.SCALE.MINUTE,this.step=1;if(15E3>a)this.scale=links.Timeline.StepDate.SCALE.SECOND,this.step=15;if(1E4>a)this.scale=links.Timeline.StepDate.SCALE.SECOND,this.step=10;if(5E3>a)this.scale=links.Timeline.StepDate.SCALE.SECOND,
this.step=5;if(1E3>a)this.scale=links.Timeline.StepDate.SCALE.SECOND,this.step=1;if(200>a)this.scale=links.Timeline.StepDate.SCALE.MILLISECOND,this.step=200;if(100>a)this.scale=links.Timeline.StepDate.SCALE.MILLISECOND,this.step=100;if(50>a)this.scale=links.Timeline.StepDate.SCALE.MILLISECOND,this.step=50;if(10>a)this.scale=links.Timeline.StepDate.SCALE.MILLISECOND,this.step=10;if(5>a)this.scale=links.Timeline.StepDate.SCALE.MILLISECOND,this.step=5;if(1>a)this.scale=links.Timeline.StepDate.SCALE.MILLISECOND,
this.step=1}};
links.Timeline.StepDate.prototype.snap=function(a){if(this.scale==links.Timeline.StepDate.SCALE.YEAR){var b=a.getFullYear()+Math.round(a.getMonth()/12);a.setFullYear(Math.round(b/this.step)*this.step);a.setMonth(0);a.setDate(0);a.setHours(0);a.setMinutes(0);a.setSeconds(0);a.setMilliseconds(0)}else if(this.scale==links.Timeline.StepDate.SCALE.MONTH)a.getDate()>15?(a.setDate(1),a.setMonth(a.getMonth()+1)):a.setDate(1),a.setHours(0),a.setMinutes(0),a.setSeconds(0),a.setMilliseconds(0);else if(this.scale==
links.Timeline.StepDate.SCALE.DAY){switch(this.step){case 5:case 2:a.setHours(Math.round(a.getHours()/24)*24);break;default:a.setHours(Math.round(a.getHours()/12)*12)}a.setMinutes(0);a.setSeconds(0);a.setMilliseconds(0)}else if(this.scale==links.Timeline.StepDate.SCALE.HOUR){switch(this.step){case 4:a.setMinutes(Math.round(a.getMinutes()/60)*60);break;default:a.setMinutes(Math.round(a.getMinutes()/30)*30)}a.setSeconds(0);a.setMilliseconds(0)}else if(this.scale==links.Timeline.StepDate.SCALE.MINUTE){switch(this.step){case 15:case 10:a.setMinutes(Math.round(a.getMinutes()/
5)*5);a.setSeconds(0);break;case 5:a.setSeconds(Math.round(a.getSeconds()/60)*60);break;default:a.setSeconds(Math.round(a.getSeconds()/30)*30)}a.setMilliseconds(0)}else if(this.scale==links.Timeline.StepDate.SCALE.SECOND)switch(this.step){case 15:case 10:a.setSeconds(Math.round(a.getSeconds()/5)*5);a.setMilliseconds(0);break;case 5:a.setMilliseconds(Math.round(a.getMilliseconds()/1E3)*1E3);break;default:a.setMilliseconds(Math.round(a.getMilliseconds()/500)*500)}else this.scale==links.Timeline.StepDate.SCALE.MILLISECOND&&
(b=this.step>5?this.step/2:1,a.setMilliseconds(Math.round(a.getMilliseconds()/b)*b))};
links.Timeline.StepDate.prototype.isMajor=function(){switch(this.scale){case links.Timeline.StepDate.SCALE.MILLISECOND:return this.current.getMilliseconds()==0;case links.Timeline.StepDate.SCALE.SECOND:return this.current.getSeconds()==0;case links.Timeline.StepDate.SCALE.MINUTE:return this.current.getHours()==0&&this.current.getMinutes()==0;case links.Timeline.StepDate.SCALE.HOUR:return this.current.getHours()==0;case links.Timeline.StepDate.SCALE.DAY:return this.current.getDate()==1;case links.Timeline.StepDate.SCALE.MONTH:return this.current.getMonth()==
0;case links.Timeline.StepDate.SCALE.YEAR:return!1;default:return!1}};
links.Timeline.StepDate.prototype.getLabelMinor=function(a){var b="Jan,Feb,Mar,Apr,May,Jun,Jul,Aug,Sep,Oct,Nov,Dec".split(",");if(a==void 0)a=this.current;switch(this.scale){case links.Timeline.StepDate.SCALE.MILLISECOND:return String(a.getMilliseconds());case links.Timeline.StepDate.SCALE.SECOND:return String(a.getSeconds());case links.Timeline.StepDate.SCALE.MINUTE:return this.addZeros(a.getHours(),2)+":"+this.addZeros(a.getMinutes(),2);case links.Timeline.StepDate.SCALE.HOUR:return this.addZeros(a.getHours(),
2)+":"+this.addZeros(a.getMinutes(),2);case links.Timeline.StepDate.SCALE.DAY:return String(a.getDate());case links.Timeline.StepDate.SCALE.MONTH:return b[a.getMonth()];case links.Timeline.StepDate.SCALE.YEAR:return String(a.getFullYear());default:return""}};
links.Timeline.StepDate.prototype.getLabelMajor=function(a){var b="January,February,March,April,May,June,July,August,September,October,November,December".split(","),c="Sunday,Monday,Tuesday,Wednesday,Thursday,Friday,Saturday".split(",");if(a==void 0)a=this.current;switch(this.scale){case links.Timeline.StepDate.SCALE.MILLISECOND:return this.addZeros(a.getHours(),2)+":"+this.addZeros(a.getMinutes(),2)+":"+this.addZeros(a.getSeconds(),2);case links.Timeline.StepDate.SCALE.SECOND:return a.getDate()+
" "+b[a.getMonth()]+" "+this.addZeros(a.getHours(),2)+":"+this.addZeros(a.getMinutes(),2);case links.Timeline.StepDate.SCALE.MINUTE:return c[a.getDay()]+" "+a.getDate()+" "+b[a.getMonth()]+" "+a.getFullYear();case links.Timeline.StepDate.SCALE.HOUR:return c[a.getDay()]+" "+a.getDate()+" "+b[a.getMonth()]+" "+a.getFullYear();case links.Timeline.StepDate.SCALE.DAY:return b[a.getMonth()]+" "+a.getFullYear();case links.Timeline.StepDate.SCALE.MONTH:return String(a.getFullYear());default:return""}};
links.Timeline.StepDate.prototype.addZeros=function(a,b){for(var c=""+a;c.length<b;)c="0"+c;return c};
links.imageloader=function(){function a(a){if(c[a]==!0)return!0;var b=new Image;b.src=a;return b.complete?!0:!1}function b(a){return d[a]!=void 0}var c={},d={};return{isLoaded:a,isLoading:b,load:function(e,g,f){f==void 0&&(f=!0);if(a(e))f&&g(e);else if(!b(e)||f){var j=d[e];if(!j)f=new Image,f.src=e,j=[],d[e]=j,f.onload=function(){c[e]=!0;delete d[e];for(var a=0;a<j.length;a++)j[a](e)};j.indexOf(g)==-1&&j.push(g)}}}}();
links.Timeline.addEventListener=function(a,b,c,d){a.addEventListener?(d===void 0&&(d=!1),b==="mousewheel"&&navigator.userAgent.indexOf("Firefox")>=0&&(b="DOMMouseScroll"),a.addEventListener(b,c,d)):a.attachEvent("on"+b,c)};links.Timeline.removeEventListener=function(a,b,c,d){a.removeEventListener?(d===void 0&&(d=!1),b==="mousewheel"&&navigator.userAgent.indexOf("Firefox")>=0&&(b="DOMMouseScroll"),a.removeEventListener(b,c,d)):a.detachEvent("on"+b,c)};
links.Timeline.getTarget=function(a){if(!a)a=window.event;var b;if(a.target)b=a.target;else if(a.srcElement)b=a.srcElement;if(b.nodeType!==void 0&&b.nodeType==3)b=b.parentNode;return b};links.Timeline.stopPropagation=function(a){if(!a)a=window.event;a.stopPropagation?a.stopPropagation():a.cancelBubble=!0};links.Timeline.preventDefault=function(a){if(!a)a=window.event;a.preventDefault?a.preventDefault():a.returnValue=!1};
links.Timeline.getAbsoluteLeft=function(a){for(var b=0;a!=null;)b+=a.offsetLeft,b-=a.scrollLeft,a=a.offsetParent;!document.body.scrollLeft&&window.pageXOffset&&(b-=window.pageXOffset);return b};links.Timeline.getAbsoluteTop=function(a){for(var b=0;a!=null;)b+=a.offsetTop,b-=a.scrollTop,a=a.offsetParent;!document.body.scrollTop&&window.pageYOffset&&(b-=window.pageYOffset);return b};links.Timeline.isArray=function(a){return a instanceof Array?!0:Object.prototype.toString.call(a)==="[object Array]"};
