/*
 * Copyright  2008-2009 SensTools, INRIA
 * 
 * <dev-team@sentools.info>
 * 
 * This software is a set of libraries designed to develop applications
 * for the WSN430 embedded hardware platform.
 * 
 * This software is governed by the CeCILL license under French law and
 * abiding by the rules of distribution of free software.  You can  use, 
 * modify and/ or redistribute the software under the terms of the CeCILL
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info". 
 * 
 * As a counterpart to the access to the source code and  rights to copy,
 * modify and redistribute granted by the license, users are provided only
 * with a limited warranty  and the software&apos;s author,  the holder of the
 * economic rights,  and the successive licensors  have only  limited
 * liability. 
 * 
 * In this respect, the user&apos;s attention is drawn to the risks associated
 * with loading,  using,  modifying and/or developing or reproducing the
 * software by the user in light of its specific status of free software,
 * that may mean  that it is complicated to manipulate,  and  that  also
 * therefore means  that it is reserved for developers  and  experienced
 * professionals having in-depth computer knowledge. Users are therefore
 * encouraged to load and test the software&apos;s suitability as regards their
 * requirements in conditions enabling the security of their systems and/or 
 * data to be ensured and,  more generally, to use and operate it in the 
 * same conditions as regards security. 
 * 
 * The fact that you are presently reading this means that you have had
 * knowledge of the CeCILL license and that you accept its terms.
 */


#include <io.h>
#include <signal.h>
#include <stdio.h>

/* Project includes */
#include "clock.h"
#include "uart0.h"
#include "cc1100.h"


int putchar(int c)
{
    uart0_putchar((char) c);
    return c;
}

uint8_t txframe[128];
uint8_t txlength;

int main( void )
{

    /* Stop the watchdog timer. */
    WDTCTL = WDTPW + WDTHOLD;
    
    /* Setup MCLK 8MHz and SMCLK 1MHz */
    set_mcu_speed_xt2_mclk_8MHz_smclk_1MHz();
    
    /* Enable Interrupts */
    eint();
    
    uart0_init(UART0_CONFIG_1MHZ_115200);
    printf("CC1100 TX test program\r\n");
    
    cc1100_init();
    cc1100_cfg_append_status(CC1100_APPEND_STATUS_ENABLE);
    cc1100_cfg_crc_autoflush(CC1100_CRC_AUTOFLUSH_DISABLE);
    cc1100_cfg_white_data(CC1100_DATA_WHITENING_ENABLE);
    cc1100_cfg_crc_en(CC1100_CRC_CALCULATION_ENABLE);
    cc1100_cfg_freq_if(0x0C);
    cc1100_cfg_fs_autocal(CC1100_AUTOCAL_NEVER);
    
    cc1100_cfg_mod_format(CC1100_MODULATION_MSK);
    
    cc1100_cfg_sync_mode(CC1100_SYNCMODE_30_32);
    
    cc1100_cfg_manchester_en(CC1100_MANCHESTER_DISABLE);
    
    
    printf("CC1100 initialized\r\n");
    
        
    int frameseq = 0;
    while (1)
    {
        cc1100_cmd_idle();
        cc1100_cmd_flush_tx();
        cc1100_cmd_calibrate();
        frameseq ++;
        
        txlength = sprintf(txframe, "Hello World #%i", frameseq);
        
        printf("Sent : %s \r\n", txframe);
        
        cc1100_fifo_put(&txlength, 1);
        cc1100_fifo_put(txframe, txlength);
        
        cc1100_cmd_tx();
        
        micro_delay(0xFFFF);
        micro_delay(0xFFFF);
        micro_delay(0xFFFF);
        micro_delay(0xFFFF);
        micro_delay(0xFFFF);
        micro_delay(0xFFFF);
        micro_delay(0xFFFF);
        micro_delay(0xFFFF);
        micro_delay(0xFFFF);
        micro_delay(0xFFFF);
        micro_delay(0xFFFF);
        micro_delay(0xFFFF);
        
    }
    
    
    return 0;
}

--------------------------------------------------------------------------------
