/****************************************************************************
    LCoV library editor for BSch3V
    Copyright (C) 2004-2005 H.Okada (http://www.suigyodo.com/online)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*****************************************************************************/


// LCoV.cpp : AvP[ṼNX`܂B
//

#include "stdafx.h"
#include "LCoV.h"
#include "MainFrm.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CLCoVApp

BEGIN_MESSAGE_MAP(CLCoVApp, CWinApp)
	ON_COMMAND(ID_APP_ABOUT, OnAppAbout)
END_MESSAGE_MAP()


// CLCoVApp RXgNV

CLCoVApp::CLCoVApp()
{
	// TODO: ̈ʒuɍ\zpR[hǉĂB
	//  InitInstance ̏dvȏׂċLqĂB

	m_bTempMode = false;
	char drive[_MAX_DRIVE];
	char dir[_MAX_DIR];
	char pathModule[_MAX_PATH];

	m_szIniFileDir[0] = '\0';

	m_pszIniFileName = new char[_MAX_PATH];		//pXi[GÅm
												//MFCdeletêŁAŒGAmۂĂ͂ȂB

	//W[̃pX𒲂ׂB
	::GetModuleFileName(NULL,m_moduleFileName,_MAX_PATH);
	::_splitpath(m_moduleFileName,pathModule,dir,NULL,NULL);
	lstrcat(pathModule,dir);	//pathModuleɃW[̃fBNgB\LB

	//JgfBNg
	::GetCurrentDirectory(_MAX_PATH,m_pszIniFileName);	//JgfBNg𓾂
	lstrcat(m_pszIniFileName,"\\");			//\Lǉ

	//W[̃pXƃJgfBNgvȂƂ́A
	//JgfBNgLCOV.INI̗LmFB
	//JgfBNgLCOV.INIƂ͂INIt@CƂĎgB
	if(lstrcmp(pathModule,m_pszIniFileName)!=0){
		lstrcat(m_pszIniFileName,"LCOV.INI");			//LCOV.INIǉ
		FILE *pf=fopen(m_pszIniFileName,"rt");
		if(pf){
			fclose(pf);
			goto EndOfFunc;
		}
	}

	//Windows 2000/XPɂ
	//\Documents and Settings\username\Local Settings\Application Data\SuigyodoONLINE\LCOV.INI TB
	//ꂪƂ́AINIt@CƂĎgB
	OSVERSIONINFO versionInfo;
	versionInfo.dwOSVersionInfoSize=sizeof(OSVERSIONINFO);
	if(GetVersionEx(&versionInfo)){
		if(versionInfo.dwPlatformId == VER_PLATFORM_WIN32_NT){
			if(SHGetSpecialFolderPath(NULL,m_pszIniFileName,CSIDL_LOCAL_APPDATA,FALSE)){
				TRACE("CBSchApp::CBSchApp() %s\n",m_pszIniFileName);
				lstrcat(m_pszIniFileName,"\\SuigyodoONLINE\\LCOV.INI");
				FILE *pf=fopen(m_pszIniFileName,"rt");
				if(pf){
					fclose(pf);
					goto EndOfFunc;
				}
			}
		}
	}

	::_splitpath(m_moduleFileName,drive,dir,NULL,NULL);
	::_makepath(m_pszIniFileName,drive,dir,"LCOV",".INI");

EndOfFunc:
	m_pszProfileName=m_pszIniFileName;	//쐬̃|C^m_pszProfileNameɃRs[
	::_splitpath(m_pszIniFileName,m_szIniFileDir,dir,NULL,NULL);
	::lstrcat(m_szIniFileDir,dir);
}


// B CLCoVApp IuWFNgłB

CLCoVApp theApp;

// CLCoVApp 

BOOL CLCoVApp::InitInstance()
{
	// AvP[V@}jtFXg@visual X^CLɂ邽߂ɁA
	// ComCtl32.dll o[W 6@ȍ~̎gpw肷ꍇ́A
	// Windows XP Ɂ@InitCommonControls() KvłBȂ΁AEBhE쐬ׂ͂Ďs܂B

	// Version 0.69 20101017
	//DLL̓ǂݍ݃pXst@C̃fBNgɐ
	char moduleFileName[_MAX_PATH];
	char dllPath[_MAX_PATH];
	char drive[_MAX_DRIVE];
	char dir[_MAX_DIR];
	::GetModuleFileName(NULL,moduleFileName,_MAX_PATH);
	::_splitpath(moduleFileName,drive,dir,NULL,NULL);
	::_makepath(dllPath,drive,dir,"lcov_lang","dll");
	//܂ Version 0.69 20101017



	CString strVersion;
	strVersion.LoadString(IDS_VERSION);
	HINSTANCE hInstRcOrg = AfxGetResourceHandle();
	HINSTANCE hInstRc = LoadLibrary( dllPath );//Version 0.69 20101017
	if ( hInstRc){				// ꃊ\[XDLL.
		AfxSetResourceHandle(hInstRc);
		//ꃊ\[X̃o[W`FbN
		CString strVersionAddRc;
		strVersionAddRc.LoadString(IDS_VERSION);
		//o[WvȂ΁Ã\[Xnhɖ߂
		if(strVersion.Compare(strVersionAddRc)!=0){
			AfxSetResourceHandle(hInstRcOrg);
		}
	}

	//HINSTANCE hInstRc = LoadLibrary( "lcov_lang.dll");
	//if ( hInstRc){				// ꃊ\[XDLL.
	//	AfxSetResourceHandle(hInstRc);
	//}

	CCommandLineInfo cmdInfo;
	ParseCommandLine(cmdInfo);

	//EBhETCY̕
	int cmdShow;
	int mainframeCx;
	int mainframeCy;
	CMainFrame::IniReadWindowPosition(cmdShow,mainframeCx,mainframeCy);
	if(cmdShow==SW_SHOWMAXIMIZED){	//ő剻ƂOI̍ő剻gBȊOWindows̎wɏ]
		m_nCmdShow = SW_SHOWMAXIMIZED;
	}
	CMainFrame::SetInitialWindowSize(mainframeCx,mainframeCy);




	InitCommonControls();

	CWinApp::InitInstance();

	// OLE Cu܂B
	if (!AfxOleInit())
	{
		AfxMessageBox(IDP_OLE_INIT_FAILED);
		return FALSE;
	}
	AfxEnableControlContainer();
	// W
	// ̋@\g킸ɁAŏIIȎs\t@C̃TCYkꍇ́A
	// ȉAsvȏ[`
	// 폜ĂB
	// ݒ肪i[Ă郌WXg L[ύX܂B
	// TODO: ̕AЖ܂͑gDȂǂ́A
	// K؂ȕɕύXĂB
	//SetRegistryKey(_T("AvP[V EBU[hŐꂽ[J AvP[V"));
	// C EChE쐬ƂÃR[h͐Vt[ EChE IuWFNg쐬A
	// AvP[ṼC EChEɃZbg܂
	LoadStdProfileSettings();  // W INI t@C̃IvV[ނ܂ (MRU ܂)

	CMainFrame* pFrame = new CMainFrame;
	if (!pFrame)
		return FALSE;
	m_pMainWnd = pFrame;
	// t[\[X烍[hč쐬܂
	pFrame->LoadFrame(IDR_MAINFRAME,
		WS_OVERLAPPEDWINDOW | FWS_ADDTOTITLE, NULL,
		NULL);
	// C EBhEꂽ̂ŁA\ƍXVs܂B
	m_pMainWnd->ShowWindow(m_nCmdShow);
	//pFrame->ShowWindow(SW_SHOW);
	pFrame->UpdateWindow();
	if(!cmdInfo.m_strFileName.IsEmpty()){
		pFrame->DoOpen(cmdInfo.m_strFileName);
		char szExt[_MAX_EXT];
		_splitpath(cmdInfo.m_strFileName,NULL,NULL,NULL,szExt);
		if(stricmp(szExt,".tmp")==0){
			m_bTempMode = true;
		}
	}
	// ڔ݂ꍇɂ̂ DragAcceptFiles ĂяoĂB
	//  SDI AvP[Vł́AProcessShellCommand ̒ɂ̌ĂяoȂ΂Ȃ܂B
	return TRUE;
}


// CLCoVApp bZ[W nh



// AvP[Ṽo[WɎg CAboutDlg _CAO

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// _CAO f[^
	enum { IDD = IDD_ABOUTBOX };

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV T|[g

// 
protected:
	DECLARE_MESSAGE_MAP()
public:
	virtual BOOL OnInitDialog();
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
END_MESSAGE_MAP()

// _CAOs邽߂̃AvP[V R}h
void CLCoVApp::OnAppAbout()
{
	CAboutDlg aboutDlg;
	aboutDlg.DoModal();
}


// CLCoVApp bZ[W nh


BOOL CAboutDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// TODO:  ɏǉĂ
	CString msg;
	CString strVersion;
	strVersion.LoadString(IDS_VERSION);
	msg = "LCoV Version ";
	msg += strVersion;
	SetDlgItemText(IDC_STATIC_VERSION,msg);


	return TRUE;  // return TRUE unless you set the focus to a control
	// O : OCX vpeB y[W͕K FALSE Ԃ܂B
}
