/****************************************************************************
    BSch3V schematic capture
    Copyright (C) 1997-2005 H.Okada

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*****************************************************************************/

/****************************************************************************
** XBSch}ʗvfxNX
****************************************************************************/
#ifndef XBSCHCOMMENT_H
#define XBSCHCOMMENT_H

#include "xbsch.h"
#include "xbschobj.h"
#include "SMarkupTextLine.h"

#define COMMENT_Y_OFFSET 2


class SXBSchComment:public SXBSchObj
{
public:
	static string	m_defaultFontName;
	static int	m_defaultFontSize;
	static bool	m_defaultFontBold;
	static bool	m_defaultFontItalic;
	static bool	m_defaultFontUnderline;
	static bool	m_defaultFontStrikeOut;



public:
	//RXgN^
	SXBSchComment();
	//fXgN^
	virtual ~SXBSchComment();

	bool readCe3(SReadCE3&,const SPoint* ,SXBSchDoc*);
	bool writeCe3(SWriteCE3& ,const SPoint* );

    //ID̎擾
	unsigned id(){return ID_COMMENT;}
	unsigned objectFilterValue(){return OBJMASK_COMMENT;} 

	MarkupTextLineList* m_pMarkupTextLineList;


protected:
	string	m_strText;
	bool	m_drawSizeIsValid;
//	int		m_drawAreaVOffset;
	SSize	m_drawSize;
	string	m_fontName;
	int		m_fontSize;
	bool	m_fontBold;
	bool	m_fontItalic;
	bool	m_fontUnderline;
	bool	m_fontStrikeOut;

	SSize	m_1lineDrawSize;
	int		m_width;
	int		m_lineHeight;
	bool	m_enableTag;



public:
	//s
	SXBSchObj* duplicate();
	//W̐ݒ  m_p2ւ̐ݒ𖳌ɂĂ
	void setX2(int){}
	void setY2(int){}
	void setP2(const SPoint&){}
	//E]s
	void mirrorH(){}	//Ȃ
	//]s
	void rotate(){}
	//_w肵đIdvxԂ
	int qSelectWeight(const SPoint& p);
	//͈͂w肵đIs
	unsigned testSelection(const SRect& rc);
	//͈͂IăhbOIs
	unsigned testSelectionForDrag(const SRect& rc);
	//`悪KvǂԂ
	bool qRedraw(const SRect& rc);
	//L͈͂Ԃ
	SRect area();
	SRect rotateRect();


public:
	//LȃIuWFNgȂtrueԂ
	bool qValid(){return (m_strText.length()>0);}
	void setText(const char* psz);
	const char* text(){return m_strText.c_str();}
	//Agr[g̕ύX\ȏꍇtrueԂB
	bool canAttribute(){return true;}
	bool drawSizeIsValid(){return m_drawSizeIsValid;}
//	void setDrawSize(int vOffset,const SSize& size);	//`TCY̐ݒB_AvOffsetォ̃TCY
//	void setDrawSize(const SSize& size);		//`TCY̐ݒ
	void setDrawSize(const SSize& size,const SSize& size1Line);		//`TCY̐ݒ
//	void set1LineDrawSize(const SSize& size);	//1C`掞̃TCY̐ݒ

//	int maxWidth();
	void setWidth(int w);
	int width();

	void setFontName(const char* psz);	//tHg̐ݒ		
	const char* fontName()const {return m_fontName.c_str();}	//tHg̎擾
	void setFontSize(int fontSize);	//tHgTCY̐ݒ
	int	fontSize()const{return m_fontSize;}//tHgTCY̎擾
	void setFontBold(bool istrue);	//{[hݒ
	bool fontBold()const{return m_fontBold;} //{[hݒ擾
	void setFontItalic(bool istrue);//C^bNݒ
	bool fontItalic()const{return m_fontItalic;}//C^bNݒ擾
	void setFontUnderline(bool istrue);//A_[Cݒ
	bool fontUnderline()const{return m_fontUnderline;}//A_[Cݒ擾
	void setFontStrikeOut(bool istrue);//ݒ
	bool fontStrikeOut()const{return m_fontStrikeOut;}//ݒ擾
	void setEnableTag(bool istrue);//^OLݒ
	bool enableTag()const{return m_enableTag;}//^Oݒ擾
	void deleteMarkupLineList();
	void setupMarkupLineList();

	//PƑÎƂɃ~[\ǂԂ
	bool canMirrorSingleSelected() {return false;}//2008/06/26
	//PƑÎƂɉ]\ǂԂ
	bool canRotateSingleSelected() {return false;}//2008/06/26


};

#endif
