
#include "core.h"

uint Memory_Test(uint start, uint end)
{
	uchar flg486 = 0;
	uint i;
	CPU_EFlags eflg;
	CPU_ControlRegister0 cr0;

	eflg.eflags = IO_Load_EFlags();
	eflg.bit.AC = True;
	IO_Store_EFlags(eflg.eflags);

	eflg.eflags = IO_Load_EFlags();
	if(eflg.bit.AC){
		flg486 = 1;
	}
	eflg.bit.AC = False;
	IO_Store_EFlags(eflg.eflags);

	if(flg486 != 0){
		cr0.cr0 = Load_CR0();
		cr0.bit.NW = True;
		cr0.bit.CD = True;
		Store_CR0(cr0.cr0);
	}
	i = Memory_Test_Sub(start, end);
	if(flg486 != 0){
		cr0.cr0 = Load_CR0();
		cr0.bit.NW = False;
		cr0.bit.CD = False;
		Store_CR0(cr0.cr0);
	}
	return i;
}

//Memory Control System
//ctrl[0].addr = 0;
//ctrl[0].size = tags;
//Memory ControlźAǗΏۂ̃̏I[ɔzuB

IO_MemoryControl Memory_Initialize_Control(void *start, uint size, uint tags)
{
	IO_MemoryControl ctrl;

	start = (void *)(((uint)start + 7) & ~7);
	size = (size + 7) & ~7;

//Memory Controlz񂪓镪葽AǗΏۂ̃^Ă邩`FbNB
	if((tags * sizeof(IO_MemoryControlTag)) > size){
		return 0;
	}

//Ǘ̓sA3^OȏȂƊǗȂ̂ŁÃ`FbNB
	if(tags < 3){
		return 0;
	}

//ǗΏۃ͈͂̍ŌォAMemory Controlz̑傫̂ڂn_MemoryControlz̐擪ƂB
	ctrl = (IO_MemoryControl)(start + (size - (tags * sizeof(IO_MemoryControlTag))));
	ctrl[0].addr = 0;
	ctrl[0].size = tags;

	ctrl[1].addr = start;
	ctrl[1].size = size - (tags * sizeof(IO_MemoryControlTag));

	ctrl[2].addr = 0;
	ctrl[2].size = 0xffffffff;

	return ctrl;
}

void Memory_Free(IO_MemoryControl ctrl, void *addr, uint size)
{
	uint i, j, k, minsize;
	uint eflags;

	size = (size + 7) & ~7;

#ifdef CHNOSPROJECT_DEBUG_MEMORY
	debug("DEBUG:MemoryFree:Start ctrl:0x%08X addr:0x%08X size 0x%08X\n", ctrl, addr, size);
#endif

	if(size == 0){
		return;
	}

	eflags = IO_Load_EFlags();

	IO_CLI();

	j = 0;
	k = 0;
	minsize = 0xffffffff;
	for(i = 1; i < ctrl[0].size; i++){
		if(ctrl[i].size == 0xffffffff){	/*I[*/
			break;
		}
		if(ctrl[i].size < minsize){	/*ŏ󂫃̌*/
			k = i;
		}
		if(addr + size <= ctrl[i].addr){	/*悤ƂĂ󂫃̎ɗׂ󂫃*/
#ifdef CHNOSPROJECT_DEBUG_MEMORY
	debug("DEBUG:MemoryFree:Found NextTagIndex:%d\n", i);
#endif
			j = i;
			break;
		}
	}
	for(i--; i < ctrl[0].size; i++){
		if(ctrl[i].size == 0xffffffff){	/*I[*/
			break;
		}
		if(ctrl[i].size < minsize){	/*ŏ󂫃̌*/
			k = i;
		}
	}
#ifdef CHNOSPROJECT_DEBUG_MEMORY
	debug("DEBUG:MemoryFree:Loop EndTagIndex:%d\n", i);
#endif
	if(j == 0){	/*AhX̏ȋ󂫏񂪌Ȃ*/
		j = i;
	}
	if(i == ctrl[0].size){	/*󂫃z񂪖t*/
		Error_Report(ERROR_NO_MORE_FREE_TAG, ctrl);	/*{͂ŁActrl[0].addr𗘗pāAЕXgɓo^Ȃ΂ȂB*/
		if(ctrl[k].size >= size){	/*ŏ̋󂫃́A悤ƂĂ󂫃̂ŁAo^~*/
			IO_Store_EFlags(eflags);
			return;
		} else if(j <= k){	/*ŏ̋󂫃́A悤ƂĂ󂫃̑}ʒuɂ*/
			for(; k > j; k--){
				ctrl[k] = ctrl[k - 1];
			}
		} else if(j > k){	/*ŏ̋󂫃́A悤ƂĂ󂫃̑}ʒuOɂ*/
			for(; k < j - 1; k++){
				ctrl[k] = ctrl[k + 1];
			}
			j--;
		}
	} else{	/*󂫂͏\̂ł炷*/
		if(i + 1 != ctrl[0].size - 1){
			ctrl[i + 1].addr = 0;
			ctrl[i + 1].size = 0xffffffff;
		}
		for(; i > j; i--){
			ctrl[i] = ctrl[i - 1];
		}
	}
	ctrl[j].addr = addr;
	ctrl[j].size = size;

	Memory_Free_Sub(ctrl, j);

	IO_Store_EFlags(eflags);

	#ifdef CHNOSPROJECT_DEBUG_MEMORY_ALLOCATE_AND_FREE
		debug("Memory_Free:ctrl:[0x%X] addr:[0x%X] size:0x%X\n", ctrl, addr, size);
	#endif

	return;
}

void Memory_Free_Sub(IO_MemoryControl ctrl, uint tagno)
{
	uint i, j, k;
	uint eflags;

	eflags = IO_Load_EFlags();

	IO_CLI();

	if(1 < tagno && tagno < ctrl[0].size - 1){
		i = tagno - 1;
		j = tagno + 1;
	} else if(tagno == 1){
		i = 1;
		j = 2;
	} else if(tagno == ctrl[0].size - 1){
		i = ctrl[0].size - 2;
		j = ctrl[0].size - 1;
	} else{
		Error_Report(ERROR_INVALID_FREE_MEMORY_INDEX, ctrl, tagno);
		IO_Store_EFlags(eflags);
		return;
	}

	for(; i < j; i++){
		if(ctrl[i].addr + ctrl[i].size >= ctrl[i + 1].addr){	/*ctrl[i]̌ɁActrl[i + 1]Ȃ*/
			if(ctrl[i].addr + ctrl[i].size > ctrl[i + 1].addr){	/*͈͂dȂĂ*/
				Error_Report(ERROR_MEMORY_FREE_RANGE_OVERLAPPED, ctrl, i);
				ctrl[i].size = (uint)ctrl[i + 1].addr - (uint)ctrl[i].addr;
			}
			ctrl[i].size += ctrl[i + 1].size;
			for(k = i + 1; k < ctrl[0].size - 1; k++){
				if(ctrl[k].size == 0xffffffff){
					break;
				}
				ctrl[k] = ctrl[k + 1];
			}
			if(k != ctrl[0].size - 1){
				ctrl[k].addr = 0;
				ctrl[k].size = 0xffffffff;
			}
			i -= 2;
			j--;
		}
	}
	IO_Store_EFlags(eflags);
	return;
}

void *Memory_Allocate(IO_MemoryControl ctrl, uint size)
{
	uint i;
	void *addr;
	uint eflags;

	size = (size + 7) & ~7;

#ifdef CHNOSPROJECT_DEBUG_MEMORY
	debug("DEBUG:MemoryAllocate:Start ctrl:0x%08X size 0x%08X\n", ctrl, size);
#endif

	eflags = IO_Load_EFlags();

	IO_CLI();

	for(i = 1; i < ctrl[0].size; i++){
		if(ctrl[i].size == 0xffffffff){	/*I[*/
			break;
		}
		if(ctrl[i].size >= size){	/*\ȋ󂫂𔭌*/
#ifdef CHNOSPROJECT_DEBUG_MEMORY
	debug("DEBUG:MemoryAllocate:Found index:%d\n", i);
#endif
			addr = ctrl[i].addr;
			if(ctrl[i].size == size){	/*҂肾̂ŋ󂫏j*/
				for(; i < ctrl[0].size - 1; i++){
					//I[𔭌Break.
					if(ctrl[i].size == 0xffffffff){
						break;
					}
					//^ORs[đOɋl߂B
					ctrl[i] = ctrl[i + 1];
				}
				//l߂ʁAI[^OKvǉiȂƂȂ͂ˁHcj
				//if(i != ctrl[0].size){
				//	ctrl[i].addr = 0;
				//	ctrl[i].size = 0xffffffff;
				//}
			} else{	/*܂cĂ̂ŋ󂫏𒲐*/
				ctrl[i].addr += size;
				ctrl[i].size -= size;
			}
			IO_Store_EFlags(eflags);
			//[NAB
			MOVSD_ZeroFill(addr, size);

			#ifdef CHNOSPROJECT_DEBUG_MEMORY_ALLOCATE_AND_FREE
						debug("Memory_Alloc:ctrl:[0x%X] addr:[0x%X] size:0x%X\n", ctrl, addr, size);
			#endif

			return addr;
		}
	}

	Error_Report(ERROR_NOT_ENOUGH_FREE_MEMORY, ctrl, size);

	IO_Store_EFlags(eflags);

	return 0;
}

void *Memory_Allocate_Aligned(IO_MemoryControl ctrl, uint size, uint align)
/*align2̙p{Ƃĉ߂B2̙p{łȂꍇ́Aő̃ZbgĂrbgɑΉlŃAC*/
{
	uint i;
	void *notaligned;
	void *aligned;

	if(align != 0){
		for(i = 0; i < 32; i++){
			align = align >> 1;
			if(align == 0){
				break;
			}
		}
		notaligned = Memory_Allocate(ctrl, size + (1 << i) - 1);
		aligned = (void *)((((uint)notaligned + (1 << i) - 1) >> i) << i);
		Memory_Free(ctrl, notaligned, (uint)aligned - (uint)notaligned);
		Memory_Free(ctrl, aligned + size, ((uint)notaligned + size + (1 << i) - 1) - ((uint)aligned + size));
	} else{
		aligned = Memory_Allocate(ctrl, size);
	}

	return aligned;
}

uint Memory_Get_FreeSize(IO_MemoryControl ctrl)
{
	uint i, size;

	size = 0;
	for(i = 1; i < ctrl[0].size; i++){
		if(ctrl[i].size == 0xffffffff){
			break;
		}
		size += ctrl[i].size;
	}

	return size;
}



