/*
 * The MIT License

   Conograph (powder auto-indexing program)

Copyright (c) <2012> <Ryoko Oishi-Tomiyasu, KEK>

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
 *
 */
#include "BravaisLattice.hh"
#include "bravais_lat.hh"
#include "../zerror_type/error_out.hh"

const SimpleLat BravaisLattice::blat_Primitive;
const BaseCenteredLat BravaisLattice::blat_Base[3] = {BaseA_Axis, BaseB_Axis, BaseC_Axis};
const FaceCenteredLat BravaisLattice::blat_Face;
const BodyCenteredLat BravaisLattice::blat_Body;
const RhombohedralLat BravaisLattice::blat_Rhom;

BravaisLattice::BravaisLattice(const eBravaisLattice& num)
{
	m_blat = NULL;
	if(num==Prim) m_blat= &blat_Primitive;
	else if(num==BaseX) m_blat= &blat_Base[(ArrayIndex)BaseA_Axis];
	else if(num==BaseY) m_blat= &blat_Base[(ArrayIndex)BaseB_Axis];
	else if(num==BaseZ) m_blat= &blat_Base[(ArrayIndex)BaseC_Axis];
	else if(num==Face) m_blat= &blat_Face;
	else if(num==Inner) m_blat= &blat_Body;
	else if(num==Rhom_hex) m_blat= &blat_Rhom;
	else assert( false );
}

BravaisLattice::BravaisLattice(const BravaisLattice& rhs)
{
	m_blat=rhs.m_blat;
}

BravaisLattice& BravaisLattice::operator=(const BravaisLattice& rhs)
{
	if(this != & rhs) m_blat = rhs.m_blat;
	return *this;
}

BravaisLattice::~BravaisLattice()
{
}
